package Module::Features::Dummy;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-02-25'; # DATE
our $DIST = 'Module-Features-Dummy'; # DIST
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our %FEATURES_DEF = (
    v => 2,
    summary => 'Dummy feature set, for testing', # XXX: use this for Abstract
    features => {
        feature1 => {
            summary => 'First feature, a bool',
        },
        feature2 => {
            summary => 'Second feature, a bool, required',
            req => 1,
        },
        feature3 => {
            summary => 'Second feature, a string',
            schema => ['str*', in=>['a','b','c']],
        },
    },
);

1;
# ABSTRACT: Dummy feature set, for testing

__END__

=pod

=encoding UTF-8

=head1 NAME

Module::Features::Dummy - Dummy feature set, for testing

=head1 VERSION

This document describes version 0.002 of Module::Features::Dummy (from Perl distribution Module-Features-Dummy), released on 2021-02-25.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Module-Features-Dummy>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Module-Features-Dummy>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Module-Features-Dummy/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Module::Features>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
