use 5.008;
use strict;
use warnings;

package Class::Value::Net::DNSSEC::DS::Digest_TEST;
BEGIN {
  $Class::Value::Net::DNSSEC::DS::Digest_TEST::VERSION = '1.103060';
}

use Test::More;
use parent 'Class::Value::Test';
use constant TESTDATA => (
    {   args    => {},
        invalid => [ qw/-1 string 0X y0y0/ ],
        valid   => [ qw/
            0C30AA64DF5149B0237F0CAD8E6AB22825BDC8CADBD7CC108F6FFC74AC428709
            0C7D18B6190D9EA7263A6DE63DAB7331F93AF238
            0CD268577B02095808CCF1F77B8B76796038F42F5602748566ECC9034440F430
            0D0CD17B3ED3F60ED687F90FF9C795BBE9C67E62
            19BC4BB9D1285BE162E390158D762291A2DA8852EF31D2EC5F17F302BCFD81D4
            1C407A48DA11EA76F04E95FC518C1010B2C92BD1
            1D83F503CCED4A4B6F7F8DB1CF43D38F9133A3EA
            23D40946A7617EC1567D00EB6F4715255643D43D837FE6BC92A49A0C9169AF4F
            26811E459C850F50A85D1EAF589E30DC14D09D1A6E6262E8D36B6BFFC605334C
            294C803483203E03C6312344AB5402C46CD19C62
            2C6EA21F9B5EF3857586A10B1DDF05C9A95E25B6E968EB1A2F7B8D4FADA5544B
            2CF61F8351DB41C190C8E58364B786EEF0201D89F709F997541BC3C7668D76EA
            2DF848B108F9AE0723EC3C563CF7BCE6B0B7D73FED5346B39BE1189E5D0AE9E1
            30FC582FE64CA122064D92FF6DF3EC8383A1E987
            338EF4055DFBAB9E17270DA4BFAD16212386E981
            342AFB8BA56277EC54F17ED007937F794B9F8257BF6CD544137B10DF5D2910EF
            34F6E274294D84E62C132117208BB64BC31CC0A8D81287DD7A7E65DCB760BD19
            3B526BCC354AE085AD9984C9BE73D271411023EFF421EF184BCE41ACE3DE9F8B
            409AA5CD776352AEAB7A46B64EE7BA8061CB9374
            457C64669C357AF4AABDEB16A6A119B22D3FCB339BBF3C1701AA84CBC3E105F3
            513D1C41DF184F249280FC9D92243315E6A1BB63
            57D1927113224D7FBB9FC2F68394A717263DDAE5F883EE461AAF8F4ED4F39E23
            58A2D5813CC2CAA6B5B88349B5127EB592E64BC85E6D796A27D1B3338CA35638
            60039CDD684CCCACF2ED7719D2844FC6C9EFC7AE
            6119CAE74A6EC411FE0B3260FC5C20ABD68A485A
            66B273B62A7282590410B4E6831A665A930CC2E9
            72863CE93E5D4CEFE529D32BE7484056442DEA804D8F0769522CDB181C86F0E5
            76518E8EB8DDDDC94994EFA3870F0761A4EB255B885F70725FC75BCD7EC6789A
            79F9C2151B0ADAB2E680574A8E1E466749B935A3
            85503A030DDF0297450DDD4B5E2B96A463D2D1EA
            8740A538FFE8CBD010BDFAC7CBAA24B7039D47E04DACBFF5A9E5E81E8F3F45AB
            87516D56B697CB3F7A7C3EB594EE0E16AE509D16A503089F4FBD4F347B336F93
            87E2B3544884B45F36A0DA72DADCB0239C4D73D4
            928C1114C32E27CD28713D776D93B462FCF5C31CDDA1BF40E9869251B7014C83
            93D30693C59CD11646CEAA77DCED10DA13BEEDE9
            94346154CF33613B7D50F0B97790FE0E0D61B33A
            96EEB2FFD9B00CD4694E78278B5EFDAB0A80446567B69F634DA078F0D90F01BA
            9C6A1545EEDBBBCF44A011198B0615377DD37CF4
            A057C8553B1DC6CF158A87CD2D0BAA2CDC9C6A14FA03DE02B19AB0DA62AF279E
            A099287BC1850C156D941915DED0F9500FDCF3A9
            A1907F85D49081239389C216912B8937D0ECEB3D
            A1AB8546B80E438A7DFE0EC559A7088EC5AED3C4E0D26B1B60ED3735F853DFD7
            A471CE5E038A05430C5B13EC457C272AF48BCC12EF5B572CF2B87544B284A006
            A4F7756C0B5E82D9E31E8649F097B81F4E28F683
            A76DDE827B52D66933340341A24B0D16A29D117C
            AEA001556720B2AA252C687B7ABE08ED868A61095F254186FEFFF75F54AE1847
            B235260ABF0877B65647D46B60AA3DDFE5F4F37F3915EC8D90615BF8AA603808
            B3F4B4844A107C5367821E9E66DDC869F7A0107539BDA39FFBE19CDCBCFCA431
            B62D6A035EC97E78692AB0026854A635A1F79777
            B8174233B52988D1A3517C9EF970DF7DF4900B3B211BBF5A931C4FA06C907F6A
            BEE4A7A77CB1FB609777B25D2754815A274452CFD99618D8F3270556D42EA897
            C686FC34C432A82BD0F7A8569C32BBA8152B2D0D
            C7AEE4D32904728741DB270E72899673D7DFAF212E517F2400C9424B231CF56B
            C9660594EFA1DCCCCA1B6B7359262F2E11052403
            CE9389182E9CD4B91E9BB68141A5A1A7A68325C3EAFE3C3DD72E34F8DFF11A47
            D071D44BF9DDF70449C5A6C37CADEB3EB3683C74
            D2C46F1B7A4F83D99C5133671167D083243A3F48
            D51F6C4A545691F4234F886F4FB82EBBEB06D2139805100F28442AFA784A33FA
            D569A173FA0099A428A4B5E0EAF6ED445309C9D76F2D8FB4CE83AEF5AE79D593
            DAB1AAE320707695D0DAACF4DC01B11B8FB3D0B0AB2AF7C27B160915D1D39DBE
            DAE1EA20F52187FDE18DC294BAF08D36F57420B2
            E1A0FC89B87F5E7F6B354D364CF704855A2E9A52B7F39BBE4E2BEA443B81B18E
            E2D262469CB998642F772610A77AAEABB84A4F71CF40B9E30C03B9C9E1F6409C
            E427598046D839DE9F8A8B381D5A2C0609AFE4BC
            E5248F29BA196ECA52987B8F697E0513D9A9CAD76E7F19172B999A5B84457B63
            E6C1716CFB6BDC84E84CE1AB5510DAC69173B5B2
            EAA0978F38879DB70A53F9FF1ACF21D046A98B5C
            EFC19D4685751FF8E11F96142A083DCB9C708912
            F2860D6D21F5B10CD4D0F9EF018812869C2ADDF4B1FA94F71EBEE0EA7A3883A8
            FB2BB4925BA253FC13CFB1E341DB0DFD8541FE27B4C6373D7D180AEC19BC1471
            FDD390379DE73265D77796341A2E38ACFCA116CF5BD04EBA5C164924D7C629C1
        / ],
    },
);

1;

__END__
=pod

=head1 NAME

Class::Value::Net::DNSSEC::DS::Digest_TEST

=head1 VERSION

version 1.103060

=head1 INSTALLATION

See perlmodinstall for information and options on installing Perl modules.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests through the web interface at
L<http://rt.cpan.org/Public/Dist/Display.html?Name=Class-Value-Net>.

=head1 AVAILABILITY

The latest version of this module is available from the Comprehensive Perl
Archive Network (CPAN). Visit L<http://www.perl.com/CPAN/> to find a CPAN
site near you, or see L<http://search.cpan.org/dist/Class-Value-Net/>.

The development version lives at L<http://github.com/hanekomu/Class-Value-Net>
and may be cloned from L<git://github.com/hanekomu/Class-Value-Net>.
Instead of sending patches, please fork this project using the standard
git and github infrastructure.

=head1 AUTHOR

Marcel Gruenauer <marcel@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2004 by Marcel Gruenauer.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

