package Class::Value::Net::NAPTR::CharacterString;

# $Id: CharacterString.pm 11427 2006-05-09 13:00:16Z gr $

use strict;
use warnings;


our $VERSION = '0.01';


use base 'Class::Value::Net';


sub is_well_formed_value {
    my ($self, $value) = @_;
    return 1 unless defined $value;
    $self->SUPER::is_well_formed_value($value)
        && $value =~ m/^[\x20-\x7E]*$/;
}


sub normalize_value {
    my ($self, $value) = @_;
    return unless defined $value;
    $value =~ s/^"(.*)"$/$1/;
    $value;
}


sub stringify {
    my $self = shift;
    sprintf '"%s"', $self->value;
}


1;


__END__

=head1 NAME

Class::Value::Net - network-related value objects

=head1 SYNOPSIS

None yet (see below).

=head1 DESCRIPTION

None yet. This is an early release; fully functional, but undocumented. The
next release will have more documentation.

=head1 TAGS

If you talk about this module in blogs, on del.icio.us or anywhere else,
please use the C<classvaluenet> tag.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to
C<bug-class-value-net@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.

=head1 INSTALLATION

See perlmodinstall for information and options on installing Perl modules.

=head1 AVAILABILITY

The latest version of this module is available from the Comprehensive Perl
Archive Network (CPAN). Visit <http://www.perl.com/CPAN/> to find a CPAN
site near you. Or see <http://www.perl.com/CPAN/authors/id/M/MA/MARCEL/>.

=head1 AUTHORS

Marcel GrE<uuml>nauer, C<< <marcel@cpan.org> >>

Heinz Ekker C<< ek@univie.ac.at >>

=head1 COPYRIGHT AND LICENSE

Copyright 2007 by Marcel GrE<uuml>nauer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

