/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.DestroyableRuntimeExecutingBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.OperaCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

public class BrowserLauncherFactory {
    private static final Pattern CUSTOM_PATTERN = Pattern.compile("^\\*custom( .*)?$");
    private static final BrowserStringPair[] supportedBrowsers = new BrowserStringPair[]{new BrowserStringPair("firefox", FirefoxCustomProfileLauncher.class), new BrowserStringPair("iexplore", InternetExplorerCustomProxyLauncher.class), new BrowserStringPair("safari", SafariCustomProfileLauncher.class), new BrowserStringPair("iehta", HTABrowserLauncher.class), new BrowserStringPair("chrome", FirefoxChromeLauncher.class), new BrowserStringPair("opera", OperaCustomProfileLauncher.class)};
    SeleniumServer server;

    public BrowserLauncherFactory(SeleniumServer server) {
        this.server = server;
    }

    public BrowserLauncher getBrowserLauncher(String browser, String sessionId) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        for (int i = 0; i < supportedBrowsers.length; ++i) {
            BrowserStringPair pair = supportedBrowsers[i];
            String name = pair.name;
            Class c = pair.c;
            Pattern pat = Pattern.compile("^\\*" + name + "( .*)?$");
            Matcher mat = pat.matcher(browser);
            if (!mat.find()) continue;
            String browserStartCommand = browser.equals("*" + name) ? null : mat.group(1).substring(1);
            return this.createBrowserLauncher(c, browserStartCommand, sessionId);
        }
        Matcher CustomMatcher = CUSTOM_PATTERN.matcher(browser);
        if (CustomMatcher.find()) {
            String browserStartCommand = CustomMatcher.group(1).substring(1);
            return new DestroyableRuntimeExecutingBrowserLauncher(browserStartCommand, sessionId);
        }
        throw this.browserNotSupported(browser);
    }

    private RuntimeException browserNotSupported(String browser) {
        StringBuffer errorMessage = new StringBuffer("Browser not supported: " + browser);
        errorMessage.append('\n');
        if (!browser.startsWith("*")) {
            errorMessage.append("(Did you forget to add a *?)\n");
        }
        errorMessage.append('\n');
        errorMessage.append("Supported browsers include:\n");
        for (int i = 0; i < supportedBrowsers.length; ++i) {
            errorMessage.append("  *").append(BrowserLauncherFactory.supportedBrowsers[i].name).append('\n');
        }
        return new RuntimeException(errorMessage.toString());
    }

    private BrowserLauncher createBrowserLauncher(Class c, String browserStartCommand, String sessionId) {
        try {
            if (null == browserStartCommand) {
                Constructor ctor = c.getConstructor(Integer.TYPE, String.class);
                Object[] args = new Object[]{new Integer(this.server.getPort()), sessionId};
                return (BrowserLauncher)ctor.newInstance(args);
            }
            Constructor ctor = c.getConstructor(Integer.TYPE, String.class, String.class);
            Object[] args = new Object[]{new Integer(this.server.getPort()), sessionId, browserStartCommand};
            return (BrowserLauncher)ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class BrowserStringPair {
        public String name;
        public Class c;

        public BrowserStringPair(String name, Class c) {
            this.name = name;
            this.c = c;
        }
    }
}

