%module "Math::GSL::CBLAS"
%include "typemaps.i"
%include "gsl_typemaps.i"

%apply double *INPUT { float const *X };
%apply float *INPUT  { double const *X };

%apply double *OUTPUT { float *C };
%{
    #include "gsl/gsl_cblas.h"
%}

%include "gsl/gsl_cblas.h"

%perlcode %{
@EXPORT_OK = qw/
               cblas_sdsdot 
               cblas_dsdot 
               cblas_sdot 
               cblas_ddot 
               cblas_cdotu_sub 
               cblas_cdotc_sub 
               cblas_zdotu_sub 
               cblas_zdotc_sub 
               cblas_snrm2 
               cblas_sasum 
               cblas_dnrm2 
               cblas_dasum 
               cblas_scnrm2 
               cblas_scasum 
               cblas_dznrm2 
               cblas_dzasum 
               cblas_isamax 
               cblas_idamax 
               cblas_icamax 
               cblas_izamax 
               cblas_sswap 
               cblas_scopy 
               cblas_saxpy 
               cblas_dswap 
               cblas_dcopy 
               cblas_daxpy 
               cblas_cswap 
               cblas_ccopy 
               cblas_caxpy 
               cblas_zswap 
               cblas_zcopy 
               cblas_zaxpy 
               cblas_srotg 
               cblas_srotmg 
               cblas_srot 
               cblas_srotm 
               cblas_drotg 
               cblas_drotmg 
               cblas_drot 
               cblas_drotm 
               cblas_sscal 
               cblas_dscal 
               cblas_cscal 
               cblas_zscal 
               cblas_csscal 
               cblas_zdscal 
               cblas_sgemv 
               cblas_sgbmv 
               cblas_strmv 
               cblas_stbmv 
               cblas_stpmv 
               cblas_strsv 
               cblas_stbsv 
               cblas_stpsv 
               cblas_dgemv 
               cblas_dgbmv 
               cblas_dtrmv 
               cblas_dtbmv 
               cblas_dtpmv 
               cblas_dtrsv 
               cblas_dtbsv 
               cblas_dtpsv 
               cblas_cgemv 
               cblas_cgbmv 
               cblas_ctrmv 
               cblas_ctbmv 
               cblas_ctpmv 
               cblas_ctrsv 
               cblas_ctbsv 
               cblas_ctpsv 
               cblas_zgemv 
               cblas_zgbmv 
               cblas_ztrmv 
               cblas_ztbmv 
               cblas_ztpmv 
               cblas_ztrsv 
               cblas_ztbsv 
               cblas_ztpsv 
               cblas_ssymv 
               cblas_ssbmv 
               cblas_sspmv 
               cblas_sger 
               cblas_ssyr 
               cblas_sspr 
               cblas_ssyr2 
               cblas_sspr2 
               cblas_dsymv 
               cblas_dsbmv 
               cblas_dspmv 
               cblas_dger 
               cblas_dsyr 
               cblas_dspr 
               cblas_dsyr2 
               cblas_dspr2 
               cblas_chemv 
               cblas_chbmv 
               cblas_chpmv 
               cblas_cgeru 
               cblas_cgerc 
               cblas_cher 
               cblas_chpr 
               cblas_cher2 
               cblas_chpr2 
               cblas_zhemv 
               cblas_zhbmv 
               cblas_zhpmv 
               cblas_zgeru 
               cblas_zgerc 
               cblas_zher 
               cblas_zhpr 
               cblas_zher2 
               cblas_zhpr2 
               cblas_sgemm 
               cblas_ssymm 
               cblas_ssyrk 
               cblas_ssyr2k 
               cblas_strmm 
               cblas_strsm 
               cblas_dgemm 
               cblas_dsymm 
               cblas_dsyrk 
               cblas_dsyr2k 
               cblas_dtrmm 
               cblas_dtrsm 
               cblas_cgemm 
               cblas_csymm 
               cblas_csyrk 
               cblas_csyr2k 
               cblas_ctrmm 
               cblas_ctrsm 
               cblas_zgemm 
               cblas_zsymm 
               cblas_zsyrk 
               cblas_zsyr2k 
               cblas_ztrmm 
               cblas_ztrsm 
               cblas_chemm 
               cblas_cherk 
               cblas_cher2k 
               cblas_zhemm 
               cblas_zherk 
               cblas_zher2k 
               cblas_xerbla 
               $CblasRowMajor 
               $CblasColMajor 
               $CblasNoTrans 
               $CblasTrans 
               $CblasConjTrans 
               $CblasUpper 
               $CblasLower 
               $CblasNonUnit 
               $CblasUnit 
               $CblasLeft 
               $CblasRight 
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

__END__

=head1 NAME

Math::GSL::CBLAS - Basic Linear Algebra Subprograms based on C functions

=head1 SYNOPSIS

use Math::GSL::CBLAS qw/:all/;

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over 1

=item C<cblas_sdsdot>

=item C<cblas_dsdot>

=item C<cblas_sdot>

=item C<cblas_ddot>

=item C<cblas_cdotu_sub>

=item C<cblas_cdotc_sub>

=item C<cblas_zdotu_sub>

=item C<cblas_zdotc_sub>

=item C<cblas_snrm2>

=item C<cblas_sasum>

=item C<cblas_dnrm2>

=item C<cblas_dasum>

=item C<cblas_scnrm2>

=item C<cblas_scasum>

=item C<cblas_dznrm2>

=item C<cblas_dzasum>

=item C<cblas_isamax>

=item C<cblas_idamax>

=item C<cblas_icamax>

=item C<cblas_izamax>

=item C<cblas_sswap>

=item C<cblas_scopy>

=item C<cblas_saxpy>

=item C<cblas_dswap>

=item C<cblas_dcopy>

=item C<cblas_daxpy>

=item C<cblas_cswap>

=item C<cblas_ccopy>

=item C<cblas_caxpy>

=item C<cblas_zswap>

=item C<cblas_zcopy>

=item C<cblas_zaxpy>

=item C<cblas_srotg>

=item C<cblas_srotmg>

=item C<cblas_srot>

=item C<cblas_srotm>

=item C<cblas_drotg>

=item C<cblas_drotmg>

=item C<cblas_drot>

=item C<cblas_drotm>

=item C<cblas_sscal>

=item C<cblas_dscal>

=item C<cblas_cscal>

=item C<cblas_zscal>

=item C<cblas_csscal>

=item C<cblas_zdscal>

=item C<cblas_sgemv>

=item C<cblas_sgbmv>

=item C<cblas_strmv>

=item C<cblas_stbmv>

=item C<cblas_stpmv>

=item C<cblas_strsv>

=item C<cblas_stbsv>

=item C<cblas_stpsv>

=item C<cblas_dgemv>

=item C<cblas_dgbmv>

=item C<cblas_dtrmv>

=item C<cblas_dtbmv>

=item C<cblas_dtpmv>

=item C<cblas_dtrsv>

=item C<cblas_dtbsv>

=item C<cblas_dtpsv>

=item C<cblas_cgemv>

=item C<cblas_cgbmv>

=item C<cblas_ctrmv>

=item C<cblas_ctbmv>

=item C<cblas_ctpmv>

=item C<cblas_ctrsv>

=item C<cblas_ctbsv>

=item C<cblas_ctpsv>

=item C<cblas_zgemv>

=item C<cblas_zgbmv>

=item C<cblas_ztrmv>

=item C<cblas_ztbmv>

=item C<cblas_ztpmv>

=item C<cblas_ztrsv>

=item C<cblas_ztbsv>

=item C<cblas_ztpsv>

=item C<cblas_ssymv>

=item C<cblas_ssbmv>

=item C<cblas_sspmv>

=item C<cblas_sger>

=item C<cblas_ssyr>

=item C<cblas_sspr>

=item C<cblas_ssyr2>

=item C<cblas_sspr2>

=item C<cblas_dsymv>

=item C<cblas_dsbmv>

=item C<cblas_dspmv>

=item C<cblas_dger>

=item C<cblas_dsyr>

=item C<cblas_dspr>

=item C<cblas_dsyr2>

=item C<cblas_dspr2>

=item C<cblas_chemv>

=item C<cblas_chbmv>

=item C<cblas_chpmv>

=item C<cblas_cgeru>

=item C<cblas_cgerc>

=item C<cblas_cher>

=item C<cblas_chpr>

=item C<cblas_cher2>

=item C<cblas_chpr2>

=item C<cblas_zhemv>

=item C<cblas_zhbmv>

=item C<cblas_zhpmv>

=item C<cblas_zgeru>

=item C<cblas_zgerc>

=item C<cblas_zher>

=item C<cblas_zhpr>

=item C<cblas_zher2>

=item C<cblas_zhpr2>

=item C<cblas_sgemm>

=item C<cblas_ssymm>

=item C<cblas_ssyrk>

=item C<cblas_ssyr2k>

=item C<cblas_strmm>

=item C<cblas_strsm>

=item C<cblas_dgemm>

=item C<cblas_dsymm>

=item C<cblas_dsyrk>

=item C<cblas_dsyr2k>

=item C<cblas_dtrmm>

=item C<cblas_dtrsm>

=item C<cblas_cgemm>

=item C<cblas_csymm>

=item C<cblas_csyrk>

=item C<cblas_csyr2k>

=item C<cblas_ctrmm>

=item C<cblas_ctrsm>

=item C<cblas_zgemm>

=item C<cblas_zsymm>

=item C<cblas_zsyrk>

=item C<cblas_zsyr2k>

=item C<cblas_ztrmm>

=item C<cblas_ztrsm>

=item C<cblas_chemm>

=item C<cblas_cherk>

=item C<cblas_cher2k>

=item C<cblas_zhemm>

=item C<cblas_zherk>

=item C<cblas_zher2k>

=item C<cblas_xerbla>

=back

This module also contains the following constants : 

=over 1

=item C<$CblasRowMajor>
               
=item C<$CblasColMajor> 

=item C<$CblasNoTrans > 

=item C<$CblasTrans > 

=item C<$CblasConjTrans > 

=item C<$CblasUpper> 

=item C<$CblasLower> 

=item C<$CblasNonUnit> 
                             
=item C<$CblasUnit >
 
=item C<$CblasLeft >

=item C<$CblasRight >

=back

For more informations on the functions, we refer you to the GSL offcial documentation: L<http://www.gnu.org/software/gsl/manual/html_node/>

Tip : search on google: site:http://www.gnu.org/software/gsl/manual/html_node/ name_of_the_function_you_want


=head1 EXAMPLES

=head1 AUTHORS

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

%}
