
use FindBin::libs;
use FindBin::libs   qw( base=t export=test_dir scalar );

use Test::More;
use File::Basename  qw( dirname );

my $var     = 'DEVEL_SHAREDLIBS_PRINT';
my $output  = './test-output';

unlink $output;

$ENV{ $var } = 1;

my $path = $test_dir . '/bin/exec-path';

-e $path or BAIL_OUT "Missing test exec: '$path'";

chomp( my @output  = qx( $path 2>&1 ) );

note "Output: $var = $ENV{ $var }\n", explain \@output;

ok ! @output, "True $var: lacks output.";

ok -e $output, "True $var: has '$output'";
ok -s $output, "True $var: non-empty '$output'";

chomp( my @found   = qx( cat $output ) );

like $_, qr{ [.]so\b }x, "Found '.so' ($_)" 
for grep /^[^#]/, @found;

done_testing;

unlink $output;

0
__END__
