=head1 Name

SPVM::Document::Modules - SPVM Standard Modules

=head1 Description

The list of SPVM Standard Modules. All Standard modules are yet experimental status.

=head1 Standard Modules

=over 2

=item * L<Address|SPVM::Address>

=item * L<Array|SPVM::Array>

=item * L<Bool|SPVM::Bool>

=item * L<Byte|SPVM::Byte>

=item * L<ByteList|SPVM::ByteList>

=item * L<Cloneable|SPVM::Cloneable>

=item * L<Cloner|SPVM::Cloner>

=item * L<CommandInfo|SPVM::CommandInfo>

=item * L<Comparator|SPVM::Comparator>

=item * L<Comparator::Double|SPVM::Comparator::Double>

=item * L<Comparator::Float|SPVM::Comparator::Float>

=item * L<Comparator::Int|SPVM::Comparator::Int>

=item * L<Comparator::Long|SPVM::Comparator::Long>

=item * L<Comparator::String|SPVM::Comparator::String>

=item * L<Compiler|SPVM::Compiler>

=item * L<Complex_2d|SPVM::Complex_2d>

=item * L<Complex_2f|SPVM::Complex_2f>

=item * L<Double|SPVM::Double>

=item * L<DoubleList|SPVM::DoubleList>

=item * L<Env|SPVM::Env>

=item * L<EqualityChecker|SPVM::EqualityChecker>

=item * L<EqualityChecker::Address|SPVM::EqualityChecker::Address>

=item * L<Error|SPVM::Error>

=item * L<Error::NotSupported|SPVM::Error::NotSupported>

=item * L<Error::System|SPVM::Error::System>

=item * L<Float|SPVM::Float>

=item * L<FloatList|SPVM::FloatList>

=item * L<Fn|SPVM::Fn>

=item * L<Format|SPVM::Format>

=item * L<Hash|SPVM::Hash>

=item * L<Hash::Entry|SPVM::Hash::Entry>

=item * L<Int|SPVM::Int>

=item * L<IntList|SPVM::IntList>

=item * L<List|SPVM::List>

=item * L<Long|SPVM::Long>

=item * L<LongList|SPVM::LongList>

=item * L<Point|SPVM::Point>

=item * L<Point3D|SPVM::Point3D>

=item * L<Point::Interface|SPVM::Point::Interface>

=item * L<Runtime|SPVM::Runtime>

=item * L<Scope::Guard|SPVM::Scope::Guard>

=item * L<Scope::Guard::Handler|SPVM::Scope::Guard::Handler>

=item * L<Short|SPVM::Short>

=item * L<ShortList|SPVM::ShortList>

=item * L<Sort|SPVM::Sort>

=item * L<Stack|SPVM::Stack>

=item * L<Stringable|SPVM::Stringable>

=item * L<StringBuffer|SPVM::StringBuffer>

=item * L<Stringer|SPVM::Stringer>

=item * L<StringList|SPVM::StringList>

=item * L<Time|SPVM::Time>

=item * L<Time::Info|SPVM::Time::Info>

=back

=head1 CPAN Modules

The list of some CPAN modules. All CPAN modules are yet experimental status.

=over 2

=item * L<JSON|SPVM::JSON> - JSON

=item * L<Math|SPVM::Math> - Math functions

=item * L<Regex|SPVM::Regex> - Regular Expression

=item * L<Unicode|SPVM::Unicode> - Unicode Utilities

=item * L<MIME::Base64|SPVM::MIME::Base64> - Base 64

=item * L<Time::Local|SPVM::Time::Local> - Time Reverse Manipulation

=item * L<SPVM::Errno> - Error Number

=item * L<SPVM::Resource::Re2::V2022_06_01> - Resource of Google RE2 release 2022-06-01.

=item * L<SPVM::Resource::Zlib::V1_2_11> - zlib v1.2.11 Resource

=item * L<SPVM::Cwd> - get pathname of current working directory

=item * L<SPVM::IO> - File IO, Socket, Select/Polling.

=item * L<SPVM::Digest::MD5> - SPVM interface to the MD5 Algorithm

=item * L<SPVM::Digest::SHA> - SPVM extension for SHA-1/224/256/384/512

=item * L<SPVM::Sys> - System Calls

=item * L<SPVM::Sys::IO> - System Calls for File IO

=item * L<SPVM::Sys::FileTest> - File Test

=item * L<SPVM::Sys::Socket> - System Calls for Sockect

=item * L<SPVM::Sys::User> - System Calls for User Manipulation

=item * L<SPVM::Sys::Process> - System Calls for Process

=back

=head2 Resource Modules

See L<SPVM::Document::Resource|/"Resource Modules">.
