#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_anon0__capture1 = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__capture1 = -1;
static int32_t FIELD_ID_anon0__capture2 = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__capture2 = -1;
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int(self,object,object)
int32_t SPPRECOMPILE__anon0__(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__anon0__(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }
  object_vars[2] = *(void**)&stack[2];
  if (object_vars[2] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[2]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture1 < 0, 0)) {
      FIELD_ID_anon0__capture1 = env->get_field_id(env, "anon0", "capture1", "int");
      if (FIELD_ID_anon0__capture1 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture1 = env->get_field_offset(env, FIELD_ID_anon0__capture1);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture1);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon0";
    const char* sub_name = "";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 7;
L7: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L12: // GOTO
  goto L13;
L13: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture2 < 0, 0)) {
      FIELD_ID_anon0__capture2 = env->get_field_id(env, "anon0", "capture2", "int");
      if (FIELD_ID_anon0__capture2 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture2 = env->get_field_offset(env, FIELD_ID_anon0__capture2);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture2);
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon0";
    const char* sub_name = "";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 10;
L16: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L21: // GOTO
  goto L22;
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture1 < 0, 0)) {
      FIELD_ID_anon0__capture1 = env->get_field_id(env, "anon0", "capture1", "int");
      if (FIELD_ID_anon0__capture1 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture1 = env->get_field_offset(env, FIELD_ID_anon0__capture1);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture1);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon0";
    const char* sub_name = "";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L25: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L32: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture1 < 0, 0)) {
      FIELD_ID_anon0__capture1 = env->get_field_id(env, "anon0", "capture1", "int");
      if (FIELD_ID_anon0__capture1 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture1 = env->get_field_offset(env, FIELD_ID_anon0__capture1);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture1) = int_vars[4];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon0";
    const char* sub_name = "";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L34: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__capture1 < 0, 0)) {
      FIELD_ID_anon0__capture1 = env->get_field_id(env, "anon0", "capture1", "int");
      if (FIELD_ID_anon0__capture1 < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 capture1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__capture1 = env->get_field_offset(env, FIELD_ID_anon0__capture1);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__capture1);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon0";
    const char* sub_name = "";
    const char* file = "TestCase/Sub.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L37: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


