#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE = -1;
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Point_3b__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__x = -1;
static int32_t FIELD_ID_TestCase__Point_3s__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__x = -1;
static int32_t FIELD_ID_TestCase__Point_3i__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__x = -1;
static int32_t FIELD_ID_TestCase__Point_3l__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__x = -1;
static int32_t FIELD_ID_TestCase__Point_3f__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__x = -1;
static int32_t FIELD_ID_TestCase__Point_3d__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__x = -1;
static int32_t FIELD_ID_TestCase__Simple__byte_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = -1;
static int32_t FIELD_ID_TestCase__Simple__short_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__short_value = -1;
static int32_t FIELD_ID_TestCase__Simple__int_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__int_value = -1;
static int32_t FIELD_ID_TestCase__Simple__long_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__long_value = -1;
static int32_t FIELD_ID_TestCase__Simple__float_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__float_value = -1;
static int32_t FIELD_ID_TestCase__Simple__double_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__double_value = -1;
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_TestCase__Simple__new = - 1;
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MAX = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3b = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3s = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3i = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3l = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3f = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3d = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_deref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_field_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_bit_and_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_bit_or_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_bit_xor_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_concat(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_divide_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_left_shift_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_multiply_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_remainder_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_right_shift_unsigned_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_right_shift_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_subtract_var(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L3: // ADD_INT
  int_vars[1] = int_vars[1] + int_vars[3];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L5: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L10: // SUBTRACT_INT
  int_vars[3] = int_vars[3] - int_vars[4];
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L12: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L17: // MULTIPLY_INT
  int_vars[4] = int_vars[4] * int_vars[5];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 12;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L24: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[5] / int_vars[6];
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 746;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L27: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L90; }
L30: // MOVE_CONSTANT_INT
  int_vars[6] = 10;
L31: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L32: // REMAINDER_INT
  if (__builtin_expect(int_vars[7] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[6] % /* REMAINDER */ int_vars[7];
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 749;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L35: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L89; }
L38: // MOVE_CONSTANT_INT
  int_vars[7] = 8;
L39: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L40: // LEFT_SHIFT_INT
  int_vars[7] = (int_vars[7] << int_vars[8]);
L41: // MOVE_CONSTANT_INT
  int_vars[8] = 16;
L42: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L45: // MOVE_CONSTANT_INT
  int_vars[8] = -8;
L46: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L47: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[8] = (int_vars[8] >> int_vars[9]);
L48: // MOVE_CONSTANT_INT
  int_vars[9] = -4;
L49: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[9]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L52: // MOVE_CONSTANT_INT
  int_vars[9] = -1;
L53: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L54: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[9] = ((int32_t)((uint32_t)int_vars[9] >> int_vars[10]));
L55: // MOVE_CONSTANT_INT
  int_vars[10] = 2147483647;
L56: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[10]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L59: // MOVE_CONSTANT_INT
  int_vars[10] = -256;
L60: // MOVE_CONSTANT_INT
  int_vars[11] = 255;
L61: // BIT_AND_INT
  int_vars[10] = int_vars[10] & int_vars[11];
L62: // MOVE_CONSTANT_INT
  int_vars[11] = 0;
L63: // EQ_INT
  int_vars[0] = (int_vars[10] == int_vars[11]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L66: // MOVE_CONSTANT_INT
  int_vars[11] = -256;
L67: // MOVE_CONSTANT_INT
  int_vars[12] = 255;
L68: // BIT_OR_INT
  int_vars[11] = int_vars[11] | int_vars[12];
L69: // MOVE_CONSTANT_INT
  int_vars[12] = -1;
L70: // EQ_INT
  int_vars[0] = (int_vars[11] == int_vars[12]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L73: // MOVE_CONSTANT_INT
  int_vars[12] = -256;
L74: // MOVE_CONSTANT_INT
  int_vars[13] = 65535;
L75: // BIT_XOR_INT
  int_vars[12] = int_vars[12] ^ int_vars[13];
L76: // MOVE_CONSTANT_INT
  int_vars[13] = -65281;
L77: // EQ_INT
  int_vars[0] = (int_vars[12] == int_vars[13]);
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L80: // MOVE_CONSTANT_INT
  int_vars[13] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[13];
  goto L97;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // GOTO
  goto L87;
L87: // GOTO
  goto L88;
L88: // GOTO
  goto L89;
L89: // GOTO
  goto L90;
L90: // GOTO
  goto L91;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L97;
L95: // INIT_INT
  int_vars[5] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L97;
L97: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 638;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 639;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L73: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L76: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 651;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L82: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 651;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L84: // MOVE_INT
  int_vars[6] = int_vars[5];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L89: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L90: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L91: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L93: // MOVE_LONG
  long_vars[3] = long_vars[2];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L98: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L99: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L100: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L102: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 654;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L108: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L109: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 654;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L111: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L113: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L115: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L116: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L118: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L119: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L120: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L121: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L241; }
L124: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L125: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 657;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L127: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L128: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L129: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L130: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L240; }
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L134: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L136: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L137: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L139: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L140: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L141: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L142: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L239; }
L145: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L146: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 659;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L148: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L149: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L150: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L151: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L238; }
L154: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L155: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L157: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L158: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L159: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L160: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L161: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L237; }
L164: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 661;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L166: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L167: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L168: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[4]);
L169: // BOOL_INT
  int_vars[0] = int_vars[0];
L170: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L171: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L172: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L174: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L176: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L177: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L178: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L179: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L180: // BOOL_INT
  int_vars[0] = int_vars[0];
L181: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L182: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 663;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L184: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L185: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L186: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L187: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L188: // BOOL_INT
  int_vars[0] = int_vars[0];
L189: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L190: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L191: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L192: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 664;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L193: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 664;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L195: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L196: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L197: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L198: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L199: // BOOL_INT
  int_vars[0] = int_vars[0];
L200: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L201: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L202: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 665;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L203: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L204: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L205: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L206: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L232; }
L209: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L210: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L211: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L212: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L213: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L215: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L216: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L217: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L218: // BOOL_INT
  int_vars[0] = int_vars[0];
L219: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L231; }
L220: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L221: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L222: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L223: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L224: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[1];
L225: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L230; }
L227: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L228: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L243;
L229: // GOTO
  goto L230;
L230: // GOTO
  goto L231;
L231: // GOTO
  goto L232;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // GOTO
  goto L237;
L237: // GOTO
  goto L238;
L238: // GOTO
  goto L239;
L239: // GOTO
  goto L240;
L240: // GOTO
  goto L241;
L241: // INIT_INT
  int_vars[4] = 0;
L242: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L243;
L243: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L244: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_int;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 372;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 372;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L22: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L24: // MOVE_INT
  int_vars[7] = int_vars[6];
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 376;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 376;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L51;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L51;
L49: // INIT_INT
  int_vars[6] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 586;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 588;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 589;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 590;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 592;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 592;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 595;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 595;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L67: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L69: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L72: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L73: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L75: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L76: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 602;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L79: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L80: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 602;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L82: // MOVE_INT
  int_vars[6] = int_vars[5];
L83: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 603;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L86: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L87: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L88: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 603;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L90: // MOVE_LONG
  long_vars[3] = long_vars[2];
L91: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 604;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L94: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L95: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L96: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 604;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L98: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L99: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 605;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L102: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L103: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L104: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 605;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L106: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L108: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L110: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L111: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L113: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L114: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L115: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L116: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L119: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L120: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 608;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L122: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L123: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L124: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L125: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L128: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L129: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 609;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L131: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L132: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 609;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L134: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L135: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L136: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L137: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L138: // BOOL_INT
  int_vars[0] = int_vars[0];
L139: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L140: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L141: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 610;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L143: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L144: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L145: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L146: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L147: // BOOL_INT
  int_vars[0] = int_vars[0];
L148: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L149: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L150: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L151: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 611;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L152: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L153: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 611;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L154: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L155: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L156: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L232; }
L159: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L162: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L163: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[5]);
L164: // BOOL_INT
  int_vars[0] = int_vars[0];
L165: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L231; }
L166: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L167: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L168: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 613;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L169: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 613;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L171: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L172: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L173: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L174: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L175: // BOOL_INT
  int_vars[0] = int_vars[0];
L176: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L230; }
L177: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L180: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L181: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L182: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L183: // BOOL_INT
  int_vars[0] = int_vars[0];
L184: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L229; }
L185: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L186: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L187: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 615;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L188: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 615;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L190: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L191: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L192: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L193: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L194: // BOOL_INT
  int_vars[0] = int_vars[0];
L195: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L228; }
L196: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L197: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 616;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L198: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L199: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L200: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L201: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L202: // BOOL_INT
  int_vars[0] = int_vars[0];
L203: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L227; }
L204: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L205: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 617;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L207: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L208: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 617;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L209: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L210: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L211: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L212: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L213: // BOOL_INT
  int_vars[0] = int_vars[0];
L214: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L226; }
L215: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L216: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_access_var_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 618;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L217: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L218: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L219: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[1];
L220: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L221: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L225; }
L222: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L223: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L238;
L224: // GOTO
  goto L225;
L225: // GOTO
  goto L226;
L226: // GOTO
  goto L227;
L227: // GOTO
  goto L228;
L228: // GOTO
  goto L229;
L229: // GOTO
  goto L230;
L230: // GOTO
  goto L231;
L231: // GOTO
  goto L232;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // INIT_INT
  int_vars[5] = 0;
L237: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L238;
L238: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L239: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 404;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 406;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // MOVE_INT
  int_vars[3] = int_vars[2];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L32: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L34: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L39: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // MOVE_INT
  int_vars[4] = int_vars[3];
L43: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L45: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L51: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 412;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // MOVE_INT
  int_vars[3] = int_vars[2];
L55: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 412;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L57: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // MOVE_INT
  int_vars[3] = int_vars[2];
L61: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // MOVE_INT
  int_vars[3] = int_vars[2];
L65: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L67: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L70: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L71: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L73: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L78: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L80: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L81: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L82: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L84: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // MOVE_INT
  int_vars[3] = int_vars[2];
L87: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L90: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L91: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[6];
      }
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L93: // MOVE_INT
  int_vars[7] = int_vars[6];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // MOVE_INT
  int_vars[3] = int_vars[2];
L96: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L100: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L101: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[2];
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L103: // MOVE_LONG
  long_vars[3] = long_vars[2];
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L105: // MOVE_INT
  int_vars[3] = int_vars[2];
L106: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L110: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L111: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[2];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L113: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L115: // MOVE_INT
  int_vars[3] = int_vars[2];
L116: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L119: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L120: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L121: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[2];
      }
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L123: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // MOVE_INT
  int_vars[3] = int_vars[2];
L126: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L128: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L129: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L131: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L132: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L133: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[6];
L134: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L259; }
L137: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L138: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L140: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L141: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L142: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L143: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L144: // BOOL_INT
  int_vars[0] = int_vars[0];
L145: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L258; }
L146: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L147: // MOVE_INT
  int_vars[3] = int_vars[2];
L148: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L150: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L151: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L153: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L154: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L155: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[6];
L156: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L257; }
L159: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L160: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L162: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L163: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L164: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L165: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L166: // BOOL_INT
  int_vars[0] = int_vars[0];
L167: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L256; }
L168: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L169: // MOVE_INT
  int_vars[3] = int_vars[2];
L170: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L171: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L172: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L174: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L175: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[6];
L176: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L177: // BOOL_INT
  int_vars[0] = int_vars[0];
L178: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L255; }
L179: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L182: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L183: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[4]);
L184: // BOOL_INT
  int_vars[0] = int_vars[0];
L185: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L254; }
L186: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L187: // MOVE_INT
  int_vars[3] = int_vars[2];
L188: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 428;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L190: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 428;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L193: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L194: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L195: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L196: // BOOL_INT
  int_vars[0] = int_vars[0];
L197: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L253; }
L198: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L199: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 429;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L200: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L201: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L202: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L203: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L204: // BOOL_INT
  int_vars[0] = int_vars[0];
L205: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L252; }
L206: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L207: // MOVE_INT
  int_vars[3] = int_vars[2];
L208: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 430;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L210: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L211: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 430;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L212: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L213: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L214: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L215: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L216: // BOOL_INT
  int_vars[0] = int_vars[0];
L217: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L251; }
L218: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L219: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 431;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L220: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L221: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L222: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L223: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L224: // BOOL_INT
  int_vars[0] = int_vars[0];
L225: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L250; }
L226: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L227: // MOVE_INT
  int_vars[3] = int_vars[2];
L228: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L229: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 432;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L230: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L231: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 432;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L232: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L233: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L234: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L235: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L236: // BOOL_INT
  int_vars[0] = int_vars[0];
L237: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L249; }
L238: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L239: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_constant_index";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L241: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L242: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[1];
L243: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L244: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L246: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L247: // GOTO
  goto L248;
L248: // GOTO
  goto L249;
L249: // GOTO
  goto L250;
L250: // GOTO
  goto L251;
L251: // GOTO
  goto L252;
L252: // GOTO
  goto L253;
L253: // GOTO
  goto L254;
L254: // GOTO
  goto L255;
L255: // GOTO
  goto L256;
L256: // GOTO
  goto L257;
L257: // GOTO
  goto L258;
L258: // GOTO
  goto L259;
L259: // INIT_INT
  int_vars[4] = 0;
L260: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L261;
L261: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L262: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 386;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 387;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 387;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L24: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[7];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L27: // MOVE_INT
  int_vars[8] = int_vars[7];
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L32: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L37: // MOVE_INT
  int_vars[4] = int_vars[3];
L38: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_array_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L47: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[2]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L52: // GOTO
  goto L53;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_deref(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[6] = {0};
  double double_vars[6];
  float float_vars[6];
  int64_t long_vars[6];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 496;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 497;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L15: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[1];
L16: // REF_SHORT
  *(void**)&ref_vars[1] = &short_vars[1];
L17: // REF_INT
  *(void**)&ref_vars[2] = &int_vars[2];
L18: // REF_LONG
  *(void**)&ref_vars[3] = &long_vars[0];
L19: // REF_FLOAT
  *(void**)&ref_vars[4] = &float_vars[0];
L20: // REF_DOUBLE
  *(void**)&ref_vars[5] = &double_vars[0];
L21: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L22: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[5];
L26: // SET_DEREF_BYTE
  *(int8_t*)*(void**)&ref_vars[0] = byte_vars[2];
L27: // MOVE_BYTE
  byte_vars[3] = byte_vars[2];
L28: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L29: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L32: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[5];
L33: // SET_DEREF_SHORT
  *(int16_t*)*(void**)&ref_vars[1] = short_vars[2];
L34: // MOVE_SHORT
  short_vars[3] = short_vars[2];
L35: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L38: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[2] = int_vars[5];
L39: // MOVE_INT
  int_vars[6] = int_vars[5];
L40: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L43: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L44: // SET_DEREF_LONG
  *(int64_t*)*(void**)&ref_vars[3] = long_vars[3];
L45: // MOVE_LONG
  long_vars[4] = long_vars[3];
L46: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L49: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[2];
L50: // SET_DEREF_FLOAT
  *(float*)*(void**)&ref_vars[4] = float_vars[3];
L51: // MOVE_FLOAT
  float_vars[4] = float_vars[3];
L52: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L55: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L56: // SET_DEREF_DOUBLE
  *(double*)*(void**)&ref_vars[5] = double_vars[3];
L57: // MOVE_DOUBLE
  double_vars[4] = double_vars[3];
L58: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L59: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 513;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[2];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L64: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L65: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L175; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L74: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L174; }
L77: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L78: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L79: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L81: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[2];
L82: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L83: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L84: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L173; }
L87: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L88: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L90: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L91: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L92: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L93: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L172; }
L96: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L97: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 517;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L100: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L101: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L171; }
L104: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 518;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L107: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L108: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[5]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L170; }
L111: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L112: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 519;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L115: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L116: // ADD_LONG
  long_vars[5] = long_vars[2] + long_vars[3];
L117: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L118: // BOOL_INT
  int_vars[0] = int_vars[0];
L119: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L169; }
L120: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 520;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L123: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L124: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L125: // EQ_LONG
  int_vars[0] = (long_vars[4] == long_vars[3]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L168; }
L128: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L129: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 521;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L132: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L133: // ADD_FLOAT
  float_vars[5] = float_vars[2] + float_vars[3];
L134: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[5]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L167; }
L137: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L141: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[2];
L142: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[3]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L166; }
L145: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L146: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L149: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L150: // ADD_DOUBLE
  double_vars[5] = double_vars[2] + double_vars[3];
L151: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L165; }
L154: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_deref";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L157: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L158: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L159: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[4];
L160: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L164; }
L161: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L162: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L177;
L163: // GOTO
  goto L164;
L164: // GOTO
  goto L165;
L165: // GOTO
  goto L166;
L166: // GOTO
  goto L167;
L167: // GOTO
  goto L168;
L168: // GOTO
  goto L169;
L169: // GOTO
  goto L170;
L170: // GOTO
  goto L171;
L171: // GOTO
  goto L172;
L172: // GOTO
  goto L173;
L173: // GOTO
  goto L174;
L174: // GOTO
  goto L175;
L175: // INIT_INT
  int_vars[5] = 0;
L176: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L177;
L177: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_field_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L6: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L7: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L9: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L11: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L12: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 545;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L16: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[2];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 545;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L18: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L20: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L22: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L24: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L26: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 548;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L28: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 548;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L30: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 550;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L34: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L35: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L36: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 550;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L38: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L39: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 551;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L41: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L44: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L45: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 551;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L47: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L48: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 552;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L51: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L52: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[4];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 552;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L54: // MOVE_INT
  int_vars[5] = int_vars[4];
L55: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L58: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L59: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L60: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[2];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L62: // MOVE_LONG
  long_vars[3] = long_vars[2];
L63: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L66: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L67: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L68: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[2];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L70: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L71: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L74: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L75: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L76: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[2];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L78: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L79: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L81: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L82: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L84: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L86: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L87: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L202; }
L90: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L91: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 558;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L93: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L95: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L96: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L201; }
L99: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L101: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L102: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L104: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L105: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L106: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L107: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L200; }
L110: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L111: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L113: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L114: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L115: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L116: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L199; }
L119: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 561;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L121: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 561;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L123: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L124: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L125: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L198; }
L128: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L130: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L131: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L132: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[4]);
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L197; }
L135: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L137: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L140: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[2];
L141: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L142: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L196; }
L145: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L147: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L148: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L149: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L150: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L151: // BOOL_INT
  int_vars[0] = int_vars[0];
L152: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L195; }
L153: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L155: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L157: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L158: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[2];
L159: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L160: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L161: // BOOL_INT
  int_vars[0] = int_vars[0];
L162: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L194; }
L163: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L164: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 566;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L166: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L167: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L168: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L169: // BOOL_INT
  int_vars[0] = int_vars[0];
L170: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L193; }
L171: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 567;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L173: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L174: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 567;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L175: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L176: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L177: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L178: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L179: // BOOL_INT
  int_vars[0] = int_vars[0];
L180: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L192; }
L181: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 568;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L183: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L184: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L185: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[1];
L186: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L187: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L191; }
L188: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L189: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L204;
L190: // GOTO
  goto L191;
L191: // GOTO
  goto L192;
L192: // GOTO
  goto L193;
L193: // GOTO
  goto L194;
L194: // GOTO
  goto L195;
L195: // GOTO
  goto L196;
L196: // GOTO
  goto L197;
L197: // GOTO
  goto L198;
L198: // GOTO
  goto L199;
L199: // GOTO
  goto L200;
L200: // GOTO
  goto L201;
L201: // GOTO
  goto L202;
L202: // INIT_INT
  int_vars[4] = 0;
L203: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L204;
L204: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L205: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 356;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 357;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 357;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L14: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 359;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L16: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 359;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L20: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[5];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 359;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L22: // MOVE_INT
  int_vars[6] = int_vars[5];
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L28: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_field_access_invocant_not_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[2]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // GOTO
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L46: // INIT_INT
  int_vars[7] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE] = byte_vars[1];
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L7: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L8: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE] = short_vars[1];
  }
L9: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L11: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE] = int_vars[2];
  }
L12: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L14: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE] = long_vars[0];
  }
L15: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L17: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE] = float_vars[0];
  }
L18: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L20: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE] = double_vars[0];
  }
L21: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE];
  }
L22: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L26: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE] = byte_vars[1];
  }
L27: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L28: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE];
  }
L29: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L31: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L32: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L33: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE] = short_vars[1];
  }
L34: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L35: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE];
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L38: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE] = int_vars[4];
  }
L39: // MOVE_INT
  int_vars[5] = int_vars[4];
L40: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE];
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L43: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L44: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE] = long_vars[2];
  }
L45: // MOVE_LONG
  long_vars[3] = long_vars[2];
L46: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE];
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L49: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L50: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE] = float_vars[2];
  }
L51: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L52: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE];
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L55: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L56: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE] = double_vars[2];
  }
L57: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L58: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__BYTE_VALUE];
  }
L59: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 464;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L64: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L175; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L73: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L74: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L174; }
L77: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__SHORT_VALUE];
  }
L78: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L79: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L81: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L83: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L84: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L173; }
L87: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L88: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L90: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L93: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L172; }
L96: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__INT_VALUE];
  }
L97: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 468;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L100: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L101: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L171; }
L104: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L108: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[4]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L170; }
L111: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__LONG_VALUE];
  }
L112: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L115: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[2];
L116: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L117: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L118: // BOOL_INT
  int_vars[0] = int_vars[0];
L119: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L169; }
L120: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L123: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L124: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L125: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L168; }
L128: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__FLOAT_VALUE];
  }
L129: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L132: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[2];
L133: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L134: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L167; }
L137: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 473;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L140: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L141: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L142: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L166; }
L145: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::SpecialAssign", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::SpecialAssign $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__SpecialAssign__DOUBLE_VALUE];
  }
L146: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L149: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L150: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L151: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L165; }
L154: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_package_var_access";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 475;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L157: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L158: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[1];
L159: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L160: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L164; }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L162: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L177;
L163: // GOTO
  goto L164;
L164: // GOTO
  goto L165;
L165: // GOTO
  goto L166;
L166: // GOTO
  goto L167;
L167: // GOTO
  goto L168;
L168: // GOTO
  goto L169;
L169: // GOTO
  goto L170;
L170: // GOTO
  goto L171;
L171: // GOTO
  goto L172;
L172: // GOTO
  goto L173;
L173: // GOTO
  goto L174;
L174: // GOTO
  goto L175;
L175: // INIT_INT
  int_vars[4] = 0;
L176: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L177;
L177: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_add_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 684;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 685;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 686;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L15: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L18: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L19: // MOVE_BYTE
  byte_vars[0] = byte_vars[1];
L20: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L23: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L24: // MOVE_SHORT
  short_vars[0] = short_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L27: // MOVE_INT
  int_vars[4] = int_vars[2];
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L29: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L30: // ADD_LONG
  long_vars[0] = long_vars[0] + long_vars[1];
L31: // MOVE_LONG
  long_vars[2] = long_vars[0];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L34: // ADD_FLOAT
  float_vars[0] = float_vars[0] + float_vars[1];
L35: // MOVE_FLOAT
  float_vars[2] = float_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L38: // ADD_DOUBLE
  double_vars[0] = double_vars[0] + double_vars[1];
L39: // MOVE_DOUBLE
  double_vars[2] = double_vars[0];
L40: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L41: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L43: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L44: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L45: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L46: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L49: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L50: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 699;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L52: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L54: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L55: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L58: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L59: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 700;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L61: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L62: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L63: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L64: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L67: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L68: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 701;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L72: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L73: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L148; }
L76: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 702;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L79: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[5];
L80: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L147; }
L83: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 703;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L86: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[5];
L87: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L146; }
L90: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 704;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L94: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[3];
L95: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L145; }
L98: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 705;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L101: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L102: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[3];
L103: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[4]);
L104: // BOOL_INT
  int_vars[0] = int_vars[0];
L105: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L144; }
L106: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L110: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[3];
L111: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L143; }
L114: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 707;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L117: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L118: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[3];
L119: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[4]);
L120: // BOOL_INT
  int_vars[0] = int_vars[0];
L121: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L142; }
L122: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 708;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L124: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L125: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L126: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[3];
L127: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L128: // BOOL_INT
  int_vars[0] = int_vars[0];
L129: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L141; }
L130: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_add_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 709;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L132: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L133: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L134: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[3];
L135: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[2];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L137: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L138: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L153;
L139: // GOTO
  goto L140;
L140: // GOTO
  goto L141;
L141: // GOTO
  goto L142;
L142: // GOTO
  goto L143;
L143: // GOTO
  goto L144;
L144: // GOTO
  goto L145;
L145: // GOTO
  goto L146;
L146: // GOTO
  goto L147;
L147: // GOTO
  goto L148;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // INIT_INT
  int_vars[6] = 0;
L152: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L153;
L153: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_bit_and_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L9: // BIT_AND_INT
  int_vars[6] = int_vars[4] & int_vars[5];
L10: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[6];
L11: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L12: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L14: // BIT_AND_INT
  int_vars[6] = int_vars[4] & int_vars[5];
L15: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L16: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L18: // BIT_AND_INT
  int_vars[2] = int_vars[2] & int_vars[4];
L19: // MOVE_INT
  int_vars[5] = int_vars[2];
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L21: // BIT_AND_INT
  int_vars[3] = int_vars[3] & int_vars[4];
L22: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L23: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L25: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L26: // BIT_AND_INT
  int_vars[8] = int_vars[6] & int_vars[7];
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L30: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L33: // BIT_AND_INT
  int_vars[8] = int_vars[6] & int_vars[7];
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L37: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L40: // BIT_AND_INT
  int_vars[8] = int_vars[6] & int_vars[7];
L41: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L44: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L46: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L47: // BIT_AND_INT
  int_vars[8] = int_vars[6] & int_vars[7];
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L53: // BIT_AND_INT
  int_vars[7] = int_vars[4] & int_vars[6];
L54: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[7]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L59: // BIT_AND_INT
  int_vars[7] = int_vars[4] & int_vars[6];
L60: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L65: // BIT_AND_INT
  int_vars[7] = int_vars[4] & int_vars[6];
L66: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L80;
L71: // GOTO
  goto L72;
L72: // GOTO
  goto L73;
L73: // GOTO
  goto L74;
L74: // GOTO
  goto L75;
L75: // GOTO
  goto L76;
L76: // GOTO
  goto L77;
L77: // GOTO
  goto L78;
L78: // INIT_INT
  int_vars[7] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L80;
L80: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_bit_or_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L9: // BIT_OR_INT
  int_vars[6] = int_vars[4] | int_vars[5];
L10: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[6];
L11: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L12: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L14: // BIT_OR_INT
  int_vars[6] = int_vars[4] | int_vars[5];
L15: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L16: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L18: // BIT_OR_INT
  int_vars[2] = int_vars[2] | int_vars[4];
L19: // MOVE_INT
  int_vars[5] = int_vars[2];
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L21: // BIT_OR_INT
  int_vars[3] = int_vars[3] | int_vars[4];
L22: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L23: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L25: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L26: // BIT_OR_INT
  int_vars[8] = int_vars[6] | int_vars[7];
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L30: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L33: // BIT_OR_INT
  int_vars[8] = int_vars[6] | int_vars[7];
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L37: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L40: // BIT_OR_INT
  int_vars[8] = int_vars[6] | int_vars[7];
L41: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L44: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L46: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L47: // BIT_OR_INT
  int_vars[8] = int_vars[6] | int_vars[7];
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L53: // BIT_OR_INT
  int_vars[7] = int_vars[4] | int_vars[6];
L54: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[7]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L59: // BIT_OR_INT
  int_vars[7] = int_vars[4] | int_vars[6];
L60: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L65: // BIT_OR_INT
  int_vars[7] = int_vars[4] | int_vars[6];
L66: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L70: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L71: // BIT_OR_INT
  int_vars[7] = int_vars[4] | int_vars[6];
L72: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L73: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L88;
L78: // GOTO
  goto L79;
L79: // GOTO
  goto L80;
L80: // GOTO
  goto L81;
L81: // GOTO
  goto L82;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // INIT_INT
  int_vars[7] = 0;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L88;
L88: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_bit_xor_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L9: // BIT_XOR_INT
  int_vars[6] = int_vars[4] ^ int_vars[5];
L10: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[6];
L11: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L12: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L14: // BIT_XOR_INT
  int_vars[6] = int_vars[4] ^ int_vars[5];
L15: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L16: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L18: // BIT_XOR_INT
  int_vars[2] = int_vars[2] ^ int_vars[4];
L19: // MOVE_INT
  int_vars[5] = int_vars[2];
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L21: // BIT_XOR_INT
  int_vars[3] = int_vars[3] ^ int_vars[4];
L22: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L23: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L25: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L26: // BIT_XOR_INT
  int_vars[8] = int_vars[6] ^ int_vars[7];
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L30: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L33: // BIT_XOR_INT
  int_vars[8] = int_vars[6] ^ int_vars[7];
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L37: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L40: // BIT_XOR_INT
  int_vars[8] = int_vars[6] ^ int_vars[7];
L41: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L44: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L46: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L47: // BIT_XOR_INT
  int_vars[8] = int_vars[6] ^ int_vars[7];
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L53: // BIT_XOR_INT
  int_vars[7] = int_vars[4] ^ int_vars[6];
L54: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[7]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L59: // BIT_XOR_INT
  int_vars[7] = int_vars[4] ^ int_vars[6];
L60: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L65: // BIT_XOR_INT
  int_vars[7] = int_vars[4] ^ int_vars[6];
L66: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L70: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L71: // BIT_XOR_INT
  int_vars[7] = int_vars[4] ^ int_vars[6];
L72: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L73: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L88;
L78: // GOTO
  goto L79;
L79: // GOTO
  goto L80;
L80: // GOTO
  goto L81;
L81: // GOTO
  goto L82;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // INIT_INT
  int_vars[7] = 0;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L88;
L88: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_concat(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62", 1));
L5: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], string3);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_concat";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 730;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L8: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L12;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_divide_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[3];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = 6LL;
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L9: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[3] / int_vars[4];
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L13: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L14: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L15: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L17: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[3] / int_vars[4];
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L20: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L22: // DIVIDE_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[2] = int_vars[2] / int_vars[3];
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L24: // MOVE_INT
  int_vars[4] = int_vars[2];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L26: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L27: // DIVIDE_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    long_vars[0] = long_vars[0] / long_vars[1];
  } 
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L29: // MOVE_LONG
  long_vars[2] = long_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L31: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L32: // DIVIDE_FLOAT
  float_vars[0] = float_vars[0] / float_vars[1];
L33: // MOVE_FLOAT
  float_vars[2] = float_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L35: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L36: // DIVIDE_DOUBLE
  double_vars[0] = double_vars[0] / double_vars[1];
L37: // MOVE_DOUBLE
  double_vars[2] = double_vars[0];
L38: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L41: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[5] / int_vars[6];
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 244;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L43: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L141; }
L46: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L48: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L49: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[5] / int_vars[6];
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L51: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L54: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L57: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[5] / int_vars[6];
  } 
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L59: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L139; }
L62: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L65: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[5] / int_vars[6];
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 247;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L67: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L138; }
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L72: // DIVIDE_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[6] = int_vars[3] / int_vars[5];
  } 
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L74: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L137; }
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L79: // DIVIDE_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[6] = int_vars[3] / int_vars[5];
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L81: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L136; }
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L86: // DIVIDE_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[6] = int_vars[3] / int_vars[5];
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L88: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L89: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L135; }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L93: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L94: // DIVIDE_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[6] = int_vars[3] / int_vars[5];
  } 
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_divide_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L96: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L97: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[1]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L134; }
L100: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L102: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L103: // DIVIDE_FLOAT
  float_vars[4] = float_vars[1] / float_vars[3];
L104: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L105: // BOOL_INT
  int_vars[0] = int_vars[0];
L106: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L107: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L110: // DIVIDE_FLOAT
  float_vars[4] = float_vars[1] / float_vars[3];
L111: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[4]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L132; }
L114: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L116: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L117: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[1] / double_vars[3];
L118: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L131; }
L121: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L123: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L124: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[1] / double_vars[3];
L125: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[2];
L126: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L130; }
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L143;
L129: // GOTO
  goto L130;
L130: // GOTO
  goto L131;
L131: // GOTO
  goto L132;
L132: // GOTO
  goto L133;
L133: // GOTO
  goto L134;
L134: // GOTO
  goto L135;
L135: // GOTO
  goto L136;
L136: // GOTO
  goto L137;
L137: // GOTO
  goto L138;
L138: // GOTO
  goto L139;
L139: // GOTO
  goto L140;
L140: // GOTO
  goto L141;
L141: // INIT_INT
  int_vars[6] = 0;
L142: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L143;
L143: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_left_shift_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L9: // LEFT_SHIFT_INT
  int_vars[6] = (int_vars[4] << int_vars[5]);
L10: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[6];
L11: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L12: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // LEFT_SHIFT_INT
  int_vars[6] = (int_vars[4] << int_vars[5]);
L15: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L16: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // LEFT_SHIFT_INT
  int_vars[2] = (int_vars[2] << int_vars[4]);
L19: // MOVE_INT
  int_vars[5] = int_vars[2];
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // LEFT_SHIFT_INT
  int_vars[3] = (int_vars[3] << int_vars[4]);
L22: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L23: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L25: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L26: // LEFT_SHIFT_INT
  int_vars[8] = (int_vars[6] << int_vars[7]);
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L30: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L33: // LEFT_SHIFT_INT
  int_vars[8] = (int_vars[6] << int_vars[7]);
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L37: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L40: // LEFT_SHIFT_INT
  int_vars[8] = (int_vars[6] << int_vars[7]);
L41: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L44: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L46: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L47: // LEFT_SHIFT_INT
  int_vars[8] = (int_vars[6] << int_vars[7]);
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L53: // LEFT_SHIFT_INT
  int_vars[7] = (int_vars[4] << int_vars[6]);
L54: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[7]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L59: // LEFT_SHIFT_INT
  int_vars[7] = (int_vars[4] << int_vars[6]);
L60: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L65: // LEFT_SHIFT_INT
  int_vars[7] = (int_vars[4] << int_vars[6]);
L66: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L70: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L71: // LEFT_SHIFT_INT
  int_vars[7] = (int_vars[4] << int_vars[6]);
L72: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L73: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L88;
L78: // GOTO
  goto L79;
L79: // GOTO
  goto L80;
L80: // GOTO
  goto L81;
L81: // GOTO
  goto L82;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // INIT_INT
  int_vars[7] = 0;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L88;
L88: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_multiply_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[3];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = 6LL;
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L9: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // MULTIPLY_INT
  int_vars[5] = int_vars[3] * int_vars[4];
L12: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L13: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L14: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L16: // MULTIPLY_INT
  int_vars[5] = int_vars[3] * int_vars[4];
L17: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L18: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L20: // MULTIPLY_INT
  int_vars[2] = int_vars[2] * int_vars[3];
L21: // MOVE_INT
  int_vars[4] = int_vars[2];
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L23: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L24: // MULTIPLY_LONG
  long_vars[0] = long_vars[0] * long_vars[1];
L25: // MOVE_LONG
  long_vars[2] = long_vars[0];
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L27: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L28: // MULTIPLY_FLOAT
  float_vars[0] = float_vars[0] * float_vars[1];
L29: // MOVE_FLOAT
  float_vars[2] = float_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L31: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L32: // MULTIPLY_DOUBLE
  double_vars[0] = double_vars[0] * double_vars[1];
L33: // MOVE_DOUBLE
  double_vars[2] = double_vars[0];
L34: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L37: // MULTIPLY_INT
  int_vars[7] = int_vars[5] * int_vars[6];
L38: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L129; }
L41: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L42: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L43: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L44: // MULTIPLY_INT
  int_vars[7] = int_vars[5] * int_vars[6];
L45: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L128; }
L48: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L51: // MULTIPLY_INT
  int_vars[7] = int_vars[5] * int_vars[6];
L52: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L127; }
L55: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L57: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L58: // MULTIPLY_INT
  int_vars[7] = int_vars[5] * int_vars[6];
L59: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L64: // MULTIPLY_INT
  int_vars[6] = int_vars[3] * int_vars[5];
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L125; }
L68: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L69: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L70: // MULTIPLY_INT
  int_vars[6] = int_vars[3] * int_vars[5];
L71: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L124; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L75: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L76: // MULTIPLY_INT
  int_vars[6] = int_vars[3] * int_vars[5];
L77: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L78: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L123; }
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L82: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L83: // MULTIPLY_INT
  int_vars[6] = int_vars[3] * int_vars[5];
L84: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L85: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[1]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L88: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L89: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L90: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L91: // MULTIPLY_FLOAT
  float_vars[4] = float_vars[1] * float_vars[3];
L92: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L93: // BOOL_INT
  int_vars[0] = int_vars[0];
L94: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L121; }
L95: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L96: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L97: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L98: // MULTIPLY_FLOAT
  float_vars[4] = float_vars[1] * float_vars[3];
L99: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[4]);
L100: // BOOL_INT
  int_vars[0] = int_vars[0];
L101: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L120; }
L102: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L104: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L105: // MULTIPLY_DOUBLE
  double_vars[4] = double_vars[1] * double_vars[3];
L106: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L109: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L110: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L111: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L112: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[1] * double_vars[3];
L113: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[2];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L118; }
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L117: // GOTO
  goto L118;
L118: // GOTO
  goto L119;
L119: // GOTO
  goto L120;
L120: // GOTO
  goto L121;
L121: // GOTO
  goto L122;
L122: // GOTO
  goto L123;
L123: // GOTO
  goto L124;
L124: // GOTO
  goto L125;
L125: // GOTO
  goto L126;
L126: // GOTO
  goto L127;
L127: // GOTO
  goto L128;
L128: // GOTO
  goto L129;
L129: // INIT_INT
  int_vars[6] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L131;
L131: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_remainder_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[1];
  int64_t long_vars[3];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = 6LL;
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L9: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // REMAINDER_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[3] % /* REMAINDER */ int_vars[4];
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L13: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L14: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L15: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L17: // REMAINDER_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[3] % /* REMAINDER */ int_vars[4];
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L20: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L22: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[2] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 207;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L24: // MOVE_INT
  int_vars[4] = int_vars[2];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L26: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L27: // REMAINDER_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    long_vars[0] = long_vars[0] % /* REMAINDER */ long_vars[1];
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L29: // MOVE_LONG
  long_vars[2] = long_vars[0];
L30: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L32: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L33: // REMAINDER_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[5] % /* REMAINDER */ int_vars[6];
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L35: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L38: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L41: // REMAINDER_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[5] % /* REMAINDER */ int_vars[6];
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L43: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L46: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L48: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L49: // REMAINDER_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[5] % /* REMAINDER */ int_vars[6];
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 212;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L51: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L54: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L57: // REMAINDER_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[5] % /* REMAINDER */ int_vars[6];
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L59: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L64: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L66: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L69: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L71: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 215;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L76: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L77: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L78: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 216;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L80: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L81: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L86: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_remainder_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L88: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L89: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[1]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L104;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // INIT_INT
  int_vars[6] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L104;
L104: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_right_shift_unsigned_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L11: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[5] = ((int32_t)((uint32_t)int_vars[3] >> int_vars[4]));
L14: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L15: // MOVE_BYTE
  byte_vars[0] = byte_vars[1];
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[5] = ((int32_t)((uint32_t)int_vars[3] >> int_vars[4]));
L19: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L20: // MOVE_SHORT
  short_vars[0] = short_vars[1];
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L22: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[2] = ((int32_t)((uint32_t)int_vars[2] >> int_vars[3]));
L23: // MOVE_INT
  int_vars[4] = int_vars[2];
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L25: // RIGHT_LOGICAL_SHIFT_LONG
  long_vars[0] = ((int64_t)((uint64_t)long_vars[0] >> int_vars[3]));
L26: // MOVE_LONG
  long_vars[1] = long_vars[0];
L27: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L28: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L30: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L32: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[7] = ((int32_t)((uint32_t)int_vars[5] >> int_vars[6]));
L33: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L36: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L37: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L39: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[7] = ((int32_t)((uint32_t)int_vars[5] >> int_vars[6]));
L42: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L45: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L46: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L48: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L49: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L50: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[7] = ((int32_t)((uint32_t)int_vars[5] >> int_vars[6]));
L51: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L54: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L55: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L57: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L59: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[7] = ((int32_t)((uint32_t)int_vars[5] >> int_vars[6]));
L60: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L63: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L66: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[6] = ((int32_t)((uint32_t)int_vars[3] >> int_vars[5]));
L67: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L70: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[6] = ((int32_t)((uint32_t)int_vars[3] >> int_vars[5]));
L74: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L77: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 36;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L80: // RIGHT_LOGICAL_SHIFT_LONG
  long_vars[3] = ((int64_t)((uint64_t)long_vars[2] >> int_vars[3]));
L81: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L84: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_unsigned_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L87: // RIGHT_LOGICAL_SHIFT_LONG
  long_vars[3] = ((int64_t)((uint64_t)long_vars[2] >> int_vars[3]));
L88: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[3]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_right_shift_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L11: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[5] = (int_vars[3] >> int_vars[4]);
L14: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L15: // MOVE_BYTE
  byte_vars[0] = byte_vars[1];
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[5] = (int_vars[3] >> int_vars[4]);
L19: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L20: // MOVE_SHORT
  short_vars[0] = short_vars[1];
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L22: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[2] = (int_vars[2] >> int_vars[3]);
L23: // MOVE_INT
  int_vars[4] = int_vars[2];
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L25: // RIGHT_ARITHMETIC_SHIFT_LONG
  long_vars[0] = (long_vars[0] >> int_vars[3]);
L26: // MOVE_LONG
  long_vars[1] = long_vars[0];
L27: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L28: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L30: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L32: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[7] = (int_vars[5] >> int_vars[6]);
L33: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L36: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L37: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L39: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[7] = (int_vars[5] >> int_vars[6]);
L42: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L45: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L46: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 62;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L48: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L49: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L50: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[7] = (int_vars[5] >> int_vars[6]);
L51: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L54: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L55: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L57: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L59: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[7] = (int_vars[5] >> int_vars[6]);
L60: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L63: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L66: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[6] = (int_vars[3] >> int_vars[5]);
L67: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L70: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[6] = (int_vars[3] >> int_vars[5]);
L74: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L77: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L80: // RIGHT_ARITHMETIC_SHIFT_LONG
  long_vars[3] = (long_vars[2] >> int_vars[3]);
L81: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[3]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L84: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_right_shift_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L87: // RIGHT_ARITHMETIC_SHIFT_LONG
  long_vars[3] = (long_vars[2] >> int_vars[3]);
L88: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[3]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__SpecialAssign__special_assign_subtract_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 315;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 316;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 318;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 319;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L15: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L18: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L19: // MOVE_BYTE
  byte_vars[0] = byte_vars[1];
L20: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L23: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L24: // MOVE_SHORT
  short_vars[0] = short_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // SUBTRACT_INT
  int_vars[2] = int_vars[2] - int_vars[3];
L27: // MOVE_INT
  int_vars[4] = int_vars[2];
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L29: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L30: // SUBTRACT_LONG
  long_vars[0] = long_vars[0] - long_vars[1];
L31: // MOVE_LONG
  long_vars[2] = long_vars[0];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L34: // SUBTRACT_FLOAT
  float_vars[0] = float_vars[0] - float_vars[1];
L35: // MOVE_FLOAT
  float_vars[2] = float_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L38: // SUBTRACT_DOUBLE
  double_vars[0] = double_vars[0] - double_vars[1];
L39: // MOVE_DOUBLE
  double_vars[2] = double_vars[0];
L40: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L41: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L43: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L44: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L45: // SUBTRACT_INT
  int_vars[7] = int_vars[5] - int_vars[6];
L46: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L49: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L50: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L52: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[2];
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L54: // SUBTRACT_INT
  int_vars[7] = int_vars[5] - int_vars[6];
L55: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L58: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L59: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 330;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L61: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L62: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L63: // SUBTRACT_INT
  int_vars[7] = int_vars[5] - int_vars[6];
L64: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L67: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L68: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[2];
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L72: // SUBTRACT_INT
  int_vars[7] = int_vars[5] - int_vars[6];
L73: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L148; }
L76: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L79: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[5];
L80: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L147; }
L83: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L86: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[5];
L87: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L146; }
L90: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L94: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[3];
L95: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L145; }
L98: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L101: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L102: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[3];
L103: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[4]);
L104: // BOOL_INT
  int_vars[0] = int_vars[0];
L105: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L144; }
L106: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 336;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L110: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[3];
L111: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L143; }
L114: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 337;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L117: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L118: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[3];
L119: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[4]);
L120: // BOOL_INT
  int_vars[0] = int_vars[0];
L121: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L142; }
L122: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 338;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L124: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L125: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L126: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[3];
L127: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L128: // BOOL_INT
  int_vars[0] = int_vars[0];
L129: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L141; }
L130: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::SpecialAssign";
    const char* sub_name = "special_assign_subtract_var";
    const char* file = "TestCase/SpecialAssign.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L132: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L133: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L134: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[3];
L135: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[2];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L137: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L138: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L153;
L139: // GOTO
  goto L140;
L140: // GOTO
  goto L141;
L141: // GOTO
  goto L142;
L142: // GOTO
  goto L143;
L143: // GOTO
  goto L144;
L144: // GOTO
  goto L145;
L145: // GOTO
  goto L146;
L146: // GOTO
  goto L147;
L147: // GOTO
  goto L148;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // INIT_INT
  int_vars[6] = 0;
L152: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L153;
L153: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


