#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__ShortList__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__ShortList__length = -1;
static int32_t FIELD_ID_SPVM__ShortList__capacity = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__ShortList__capacity = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT16_MAX = - 1;
static int32_t SUB_ID_SPVM__ShortList__newa = - 1;
static int32_t SUB_ID_SPVM__ShortList__get = - 1;
static int32_t SUB_ID_SPVM__ShortList__length = - 1;
static int32_t SUB_ID_SPVM__ShortList__insert = - 1;
static int32_t SUB_ID_SPVM__ShortList__to_array = - 1;
static int32_t SUB_ID_SPVM__Util__equals_sarray = - 1;
static int32_t SUB_ID_SPVM__ShortList__capacity = - 1;
static int32_t SUB_ID_SPVM__ShortList__new = - 1;
static int32_t SUB_ID_SPVM__ShortList__unshift = - 1;
static int32_t SUB_ID_SPVM__ShortList__new_capacity = - 1;
static int32_t SUB_ID_SPVM__ShortList__push = - 1;
static int32_t SUB_ID_SPVM__ShortList__pop = - 1;
static int32_t SUB_ID_SPVM__ShortList__remove = - 1;
static int32_t SUB_ID_SPVM__ShortList__set = - 1;
static int32_t SUB_ID_SPVM__ShortList__shift = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_short = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__get(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__insert(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__length(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__new_capacity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__newa(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__pop(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__push(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__remove(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__set(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__shift(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__to_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__unshift(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__get(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L27: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L28: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L30: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L32: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[4];
L40: // MOVE_INT
  int_vars[0] = int_vars[0];
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L49: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 204;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L51: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L53: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L58: // GOTO
  goto L59;
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L60: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L61: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L62: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L64: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L65: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L67: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L68: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L73: // GOTO
  goto L74;
L74: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 212;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L77: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_NE_ZERO
  if (int_vars[0]) { goto L83; }
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L82: // GOTO
  goto L83;
L83: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L84: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L87: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 218;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L89;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L90: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L91: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L92: // IF_NE_ZERO
  if (int_vars[0]) { goto L97; }
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L96: // GOTO
  goto L97;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L99: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L100: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L101: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L102: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L103: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 225;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L105: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L106: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L107: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L108: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L111: // GOTO
  goto L112;
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L117: // INIT_INT
  int_vars[4] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L119;
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__insert(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[21];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L27: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L31: // CALL_SUB_VOID
  // SPVM::ShortList->insert
  {
    if (SUB_ID_SPVM__ShortList__insert < 0) {
      SUB_ID_SPVM__ShortList__insert = env->get_sub_id(env, "SPVM::ShortList", "insert", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L35: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L39: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L42: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L47: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L48: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L49: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L52: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[7];
L53: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L54: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L57: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[9];
L58: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L59: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L63: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[11];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L76: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L79: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L80: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L81: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L84: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L85: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L86: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L89: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L90: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L91: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L95: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L97: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L98: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L100: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L102: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L103: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L104: // CALL_SUB_VOID
  // SPVM::ShortList->insert
  {
    if (SUB_ID_SPVM__ShortList__insert < 0) {
      SUB_ID_SPVM__ShortList__insert = env->get_sub_id(env, "SPVM::ShortList", "insert", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L107: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L108: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L111: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L112: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L115: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L116: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L117: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L120: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L121: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L122: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L124: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L125: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[7];
L126: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L127: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L129: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L130: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[9];
L131: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L132: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L134: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L135: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L136: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L137: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L138: // BOOL_INT
  int_vars[0] = int_vars[11];
L139: // IF_NE_ZERO
  if (int_vars[0]) { goto L145; }
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L141: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L142: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L144: // GOTO
  goto L145;
L145: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L146: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L147: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L149: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L151: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L152: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L153: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L154: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L157: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L158: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L159: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L162: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L163: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L164: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L166: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L167: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L168: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L170: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L171: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L172: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L173: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L174: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L175: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L176: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L177: // CALL_SUB_VOID
  // SPVM::ShortList->insert
  {
    if (SUB_ID_SPVM__ShortList__insert < 0) {
      SUB_ID_SPVM__ShortList__insert = env->get_sub_id(env, "SPVM::ShortList", "insert", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L179: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L180: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L181: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L183: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L184: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L185: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L186: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L187: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L188: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L189: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L190: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L193: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L194: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L195: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L198: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[7];
L199: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L200: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L201: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L202: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L203: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[9];
L204: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L205: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L207: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L208: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L209: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L210: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L211: // BOOL_INT
  int_vars[0] = int_vars[11];
L212: // IF_NE_ZERO
  if (int_vars[0]) { goto L218; }
L213: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L214: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L215: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L216: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L217: // GOTO
  goto L218;
L218: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L219: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L220: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L221: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L222: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L223: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L224: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L225: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L226: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L227: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L228: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L229: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L230: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L231: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L232: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L233: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L234: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L235: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L236: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L237: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L238: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L239: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L240: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L241: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L242: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L243: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L244: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L245: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L246: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L247: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L248: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L249: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L250: // CALL_SUB_VOID
  // SPVM::ShortList->insert
  {
    if (SUB_ID_SPVM__ShortList__insert < 0) {
      SUB_ID_SPVM__ShortList__insert = env->get_sub_id(env, "SPVM::ShortList", "insert", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L251: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L252: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__capacity < 0, 0)) {
      FIELD_ID_SPVM__ShortList__capacity = env->get_field_id(env, "SPVM::ShortList", "capacity", "int");
      if (FIELD_ID_SPVM__ShortList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__capacity);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__capacity);
    }
  }
L253: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L254: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L255: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L256: // BOOL_INT
  int_vars[0] = int_vars[0];
L257: // IF_NE_ZERO
  if (int_vars[0]) { goto L261; }
L258: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L259: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L260: // GOTO
  goto L261;
L261: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L262: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L263: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L264: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L265: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L266: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L267: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L268: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L269: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L270: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L271: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L272: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L273: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L274: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L275: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L276: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L277: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L278: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L279: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L280: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L281: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L282: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L283: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L284: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L285: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L286: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L287: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L288: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L289: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L290: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L291: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L292: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L293: // CALL_SUB_VOID
  // SPVM::ShortList->insert
  {
    if (SUB_ID_SPVM__ShortList__insert < 0) {
      SUB_ID_SPVM__ShortList__insert = env->get_sub_id(env, "SPVM::ShortList", "insert", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L294: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 87;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L295: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L296: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L297: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L298: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L299: // IF_NE_ZERO
  if (int_vars[0]) { goto L304; }
L300: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L301: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L302: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L303: // GOTO
  goto L304;
L304: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L305: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L306: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L307: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L308: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L309: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L310: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L311: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L312: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L313: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L314: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L315: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L316: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L317: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L318: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L319: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L320: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L321: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L322: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[7];
L323: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L324: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L325: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L326: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L327: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L328: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L329: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L330: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L331: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L332: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L333: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L334: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L335: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L336: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L337: // CALL_SUB_VOID
  // SPVM::ShortList->insert
  {
    if (SUB_ID_SPVM__ShortList__insert < 0) {
      SUB_ID_SPVM__ShortList__insert = env->get_sub_id(env, "SPVM::ShortList", "insert", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L338: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 97;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L339: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L340: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L341: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L342: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L343: // IF_NE_ZERO
  if (int_vars[0]) { goto L348; }
L344: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L345: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L346: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L347: // GOTO
  goto L348;
L348: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L349: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L350: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L351: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L352: // INIT_INT
  int_vars[4] = 0;
L353: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L354;
L354: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L355: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__length(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L16: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 456;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L36;
L30: // GOTO
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__new_capacity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ShortList->new_capacity
  {
    if (SUB_ID_SPVM__ShortList__new_capacity < 0) {
      SUB_ID_SPVM__ShortList__new_capacity = env->get_sub_id(env, "SPVM::ShortList", "new_capacity", "SPVM::ShortList(int)");
      if (SUB_ID_SPVM__ShortList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L6: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L14: // GOTO
  goto L15;
L15: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__capacity < 0, 0)) {
      FIELD_ID_SPVM__ShortList__capacity = env->get_field_id(env, "SPVM::ShortList", "capacity", "int");
      if (FIELD_ID_SPVM__ShortList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__capacity);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__capacity);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 32;
L18: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L23: // GOTO
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__newa(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L27: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L28: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L30: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L32: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L80;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L40: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L41: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L43: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L44: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L45: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L80;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L53: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L54: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L56: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L57: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L59: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L60: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L80;
L65: // GOTO
  goto L66;
L66: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L80;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L69: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L80;
L74: // GOTO
  goto L75;
L75: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L80;
L78: // INIT_INT
  int_vars[6] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L80;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__pop(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 330;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L16: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_SHORT
  // SPVM::ShortList->pop
  {
    if (SUB_ID_SPVM__ShortList__pop < 0) {
      SUB_ID_SPVM__ShortList__pop = env->get_sub_id(env, "SPVM::ShortList", "pop", "short(self)");
      if (SUB_ID_SPVM__ShortList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L25: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L26: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L28: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L36: // BOOL_INT
  int_vars[0] = int_vars[4];
L37: // MOVE_INT
  int_vars[0] = int_vars[0];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L42: // GOTO
  goto L43;
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L44: // CALL_SUB_SHORT
  // SPVM::ShortList->pop
  {
    if (SUB_ID_SPVM__ShortList__pop < 0) {
      SUB_ID_SPVM__ShortList__pop = env->get_sub_id(env, "SPVM::ShortList", "pop", "short(self)");
      if (SUB_ID_SPVM__ShortList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 342;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L46: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L53: // GOTO
  goto L54;
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L55: // CALL_SUB_SHORT
  // SPVM::ShortList->pop
  {
    if (SUB_ID_SPVM__ShortList__pop < 0) {
      SUB_ID_SPVM__ShortList__pop = env->get_sub_id(env, "SPVM::ShortList", "pop", "short(self)");
      if (SUB_ID_SPVM__ShortList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 346;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L57: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L59: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L64: // GOTO
  goto L65;
L65: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L93;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L73: // GOTO
  goto L74;
L74: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L76: // CALL_SUB_SHORT
  // SPVM::ShortList->pop
  {
    if (SUB_ID_SPVM__ShortList__pop < 0) {
      SUB_ID_SPVM__ShortList__pop = env->get_sub_id(env, "SPVM::ShortList", "pop", "short(self)");
      if (SUB_ID_SPVM__ShortList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L77: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 356;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L79: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L80: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L82: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L85: // GOTO
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L93;
L91: // INIT_INT
  int_vars[4] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L93;
L93: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L94: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__push(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L16: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 291;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L34: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L36: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L37: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L38: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L43: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L44: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L46: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[3];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[4];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[5];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L63: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L64: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L66: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L67: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L69: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L70: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // GOTO
  goto L81;
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L80: // BOOL_INT
  int_vars[0] = int_vars[5];
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L85: // GOTO
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L88: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L91: // GOTO
  goto L101;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L95: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L96: // CALL_SUB_VOID
  // SPVM::ShortList->push
  {
    if (SUB_ID_SPVM__ShortList__push < 0) {
      SUB_ID_SPVM__ShortList__push = env->get_sub_id(env, "SPVM::ShortList", "push", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L98: // MOVE_INT
  int_vars[3] = int_vars[2];
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L100: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L102: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L92; }
L105: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L108: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L111: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L113: // GOTO
  goto L114;
L114: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L115: // GOTO
  goto L131;
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L117: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L118: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 315;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L120: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L121: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L122: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L123: // BOOL_INT
  int_vars[0] = int_vars[0];
L124: // IF_NE_ZERO
  if (int_vars[0]) { goto L128; }
L125: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L127: // GOTO
  goto L128;
L128: // MOVE_INT
  int_vars[6] = int_vars[5];
L129: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L130: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L131: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L132: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_NE_ZERO
  if (int_vars[0]) { goto L116; }
L135: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L138: // INIT_INT
  int_vars[5] = 0;
L139: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L140;
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__remove(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[19];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L21: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[8];
L22: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L23: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L33: // CALL_SUB_SHORT
  // SPVM::ShortList->remove
  {
    if (SUB_ID_SPVM__ShortList__remove < 0) {
      SUB_ID_SPVM__ShortList__remove = env->get_sub_id(env, "SPVM::ShortList", "remove", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L41: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L46: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L49: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[5];
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L51: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L54: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[7];
L55: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L56: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L60: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L62: // BOOL_INT
  int_vars[0] = int_vars[9];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L68: // GOTO
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L72: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L84: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L85: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L86: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L89: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L90: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L91: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L94: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L95: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L96: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L100: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L105: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L106: // CALL_SUB_SHORT
  // SPVM::ShortList->remove
  {
    if (SUB_ID_SPVM__ShortList__remove < 0) {
      SUB_ID_SPVM__ShortList__remove = env->get_sub_id(env, "SPVM::ShortList", "remove", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L110: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L113: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L114: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L117: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L119: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L121: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L122: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L123: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L124: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L126: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L127: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L128: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L130: // BOOL_INT
  int_vars[0] = int_vars[7];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L137; }
L132: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L133: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L134: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L135: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L136: // GOTO
  goto L137;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L140: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L141: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L144: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L145: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L146: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L149: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L150: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L151: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L153: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L154: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L155: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L156: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L157: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L158: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L159: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L160: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L162: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L163: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L164: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L165: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L166: // CALL_SUB_SHORT
  // SPVM::ShortList->remove
  {
    if (SUB_ID_SPVM__ShortList__remove < 0) {
      SUB_ID_SPVM__ShortList__remove = env->get_sub_id(env, "SPVM::ShortList", "remove", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L168: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L169: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L170: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L171: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L172: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L173: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L174: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L176: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L177: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L178: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L179: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L182: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L183: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L184: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L186: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L187: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L188: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L190: // BOOL_INT
  int_vars[0] = int_vars[7];
L191: // IF_NE_ZERO
  if (int_vars[0]) { goto L197; }
L192: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L193: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L194: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L195: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L196: // GOTO
  goto L197;
L197: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L198: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L199: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L200: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L201: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L202: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L203: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L204: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L205: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L206: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L207: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L208: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L209: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L210: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L211: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L212: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L213: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L215: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L216: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L217: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L218: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L219: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L220: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L221: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L222: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L223: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L224: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L225: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L226: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L227: // CALL_SUB_SHORT
  // SPVM::ShortList->remove
  {
    if (SUB_ID_SPVM__ShortList__remove < 0) {
      SUB_ID_SPVM__ShortList__remove = env->get_sub_id(env, "SPVM::ShortList", "remove", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L228: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 141;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L229: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L230: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L231: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L232: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L233: // IF_NE_ZERO
  if (int_vars[0]) { goto L238; }
L234: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L235: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L236: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L237: // GOTO
  goto L238;
L238: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L239: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L240: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L241: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L242: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L243: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L244: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L245: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L246: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L247: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L248: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L249: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L250: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L251: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L252: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L253: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L254: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L255: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L256: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[7];
L257: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L258: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L259: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L260: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L261: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L262: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L263: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L264: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L265: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L266: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L267: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L268: // CALL_SUB_SHORT
  // SPVM::ShortList->remove
  {
    if (SUB_ID_SPVM__ShortList__remove < 0) {
      SUB_ID_SPVM__ShortList__remove = env->get_sub_id(env, "SPVM::ShortList", "remove", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L269: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 151;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L270: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L271: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L272: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L273: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L274: // IF_NE_ZERO
  if (int_vars[0]) { goto L279; }
L275: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L276: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L277: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L278: // GOTO
  goto L279;
L279: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L280: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L281: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L282: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L283: // INIT_INT
  int_vars[4] = 0;
L284: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L285;
L285: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L286: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__set(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L27: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L31: // CALL_SUB_VOID
  // SPVM::ShortList->set
  {
    if (SUB_ID_SPVM__ShortList__set < 0) {
      SUB_ID_SPVM__ShortList__set = env->get_sub_id(env, "SPVM::ShortList", "set", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L35: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L38: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L39: // CALL_SUB_VOID
  // SPVM::ShortList->set
  {
    if (SUB_ID_SPVM__ShortList__set < 0) {
      SUB_ID_SPVM__ShortList__set = env->get_sub_id(env, "SPVM::ShortList", "set", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L42: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L45: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L46: // PUSH_ARG_SHORT
  *(int16_t*)&stack[2] = short_vars[0];
L47: // CALL_SUB_VOID
  // SPVM::ShortList->set
  {
    if (SUB_ID_SPVM__ShortList__set < 0) {
      SUB_ID_SPVM__ShortList__set = env->get_sub_id(env, "SPVM::ShortList", "set", "void(self,int,short)");
      if (SUB_ID_SPVM__ShortList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L51: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L52: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L54: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L56: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L61: // GOTO
  goto L62;
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L63: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L64: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L65: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L67: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L68: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L69: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L74: // GOTO
  goto L75;
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L77: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L78: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L80: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L81: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L83: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L84: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L89: // GOTO
  goto L90;
L90: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L93: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L98: // GOTO
  goto L99;
L99: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L100: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L102: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L103: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L104: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 263;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L105: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L106: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L107: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L109: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L112: // GOTO
  goto L113;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L115: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L117: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L118: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L119: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 270;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L120: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L121: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L122: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L128; }
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L127: // GOTO
  goto L128;
L128: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L129: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L130: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L133: // INIT_INT
  int_vars[4] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L135;
L135: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L136: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__shift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 412;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L16: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_SHORT
  // SPVM::ShortList->shift
  {
    if (SUB_ID_SPVM__ShortList__shift < 0) {
      SUB_ID_SPVM__ShortList__shift = env->get_sub_id(env, "SPVM::ShortList", "shift", "short(self)");
      if (SUB_ID_SPVM__ShortList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L25: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L26: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L28: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L34: // GOTO
  goto L35;
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L36: // CALL_SUB_SHORT
  // SPVM::ShortList->shift
  {
    if (SUB_ID_SPVM__ShortList__shift < 0) {
      SUB_ID_SPVM__ShortList__shift = env->get_sub_id(env, "SPVM::ShortList", "shift", "short(self)");
      if (SUB_ID_SPVM__ShortList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L38: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L40: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L45: // GOTO
  goto L46;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_SHORT
  // SPVM::ShortList->shift
  {
    if (SUB_ID_SPVM__ShortList__shift < 0) {
      SUB_ID_SPVM__ShortList__shift = env->get_sub_id(env, "SPVM::ShortList", "shift", "short(self)");
      if (SUB_ID_SPVM__ShortList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L49: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L50: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L51: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L56: // GOTO
  goto L57;
L57: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 430;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L85;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L65: // GOTO
  goto L66;
L66: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L68: // CALL_SUB_SHORT
  // SPVM::ShortList->shift
  {
    if (SUB_ID_SPVM__ShortList__shift < 0) {
      SUB_ID_SPVM__ShortList__shift = env->get_sub_id(env, "SPVM::ShortList", "shift", "short(self)");
      if (SUB_ID_SPVM__ShortList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 436;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L71: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L72: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L85;
L83: // INIT_INT
  int_vars[4] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L85;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__to_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::ShortList->newa
  {
    if (SUB_ID_SPVM__ShortList__newa < 0) {
      SUB_ID_SPVM__ShortList__newa = env->get_sub_id(env, "SPVM::ShortList", "newa", "SPVM::ShortList(short[])");
      if (SUB_ID_SPVM__ShortList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L27: // CALL_SUB_OBJECT
  // SPVM::ShortList->to_array
  {
    if (SUB_ID_SPVM__ShortList__to_array < 0) {
      SUB_ID_SPVM__ShortList__to_array = env->get_sub_id(env, "SPVM::ShortList", "to_array", "short[](self)");
      if (SUB_ID_SPVM__ShortList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L29: // IS_TYPE
  {
    if (BASIC_TYPE_ID_short < 0) {
      BASIC_TYPE_ID_short = env->get_basic_type_id(env, "short");
      if (BASIC_TYPE_ID_short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_short;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L84;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L38: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L39: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L40: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L84;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 175;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L49: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L51: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L84;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L58: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L60: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L61: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L63: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L64: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L84;
L69: // GOTO
  goto L70;
L70: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L84;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L84;
L78: // GOTO
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L84;
L82: // INIT_INT
  int_vars[6] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ShortList__unshift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 370;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 372;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L16: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 376;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L34: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L36: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L37: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L39: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L40: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L45: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L46: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L48: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L50: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L54: // BOOL_INT
  int_vars[0] = int_vars[3];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[4];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[5];
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L64: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L65: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L66: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L68: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L69: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L70: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // GOTO
  goto L81;
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L80: // BOOL_INT
  int_vars[0] = int_vars[5];
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L85: // GOTO
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L88: // CALL_SUB_OBJECT
  // SPVM::ShortList->new
  {
    if (SUB_ID_SPVM__ShortList__new < 0) {
      SUB_ID_SPVM__ShortList__new = env->get_sub_id(env, "SPVM::ShortList", "new", "SPVM::ShortList()");
      if (SUB_ID_SPVM__ShortList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L91: // GOTO
  goto L101;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L95: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[0];
L96: // CALL_SUB_VOID
  // SPVM::ShortList->unshift
  {
    if (SUB_ID_SPVM__ShortList__unshift < 0) {
      SUB_ID_SPVM__ShortList__unshift = env->get_sub_id(env, "SPVM::ShortList", "unshift", "void(self,short)");
      if (SUB_ID_SPVM__ShortList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L98: // MOVE_INT
  int_vars[3] = int_vars[2];
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L100: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L102: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L92; }
L105: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ShortList__length < 0, 0)) {
      FIELD_ID_SPVM__ShortList__length = env->get_field_id(env, "SPVM::ShortList", "length", "int");
      if (FIELD_ID_SPVM__ShortList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ShortList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ShortList__length = env->get_field_offset(env, FIELD_ID_SPVM__ShortList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ShortList__length);
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 394;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L108: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L111: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L113: // GOTO
  goto L114;
L114: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L115: // GOTO
  goto L131;
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L117: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L118: // CALL_SUB_SHORT
  // SPVM::ShortList->get
  {
    if (SUB_ID_SPVM__ShortList__get < 0) {
      SUB_ID_SPVM__ShortList__get = env->get_sub_id(env, "SPVM::ShortList", "get", "short(self,int)");
      if (SUB_ID_SPVM__ShortList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ShortList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ShortList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ShortList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/ShortList.spvm";
    int32_t line = 400;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L120: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L121: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L122: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L123: // BOOL_INT
  int_vars[0] = int_vars[0];
L124: // IF_NE_ZERO
  if (int_vars[0]) { goto L128; }
L125: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L127: // GOTO
  goto L128;
L128: // MOVE_INT
  int_vars[6] = int_vars[5];
L129: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L130: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L131: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L132: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_NE_ZERO
  if (int_vars[0]) { goto L116; }
L135: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L138: // INIT_INT
  int_vars[5] = 0;
L139: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L140;
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


