#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_SPVM__Math__INFINITY = - 1;
static int32_t SUB_ID_SPVM__Math__isinf = - 1;
static int32_t SUB_ID_SPVM__Math__NAN = - 1;
static int32_t SUB_ID_SPVM__Math__isnan = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MAX = - 1;
static int32_t SUB_ID_SPVM__Math__signbit = - 1;
static int32_t SUB_ID_SPVM__Math__INFINITYF = - 1;
static int32_t SUB_ID_SPVM__Math__NANF = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MAX = - 1;
static int32_t SUB_ID_SPVM__Math__isinff = - 1;
static int32_t SUB_ID_SPVM__Math__signbitf = - 1;
static int32_t SUB_ID_SPVM__Math__acos = - 1;
static int32_t SUB_ID_SPVM__Util__PI = - 1;
static int32_t SUB_ID_SPVM__Math__acosf = - 1;
static int32_t SUB_ID_SPVM__Math__acosh = - 1;
static int32_t SUB_ID_SPVM__Math__acoshf = - 1;
static int32_t SUB_ID_SPVM__Math__asin = - 1;
static int32_t SUB_ID_SPVM__Math__asinf = - 1;
static int32_t SUB_ID_SPVM__Math__asinh = - 1;
static int32_t SUB_ID_SPVM__Math__asinhf = - 1;
static int32_t SUB_ID_SPVM__Math__atan = - 1;
static int32_t SUB_ID_SPVM__Math__atanf = - 1;
static int32_t SUB_ID_SPVM__Math__atanh = - 1;
static int32_t SUB_ID_SPVM__Math__atanhf = - 1;
static int32_t SUB_ID_SPVM__Math__cbrt = - 1;
static int32_t SUB_ID_SPVM__Math__cbrtf = - 1;
static int32_t SUB_ID_SPVM__Math__ceil = - 1;
static int32_t SUB_ID_SPVM__Math__ceilf = - 1;
static int32_t SUB_ID_SPVM__Math__copysign = - 1;
static int32_t SUB_ID_SPVM__Math__copysignf = - 1;
static int32_t SUB_ID_SPVM__Math__cos = - 1;
static int32_t SUB_ID_SPVM__Math__cosf = - 1;
static int32_t SUB_ID_SPVM__Math__cosh = - 1;
static int32_t SUB_ID_SPVM__Math__coshf = - 1;
static int32_t SUB_ID_SPVM__Math__erf = - 1;
static int32_t SUB_ID_SPVM__Math__erfc = - 1;
static int32_t SUB_ID_SPVM__Math__erff = - 1;
static int32_t SUB_ID_SPVM__Math__exp = - 1;
static int32_t SUB_ID_SPVM__Math__exp2 = - 1;
static int32_t SUB_ID_SPVM__Math__exp2f = - 1;
static int32_t SUB_ID_SPVM__Math__expf = - 1;
static int32_t SUB_ID_SPVM__Math__expm1 = - 1;
static int32_t SUB_ID_SPVM__Math__expm1f = - 1;
static int32_t SUB_ID_SPVM__Math__fabs = - 1;
static int32_t SUB_ID_SPVM__Math__fabsf = - 1;
static int32_t SUB_ID_SPVM__Math__fdim = - 1;
static int32_t SUB_ID_SPVM__Math__fdimf = - 1;
static int32_t SUB_ID_SPVM__Math__isnanf = - 1;
static int32_t SUB_ID_SPVM__Math__floor = - 1;
static int32_t SUB_ID_SPVM__Math__floorf = - 1;
static int32_t SUB_ID_SPVM__Math__fma = - 1;
static int32_t SUB_ID_SPVM__Math__fmaf = - 1;
static int32_t SUB_ID_SPVM__Math__fmax = - 1;
static int32_t SUB_ID_SPVM__Math__fmaxf = - 1;
static int32_t SUB_ID_SPVM__Math__fmin = - 1;
static int32_t SUB_ID_SPVM__Math__fminf = - 1;
static int32_t SUB_ID_SPVM__Math__fmod = - 1;
static int32_t SUB_ID_SPVM__Math__fmodf = - 1;
static int32_t SUB_ID_SPVM__Math__fpclassify = - 1;
static int32_t SUB_ID_SPVM__Math__FP_INFINITE = - 1;
static int32_t SUB_ID_SPVM__Math__FP_NAN = - 1;
static int32_t SUB_ID_SPVM__Math__FP_NORMAL = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Math__FP_SUBNORMAL = - 1;
static int32_t SUB_ID_SPVM__Math__FP_ZERO = - 1;
static int32_t SUB_ID_SPVM__Math__fpclassifyf = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Math__frexp = - 1;
static int32_t SUB_ID_SPVM__Math__frexpf = - 1;
static int32_t SUB_ID_SPVM__Math__hypot = - 1;
static int32_t SUB_ID_SPVM__Math__hypotf = - 1;
static int32_t SUB_ID_SPVM__Math__ilogb = - 1;
static int32_t SUB_ID_SPVM__Math__FP_ILOGB0 = - 1;
static int32_t SUB_ID_SPVM__Math__FP_ILOGBNAN = - 1;
static int32_t SUB_ID_SPVM__Math__ilogbf = - 1;
static int32_t SUB_ID_SPVM__Math__isfinite = - 1;
static int32_t SUB_ID_SPVM__Math__isfinitef = - 1;
static int32_t SUB_ID_SPVM__Math__isgreater = - 1;
static int32_t SUB_ID_SPVM__Math__isgreaterequal = - 1;
static int32_t SUB_ID_SPVM__Math__isgreaterequalf = - 1;
static int32_t SUB_ID_SPVM__Math__isgreaterf = - 1;
static int32_t SUB_ID_SPVM__Math__isless = - 1;
static int32_t SUB_ID_SPVM__Math__islessequal = - 1;
static int32_t SUB_ID_SPVM__Math__islessequalf = - 1;
static int32_t SUB_ID_SPVM__Math__islessf = - 1;
static int32_t SUB_ID_SPVM__Math__islessgreater = - 1;
static int32_t SUB_ID_SPVM__Math__islessgreaterf = - 1;
static int32_t SUB_ID_SPVM__Math__isnormal = - 1;
static int32_t SUB_ID_SPVM__Math__isnormalf = - 1;
static int32_t SUB_ID_SPVM__Math__isunordered = - 1;
static int32_t SUB_ID_SPVM__Math__isunorderedf = - 1;
static int32_t SUB_ID_SPVM__Math__ldexp = - 1;
static int32_t SUB_ID_SPVM__Math__ldexpf = - 1;
static int32_t SUB_ID_SPVM__Math__lgamma = - 1;
static int32_t SUB_ID_SPVM__Math__lgammaf = - 1;
static int32_t SUB_ID_SPVM__Math__log = - 1;
static int32_t SUB_ID_SPVM__Math__log10 = - 1;
static int32_t SUB_ID_SPVM__Math__log10f = - 1;
static int32_t SUB_ID_SPVM__Math__log1p = - 1;
static int32_t SUB_ID_SPVM__Math__log1pf = - 1;
static int32_t SUB_ID_SPVM__Math__log2 = - 1;
static int32_t SUB_ID_SPVM__Math__log2f = - 1;
static int32_t SUB_ID_SPVM__Math__logb = - 1;
static int32_t SUB_ID_SPVM__Math__logbf = - 1;
static int32_t SUB_ID_SPVM__Math__logf = - 1;
static int32_t SUB_ID_SPVM__Math__lround = - 1;
static int32_t SUB_ID_SPVM__Math__lroundf = - 1;
static int32_t SUB_ID_SPVM__Math__modf = - 1;
static int32_t SUB_ID_SPVM__Math__modff = - 1;
static int32_t SUB_ID_SPVM__Math__nan = - 1;
static int32_t SUB_ID_SPVM__Util__contains = - 1;
static int32_t SUB_ID_SPVM__Math__nanf = - 1;
static int32_t SUB_ID_SPVM__Math__FE_DOWNWARD = - 1;
static int32_t SUB_ID_SPVM__Math__fesetround = - 1;
static int32_t SUB_ID_SPVM__Math__nearbyint = - 1;
static int32_t SUB_ID_SPVM__Math__FE_TONEAREST = - 1;
static int32_t SUB_ID_SPVM__Math__FE_TOWARDZERO = - 1;
static int32_t SUB_ID_SPVM__Math__FE_UPWARD = - 1;
static int32_t SUB_ID_SPVM__Math__nearbyintf = - 1;
static int32_t SUB_ID_SPVM__Math__nextafter = - 1;
static int32_t SUB_ID_SPVM__Math__nextafterf = - 1;
static int32_t SUB_ID_SPVM__Math__nexttoward = - 1;
static int32_t SUB_ID_SPVM__Math__nexttowardf = - 1;
static int32_t SUB_ID_SPVM__Math__pow = - 1;
static int32_t SUB_ID_SPVM__Math__powf = - 1;
static int32_t SUB_ID_SPVM__Math__remainder = - 1;
static int32_t SUB_ID_SPVM__Math__remainderf = - 1;
static int32_t SUB_ID_SPVM__Math__remquo = - 1;
static int32_t SUB_ID_SPVM__Math__remquof = - 1;
static int32_t SUB_ID_SPVM__Math__round = - 1;
static int32_t SUB_ID_SPVM__Math__roundf = - 1;
static int32_t SUB_ID_SPVM__Math__scalbln = - 1;
static int32_t SUB_ID_SPVM__Math__scalblnf = - 1;
static int32_t SUB_ID_SPVM__Math__scalbn = - 1;
static int32_t SUB_ID_SPVM__Math__scalbnf = - 1;
static int32_t SUB_ID_SPVM__Math__sin = - 1;
static int32_t SUB_ID_SPVM__Math__sinf = - 1;
static int32_t SUB_ID_SPVM__Math__sinh = - 1;
static int32_t SUB_ID_SPVM__Math__sinhf = - 1;
static int32_t SUB_ID_SPVM__Math__sqrt = - 1;
static int32_t SUB_ID_SPVM__Math__sqrtf = - 1;
static int32_t SUB_ID_SPVM__Math__tan = - 1;
static int32_t SUB_ID_SPVM__Math__tanf = - 1;
static int32_t SUB_ID_SPVM__Math__tanh = - 1;
static int32_t SUB_ID_SPVM__Math__tanhf = - 1;
static int32_t SUB_ID_SPVM__Math__tgamma = - 1;
static int32_t SUB_ID_SPVM__Math__tgammaf = - 1;
static int32_t SUB_ID_SPVM__Math__trunc = - 1;
static int32_t SUB_ID_SPVM__Math__truncf = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_nan_left(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_nan_right(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_over_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_over_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_same_sign_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_nan_left(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_nan_right(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_over_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_over_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_same_sign_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_nan_left(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_nan_right(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_over_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_over_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_nan_left(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_nan_right(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_over_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_over_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_long_underflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acos(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acosf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acosh(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acoshf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asin(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asinf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asinh(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asinhf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atanf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atanh(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atanhf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cbrt(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cbrtf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ceil(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ceilf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_copysign(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_copysignf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cos(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cosf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cosh(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_coshf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(double)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_double_pass_nan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(double)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_double_pass_positive_infinity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erfc(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erfcf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erff(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_exp(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_exp2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_exp2f(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_expf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_expm1(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_expm1f(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fabs(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fabsf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fdim(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fdimf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(float)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_float_pass_nan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(float)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_float_pass_positive_infinity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_floor(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_floorf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fma(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmaf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmax(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmaxf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmin(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fminf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmod(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmodf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fpclassify(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fpclassifyf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_frexp(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_frexpf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_hypot(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_hypotf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ilogb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ilogbf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isfinite(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isfinitef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreater(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreaterequal(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreaterequalf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreaterf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isinf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isinff(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isless(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessequal(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessequalf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessgreater(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessgreaterf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnanf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnormal(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnormalf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isunordered(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isunorderedf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ldexp(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ldexpf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lgamma(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lgammaf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log10(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log10f(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log1p(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log1pf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log2f(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_logb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_logbf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_logf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lround(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lroundf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_modf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_modff(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nanf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nearbyint(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nearbyintf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nextafter(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nextafterf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nexttoward(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nexttowardf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_pi(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_pow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_powf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remainder(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remainderf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remquo(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remquof(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_round(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_roundf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_scalbln(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_scalblnf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_scalbn(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_scalbnf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_signbit(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_signbitf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_sin(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_sinf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_sinh(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_sinhf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_sqrt(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_sqrtf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_tan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_tanf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_tanh(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_tanhf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_tgamma(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_tgammaf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_trunc(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_truncf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_double_inf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_double_nan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_double_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_float_inf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_float_nan(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_float_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__unary_minus_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 728;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L7: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 730;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L16: // GT_DOUBLE
  int_vars[0] = (double_vars[2] > double_vars[0]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // MOVE_INT
  int_vars[0] = int_vars[0];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 764;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L3: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[1];
L6: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[3];
L8: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 766;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L17: // LT_DOUBLE
  int_vars[0] = (double_vars[3] < double_vars[0]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // MOVE_INT
  int_vars[0] = int_vars[0];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_nan_left(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 654;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.0;
L4: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_nan_right(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 3.0;
L2: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L4: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 670;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_over_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L5: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // BOOL_INT
  int_vars[0] = int_vars[2];
L8: // MOVE_INT
  int_vars[0] = int_vars[0];
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L13: // GOTO
  goto L14;
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L15: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L24: // GT_DOUBLE
  int_vars[0] = (double_vars[2] > double_vars[0]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_over_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 608;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L3: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 608;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // NEGATE_DOUBLE
  double_vars[3] = -double_vars[2];
L7: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // MOVE_INT
  int_vars[0] = int_vars[0];
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L15: // GOTO
  goto L16;
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[4];
L17: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L26: // LT_DOUBLE
  int_vars[0] = (double_vars[4] < double_vars[0]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 696;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 696;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L5: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L6: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[3];
L8: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[4];
L17: // MOVE_INT
  int_vars[0] = int_vars[0];
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L3: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L13: // CALL_SUB_INT
  // SPVM::Math->signbit
  {
    if (SUB_ID_SPVM__Math__signbit < 0) {
      SUB_ID_SPVM__Math__signbit = env->get_sub_id(env, "SPVM::Math", "signbit", "int(double)");
      if (SUB_ID_SPVM__Math__signbit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_plus_zero_minus_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 521;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_double_same_sign_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L3: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L11: // GOTO
  goto L12;
L12: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L13: // CALL_SUB_INT
  // SPVM::Math->signbit
  {
    if (SUB_ID_SPVM__Math__signbit < 0) {
      SUB_ID_SPVM__Math__signbit = env->get_sub_id(env, "SPVM::Math", "signbit", "int(double)");
      if (SUB_ID_SPVM__Math__signbit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_same_sign_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = -0.0;
L21: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L22: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L25: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L30: // GOTO
  goto L31;
L31: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L32: // CALL_SUB_INT
  // SPVM::Math->signbit
  {
    if (SUB_ID_SPVM__Math__signbit < 0) {
      SUB_ID_SPVM__Math__signbit = env->get_sub_id(env, "SPVM::Math", "signbit", "int(double)");
      if (SUB_ID_SPVM__Math__signbit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_double_same_sign_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 710;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L5: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L6: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L8: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 712;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L17: // GT_FLOAT
  int_vars[0] = (float_vars[2] > float_vars[0]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // MOVE_INT
  int_vars[0] = int_vars[0];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 746;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L3: // NEGATE_FLOAT
  float_vars[1] = -float_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[1];
L6: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[2];
L7: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L8: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L9: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 748;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L18: // LT_FLOAT
  int_vars[0] = (float_vars[3] < float_vars[0]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // MOVE_INT
  int_vars[0] = int_vars[0];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_nan_left(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 3.0;
L4: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L5: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 628;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_nan_right(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 3.0;
L2: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L4: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L5: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_over_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L3: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L5: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // BOOL_INT
  int_vars[0] = int_vars[2];
L8: // MOVE_INT
  int_vars[0] = int_vars[0];
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L13: // GOTO
  goto L14;
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L15: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L24: // GT_FLOAT
  int_vars[0] = (float_vars[2] > float_vars[0]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_over_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 591;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L3: // NEGATE_FLOAT
  float_vars[1] = -float_vars[0];
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 591;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // NEGATE_FLOAT
  float_vars[3] = -float_vars[2];
L7: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // MOVE_INT
  int_vars[0] = int_vars[0];
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L15: // GOTO
  goto L16;
L16: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[4];
L17: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L26: // LT_FLOAT
  int_vars[0] = (float_vars[4] < float_vars[0]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 682;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 682;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L5: // NEGATE_FLOAT
  float_vars[2] = -float_vars[1];
L6: // ADD_FLOAT
  float_vars[3] = float_vars[0] + float_vars[2];
L7: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L8: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L9: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 684;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // MOVE_INT
  int_vars[0] = int_vars[0];
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L3: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L10: // GOTO
  goto L11;
L11: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L12: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L13: // CALL_SUB_INT
  // SPVM::Math->signbit
  {
    if (SUB_ID_SPVM__Math__signbit < 0) {
      SUB_ID_SPVM__Math__signbit = env->get_sub_id(env, "SPVM::Math", "signbit", "int(double)");
      if (SUB_ID_SPVM__Math__signbit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_plus_zero_minus_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_float_same_sign_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L3: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L10: // GOTO
  goto L11;
L11: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L12: // CALL_SUB_INT
  // SPVM::Math->signbitf
  {
    if (SUB_ID_SPVM__Math__signbitf < 0) {
      SUB_ID_SPVM__Math__signbitf = env->get_sub_id(env, "SPVM::Math", "signbitf", "int(float)");
      if (SUB_ID_SPVM__Math__signbitf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbitf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbitf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_same_sign_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 536;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_FLOAT
  float_vars[0] = -0.0;
L20: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L21: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L22: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L23: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L28: // GOTO
  goto L29;
L29: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L30: // CALL_SUB_INT
  // SPVM::Math->signbitf
  {
    if (SUB_ID_SPVM__Math__signbitf < 0) {
      SUB_ID_SPVM__Math__signbitf = env->get_sub_id(env, "SPVM::Math", "signbitf", "int(float)");
      if (SUB_ID_SPVM__Math__signbitf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbitf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbitf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "add_float_same_sign_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L32: // BOOL_INT
  int_vars[0] = int_vars[4];
L33: // IF_NE_ZERO
  if (int_vars[0]) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L41;
L39: // INIT_INT
  int_vars[6] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L41;
L41: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[5];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 9223372036854775807LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[1];
L5: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  goto L9;
L7: // INIT_LONG
  long_vars[4] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__add_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2147483647;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = INT32_MIN;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[5];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 315;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L7: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L16: // GT_DOUBLE
  int_vars[0] = (double_vars[2] > double_vars[0]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // MOVE_INT
  int_vars[0] = int_vars[0];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L3: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[1];
L6: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[3];
L8: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 353;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L17: // LT_DOUBLE
  int_vars[0] = (double_vars[3] < double_vars[0]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // MOVE_INT
  int_vars[0] = int_vars[0];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_nan_left(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.0;
L4: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_nan_right(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 3.0;
L2: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L4: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_over_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L5: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L6: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[0] - double_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // MOVE_INT
  int_vars[0] = int_vars[0];
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[3];
L16: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L25: // GT_DOUBLE
  int_vars[0] = (double_vars[3] > double_vars[0]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_over_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L3: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L7: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // MOVE_INT
  int_vars[0] = int_vars[0];
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L15: // GOTO
  goto L16;
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[4];
L17: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L26: // LT_DOUBLE
  int_vars[0] = (double_vars[4] < double_vars[0]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L3: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L5: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L7: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_double_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L3: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L13: // CALL_SUB_INT
  // SPVM::Math->signbit
  {
    if (SUB_ID_SPVM__Math__signbit < 0) {
      SUB_ID_SPVM__Math__signbit = env->get_sub_id(env, "SPVM::Math", "signbit", "int(double)");
      if (SUB_ID_SPVM__Math__signbit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_double_plus_zero_minus_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_inf_plus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L5: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L6: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L8: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_inf_plus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L17: // GT_FLOAT
  int_vars[0] = (float_vars[2] > float_vars[0]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // MOVE_INT
  int_vars[0] = int_vars[0];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_minus_inf_minus_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L3: // NEGATE_FLOAT
  float_vars[1] = -float_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[1];
L6: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[2];
L7: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[3];
L8: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L9: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_minus_inf_minus_value";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L18: // LT_FLOAT
  int_vars[0] = (float_vars[3] < float_vars[0]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // MOVE_INT
  int_vars[0] = int_vars[0];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_nan_left(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 3.0;
L4: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L5: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_nan_left";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 215;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_nan_right(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 3.0;
L2: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L4: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L5: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_nan_right";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 229;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_over_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 397;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L3: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 397;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L5: // NEGATE_FLOAT
  float_vars[2] = -float_vars[1];
L6: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[0] - float_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // MOVE_INT
  int_vars[0] = int_vars[0];
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[3];
L16: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_over_max";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L25: // GT_FLOAT
  int_vars[0] = (float_vars[3] > float_vars[0]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_over_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L3: // NEGATE_FLOAT
  float_vars[1] = -float_vars[0];
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L7: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[3];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // MOVE_INT
  int_vars[0] = int_vars[0];
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L15: // GOTO
  goto L16;
L16: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[4];
L17: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_over_min";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L26: // LT_FLOAT
  int_vars[0] = (float_vars[4] < float_vars[0]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_plus_inf_minus_inf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L5: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L6: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L8: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_plus_inf_minus_inf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[4];
L17: // MOVE_INT
  int_vars[0] = int_vars[0];
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_float_plus_zero_minus_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L3: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L10: // GOTO
  goto L11;
L11: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L12: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L13: // CALL_SUB_INT
  // SPVM::Math->signbit
  {
    if (SUB_ID_SPVM__Math__signbit < 0) {
      SUB_ID_SPVM__Math__signbit = env->get_sub_id(env, "SPVM::Math", "signbit", "int(double)");
      if (SUB_ID_SPVM__Math__signbit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math signbit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__signbit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "subtract_float_plus_zero_minus_zero";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 375;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_long_underflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[5];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = INT64_MIN;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[1];
L5: // SUBTRACT_LONG
  long_vars[3] = long_vars[1] - long_vars[2];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  goto L9;
L7: // INIT_LONG
  long_vars[4] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__subtract_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = INT32_MIN;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // SUBTRACT_INT
  int_vars[3] = int_vars[1] - int_vars[2];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 2147483647;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[5];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acos(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.8660254037844386;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->acos
  {
    if (SUB_ID_SPVM__Math__acos < 0) {
      SUB_ID_SPVM__Math__acos = env->get_sub_id(env, "SPVM::Math", "acos", "double(double)");
      if (SUB_ID_SPVM__Math__acos < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math acos");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__acos;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acos";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 942;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acos";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 943;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L10: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[1] / double_vars[3];
L11: // SUBTRACT_DOUBLE
  double_vars[1] = double_vars[4] - double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_DOUBLE
  double_vars[1] = double_vars[4] + double_vars[0];
L16: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[1]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acosf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.866025388;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->acosf
  {
    if (SUB_ID_SPVM__Math__acosf < 0) {
      SUB_ID_SPVM__Math__acosf = env->get_sub_id(env, "SPVM::Math", "acosf", "float(float)");
      if (SUB_ID_SPVM__Math__acosf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math acosf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__acosf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acosf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 952;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acosf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 953;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L10: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L11: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[2];
L12: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L13: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acosh(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acosh";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1063;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L6: // DIVIDE_DOUBLE
  double_vars[3] = double_vars[1] / double_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[3];
L8: // CALL_SUB_DOUBLE
  // SPVM::Math->acosh
  {
    if (SUB_ID_SPVM__Math__acosh < 0) {
      SUB_ID_SPVM__Math__acosh = env->get_sub_id(env, "SPVM::Math", "acosh", "double(double)");
      if (SUB_ID_SPVM__Math__acosh < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math acosh");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__acosh;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acosh";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1063;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0232274785475506;
L11: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L16: // LE_DOUBLE
  int_vars[0] = (double_vars[4] <= double_vars[2]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_acoshf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acoshf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1073;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L5: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L6: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L7: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[2];
L8: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L9: // CALL_SUB_FLOAT
  // SPVM::Math->acoshf
  {
    if (SUB_ID_SPVM__Math__acoshf < 0) {
      SUB_ID_SPVM__Math__acoshf = env->get_sub_id(env, "SPVM::Math", "acoshf", "float(float)");
      if (SUB_ID_SPVM__Math__acoshf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math acoshf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__acoshf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_acoshf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1073;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L11: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.02322745;
L12: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L13: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asin(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->asin
  {
    if (SUB_ID_SPVM__Math__asin < 0) {
      SUB_ID_SPVM__Math__asin = env->get_sub_id(env, "SPVM::Math", "asin", "double(double)");
      if (SUB_ID_SPVM__Math__asin < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math asin");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__asin;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asin";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 962;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asin";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 963;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L10: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[1] / double_vars[3];
L11: // SUBTRACT_DOUBLE
  double_vars[1] = double_vars[4] - double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_DOUBLE
  double_vars[1] = double_vars[4] + double_vars[0];
L16: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[1]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asinf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->asinf
  {
    if (SUB_ID_SPVM__Math__asinf < 0) {
      SUB_ID_SPVM__Math__asinf = env->get_sub_id(env, "SPVM::Math", "asinf", "float(float)");
      if (SUB_ID_SPVM__Math__asinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math asinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__asinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 972;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 973;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L10: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L11: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[2];
L12: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L13: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asinh(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asinh";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1083;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->asinh
  {
    if (SUB_ID_SPVM__Math__asinh < 0) {
      SUB_ID_SPVM__Math__asinh = env->get_sub_id(env, "SPVM::Math", "asinh", "double(double)");
      if (SUB_ID_SPVM__Math__asinh < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math asinh");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__asinh;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asinh";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1083;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.8622957433108482;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_asinhf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asinhf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1093;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->asinhf
  {
    if (SUB_ID_SPVM__Math__asinhf < 0) {
      SUB_ID_SPVM__Math__asinhf = env->get_sub_id(env, "SPVM::Math", "asinhf", "float(float)");
      if (SUB_ID_SPVM__Math__asinhf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math asinhf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__asinhf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_asinhf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1093;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.86229575;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atan(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.57735026918962573;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->atan
  {
    if (SUB_ID_SPVM__Math__atan < 0) {
      SUB_ID_SPVM__Math__atan = env->get_sub_id(env, "SPVM::Math", "atan", "double(double)");
      if (SUB_ID_SPVM__Math__atan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math atan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__atan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_atan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 982;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_atan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 983;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L10: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[1] / double_vars[3];
L11: // SUBTRACT_DOUBLE
  double_vars[1] = double_vars[4] - double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_DOUBLE
  double_vars[1] = double_vars[4] + double_vars[0];
L16: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[1]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atanf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.577350259;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->atanf
  {
    if (SUB_ID_SPVM__Math__atanf < 0) {
      SUB_ID_SPVM__Math__atanf = env->get_sub_id(env, "SPVM::Math", "atanf", "float(float)");
      if (SUB_ID_SPVM__Math__atanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math atanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__atanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_atanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 992;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_atanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 993;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L10: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L11: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[2];
L12: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L13: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atanh(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->atanh
  {
    if (SUB_ID_SPVM__Math__atanh < 0) {
      SUB_ID_SPVM__Math__atanh = env->get_sub_id(env, "SPVM::Math", "atanh", "double(double)");
      if (SUB_ID_SPVM__Math__atanh < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math atanh");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__atanh;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_atanh";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L6: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.54930614433405489;
L7: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L8: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_atanhf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->atanhf
  {
    if (SUB_ID_SPVM__Math__atanhf < 0) {
      SUB_ID_SPVM__Math__atanhf = env->get_sub_id(env, "SPVM::Math", "atanhf", "float(float)");
      if (SUB_ID_SPVM__Math__atanhf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math atanhf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__atanhf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_atanhf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L6: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.549306154;
L7: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L8: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cbrt(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cbrt";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1431;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->cbrt
  {
    if (SUB_ID_SPVM__Math__cbrt < 0) {
      SUB_ID_SPVM__Math__cbrt = env->get_sub_id(env, "SPVM::Math", "cbrt", "double(double)");
      if (SUB_ID_SPVM__Math__cbrt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math cbrt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__cbrt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cbrt";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1431;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.4645918875615234;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cbrtf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cbrtf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->cbrtf
  {
    if (SUB_ID_SPVM__Math__cbrtf < 0) {
      SUB_ID_SPVM__Math__cbrtf = env->get_sub_id(env, "SPVM::Math", "cbrtf", "float(float)");
      if (SUB_ID_SPVM__Math__cbrtf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math cbrtf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__cbrtf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cbrtf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.46459186;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ceil(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ceil";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->ceil
  {
    if (SUB_ID_SPVM__Math__ceil < 0) {
      SUB_ID_SPVM__Math__ceil = env->get_sub_id(env, "SPVM::Math", "ceil", "double(double)");
      if (SUB_ID_SPVM__Math__ceil < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ceil");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ceil;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ceil";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L8: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ceilf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[2];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ceilf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1621;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L3: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_FLOAT
  // SPVM::Math->ceilf
  {
    if (SUB_ID_SPVM__Math__ceilf < 0) {
      SUB_ID_SPVM__Math__ceilf = env->get_sub_id(env, "SPVM::Math", "ceilf", "float(float)");
      if (SUB_ID_SPVM__Math__ceilf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ceilf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ceilf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ceilf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1621;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L8: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L9: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L19;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L19;
L17: // INIT_INT
  int_vars[7] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_copysign(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1952;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1952;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L8: // CALL_SUB_DOUBLE
  // SPVM::Math->copysign
  {
    if (SUB_ID_SPVM__Math__copysign < 0) {
      SUB_ID_SPVM__Math__copysign = env->get_sub_id(env, "SPVM::Math", "copysign", "double(double,double)");
      if (SUB_ID_SPVM__Math__copysign < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysign");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysign;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1952;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L10: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1953;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L12: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L17: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L139;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L34: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L36: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L37: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L39: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L40: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[3];
L41: // CALL_SUB_DOUBLE
  // SPVM::Math->copysign
  {
    if (SUB_ID_SPVM__Math__copysign < 0) {
      SUB_ID_SPVM__Math__copysign = env->get_sub_id(env, "SPVM::Math", "copysign", "double(double,double)");
      if (SUB_ID_SPVM__Math__copysign < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysign");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysign;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L43: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1961;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L45: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L46: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[4]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L49: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L50: // LE_DOUBLE
  int_vars[0] = (double_vars[4] <= double_vars[2]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // BOOL_INT
  int_vars[0] = int_vars[2];
L55: // GOTO
  goto L58;
L56: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L57: // BOOL_INT
  int_vars[0] = int_vars[3];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[4];
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L139;
L65: // GOTO
  goto L66;
L66: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L67: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1968;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L69: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1968;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L71: // NEGATE_DOUBLE
  double_vars[3] = -double_vars[2];
L72: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L73: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[3];
L74: // CALL_SUB_DOUBLE
  // SPVM::Math->copysign
  {
    if (SUB_ID_SPVM__Math__copysign < 0) {
      SUB_ID_SPVM__Math__copysign = env->get_sub_id(env, "SPVM::Math", "copysign", "double(double,double)");
      if (SUB_ID_SPVM__Math__copysign < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysign");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysign;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1968;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L76: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1969;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L78: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L79: // SUBTRACT_DOUBLE
  double_vars[1] = double_vars[2] - double_vars[0];
L80: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[4]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ADD_DOUBLE
  double_vars[1] = double_vars[2] + double_vars[0];
L84: // LE_DOUBLE
  int_vars[0] = (double_vars[4] <= double_vars[1]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L90; }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L88: // BOOL_INT
  int_vars[0] = int_vars[2];
L89: // GOTO
  goto L92;
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // BOOL_INT
  int_vars[0] = int_vars[3];
L92: // GOTO
  goto L95;
L93: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L94: // BOOL_INT
  int_vars[0] = int_vars[4];
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_NE_ZERO
  if (int_vars[0]) { goto L100; }
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L139;
L99: // GOTO
  goto L100;
L100: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L101: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1976;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L103: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L104: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1976;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L106: // NEGATE_DOUBLE
  double_vars[4] = -double_vars[3];
L107: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L108: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[4];
L109: // CALL_SUB_DOUBLE
  // SPVM::Math->copysign
  {
    if (SUB_ID_SPVM__Math__copysign < 0) {
      SUB_ID_SPVM__Math__copysign = env->get_sub_id(env, "SPVM::Math", "copysign", "double(double,double)");
      if (SUB_ID_SPVM__Math__copysign < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysign");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysign;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[5] = *(double*)&stack[0];
    }
  }
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1976;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L111: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysign";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1977;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L139;
  }
L113: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L114: // SUBTRACT_DOUBLE
  double_vars[1] = double_vars[2] - double_vars[0];
L115: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[5]);
L116: // BOOL_INT
  int_vars[0] = int_vars[0];
L117: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L128; }
L118: // ADD_DOUBLE
  double_vars[1] = double_vars[2] + double_vars[0];
L119: // LE_DOUBLE
  int_vars[0] = (double_vars[5] <= double_vars[1]);
L120: // BOOL_INT
  int_vars[0] = int_vars[0];
L121: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L125; }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L123: // BOOL_INT
  int_vars[0] = int_vars[2];
L124: // GOTO
  goto L127;
L125: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L126: // BOOL_INT
  int_vars[0] = int_vars[3];
L127: // GOTO
  goto L130;
L128: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L129: // BOOL_INT
  int_vars[0] = int_vars[4];
L130: // BOOL_INT
  int_vars[0] = int_vars[0];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L135; }
L132: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L139;
L134: // GOTO
  goto L135;
L135: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L139;
L137: // INIT_INT
  int_vars[6] = 0;
L138: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L139;
L139: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_copysignf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L4: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L5: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L8: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[2];
L9: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L10: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L11: // CALL_SUB_FLOAT
  // SPVM::Math->copysignf
  {
    if (SUB_ID_SPVM__Math__copysignf < 0) {
      SUB_ID_SPVM__Math__copysignf = env->get_sub_id(env, "SPVM::Math", "copysignf", "float(float,float)");
      if (SUB_ID_SPVM__Math__copysignf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysignf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysignf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1989;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L15: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L16: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L20: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L21: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_NE_ZERO
  if (int_vars[0]) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L153;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L38: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1996;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L40: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L41: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L42: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1996;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L44: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[2];
L45: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L46: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L47: // CALL_SUB_FLOAT
  // SPVM::Math->copysignf
  {
    if (SUB_ID_SPVM__Math__copysignf < 0) {
      SUB_ID_SPVM__Math__copysignf = env->get_sub_id(env, "SPVM::Math", "copysignf", "float(float,float)");
      if (SUB_ID_SPVM__Math__copysignf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysignf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysignf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1996;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L49: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1997;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L51: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L52: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L53: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L56: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L57: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // BOOL_INT
  int_vars[0] = int_vars[2];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[3];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L153;
L72: // GOTO
  goto L73;
L73: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L74: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L76: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L77: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L78: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L80: // NEGATE_DOUBLE
  double_vars[3] = -double_vars[2];
L81: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[3];
L82: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L83: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L84: // CALL_SUB_FLOAT
  // SPVM::Math->copysignf
  {
    if (SUB_ID_SPVM__Math__copysignf < 0) {
      SUB_ID_SPVM__Math__copysignf = env->get_sub_id(env, "SPVM::Math", "copysignf", "float(float,float)");
      if (SUB_ID_SPVM__Math__copysignf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysignf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysignf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L86: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2005;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L88: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L89: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L90: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L91: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L92: // BOOL_INT
  int_vars[0] = int_vars[0];
L93: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L104; }
L94: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L95: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L98: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L99: // BOOL_INT
  int_vars[0] = int_vars[2];
L100: // GOTO
  goto L103;
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L102: // BOOL_INT
  int_vars[0] = int_vars[3];
L103: // GOTO
  goto L106;
L104: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L105: // BOOL_INT
  int_vars[0] = int_vars[4];
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_NE_ZERO
  if (int_vars[0]) { goto L111; }
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L153;
L110: // GOTO
  goto L111;
L111: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L112: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2012;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L114: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L115: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L116: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2012;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L118: // NEGATE_DOUBLE
  double_vars[3] = -double_vars[2];
L119: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[3];
L120: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L121: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L122: // CALL_SUB_FLOAT
  // SPVM::Math->copysignf
  {
    if (SUB_ID_SPVM__Math__copysignf < 0) {
      SUB_ID_SPVM__Math__copysignf = env->get_sub_id(env, "SPVM::Math", "copysignf", "float(float,float)");
      if (SUB_ID_SPVM__Math__copysignf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math copysignf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__copysignf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2012;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L124: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_copysignf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2013;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L153;
  }
L126: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L127: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L128: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L129: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L130: // BOOL_INT
  int_vars[0] = int_vars[0];
L131: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L142; }
L132: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L133: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L134: // BOOL_INT
  int_vars[0] = int_vars[0];
L135: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L139; }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L137: // BOOL_INT
  int_vars[0] = int_vars[2];
L138: // GOTO
  goto L141;
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L140: // BOOL_INT
  int_vars[0] = int_vars[3];
L141: // GOTO
  goto L144;
L142: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L143: // BOOL_INT
  int_vars[0] = int_vars[4];
L144: // BOOL_INT
  int_vars[0] = int_vars[0];
L145: // IF_NE_ZERO
  if (int_vars[0]) { goto L149; }
L146: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L153;
L148: // GOTO
  goto L149;
L149: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L150: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L153;
L151: // INIT_INT
  int_vars[6] = 0;
L152: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L153;
L153: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cos(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cos";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 887;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L4: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // CALL_SUB_DOUBLE
  // SPVM::Math->cos
  {
    if (SUB_ID_SPVM__Math__cos < 0) {
      SUB_ID_SPVM__Math__cos = env->get_sub_id(env, "SPVM::Math", "cos", "double(double)");
      if (SUB_ID_SPVM__Math__cos < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math cos");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__cos;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cos";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 887;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 9.9999999999999995e-07;
L9: // LT_DOUBLE
  int_vars[0] = (double_vars[3] < double_vars[0]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = -9.9999999999999995e-07;
L13: // GT_DOUBLE
  int_vars[0] = (double_vars[3] > double_vars[0]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cosf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cosf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 896;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L4: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L5: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[2];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L7: // CALL_SUB_FLOAT
  // SPVM::Math->cosf
  {
    if (SUB_ID_SPVM__Math__cosf < 0) {
      SUB_ID_SPVM__Math__cosf = env->get_sub_id(env, "SPVM::Math", "cosf", "float(float)");
      if (SUB_ID_SPVM__Math__cosf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math cosf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__cosf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cosf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 896;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L9: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L10: // LT_FLOAT
  int_vars[0] = (float_vars[1] < float_vars[0]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // MOVE_CONSTANT_FLOAT
  float_vars[0] = -9.99999975e-05;
L14: // GT_FLOAT
  int_vars[0] = (float_vars[1] > float_vars[0]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_cosh(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->cosh
  {
    if (SUB_ID_SPVM__Math__cosh < 0) {
      SUB_ID_SPVM__Math__cosh = env->get_sub_id(env, "SPVM::Math", "cosh", "double(double)");
      if (SUB_ID_SPVM__Math__cosh < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math cosh");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__cosh;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_cosh";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1003;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L6: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.1276259652063807;
L7: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L8: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_coshf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->coshf
  {
    if (SUB_ID_SPVM__Math__coshf < 0) {
      SUB_ID_SPVM__Math__coshf = env->get_sub_id(env, "SPVM::Math", "coshf", "float(float)");
      if (SUB_ID_SPVM__Math__coshf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math coshf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__coshf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_coshf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1013;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L6: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.12762594;
L7: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L8: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_double_pass_nan(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  double_vars[0] = *(double*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L2: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_double_pass_nan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 870;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L13;
  }
L4: // BOOL_INT
  int_vars[0] = int_vars[1];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_double_pass_positive_infinity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  double_vars[0] = *(double*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_double_pass_positive_infinity";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 878;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L13;
  }
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1533;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->erf
  {
    if (SUB_ID_SPVM__Math__erf < 0) {
      SUB_ID_SPVM__Math__erf = env->get_sub_id(env, "SPVM::Math", "erf", "double(double)");
      if (SUB_ID_SPVM__Math__erf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math erf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__erf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1533;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.99999112385363231;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erfc(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erfc";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->erfc
  {
    if (SUB_ID_SPVM__Math__erfc < 0) {
      SUB_ID_SPVM__Math__erfc = env->get_sub_id(env, "SPVM::Math", "erfc", "double(double)");
      if (SUB_ID_SPVM__Math__erfc < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math erfc");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__erfc;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erfc";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 8.8761463676416052e-06;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erfcf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.1111111111111112;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->erfc
  {
    if (SUB_ID_SPVM__Math__erfc < 0) {
      SUB_ID_SPVM__Math__erfc = env->get_sub_id(env, "SPVM::Math", "erfc", "double(double)");
      if (SUB_ID_SPVM__Math__erfc < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math erfc");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__erfc;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erfcf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L6: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.116101742;
L7: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L8: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[0] <= double_vars[1]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L12: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L13: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[2];
L14: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[0]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_erff(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->erff
  {
    if (SUB_ID_SPVM__Math__erff < 0) {
      SUB_ID_SPVM__Math__erff = env->get_sub_id(env, "SPVM::Math", "erff", "float(float)");
      if (SUB_ID_SPVM__Math__erff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math erff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__erff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_erff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.999991119;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_exp(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->exp
  {
    if (SUB_ID_SPVM__Math__exp < 0) {
      SUB_ID_SPVM__Math__exp = env->get_sub_id(env, "SPVM::Math", "exp", "double(double)");
      if (SUB_ID_SPVM__Math__exp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math exp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__exp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_exp";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.7182818284590451;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_exp2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_exp2";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->exp2
  {
    if (SUB_ID_SPVM__Math__exp2 < 0) {
      SUB_ID_SPVM__Math__exp2 = env->get_sub_id(env, "SPVM::Math", "exp2", "double(double)");
      if (SUB_ID_SPVM__Math__exp2 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math exp2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__exp2;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_exp2";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 8.8249778270762871;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_exp2f(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_exp2f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1153;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->exp2f
  {
    if (SUB_ID_SPVM__Math__exp2f < 0) {
      SUB_ID_SPVM__Math__exp2f = env->get_sub_id(env, "SPVM::Math", "exp2f", "float(float)");
      if (SUB_ID_SPVM__Math__exp2f < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math exp2f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__exp2f;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_exp2f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1153;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 8.82497787;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_expf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->expf
  {
    if (SUB_ID_SPVM__Math__expf < 0) {
      SUB_ID_SPVM__Math__expf = env->get_sub_id(env, "SPVM::Math", "expf", "float(float)");
      if (SUB_ID_SPVM__Math__expf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math expf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__expf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_expf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L6: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.71828175;
L7: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L8: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_expm1(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->expm1
  {
    if (SUB_ID_SPVM__Math__expm1 < 0) {
      SUB_ID_SPVM__Math__expm1 = env->get_sub_id(env, "SPVM::Math", "expm1", "double(double)");
      if (SUB_ID_SPVM__Math__expm1 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math expm1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__expm1;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_expm1";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.7182818284590453;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_expm1f(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->expm1f
  {
    if (SUB_ID_SPVM__Math__expm1f < 0) {
      SUB_ID_SPVM__Math__expm1f = env->get_sub_id(env, "SPVM::Math", "expm1f", "float(float)");
      if (SUB_ID_SPVM__Math__expm1f < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math expm1f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__expm1f;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_expm1f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L32;
  }
L6: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.71828187;
L7: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L8: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_NE_ZERO
  if (int_vars[0]) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L32;
L30: // INIT_INT
  int_vars[6] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fabs(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fabs";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L4: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // CALL_SUB_DOUBLE
  // SPVM::Math->fabs
  {
    if (SUB_ID_SPVM__Math__fabs < 0) {
      SUB_ID_SPVM__Math__fabs = env->get_sub_id(env, "SPVM::Math", "fabs", "double(double)");
      if (SUB_ID_SPVM__Math__fabs < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fabs");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fabs;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fabs";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L8: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fabs";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L10: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fabsf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fabsf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L4: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L5: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[1];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L7: // CALL_SUB_FLOAT
  // SPVM::Math->fabsf
  {
    if (SUB_ID_SPVM__Math__fabsf < 0) {
      SUB_ID_SPVM__Math__fabsf = env->get_sub_id(env, "SPVM::Math", "fabsf", "float(float)");
      if (SUB_ID_SPVM__Math__fabsf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fabsf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fabsf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fabsf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L9: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fabsf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L11: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L12: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L13: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fdim(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdim";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2090;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdim";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2090;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L8: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[2] / double_vars[3];
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[4];
L11: // CALL_SUB_DOUBLE
  // SPVM::Math->fdim
  {
    if (SUB_ID_SPVM__Math__fdim < 0) {
      SUB_ID_SPVM__Math__fdim = env->get_sub_id(env, "SPVM::Math", "fdim", "double(double,double)");
      if (SUB_ID_SPVM__Math__fdim < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fdim");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fdim;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[5] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdim";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2090;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.5707963267948966;
L14: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[5]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L18: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L19: // LE_DOUBLE
  int_vars[0] = (double_vars[5] <= double_vars[2]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L34: // GOTO
  goto L35;
L35: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdim";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2097;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L38: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L39: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L40: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdim";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2097;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L42: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L43: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[3];
L44: // CALL_SUB_DOUBLE
  // SPVM::Math->fdim
  {
    if (SUB_ID_SPVM__Math__fdim < 0) {
      SUB_ID_SPVM__Math__fdim = env->get_sub_id(env, "SPVM::Math", "fdim", "double(double,double)");
      if (SUB_ID_SPVM__Math__fdim < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fdim");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fdim;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdim";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2097;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L48: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[0]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L58;
L53: // GOTO
  goto L54;
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L56: // INIT_INT
  int_vars[6] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L58;
L58: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fdimf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdimf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdimf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L7: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[1];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L10: // DIVIDE_FLOAT
  float_vars[4] = float_vars[2] / float_vars[3];
L11: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L12: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[4];
L13: // CALL_SUB_FLOAT
  // SPVM::Math->fdimf
  {
    if (SUB_ID_SPVM__Math__fdimf < 0) {
      SUB_ID_SPVM__Math__fdimf = env->get_sub_id(env, "SPVM::Math", "fdimf", "float(float,float)");
      if (SUB_ID_SPVM__Math__fdimf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fdimf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fdimf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[5] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdimf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L15: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.57079637;
L16: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L20: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L21: // LE_FLOAT
  int_vars[0] = (float_vars[5] <= float_vars[2]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_NE_ZERO
  if (int_vars[0]) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L64;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L64;
L39: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdimf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L41: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L43: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[6];
L44: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L45: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdimf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L47: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[3] = (float)double_vars[1];
L48: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L49: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[3];
L50: // CALL_SUB_FLOAT
  // SPVM::Math->fdimf
  {
    if (SUB_ID_SPVM__Math__fdimf < 0) {
      SUB_ID_SPVM__Math__fdimf = env->get_sub_id(env, "SPVM::Math", "fdimf", "float(float,float)");
      if (SUB_ID_SPVM__Math__fdimf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fdimf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fdimf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fdimf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L54: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[0]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L64;
L59: // GOTO
  goto L60;
L60: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L64;
L62: // INIT_INT
  int_vars[2] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L64;
L64: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_float_pass_nan(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  float_vars[0] = *(float*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L2: // CALL_SUB_INT
  // SPVM::Math->isnanf
  {
    if (SUB_ID_SPVM__Math__isnanf < 0) {
      SUB_ID_SPVM__Math__isnanf = env->get_sub_id(env, "SPVM::Math", "isnanf", "int(float)");
      if (SUB_ID_SPVM__Math__isnanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_float_pass_nan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 826;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L13;
  }
L4: // BOOL_INT
  int_vars[0] = int_vars[1];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_float_pass_positive_infinity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  float_vars[0] = *(float*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_float_pass_positive_infinity";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L13;
  }
L3: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_floor(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_floor";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->floor
  {
    if (SUB_ID_SPVM__Math__floor < 0) {
      SUB_ID_SPVM__Math__floor = env->get_sub_id(env, "SPVM::Math", "floor", "double(double)");
      if (SUB_ID_SPVM__Math__floor < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math floor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__floor;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_floor";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L8: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_floorf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[2];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_floorf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1639;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L3: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_FLOAT
  // SPVM::Math->floorf
  {
    if (SUB_ID_SPVM__Math__floorf < 0) {
      SUB_ID_SPVM__Math__floorf = env->get_sub_id(env, "SPVM::Math", "floorf", "float(float)");
      if (SUB_ID_SPVM__Math__floorf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math floorf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__floorf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_floorf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1639;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L8: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L9: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L19;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L19;
L17: // INIT_INT
  int_vars[7] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fma(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[9];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fma";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fma";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L8: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[2] / double_vars[3];
L9: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[5] = *(double*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fma";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[6] = (double)int_vars[3];
L13: // DIVIDE_DOUBLE
  double_vars[7] = double_vars[5] / double_vars[6];
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[4];
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[2] = double_vars[7];
L17: // CALL_SUB_DOUBLE
  // SPVM::Math->fma
  {
    if (SUB_ID_SPVM__Math__fma < 0) {
      SUB_ID_SPVM__Math__fma = env->get_sub_id(env, "SPVM::Math", "fma", "double(double,double,double)");
      if (SUB_ID_SPVM__Math__fma < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fma");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fma;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[8] = *(double*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fma";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L19: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 5.9819997517412764;
L20: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L21: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[8]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L24: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L25: // LE_DOUBLE
  int_vars[0] = (double_vars[8] <= double_vars[2]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // GOTO
  goto L36;
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[4];
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L45;
L40: // GOTO
  goto L41;
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmaf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[9];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L7: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[1];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L10: // DIVIDE_FLOAT
  float_vars[4] = float_vars[2] / float_vars[3];
L11: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L13: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[5] = (float)double_vars[2];
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L15: // CONVERT_INT_TO_FLOAT
  float_vars[6] = (float)int_vars[3];
L16: // DIVIDE_FLOAT
  float_vars[7] = float_vars[5] / float_vars[6];
L17: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L18: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[4];
L19: // PUSH_ARG_FLOAT
  *(float*)&stack[2] = float_vars[7];
L20: // CALL_SUB_FLOAT
  // SPVM::Math->fmaf
  {
    if (SUB_ID_SPVM__Math__fmaf < 0) {
      SUB_ID_SPVM__Math__fmaf = env->get_sub_id(env, "SPVM::Math", "fmaf", "float(float,float,float)");
      if (SUB_ID_SPVM__Math__fmaf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fmaf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fmaf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[8] = *(float*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L22: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 5.98199987;
L23: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L24: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[8]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L27: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L28: // LE_FLOAT
  int_vars[0] = (float_vars[8] <= float_vars[2]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[2];
L33: // GOTO
  goto L36;
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[3];
L36: // GOTO
  goto L39;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // BOOL_INT
  int_vars[0] = int_vars[4];
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L43: // GOTO
  goto L44;
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L46: // INIT_INT
  int_vars[6] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L48;
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmax(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmax";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmax";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L8: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[2] / double_vars[3];
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[4];
L11: // CALL_SUB_DOUBLE
  // SPVM::Math->fmax
  {
    if (SUB_ID_SPVM__Math__fmax < 0) {
      SUB_ID_SPVM__Math__fmax = env->get_sub_id(env, "SPVM::Math", "fmax", "double(double,double)");
      if (SUB_ID_SPVM__Math__fmax < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fmax");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fmax;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[5] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmax";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmax";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L15: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L16: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[5]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L19: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L20: // LE_DOUBLE
  int_vars[0] = (double_vars[5] <= double_vars[2]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[2];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[3];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L40;
L38: // INIT_INT
  int_vars[6] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L40;
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmaxf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaxf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaxf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L7: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[1];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L10: // DIVIDE_FLOAT
  float_vars[4] = float_vars[2] / float_vars[3];
L11: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L12: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[4];
L13: // CALL_SUB_FLOAT
  // SPVM::Math->fmaxf
  {
    if (SUB_ID_SPVM__Math__fmaxf < 0) {
      SUB_ID_SPVM__Math__fmaxf = env->get_sub_id(env, "SPVM::Math", "fmaxf", "float(float,float)");
      if (SUB_ID_SPVM__Math__fmaxf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fmaxf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fmaxf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[5] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaxf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L15: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmaxf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L17: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L18: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L19: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L22: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L23: // LE_FLOAT
  int_vars[0] = (float_vars[5] <= float_vars[2]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmin(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmin";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmin";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L8: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[2] / double_vars[3];
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[4];
L11: // CALL_SUB_DOUBLE
  // SPVM::Math->fmin
  {
    if (SUB_ID_SPVM__Math__fmin < 0) {
      SUB_ID_SPVM__Math__fmin = env->get_sub_id(env, "SPVM::Math", "fmin", "double(double,double)");
      if (SUB_ID_SPVM__Math__fmin < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fmin");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fmin;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[5] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmin";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmin";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L17: // DIVIDE_DOUBLE
  double_vars[3] = double_vars[1] / double_vars[2];
L18: // SUBTRACT_DOUBLE
  double_vars[1] = double_vars[3] - double_vars[0];
L19: // LE_DOUBLE
  int_vars[0] = (double_vars[1] <= double_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L22: // ADD_DOUBLE
  double_vars[1] = double_vars[3] + double_vars[0];
L23: // LE_DOUBLE
  int_vars[0] = (double_vars[5] <= double_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fminf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fminf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fminf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L7: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[1];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L10: // DIVIDE_FLOAT
  float_vars[4] = float_vars[2] / float_vars[3];
L11: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L12: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[4];
L13: // CALL_SUB_FLOAT
  // SPVM::Math->fminf
  {
    if (SUB_ID_SPVM__Math__fminf < 0) {
      SUB_ID_SPVM__Math__fminf = env->get_sub_id(env, "SPVM::Math", "fminf", "float(float,float)");
      if (SUB_ID_SPVM__Math__fminf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fminf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fminf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[5] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fminf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L15: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fminf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L17: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L18: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 2.0;
L19: // DIVIDE_FLOAT
  float_vars[3] = float_vars[1] / float_vars[2];
L20: // SUBTRACT_FLOAT
  float_vars[1] = float_vars[3] - float_vars[0];
L21: // LE_FLOAT
  int_vars[0] = (float_vars[1] <= float_vars[5]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L24: // ADD_FLOAT
  float_vars[1] = float_vars[3] + float_vars[0];
L25: // LE_FLOAT
  int_vars[0] = (float_vars[5] <= float_vars[1]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // GOTO
  goto L36;
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[4];
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L45;
L40: // GOTO
  goto L41;
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmod(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmod";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1881;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 2.1000000000000001;
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L7: // CALL_SUB_DOUBLE
  // SPVM::Math->fmod
  {
    if (SUB_ID_SPVM__Math__fmod < 0) {
      SUB_ID_SPVM__Math__fmod = env->get_sub_id(env, "SPVM::Math", "fmod", "double(double,double)");
      if (SUB_ID_SPVM__Math__fmod < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fmod");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fmod;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmod";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1881;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0415926535897932;
L10: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fmodf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmodf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1891;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 2.0999999;
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L8: // CALL_SUB_FLOAT
  // SPVM::Math->fmodf
  {
    if (SUB_ID_SPVM__Math__fmodf < 0) {
      SUB_ID_SPVM__Math__fmodf = env->get_sub_id(env, "SPVM::Math", "fmodf", "float(float,float)");
      if (SUB_ID_SPVM__Math__fmodf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fmodf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fmodf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fmodf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1891;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0415926;
L11: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L16: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fpclassify(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->fpclassify
  {
    if (SUB_ID_SPVM__Math__fpclassify < 0) {
      SUB_ID_SPVM__Math__fpclassify = env->get_sub_id(env, "SPVM::Math", "fpclassify", "int(double)");
      if (SUB_ID_SPVM__Math__fpclassify < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassify");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassify;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L6: // CALL_SUB_INT
  // SPVM::Math->FP_INFINITE
  {
    if (SUB_ID_SPVM__Math__FP_INFINITE < 0) {
      SUB_ID_SPVM__Math__FP_INFINITE = env->get_sub_id(env, "SPVM::Math", "FP_INFINITE", "int()");
      if (SUB_ID_SPVM__Math__FP_INFINITE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_INFINITE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_INFINITE;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L8: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L13: // GOTO
  goto L14;
L14: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L17: // CALL_SUB_INT
  // SPVM::Math->fpclassify
  {
    if (SUB_ID_SPVM__Math__fpclassify < 0) {
      SUB_ID_SPVM__Math__fpclassify = env->get_sub_id(env, "SPVM::Math", "fpclassify", "int(double)");
      if (SUB_ID_SPVM__Math__fpclassify < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassify");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassify;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L19: // CALL_SUB_INT
  // SPVM::Math->FP_NAN
  {
    if (SUB_ID_SPVM__Math__FP_NAN < 0) {
      SUB_ID_SPVM__Math__FP_NAN = env->get_sub_id(env, "SPVM::Math", "FP_NAN", "int()");
      if (SUB_ID_SPVM__Math__FP_NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L21: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_NE_ZERO
  if (int_vars[0]) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 10.0;
L28: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L29: // CALL_SUB_INT
  // SPVM::Math->fpclassify
  {
    if (SUB_ID_SPVM__Math__fpclassify < 0) {
      SUB_ID_SPVM__Math__fpclassify = env->get_sub_id(env, "SPVM::Math", "fpclassify", "int(double)");
      if (SUB_ID_SPVM__Math__fpclassify < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassify");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassify;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L31: // CALL_SUB_INT
  // SPVM::Math->FP_NORMAL
  {
    if (SUB_ID_SPVM__Math__FP_NORMAL < 0) {
      SUB_ID_SPVM__Math__FP_NORMAL = env->get_sub_id(env, "SPVM::Math", "FP_NORMAL", "int()");
      if (SUB_ID_SPVM__Math__FP_NORMAL < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_NORMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_NORMAL;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2203;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L33: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L38: // GOTO
  goto L39;
L39: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L42: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L43: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L44: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L45: // CALL_SUB_INT
  // SPVM::Math->fpclassify
  {
    if (SUB_ID_SPVM__Math__fpclassify < 0) {
      SUB_ID_SPVM__Math__fpclassify = env->get_sub_id(env, "SPVM::Math", "fpclassify", "int(double)");
      if (SUB_ID_SPVM__Math__fpclassify < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassify");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassify;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L47: // CALL_SUB_INT
  // SPVM::Math->FP_SUBNORMAL
  {
    if (SUB_ID_SPVM__Math__FP_SUBNORMAL < 0) {
      SUB_ID_SPVM__Math__FP_SUBNORMAL = env->get_sub_id(env, "SPVM::Math", "FP_SUBNORMAL", "int()");
      if (SUB_ID_SPVM__Math__FP_SUBNORMAL < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_SUBNORMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_SUBNORMAL;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L49: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = -0.0;
L56: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L57: // CALL_SUB_INT
  // SPVM::Math->fpclassify
  {
    if (SUB_ID_SPVM__Math__fpclassify < 0) {
      SUB_ID_SPVM__Math__fpclassify = env->get_sub_id(env, "SPVM::Math", "fpclassify", "int(double)");
      if (SUB_ID_SPVM__Math__fpclassify < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassify");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassify;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2216;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L59: // CALL_SUB_INT
  // SPVM::Math->FP_ZERO
  {
    if (SUB_ID_SPVM__Math__FP_ZERO < 0) {
      SUB_ID_SPVM__Math__FP_ZERO = env->get_sub_id(env, "SPVM::Math", "FP_ZERO", "int()");
      if (SUB_ID_SPVM__Math__FP_ZERO < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_ZERO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_ZERO;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassify";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L61: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_fpclassifyf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->fpclassifyf
  {
    if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
      SUB_ID_SPVM__Math__fpclassifyf = env->get_sub_id(env, "SPVM::Math", "fpclassifyf", "int(float)");
      if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassifyf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassifyf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L6: // CALL_SUB_INT
  // SPVM::Math->FP_INFINITE
  {
    if (SUB_ID_SPVM__Math__FP_INFINITE < 0) {
      SUB_ID_SPVM__Math__FP_INFINITE = env->get_sub_id(env, "SPVM::Math", "FP_INFINITE", "int()");
      if (SUB_ID_SPVM__Math__FP_INFINITE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_INFINITE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_INFINITE;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2228;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L8: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L13: // GOTO
  goto L14;
L14: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L16: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L17: // CALL_SUB_INT
  // SPVM::Math->fpclassifyf
  {
    if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
      SUB_ID_SPVM__Math__fpclassifyf = env->get_sub_id(env, "SPVM::Math", "fpclassifyf", "int(float)");
      if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassifyf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassifyf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L19: // CALL_SUB_INT
  // SPVM::Math->FP_NAN
  {
    if (SUB_ID_SPVM__Math__FP_NAN < 0) {
      SUB_ID_SPVM__Math__FP_NAN = env->get_sub_id(env, "SPVM::Math", "FP_NAN", "int()");
      if (SUB_ID_SPVM__Math__FP_NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L21: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_NE_ZERO
  if (int_vars[0]) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 10.0;
L28: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L29: // CALL_SUB_INT
  // SPVM::Math->fpclassifyf
  {
    if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
      SUB_ID_SPVM__Math__fpclassifyf = env->get_sub_id(env, "SPVM::Math", "fpclassifyf", "int(float)");
      if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassifyf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassifyf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L31: // CALL_SUB_INT
  // SPVM::Math->FP_NORMAL
  {
    if (SUB_ID_SPVM__Math__FP_NORMAL < 0) {
      SUB_ID_SPVM__Math__FP_NORMAL = env->get_sub_id(env, "SPVM::Math", "FP_NORMAL", "int()");
      if (SUB_ID_SPVM__Math__FP_NORMAL < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_NORMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_NORMAL;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L33: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L38: // GOTO
  goto L39;
L39: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L42: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L43: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L44: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L45: // CALL_SUB_INT
  // SPVM::Math->fpclassifyf
  {
    if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
      SUB_ID_SPVM__Math__fpclassifyf = env->get_sub_id(env, "SPVM::Math", "fpclassifyf", "int(float)");
      if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassifyf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassifyf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L47: // CALL_SUB_INT
  // SPVM::Math->FP_SUBNORMAL
  {
    if (SUB_ID_SPVM__Math__FP_SUBNORMAL < 0) {
      SUB_ID_SPVM__Math__FP_SUBNORMAL = env->get_sub_id(env, "SPVM::Math", "FP_SUBNORMAL", "int()");
      if (SUB_ID_SPVM__Math__FP_SUBNORMAL < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_SUBNORMAL");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_SUBNORMAL;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L49: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_FLOAT
  float_vars[0] = -0.0;
L56: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L57: // CALL_SUB_INT
  // SPVM::Math->fpclassifyf
  {
    if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
      SUB_ID_SPVM__Math__fpclassifyf = env->get_sub_id(env, "SPVM::Math", "fpclassifyf", "int(float)");
      if (SUB_ID_SPVM__Math__fpclassifyf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fpclassifyf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fpclassifyf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L59: // CALL_SUB_INT
  // SPVM::Math->FP_ZERO
  {
    if (SUB_ID_SPVM__Math__FP_ZERO < 0) {
      SUB_ID_SPVM__Math__FP_ZERO = env->get_sub_id(env, "SPVM::Math", "FP_ZERO", "int()");
      if (SUB_ID_SPVM__Math__FP_ZERO < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_ZERO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_ZERO;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_fpclassifyf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2256;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L61: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_frexp(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[4];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // INIT_INT
  int_vars[2] = 0;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_frexp";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L5: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L7: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L8: // CALL_SUB_DOUBLE
  // SPVM::Math->frexp
  {
    if (SUB_ID_SPVM__Math__frexp < 0) {
      SUB_ID_SPVM__Math__frexp = env->get_sub_id(env, "SPVM::Math", "frexp", "double(double,&int)");
      if (SUB_ID_SPVM__Math__frexp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math frexp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__frexp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_frexp";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L11: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.78539816339744828;
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L17: // GOTO
  goto L18;
L18: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L19: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L22: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L23: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[5];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[6];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L41: // INIT_INT
  int_vars[8] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_frexpf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // INIT_INT
  int_vars[2] = 0;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_frexpf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L5: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L6: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L8: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L9: // CALL_SUB_FLOAT
  // SPVM::Math->frexpf
  {
    if (SUB_ID_SPVM__Math__frexpf < 0) {
      SUB_ID_SPVM__Math__frexpf = env->get_sub_id(env, "SPVM::Math", "frexpf", "float(float,&int)");
      if (SUB_ID_SPVM__Math__frexpf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math frexpf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__frexpf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_frexpf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L12: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.785398185;
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L18: // GOTO
  goto L19;
L19: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L20: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L23: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L24: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L28: // BOOL_INT
  int_vars[0] = int_vars[4];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[5];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[6];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L42: // INIT_INT
  int_vars[8] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_hypot(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.7182818284590451;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_hypot";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L7: // CALL_SUB_DOUBLE
  // SPVM::Math->hypot
  {
    if (SUB_ID_SPVM__Math__hypot < 0) {
      SUB_ID_SPVM__Math__hypot = env->get_sub_id(env, "SPVM::Math", "hypot", "double(double,double)");
      if (SUB_ID_SPVM__Math__hypot < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math hypot");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__hypot;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_hypot";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 4.1543544023133139;
L10: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[2] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[4] <= double_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[4] = double_vars[2] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_hypotf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.71828175;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_hypotf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1483;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L5: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[0];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L8: // CALL_SUB_FLOAT
  // SPVM::Math->hypotf
  {
    if (SUB_ID_SPVM__Math__hypotf < 0) {
      SUB_ID_SPVM__Math__hypotf = env->get_sub_id(env, "SPVM::Math", "hypotf", "float(float,float)");
      if (SUB_ID_SPVM__Math__hypotf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math hypotf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__hypotf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_hypotf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1483;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 4.15435457;
L11: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[2] - float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[4] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_FLOAT
  float_vars[4] = float_vars[2] + float_vars[0];
L16: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ilogb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1024.1111111111111;
L2: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L3: // CALL_SUB_INT
  // SPVM::Math->ilogb
  {
    if (SUB_ID_SPVM__Math__ilogb < 0) {
      SUB_ID_SPVM__Math__ilogb = env->get_sub_id(env, "SPVM::Math", "ilogb", "int(double)");
      if (SUB_ID_SPVM__Math__ilogb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ilogb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ilogb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1212;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L6: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L13: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[6];
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L15: // CALL_SUB_INT
  // SPVM::Math->ilogb
  {
    if (SUB_ID_SPVM__Math__ilogb < 0) {
      SUB_ID_SPVM__Math__ilogb = env->get_sub_id(env, "SPVM::Math", "ilogb", "int(double)");
      if (SUB_ID_SPVM__Math__ilogb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ilogb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ilogb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L17: // CALL_SUB_INT
  // SPVM::Math->FP_ILOGB0
  {
    if (SUB_ID_SPVM__Math__FP_ILOGB0 < 0) {
      SUB_ID_SPVM__Math__FP_ILOGB0 = env->get_sub_id(env, "SPVM::Math", "FP_ILOGB0", "int()");
      if (SUB_ID_SPVM__Math__FP_ILOGB0 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_ILOGB0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_ILOGB0;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L19: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L24: // GOTO
  goto L25;
L25: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L27: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L28: // CALL_SUB_INT
  // SPVM::Math->ilogb
  {
    if (SUB_ID_SPVM__Math__ilogb < 0) {
      SUB_ID_SPVM__Math__ilogb = env->get_sub_id(env, "SPVM::Math", "ilogb", "int(double)");
      if (SUB_ID_SPVM__Math__ilogb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ilogb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ilogb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L30: // CALL_SUB_INT
  // SPVM::Math->FP_ILOGBNAN
  {
    if (SUB_ID_SPVM__Math__FP_ILOGBNAN < 0) {
      SUB_ID_SPVM__Math__FP_ILOGBNAN = env->get_sub_id(env, "SPVM::Math", "FP_ILOGBNAN", "int()");
      if (SUB_ID_SPVM__Math__FP_ILOGBNAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_ILOGBNAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_ILOGBNAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L32: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L40: // INIT_INT
  int_vars[8] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L42;
L42: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ilogbf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1024.11108;
L2: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L3: // CALL_SUB_INT
  // SPVM::Math->ilogbf
  {
    if (SUB_ID_SPVM__Math__ilogbf < 0) {
      SUB_ID_SPVM__Math__ilogbf = env->get_sub_id(env, "SPVM::Math", "ilogbf", "int(float)");
      if (SUB_ID_SPVM__Math__ilogbf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ilogbf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ilogbf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L6: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L13: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[6];
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L15: // CALL_SUB_INT
  // SPVM::Math->ilogbf
  {
    if (SUB_ID_SPVM__Math__ilogbf < 0) {
      SUB_ID_SPVM__Math__ilogbf = env->get_sub_id(env, "SPVM::Math", "ilogbf", "int(float)");
      if (SUB_ID_SPVM__Math__ilogbf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ilogbf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ilogbf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1232;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L17: // CALL_SUB_INT
  // SPVM::Math->FP_ILOGB0
  {
    if (SUB_ID_SPVM__Math__FP_ILOGB0 < 0) {
      SUB_ID_SPVM__Math__FP_ILOGB0 = env->get_sub_id(env, "SPVM::Math", "FP_ILOGB0", "int()");
      if (SUB_ID_SPVM__Math__FP_ILOGB0 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_ILOGB0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_ILOGB0;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1232;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L19: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L24: // GOTO
  goto L25;
L25: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L27: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L28: // CALL_SUB_INT
  // SPVM::Math->ilogbf
  {
    if (SUB_ID_SPVM__Math__ilogbf < 0) {
      SUB_ID_SPVM__Math__ilogbf = env->get_sub_id(env, "SPVM::Math", "ilogbf", "int(float)");
      if (SUB_ID_SPVM__Math__ilogbf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ilogbf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ilogbf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L30: // CALL_SUB_INT
  // SPVM::Math->FP_ILOGBNAN
  {
    if (SUB_ID_SPVM__Math__FP_ILOGBNAN < 0) {
      SUB_ID_SPVM__Math__FP_ILOGBNAN = env->get_sub_id(env, "SPVM::Math", "FP_ILOGBNAN", "int()");
      if (SUB_ID_SPVM__Math__FP_ILOGBNAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FP_ILOGBNAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FP_ILOGBNAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ilogbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L32: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L40: // INIT_INT
  int_vars[8] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L42;
L42: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isfinite(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinite";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 846;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->isfinite
  {
    if (SUB_ID_SPVM__Math__isfinite < 0) {
      SUB_ID_SPVM__Math__isfinite = env->get_sub_id(env, "SPVM::Math", "isfinite", "int(double)");
      if (SUB_ID_SPVM__Math__isfinite < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isfinite");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isfinite;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinite";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 846;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[1];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[3];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L15: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinite";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 847;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L17: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L18: // CALL_SUB_INT
  // SPVM::Math->isfinite
  {
    if (SUB_ID_SPVM__Math__isfinite < 0) {
      SUB_ID_SPVM__Math__isfinite = env->get_sub_id(env, "SPVM::Math", "isfinite", "int(double)");
      if (SUB_ID_SPVM__Math__isfinite < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isfinite");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isfinite;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinite";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 847;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L29: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.10000000000000001;
L30: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L31: // CALL_SUB_INT
  // SPVM::Math->isfinite
  {
    if (SUB_ID_SPVM__Math__isfinite < 0) {
      SUB_ID_SPVM__Math__isfinite = env->get_sub_id(env, "SPVM::Math", "isfinite", "int(double)");
      if (SUB_ID_SPVM__Math__isfinite < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isfinite");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isfinite;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinite";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 848;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L33: // BOOL_INT
  int_vars[0] = int_vars[2];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isfinitef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinitef";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->isfinitef
  {
    if (SUB_ID_SPVM__Math__isfinitef < 0) {
      SUB_ID_SPVM__Math__isfinitef = env->get_sub_id(env, "SPVM::Math", "isfinitef", "int(float)");
      if (SUB_ID_SPVM__Math__isfinitef < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isfinitef");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isfinitef;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinitef";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[1];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[3];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L15: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinitef";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 795;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L17: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L18: // CALL_SUB_INT
  // SPVM::Math->isfinitef
  {
    if (SUB_ID_SPVM__Math__isfinitef < 0) {
      SUB_ID_SPVM__Math__isfinitef = env->get_sub_id(env, "SPVM::Math", "isfinitef", "int(float)");
      if (SUB_ID_SPVM__Math__isfinitef < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isfinitef");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isfinitef;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinitef";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 795;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L29: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.100000001;
L30: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L31: // CALL_SUB_INT
  // SPVM::Math->isfinitef
  {
    if (SUB_ID_SPVM__Math__isfinitef < 0) {
      SUB_ID_SPVM__Math__isfinitef = env->get_sub_id(env, "SPVM::Math", "isfinitef", "int(float)");
      if (SUB_ID_SPVM__Math__isfinitef < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isfinitef");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isfinitef;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isfinitef";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 796;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L33: // BOOL_INT
  int_vars[0] = int_vars[2];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreater(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L14: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L17: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L25: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L26: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L27: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L28: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2353;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L36: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L37: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L38: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2356;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L47: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L48: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L49: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L50: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2359;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[4];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L58: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L60: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L61: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L62: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[4];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L68: // GOTO
  goto L69;
L69: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L71: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L74: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L85: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L86: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L95: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L98: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L111: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->isgreater
  {
    if (SUB_ID_SPVM__Math__isgreater < 0) {
      SUB_ID_SPVM__Math__isgreater = env->get_sub_id(env, "SPVM::Math", "isgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreaterequal(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L16: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L25: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L26: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L27: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L33: // GOTO
  goto L34;
L34: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L36: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L37: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L38: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L48: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L50: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L51: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L52: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L54: // BOOL_INT
  int_vars[0] = int_vars[4];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L58: // GOTO
  goto L59;
L59: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L60: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L61: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L62: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L63: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2430;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[4];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L69: // GOTO
  goto L70;
L70: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L71: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L74: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L85: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L86: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L95: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L98: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2442;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2442;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L111: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->isgreaterequal
  {
    if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
      SUB_ID_SPVM__Math__isgreaterequal = env->get_sub_id(env, "SPVM::Math", "isgreaterequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__isgreaterequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2442;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreaterequalf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L13: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L16: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L24: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L25: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L26: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L27: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L33: // GOTO
  goto L34;
L34: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2458;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L36: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L37: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L38: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2458;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L48: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L50: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L51: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L52: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L54: // BOOL_INT
  int_vars[0] = int_vars[4];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L58: // GOTO
  goto L59;
L59: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L60: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L61: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L62: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L63: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2464;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[4];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L69: // GOTO
  goto L70;
L70: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L71: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L74: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L85: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L86: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L95: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2473;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L98: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2473;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2476;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2476;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L111: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->isgreaterequalf
  {
    if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
      SUB_ID_SPVM__Math__isgreaterequalf = env->get_sub_id(env, "SPVM::Math", "isgreaterequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2476;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isgreaterf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2384;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L14: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L16: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L17: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2384;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L25: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L26: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L27: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L28: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2387;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L36: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L37: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L38: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L47: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L48: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L49: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L50: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2393;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[4];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L58: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2396;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L60: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L61: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L62: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2396;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[4];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L68: // GOTO
  goto L69;
L69: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L71: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L74: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L85: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L86: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L95: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L98: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L111: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->isgreaterf
  {
    if (SUB_ID_SPVM__Math__isgreaterf < 0) {
      SUB_ID_SPVM__Math__isgreaterf = env->get_sub_id(env, "SPVM::Math", "isgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isinf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 834;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 834;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[1];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L8: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L11: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L13: // BOOL_INT
  int_vars[0] = int_vars[2];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L22: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.10000000000000001;
L23: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L24: // CALL_SUB_INT
  // SPVM::Math->isinf
  {
    if (SUB_ID_SPVM__Math__isinf < 0) {
      SUB_ID_SPVM__Math__isinf = env->get_sub_id(env, "SPVM::Math", "isinf", "int(double)");
      if (SUB_ID_SPVM__Math__isinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 836;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isinff(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 782;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 782;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[1];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L8: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 783;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L10: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L11: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 783;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L13: // BOOL_INT
  int_vars[0] = int_vars[2];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // BOOL_INT
  int_vars[0] = int_vars[2];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L22: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.100000001;
L23: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L24: // CALL_SUB_INT
  // SPVM::Math->isinff
  {
    if (SUB_ID_SPVM__Math__isinff < 0) {
      SUB_ID_SPVM__Math__isinff = env->get_sub_id(env, "SPVM::Math", "isinff", "int(float)");
      if (SUB_ID_SPVM__Math__isinff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isinff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isinff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isinff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 784;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isless(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2483;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L13: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L17: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L25: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L26: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L27: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L28: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2489;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L36: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L37: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L38: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L47: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L48: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L49: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L50: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[4];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L56: // GOTO
  goto L57;
L57: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L59: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L60: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L61: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L62: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[4];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L68: // GOTO
  goto L69;
L69: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L71: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L74: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L85: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L86: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L95: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L98: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L111: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->isless
  {
    if (SUB_ID_SPVM__Math__isless < 0) {
      SUB_ID_SPVM__Math__isless = env->get_sub_id(env, "SPVM::Math", "isless", "int(double,double)");
      if (SUB_ID_SPVM__Math__isless < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isless");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isless;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isless";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessequal(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2551;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L16: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L25: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L26: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L27: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L33: // GOTO
  goto L34;
L34: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L35: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L37: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L38: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L48: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L50: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L51: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L52: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L54: // BOOL_INT
  int_vars[0] = int_vars[4];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L58: // GOTO
  goto L59;
L59: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L60: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L61: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L62: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L63: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2566;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[4];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L69: // GOTO
  goto L70;
L70: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L72: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L73: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L74: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L85: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L86: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L95: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2575;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L98: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2575;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L111: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->islessequal
  {
    if (SUB_ID_SPVM__Math__islessequal < 0) {
      SUB_ID_SPVM__Math__islessequal = env->get_sub_id(env, "SPVM::Math", "islessequal", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessequal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessequalf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L13: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L16: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2588;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L24: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L25: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L26: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L27: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2591;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L33: // GOTO
  goto L34;
L34: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L35: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L37: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L38: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L48: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L50: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L51: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L52: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L54: // BOOL_INT
  int_vars[0] = int_vars[4];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L58: // GOTO
  goto L59;
L59: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L60: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L61: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L62: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L63: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[4];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L69: // GOTO
  goto L70;
L70: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2603;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L72: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L73: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L74: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2603;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2606;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L85: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L86: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2606;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L95: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2609;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L98: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2609;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L111: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->islessequalf
  {
    if (SUB_ID_SPVM__Math__islessequalf < 0) {
      SUB_ID_SPVM__Math__islessequalf = env->get_sub_id(env, "SPVM::Math", "islessequalf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessequalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessequalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessequalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessequalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2517;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L13: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2520;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L16: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L17: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2520;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L25: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L26: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L27: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L28: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L36: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L37: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L38: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L39: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[4];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L47: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L48: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L49: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L50: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[4];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L56: // GOTO
  goto L57;
L57: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2532;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L59: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L60: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L61: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L62: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2532;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[4];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L68: // GOTO
  goto L69;
L69: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L71: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L74: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2538;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L85: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L86: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2538;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L95: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L98: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L111: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->islessf
  {
    if (SUB_ID_SPVM__Math__islessf < 0) {
      SUB_ID_SPVM__Math__islessf = env->get_sub_id(env, "SPVM::Math", "islessf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessgreater(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2619;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L16: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2622;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L24: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L26: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L27: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L28: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L34: // GOTO
  goto L35;
L35: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2628;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L37: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L38: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L39: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L40: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2628;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L42: // BOOL_INT
  int_vars[0] = int_vars[4];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L46: // GOTO
  goto L47;
L47: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L48: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L49: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L50: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L51: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2631;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L53: // BOOL_INT
  int_vars[0] = int_vars[4];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L57: // GOTO
  goto L58;
L58: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L59: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.0;
L60: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L61: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L62: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2634;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[4];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L68: // GOTO
  goto L69;
L69: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L71: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L74: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L85: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L86: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L95: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L98: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L111: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->islessgreater
  {
    if (SUB_ID_SPVM__Math__islessgreater < 0) {
      SUB_ID_SPVM__Math__islessgreater = env->get_sub_id(env, "SPVM::Math", "islessgreater", "int(double,double)");
      if (SUB_ID_SPVM__Math__islessgreater < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreater");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreater;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreater";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_islessgreaterf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[1];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L13: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L16: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L24: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2659;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L26: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L27: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L28: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2659;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[4];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L34: // GOTO
  goto L35;
L35: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L37: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L38: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L39: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L40: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L42: // BOOL_INT
  int_vars[0] = int_vars[4];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L46: // GOTO
  goto L47;
L47: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L48: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L49: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L50: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L51: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2665;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L53: // BOOL_INT
  int_vars[0] = int_vars[4];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L57: // GOTO
  goto L58;
L58: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L59: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.0;
L60: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L61: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L62: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[4];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L68: // GOTO
  goto L69;
L69: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2671;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L71: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2671;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L73: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L74: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L75: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2671;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L81: // GOTO
  goto L82;
L82: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2674;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L84: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.0;
L85: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L86: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L87: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2674;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[4];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L95: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L97: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L98: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L99: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L105: // GOTO
  goto L106;
L106: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L108: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L110: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L111: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L112: // CALL_SUB_INT
  // SPVM::Math->islessgreaterf
  {
    if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
      SUB_ID_SPVM__Math__islessgreaterf = env->get_sub_id(env, "SPVM::Math", "islessgreaterf", "int(float,float)");
      if (SUB_ID_SPVM__Math__islessgreaterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math islessgreaterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__islessgreaterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_islessgreaterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L123;
  }
L114: // BOOL_INT
  int_vars[0] = int_vars[4];
L115: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L119; }
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L123;
L118: // GOTO
  goto L119;
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L123;
L121: // INIT_INT
  int_vars[6] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L123;
L123: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnan(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 858;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 858;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[1];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[3];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L15: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 859;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L17: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L18: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 859;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L22: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.10000000000000001;
L23: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L24: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 860;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnanf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // CALL_SUB_INT
  // SPVM::Math->isnanf
  {
    if (SUB_ID_SPVM__Math__isnanf < 0) {
      SUB_ID_SPVM__Math__isnanf = env->get_sub_id(env, "SPVM::Math", "isnanf", "int(float)");
      if (SUB_ID_SPVM__Math__isnanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[1];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[3];
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L15: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 807;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L17: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L18: // CALL_SUB_INT
  // SPVM::Math->isnanf
  {
    if (SUB_ID_SPVM__Math__isnanf < 0) {
      SUB_ID_SPVM__Math__isnanf = env->get_sub_id(env, "SPVM::Math", "isnanf", "int(float)");
      if (SUB_ID_SPVM__Math__isnanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 807;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L22: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.100000001;
L23: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L24: // CALL_SUB_INT
  // SPVM::Math->isnanf
  {
    if (SUB_ID_SPVM__Math__isnanf < 0) {
      SUB_ID_SPVM__Math__isnanf = env->get_sub_id(env, "SPVM::Math", "isnanf", "int(float)");
      if (SUB_ID_SPVM__Math__isnanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 808;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnormal(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L3: // CALL_SUB_INT
  // SPVM::Math->isnormal
  {
    if (SUB_ID_SPVM__Math__isnormal < 0) {
      SUB_ID_SPVM__Math__isnormal = env->get_sub_id(env, "SPVM::Math", "isnormal", "int(double)");
      if (SUB_ID_SPVM__Math__isnormal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L5: // BOOL_INT
  int_vars[0] = int_vars[1];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L11: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L12: // CALL_SUB_INT
  // SPVM::Math->isnormal
  {
    if (SUB_ID_SPVM__Math__isnormal < 0) {
      SUB_ID_SPVM__Math__isnormal = env->get_sub_id(env, "SPVM::Math", "isnormal", "int(double)");
      if (SUB_ID_SPVM__Math__isnormal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L18: // GOTO
  goto L19;
L19: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L21: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L22: // CALL_SUB_INT
  // SPVM::Math->isnormal
  {
    if (SUB_ID_SPVM__Math__isnormal < 0) {
      SUB_ID_SPVM__Math__isnormal = env->get_sub_id(env, "SPVM::Math", "isnormal", "int(double)");
      if (SUB_ID_SPVM__Math__isnormal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L28: // GOTO
  goto L29;
L29: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L31: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L32: // CALL_SUB_INT
  // SPVM::Math->isnormal
  {
    if (SUB_ID_SPVM__Math__isnormal < 0) {
      SUB_ID_SPVM__Math__isnormal = env->get_sub_id(env, "SPVM::Math", "isnormal", "int(double)");
      if (SUB_ID_SPVM__Math__isnormal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L38: // GOTO
  goto L39;
L39: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L42: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L43: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L44: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L45: // CALL_SUB_INT
  // SPVM::Math->isnormal
  {
    if (SUB_ID_SPVM__Math__isnormal < 0) {
      SUB_ID_SPVM__Math__isnormal = env->get_sub_id(env, "SPVM::Math", "isnormal", "int(double)");
      if (SUB_ID_SPVM__Math__isnormal < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormal;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormal";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[5];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L51: // GOTO
  goto L52;
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L56;
L54: // INIT_INT
  int_vars[6] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L56;
L56: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isnormalf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L3: // CALL_SUB_INT
  // SPVM::Math->isnormalf
  {
    if (SUB_ID_SPVM__Math__isnormalf < 0) {
      SUB_ID_SPVM__Math__isnormalf = env->get_sub_id(env, "SPVM::Math", "isnormalf", "int(float)");
      if (SUB_ID_SPVM__Math__isnormalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2284;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L5: // BOOL_INT
  int_vars[0] = int_vars[1];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L11: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L12: // CALL_SUB_INT
  // SPVM::Math->isnormalf
  {
    if (SUB_ID_SPVM__Math__isnormalf < 0) {
      SUB_ID_SPVM__Math__isnormalf = env->get_sub_id(env, "SPVM::Math", "isnormalf", "int(float)");
      if (SUB_ID_SPVM__Math__isnormalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L18: // GOTO
  goto L19;
L19: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L21: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L22: // CALL_SUB_INT
  // SPVM::Math->isnormalf
  {
    if (SUB_ID_SPVM__Math__isnormalf < 0) {
      SUB_ID_SPVM__Math__isnormalf = env->get_sub_id(env, "SPVM::Math", "isnormalf", "int(float)");
      if (SUB_ID_SPVM__Math__isnormalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L28: // GOTO
  goto L29;
L29: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L31: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L32: // CALL_SUB_INT
  // SPVM::Math->isnormalf
  {
    if (SUB_ID_SPVM__Math__isnormalf < 0) {
      SUB_ID_SPVM__Math__isnormalf = env->get_sub_id(env, "SPVM::Math", "isnormalf", "int(float)");
      if (SUB_ID_SPVM__Math__isnormalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L38: // GOTO
  goto L39;
L39: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L41: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L42: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L43: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L44: // CALL_SUB_INT
  // SPVM::Math->isnormalf
  {
    if (SUB_ID_SPVM__Math__isnormalf < 0) {
      SUB_ID_SPVM__Math__isnormalf = env->get_sub_id(env, "SPVM::Math", "isnormalf", "int(float)");
      if (SUB_ID_SPVM__Math__isnormalf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnormalf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnormalf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isnormalf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L55;
  }
L46: // BOOL_INT
  int_vars[0] = int_vars[4];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L55;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L55;
L53: // INIT_INT
  int_vars[6] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L55;
L55: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isunordered(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // CALL_SUB_DOUBLE
  // SPVM::Math->NAN
  {
    if (SUB_ID_SPVM__Math__NAN < 0) {
      SUB_ID_SPVM__Math__NAN = env->get_sub_id(env, "SPVM::Math", "NAN", "double()");
      if (SUB_ID_SPVM__Math__NAN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NAN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NAN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunordered";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L6: // CALL_SUB_INT
  // SPVM::Math->isunordered
  {
    if (SUB_ID_SPVM__Math__isunordered < 0) {
      SUB_ID_SPVM__Math__isunordered = env->get_sub_id(env, "SPVM::Math", "isunordered", "int(double,double)");
      if (SUB_ID_SPVM__Math__isunordered < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isunordered");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isunordered;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunordered";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[1];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L14: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L15: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L16: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L17: // CALL_SUB_INT
  // SPVM::Math->isunordered
  {
    if (SUB_ID_SPVM__Math__isunordered < 0) {
      SUB_ID_SPVM__Math__isunordered = env->get_sub_id(env, "SPVM::Math", "isunordered", "int(double,double)");
      if (SUB_ID_SPVM__Math__isunordered < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isunordered");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isunordered;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunordered";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2690;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L25: // CALL_SUB_DOUBLE
  // SPVM::Math->INFINITY
  {
    if (SUB_ID_SPVM__Math__INFINITY < 0) {
      SUB_ID_SPVM__Math__INFINITY = env->get_sub_id(env, "SPVM::Math", "INFINITY", "double()");
      if (SUB_ID_SPVM__Math__INFINITY < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITY");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITY;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunordered";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L27: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L28: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L29: // CALL_SUB_INT
  // SPVM::Math->isunordered
  {
    if (SUB_ID_SPVM__Math__isunordered < 0) {
      SUB_ID_SPVM__Math__isunordered = env->get_sub_id(env, "SPVM::Math", "isunordered", "int(double,double)");
      if (SUB_ID_SPVM__Math__isunordered < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isunordered");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isunordered;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunordered";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L40;
L38: // INIT_INT
  int_vars[6] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L40;
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_isunorderedf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // CALL_SUB_FLOAT
  // SPVM::Math->NANF
  {
    if (SUB_ID_SPVM__Math__NANF < 0) {
      SUB_ID_SPVM__Math__NANF = env->get_sub_id(env, "SPVM::Math", "NANF", "float()");
      if (SUB_ID_SPVM__Math__NANF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math NANF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__NANF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunorderedf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2700;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L6: // CALL_SUB_INT
  // SPVM::Math->isunorderedf
  {
    if (SUB_ID_SPVM__Math__isunorderedf < 0) {
      SUB_ID_SPVM__Math__isunorderedf = env->get_sub_id(env, "SPVM::Math", "isunorderedf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isunorderedf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isunorderedf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isunorderedf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunorderedf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2700;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[1];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L14: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L15: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L16: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L17: // CALL_SUB_INT
  // SPVM::Math->isunorderedf
  {
    if (SUB_ID_SPVM__Math__isunorderedf < 0) {
      SUB_ID_SPVM__Math__isunorderedf = env->get_sub_id(env, "SPVM::Math", "isunorderedf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isunorderedf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isunorderedf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isunorderedf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunorderedf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2703;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L25: // CALL_SUB_FLOAT
  // SPVM::Math->INFINITYF
  {
    if (SUB_ID_SPVM__Math__INFINITYF < 0) {
      SUB_ID_SPVM__Math__INFINITYF = env->get_sub_id(env, "SPVM::Math", "INFINITYF", "float()");
      if (SUB_ID_SPVM__Math__INFINITYF < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math INFINITYF");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__INFINITYF;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunorderedf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L27: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L28: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L29: // CALL_SUB_INT
  // SPVM::Math->isunorderedf
  {
    if (SUB_ID_SPVM__Math__isunorderedf < 0) {
      SUB_ID_SPVM__Math__isunorderedf = env->get_sub_id(env, "SPVM::Math", "isunorderedf", "int(float,float)");
      if (SUB_ID_SPVM__Math__isunorderedf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isunorderedf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isunorderedf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_isunorderedf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L40;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L40;
L38: // INIT_INT
  int_vars[6] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L40;
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ldexp(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ldexp";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // CALL_SUB_DOUBLE
  // SPVM::Math->ldexp
  {
    if (SUB_ID_SPVM__Math__ldexp < 0) {
      SUB_ID_SPVM__Math__ldexp = env->get_sub_id(env, "SPVM::Math", "ldexp", "double(double,int)");
      if (SUB_ID_SPVM__Math__ldexp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ldexp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ldexp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ldexp";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 25.132741228718345;
L10: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_ldexpf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ldexpf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L8: // CALL_SUB_FLOAT
  // SPVM::Math->ldexpf
  {
    if (SUB_ID_SPVM__Math__ldexpf < 0) {
      SUB_ID_SPVM__Math__ldexpf = env->get_sub_id(env, "SPVM::Math", "ldexpf", "float(float,int)");
      if (SUB_ID_SPVM__Math__ldexpf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math ldexpf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__ldexpf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_ldexpf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 25.1327419;
L11: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L16: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lgamma(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lgamma";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->lgamma
  {
    if (SUB_ID_SPVM__Math__lgamma < 0) {
      SUB_ID_SPVM__Math__lgamma = env->get_sub_id(env, "SPVM::Math", "lgamma", "double(double)");
      if (SUB_ID_SPVM__Math__lgamma < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math lgamma");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__lgamma;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lgamma";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.82769459232343712;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lgammaf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lgammaf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->lgammaf
  {
    if (SUB_ID_SPVM__Math__lgammaf < 0) {
      SUB_ID_SPVM__Math__lgammaf = env->get_sub_id(env, "SPVM::Math", "lgammaf", "float(float)");
      if (SUB_ID_SPVM__Math__lgammaf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math lgammaf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__lgammaf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lgammaf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.827694595;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->log
  {
    if (SUB_ID_SPVM__Math__log < 0) {
      SUB_ID_SPVM__Math__log = env->get_sub_id(env, "SPVM::Math", "log", "double(double)");
      if (SUB_ID_SPVM__Math__log < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.1447298858494002;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log10(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log10";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->log10
  {
    if (SUB_ID_SPVM__Math__log10 < 0) {
      SUB_ID_SPVM__Math__log10 = env->get_sub_id(env, "SPVM::Math", "log10", "double(double)");
      if (SUB_ID_SPVM__Math__log10 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log10");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log10;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log10";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.49714987269413385;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log10f(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log10f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->log10f
  {
    if (SUB_ID_SPVM__Math__log10f < 0) {
      SUB_ID_SPVM__Math__log10f = env->get_sub_id(env, "SPVM::Math", "log10f", "float(float)");
      if (SUB_ID_SPVM__Math__log10f < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log10f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log10f;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log10f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.497149885;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log1p(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log1p";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->log1p
  {
    if (SUB_ID_SPVM__Math__log1p < 0) {
      SUB_ID_SPVM__Math__log1p = env->get_sub_id(env, "SPVM::Math", "log1p", "double(double)");
      if (SUB_ID_SPVM__Math__log1p < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log1p");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log1p;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log1p";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.4210804127942926;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log1pf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log1pf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->log1pf
  {
    if (SUB_ID_SPVM__Math__log1pf < 0) {
      SUB_ID_SPVM__Math__log1pf = env->get_sub_id(env, "SPVM::Math", "log1pf", "float(float)");
      if (SUB_ID_SPVM__Math__log1pf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log1pf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log1pf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log1pf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.42108047;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log2";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L5: // CALL_SUB_DOUBLE
  // SPVM::Math->log2
  {
    if (SUB_ID_SPVM__Math__log2 < 0) {
      SUB_ID_SPVM__Math__log2 = env->get_sub_id(env, "SPVM::Math", "log2", "double(double)");
      if (SUB_ID_SPVM__Math__log2 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log2;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log2";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.6514961294723187;
L8: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[0];
L9: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L12: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[0];
L13: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[2];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[3];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_log2f(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log2f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->log2f
  {
    if (SUB_ID_SPVM__Math__log2f < 0) {
      SUB_ID_SPVM__Math__log2f = env->get_sub_id(env, "SPVM::Math", "log2f", "float(float)");
      if (SUB_ID_SPVM__Math__log2f < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math log2f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__log2f;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_log2f";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.65149617;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_logb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_logb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1342;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->logb
  {
    if (SUB_ID_SPVM__Math__logb < 0) {
      SUB_ID_SPVM__Math__logb = env->get_sub_id(env, "SPVM::Math", "logb", "double(double)");
      if (SUB_ID_SPVM__Math__logb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math logb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__logb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_logb";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1342;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L8: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_logbf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_logbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L3: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_FLOAT
  // SPVM::Math->logbf
  {
    if (SUB_ID_SPVM__Math__logbf < 0) {
      SUB_ID_SPVM__Math__logbf = env->get_sub_id(env, "SPVM::Math", "logbf", "float(float)");
      if (SUB_ID_SPVM__Math__logbf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math logbf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__logbf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_logbf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L8: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_logf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_logf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L6: // CALL_SUB_FLOAT
  // SPVM::Math->logf
  {
    if (SUB_ID_SPVM__Math__logf < 0) {
      SUB_ID_SPVM__Math__logf = env->get_sub_id(env, "SPVM::Math", "logf", "float(float)");
      if (SUB_ID_SPVM__Math__logf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math logf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__logf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_logf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.14472985;
L9: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[0];
L10: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L13: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[4];
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lround(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lround";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1826;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1000000000;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L7: // CALL_SUB_LONG
  // SPVM::Math->lround
  {
    if (SUB_ID_SPVM__Math__lround < 0) {
      SUB_ID_SPVM__Math__lround = env->get_sub_id(env, "SPVM::Math", "lround", "long(double)");
      if (SUB_ID_SPVM__Math__lround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math lround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__lround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lround";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1826;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L9: // MOVE_CONSTANT_LONG
  long_vars[1] = 3141592654LL;
L10: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_lroundf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[1];
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lroundf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 100000;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L6: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[2];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L8: // CALL_SUB_LONG
  // SPVM::Math->lroundf
  {
    if (SUB_ID_SPVM__Math__lroundf < 0) {
      SUB_ID_SPVM__Math__lroundf = env->get_sub_id(env, "SPVM::Math", "lroundf", "long(float)");
      if (SUB_ID_SPVM__Math__lroundf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math lroundf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__lroundf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_lroundf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L10: // MOVE_CONSTANT_LONG
  long_vars[1] = 314159LL;
L11: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_modf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // INIT_DOUBLE
  double_vars[1] = 0;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_modf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L5: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L7: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L8: // CALL_SUB_DOUBLE
  // SPVM::Math->modf
  {
    if (SUB_ID_SPVM__Math__modf < 0) {
      SUB_ID_SPVM__Math__modf = env->get_sub_id(env, "SPVM::Math", "modf", "double(double,&double)");
      if (SUB_ID_SPVM__Math__modf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math modf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__modf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_modf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 3.0;
L11: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_modf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1364;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L13: // MOVE_CONSTANT_DOUBLE
  double_vars[5] = 3.0;
L14: // SUBTRACT_DOUBLE
  double_vars[6] = double_vars[4] - double_vars[5];
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L20: // GOTO
  goto L21;
L21: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[6] - double_vars[0];
L22: // LE_DOUBLE
  int_vars[0] = (double_vars[4] <= double_vars[3]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L25: // ADD_DOUBLE
  double_vars[4] = double_vars[6] + double_vars[0];
L26: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[4]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // BOOL_INT
  int_vars[0] = int_vars[2];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[3];
L34: // GOTO
  goto L37;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // BOOL_INT
  int_vars[0] = int_vars[4];
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L41: // GOTO
  goto L42;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_modff(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[3];
  float float_vars[6];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // INIT_FLOAT
  float_vars[1] = 0;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_modff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L5: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[0];
L6: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[1];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L8: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L9: // CALL_SUB_FLOAT
  // SPVM::Math->modff
  {
    if (SUB_ID_SPVM__Math__modff < 0) {
      SUB_ID_SPVM__Math__modff = env->get_sub_id(env, "SPVM::Math", "modff", "float(float,&float)");
      if (SUB_ID_SPVM__Math__modff < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math modff");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__modff;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_modff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L11: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 3.0;
L12: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_modff";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1379;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L14: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.0;
L15: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L16: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[4] = (float)double_vars[2];
L17: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L22: // GOTO
  goto L23;
L23: // SUBTRACT_FLOAT
  float_vars[5] = float_vars[4] - float_vars[0];
L24: // LE_FLOAT
  int_vars[0] = (float_vars[5] <= float_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L27: // ADD_FLOAT
  float_vars[5] = float_vars[4] + float_vars[0];
L28: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[5]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[2];
L33: // GOTO
  goto L36;
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[3];
L36: // GOTO
  goto L39;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // BOOL_INT
  int_vars[0] = int_vars[4];
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L43: // GOTO
  goto L44;
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L46: // INIT_INT
  int_vars[6] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L48;
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nan(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[1];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x74\x65\x73\x74", 4));
L3: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L4: // CALL_SUB_DOUBLE
  // SPVM::Math->nan
  {
    if (SUB_ID_SPVM__Math__nan < 0) {
      SUB_ID_SPVM__Math__nan = env->get_sub_id(env, "SPVM::Math", "nan", "double(string)");
      if (SUB_ID_SPVM__Math__nan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2022;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2022;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[1];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L14: // GOTO
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L17: // PUSH_ARG_UNDEF
  *(void**)&stack[0] = NULL;
L18: // CALL_SUB_DOUBLE
  // SPVM::Math->nan
  {
    if (SUB_ID_SPVM__Math__nan < 0) {
      SUB_ID_SPVM__Math__nan = env->get_sub_id(env, "SPVM::Math", "nan", "double(string)");
      if (SUB_ID_SPVM__Math__nan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2026;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L21: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L22: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L26: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x53\x74\x72\x69\x6E\x67\x20\x6D\x75\x73\x74\x20\x62\x65\x20\x64\x65\x66\x69\x6E\x65\x64", 22));
L29: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L31: // CALL_SUB_INT
  // SPVM::Util->contains
  {
    if (SUB_ID_SPVM__Util__contains < 0) {
      SUB_ID_SPVM__Util__contains = env->get_sub_id(env, "SPVM::Util", "contains", "int(string,string)");
      if (SUB_ID_SPVM__Util__contains < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util contains");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__contains;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nan";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2028;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L33: // BOOL_INT
  int_vars[0] = int_vars[2];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[2];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[3];
L42: // GOTO
  goto L46;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[4];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L50: // GOTO
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L55: // INIT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L57;
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nanf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[1];
  float float_vars[1];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x74\x65\x73\x74", 4));
L3: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L4: // CALL_SUB_FLOAT
  // SPVM::Math->nanf
  {
    if (SUB_ID_SPVM__Math__nanf < 0) {
      SUB_ID_SPVM__Math__nanf = env->get_sub_id(env, "SPVM::Math", "nanf", "float(string)");
      if (SUB_ID_SPVM__Math__nanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2036;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L6: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L8: // CALL_SUB_INT
  // SPVM::Math->isnan
  {
    if (SUB_ID_SPVM__Math__isnan < 0) {
      SUB_ID_SPVM__Math__isnan = env->get_sub_id(env, "SPVM::Math", "isnan", "int(double)");
      if (SUB_ID_SPVM__Math__isnan < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math isnan");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__isnan;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2036;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[1];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L15: // GOTO
  goto L16;
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L18: // PUSH_ARG_UNDEF
  *(void**)&stack[0] = NULL;
L19: // CALL_SUB_FLOAT
  // SPVM::Math->nanf
  {
    if (SUB_ID_SPVM__Math__nanf < 0) {
      SUB_ID_SPVM__Math__nanf = env->get_sub_id(env, "SPVM::Math", "nanf", "float(string)");
      if (SUB_ID_SPVM__Math__nanf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nanf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nanf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2040;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L22: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L23: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L29: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x53\x74\x72\x69\x6E\x67\x20\x6D\x75\x73\x74\x20\x62\x65\x20\x64\x65\x66\x69\x6E\x65\x64", 22));
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L32: // CALL_SUB_INT
  // SPVM::Util->contains
  {
    if (SUB_ID_SPVM__Util__contains < 0) {
      SUB_ID_SPVM__Util__contains = env->get_sub_id(env, "SPVM::Util", "contains", "int(string,string)");
      if (SUB_ID_SPVM__Util__contains < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util contains");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__contains;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nanf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2042;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[2];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[2];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[3];
L43: // GOTO
  goto L47;
L44: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[4];
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L51: // GOTO
  goto L52;
L52: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L53: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L56: // INIT_INT
  int_vars[4] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L58;
L58: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nearbyint(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Math->FE_DOWNWARD
  {
    if (SUB_ID_SPVM__Math__FE_DOWNWARD < 0) {
      SUB_ID_SPVM__Math__FE_DOWNWARD = env->get_sub_id(env, "SPVM::Math", "FE_DOWNWARD", "int()");
      if (SUB_ID_SPVM__Math__FE_DOWNWARD < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_DOWNWARD");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_DOWNWARD;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[2];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x44\x4F\x57\x4E\x57\x41\x52\x44\x29", 37));
L10: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L11: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L14: // GOTO
  goto L16;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L19: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L20: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L23: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L24: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L29: // GOTO
  goto L30;
L30: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L32: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L33: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L34: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = -4;
L37: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L38: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L43: // GOTO
  goto L44;
L44: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L45: // CALL_SUB_INT
  // SPVM::Math->FE_TONEAREST
  {
    if (SUB_ID_SPVM__Math__FE_TONEAREST < 0) {
      SUB_ID_SPVM__Math__FE_TONEAREST = env->get_sub_id(env, "SPVM::Math", "FE_TONEAREST", "int()");
      if (SUB_ID_SPVM__Math__FE_TONEAREST < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_TONEAREST");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_TONEAREST;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L48: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L50: // BOOL_INT
  int_vars[0] = int_vars[5];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x54\x4F\x4E\x45\x41\x52\x45\x53\x54\x29", 38));
L54: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L55: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1669;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L57: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L58: // GOTO
  goto L60;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1672;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L63: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L64: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1672;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L67: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L68: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L73: // GOTO
  goto L74;
L74: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1679;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L77: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L78: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L79: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[2];
L80: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1679;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L83: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L84: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[0]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L89: // GOTO
  goto L90;
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // CALL_SUB_INT
  // SPVM::Math->FE_TOWARDZERO
  {
    if (SUB_ID_SPVM__Math__FE_TOWARDZERO < 0) {
      SUB_ID_SPVM__Math__FE_TOWARDZERO = env->get_sub_id(env, "SPVM::Math", "FE_TOWARDZERO", "int()");
      if (SUB_ID_SPVM__Math__FE_TOWARDZERO < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_TOWARDZERO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_TOWARDZERO;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L93: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L94: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L96: // BOOL_INT
  int_vars[0] = int_vars[5];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L105; }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L99: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x54\x4F\x57\x41\x52\x44\x5A\x45\x52\x4F\x29", 39));
L100: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L101: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L104: // GOTO
  goto L106;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L108: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L109: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L110: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L113: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L114: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_NE_ZERO
  if (int_vars[0]) { goto L120; }
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L119: // GOTO
  goto L120;
L120: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L122: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L123: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L124: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L126: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L127: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L128: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L129: // BOOL_INT
  int_vars[0] = int_vars[0];
L130: // IF_NE_ZERO
  if (int_vars[0]) { goto L134; }
L131: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L133: // GOTO
  goto L134;
L134: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L135: // CALL_SUB_INT
  // SPVM::Math->FE_UPWARD
  {
    if (SUB_ID_SPVM__Math__FE_UPWARD < 0) {
      SUB_ID_SPVM__Math__FE_UPWARD = env->get_sub_id(env, "SPVM::Math", "FE_UPWARD", "int()");
      if (SUB_ID_SPVM__Math__FE_UPWARD < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_UPWARD");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_UPWARD;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L137: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L138: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L140: // BOOL_INT
  int_vars[0] = int_vars[5];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L142: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L143: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x55\x50\x57\x41\x52\x44\x29", 35));
L144: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L145: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1707;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L147: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L148: // GOTO
  goto L150;
L149: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L150: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L151: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1710;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L153: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L154: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1710;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L157: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L158: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L159: // BOOL_INT
  int_vars[0] = int_vars[0];
L160: // IF_NE_ZERO
  if (int_vars[0]) { goto L164; }
L161: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L162: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L163: // GOTO
  goto L164;
L164: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L166: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L167: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L168: // CALL_SUB_DOUBLE
  // SPVM::Math->nearbyint
  {
    if (SUB_ID_SPVM__Math__nearbyint < 0) {
      SUB_ID_SPVM__Math__nearbyint = env->get_sub_id(env, "SPVM::Math", "nearbyint", "double(double)");
      if (SUB_ID_SPVM__Math__nearbyint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyint";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L183;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L171: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L172: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L173: // BOOL_INT
  int_vars[0] = int_vars[0];
L174: // IF_NE_ZERO
  if (int_vars[0]) { goto L178; }
L175: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L176: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L183;
L177: // GOTO
  goto L178;
L178: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L180: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L183;
L181: // INIT_INT
  int_vars[6] = 0;
L182: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L183;
L183: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L184: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nearbyintf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Math->FE_DOWNWARD
  {
    if (SUB_ID_SPVM__Math__FE_DOWNWARD < 0) {
      SUB_ID_SPVM__Math__FE_DOWNWARD = env->get_sub_id(env, "SPVM::Math", "FE_DOWNWARD", "int()");
      if (SUB_ID_SPVM__Math__FE_DOWNWARD < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_DOWNWARD");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_DOWNWARD;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1729;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1729;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[2];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x44\x4F\x57\x4E\x57\x41\x52\x44\x29", 37));
L10: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L11: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1730;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L14: // GOTO
  goto L16;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1733;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L19: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L20: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L21: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1733;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L24: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L25: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L30: // GOTO
  goto L31;
L31: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1740;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L33: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L34: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[1];
L35: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L36: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1740;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = -4;
L39: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L40: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // CALL_SUB_INT
  // SPVM::Math->FE_TONEAREST
  {
    if (SUB_ID_SPVM__Math__FE_TONEAREST < 0) {
      SUB_ID_SPVM__Math__FE_TONEAREST = env->get_sub_id(env, "SPVM::Math", "FE_TONEAREST", "int()");
      if (SUB_ID_SPVM__Math__FE_TONEAREST < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_TONEAREST");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_TONEAREST;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1748;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L49: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L50: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1748;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[5];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L61; }
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L55: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x54\x4F\x4E\x45\x41\x52\x45\x53\x54\x29", 38));
L56: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L57: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1749;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L60: // GOTO
  goto L62;
L61: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1752;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L65: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L66: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L67: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1752;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L70: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L71: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L77; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L76: // GOTO
  goto L77;
L77: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1759;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L79: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L81: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L82: // MULTIPLY_FLOAT
  float_vars[2] = float_vars[0] * float_vars[1];
L83: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[2];
L84: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1759;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L87: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L88: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L93: // GOTO
  goto L94;
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // CALL_SUB_INT
  // SPVM::Math->FE_TOWARDZERO
  {
    if (SUB_ID_SPVM__Math__FE_TOWARDZERO < 0) {
      SUB_ID_SPVM__Math__FE_TOWARDZERO = env->get_sub_id(env, "SPVM::Math", "FE_TOWARDZERO", "int()");
      if (SUB_ID_SPVM__Math__FE_TOWARDZERO < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_TOWARDZERO");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_TOWARDZERO;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1767;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L97: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L98: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1767;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L100: // BOOL_INT
  int_vars[0] = int_vars[5];
L101: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L109; }
L102: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L103: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x54\x4F\x57\x41\x52\x44\x5A\x45\x52\x4F\x29", 39));
L104: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L105: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1768;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L108: // GOTO
  goto L110;
L109: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L110: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L111: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1771;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L113: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L114: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L115: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1771;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L117: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L118: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L119: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L120: // BOOL_INT
  int_vars[0] = int_vars[0];
L121: // IF_NE_ZERO
  if (int_vars[0]) { goto L125; }
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L123: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L124: // GOTO
  goto L125;
L125: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1778;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L127: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L128: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[1];
L129: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L130: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1778;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L132: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L133: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L134: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_NE_ZERO
  if (int_vars[0]) { goto L140; }
L137: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L138: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L139: // GOTO
  goto L140;
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // CALL_SUB_INT
  // SPVM::Math->FE_UPWARD
  {
    if (SUB_ID_SPVM__Math__FE_UPWARD < 0) {
      SUB_ID_SPVM__Math__FE_UPWARD = env->get_sub_id(env, "SPVM::Math", "FE_UPWARD", "int()");
      if (SUB_ID_SPVM__Math__FE_UPWARD < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math FE_UPWARD");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__FE_UPWARD;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1786;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L143: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L144: // CALL_SUB_INT
  // SPVM::Math->fesetround
  {
    if (SUB_ID_SPVM__Math__fesetround < 0) {
      SUB_ID_SPVM__Math__fesetround = env->get_sub_id(env, "SPVM::Math", "fesetround", "int(int)");
      if (SUB_ID_SPVM__Math__fesetround < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math fesetround");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__fesetround;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1786;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L146: // BOOL_INT
  int_vars[0] = int_vars[5];
L147: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L149: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x61\x69\x6C\x65\x64\x20\x74\x6F\x20\x73\x65\x74\x20\x66\x65\x73\x65\x74\x72\x6F\x75\x6E\x64\x28\x46\x45\x5F\x55\x50\x57\x41\x52\x44\x29", 35));
L150: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L151: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1787;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L153: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L154: // GOTO
  goto L156;
L155: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L156: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L157: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L158: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1790;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L159: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L160: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L161: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L162: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1790;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L163: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L164: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L165: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L166: // BOOL_INT
  int_vars[0] = int_vars[0];
L167: // IF_NE_ZERO
  if (int_vars[0]) { goto L171; }
L168: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L169: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L170: // GOTO
  goto L171;
L171: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1797;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L173: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L174: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[1];
L175: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L176: // CALL_SUB_FLOAT
  // SPVM::Math->nearbyintf
  {
    if (SUB_ID_SPVM__Math__nearbyintf < 0) {
      SUB_ID_SPVM__Math__nearbyintf = env->get_sub_id(env, "SPVM::Math", "nearbyintf", "float(float)");
      if (SUB_ID_SPVM__Math__nearbyintf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nearbyintf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nearbyintf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L177: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nearbyintf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1797;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L191;
  }
L178: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L179: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L180: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L181: // BOOL_INT
  int_vars[0] = int_vars[0];
L182: // IF_NE_ZERO
  if (int_vars[0]) { goto L186; }
L183: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L184: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L191;
L185: // GOTO
  goto L186;
L186: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L187: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L188: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L191;
L189: // INIT_INT
  int_vars[6] = 0;
L190: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L191;
L191: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L192: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nextafter(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nextafter";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2050;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 10.0;
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L7: // CALL_SUB_DOUBLE
  // SPVM::Math->nextafter
  {
    if (SUB_ID_SPVM__Math__nextafter < 0) {
      SUB_ID_SPVM__Math__nextafter = env->get_sub_id(env, "SPVM::Math", "nextafter", "double(double,double)");
      if (SUB_ID_SPVM__Math__nextafter < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nextafter");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nextafter;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nextafter";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2050;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.1415926535897936;
L10: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nextafterf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nextafterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2060;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 10.0;
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L8: // CALL_SUB_FLOAT
  // SPVM::Math->nextafterf
  {
    if (SUB_ID_SPVM__Math__nextafterf < 0) {
      SUB_ID_SPVM__Math__nextafterf = env->get_sub_id(env, "SPVM::Math", "nextafterf", "float(float,float)");
      if (SUB_ID_SPVM__Math__nextafterf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nextafterf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nextafterf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nextafterf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2060;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 3.14159274;
L11: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L16: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nexttoward(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nexttoward";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 10.0;
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L7: // CALL_SUB_DOUBLE
  // SPVM::Math->nexttoward
  {
    if (SUB_ID_SPVM__Math__nexttoward < 0) {
      SUB_ID_SPVM__Math__nexttoward = env->get_sub_id(env, "SPVM::Math", "nexttoward", "double(double,double)");
      if (SUB_ID_SPVM__Math__nexttoward < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nexttoward");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nexttoward;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nexttoward";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.1415926535897936;
L10: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_nexttowardf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nexttowardf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2079;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 10.0;
L6: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[2];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L8: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L9: // CALL_SUB_FLOAT
  // SPVM::Math->nexttowardf
  {
    if (SUB_ID_SPVM__Math__nexttowardf < 0) {
      SUB_ID_SPVM__Math__nexttowardf = env->get_sub_id(env, "SPVM::Math", "nexttowardf", "float(float,double)");
      if (SUB_ID_SPVM__Math__nexttowardf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math nexttowardf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__nexttowardf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_nexttowardf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 2079;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L11: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 3.14159274;
L12: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L13: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L16: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L17: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[2];
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // BOOL_INT
  int_vars[0] = int_vars[3];
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[4];
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_pi(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_pi";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 6;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.1415926535897931;
L4: // GE_DOUBLE
  int_vars[0] = (double_vars[0] >= double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.141592653589794;
L8: // LE_DOUBLE
  int_vars[0] = (double_vars[0] <= double_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[2];
L13: // GOTO
  goto L16;
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L15: // BOOL_INT
  int_vars[0] = int_vars[3];
L16: // GOTO
  goto L19;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_pow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_pow";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_pow";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L8: // CALL_SUB_DOUBLE
  // SPVM::Math->pow
  {
    if (SUB_ID_SPVM__Math__pow < 0) {
      SUB_ID_SPVM__Math__pow = env->get_sub_id(env, "SPVM::Math", "pow", "double(double,double)");
      if (SUB_ID_SPVM__Math__pow < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math pow");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__pow;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_pow";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 36.462159607207909;
L11: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L12: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L16: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_powf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_powf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1503;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_powf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1503;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L7: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[2] = (float)double_vars[1];
L8: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L9: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L10: // CALL_SUB_FLOAT
  // SPVM::Math->powf
  {
    if (SUB_ID_SPVM__Math__powf < 0) {
      SUB_ID_SPVM__Math__powf = env->get_sub_id(env, "SPVM::Math", "powf", "float(float,float)");
      if (SUB_ID_SPVM__Math__powf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math powf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__powf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_powf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1503;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L12: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 36.4621582;
L13: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L14: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L17: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L18: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // BOOL_INT
  int_vars[0] = int_vars[2];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[3];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[4];
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L38;
L33: // GOTO
  goto L34;
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L38;
L36: // INIT_INT
  int_vars[6] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L38;
L38: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remainder(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_remainder";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1901;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 2.0;
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L7: // CALL_SUB_DOUBLE
  // SPVM::Math->remainder
  {
    if (SUB_ID_SPVM__Math__remainder < 0) {
      SUB_ID_SPVM__Math__remainder = env->get_sub_id(env, "SPVM::Math", "remainder", "double(double,double)");
      if (SUB_ID_SPVM__Math__remainder < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math remainder");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__remainder;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_remainder";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1901;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.85840734641020688;
L10: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[1] - double_vars[0];
L11: // LE_DOUBLE
  int_vars[0] = (double_vars[2] <= double_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L14: // ADD_DOUBLE
  double_vars[2] = double_vars[1] + double_vars[0];
L15: // LE_DOUBLE
  int_vars[0] = (double_vars[3] <= double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[2];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[3];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remainderf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 9.99999975e-05;
L2: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_remainderf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1911;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[1] = (float)double_vars[0];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 2.0;
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L8: // CALL_SUB_FLOAT
  // SPVM::Math->remainderf
  {
    if (SUB_ID_SPVM__Math__remainderf < 0) {
      SUB_ID_SPVM__Math__remainderf = env->get_sub_id(env, "SPVM::Math", "remainderf", "float(float,float)");
      if (SUB_ID_SPVM__Math__remainderf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math remainderf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Math__remainderf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_remainderf";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1911;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -0.858407319;
L11: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[1] - float_vars[0];
L12: // LE_FLOAT
  int_vars[0] = (float_vars[2] <= float_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L15: // ADD_FLOAT
  float_vars[2] = float_vars[1] + float_vars[0];
L16: // LE_FLOAT
  int_vars[0] = (float_vars[3] <= float_vars[2]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Math__test_remquo(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[4];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0000000000000001e-09;
L2: // INIT_INT
  int_vars[2] = 0;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Math";
    const char* sub_name = "test_remquo";
    const char* file = "TestCase/Lib/SPVM/Math.spvm";
    int32_t line = 1922;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 2.0;
L6: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L8: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L9: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L10: // CALL_SUB_DOUBLE
  // SPVM::Math->remquo
  {
    if (SUB_ID_SPVM__Math__remquo < 0) {
      SUB_ID_SPVM__Math__remquo = env->get_sub_id(env, "SPVM::Math", "remquo", "double(double,double,&int)");
      if (SUB_ID_SPVM__Math__remquo < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Math remquo");
        env->set_exception(env, exception);
        r