#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__basic(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__condition_my(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__nested_last(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__nested_last_with_switch(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__nested_next(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__next_statement(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__For__omit_init_inc(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__For__basic(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L4: // GOTO
  goto L9;
L5: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[4];
L6: // MOVE_INT
  int_vars[5] = int_vars[4];
L7: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L8: // ADD_INT
  int_vars[4] = int_vars[5] + int_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L5; }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L14: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L17: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L22: // GOTO
  goto L33;
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L24: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L27: // GOTO
  goto L37;
L28: // GOTO
  goto L29;
L29: // ADD_INT
  int_vars[4] = int_vars[4] + int_vars[5];
L30: // MOVE_INT
  int_vars[6] = int_vars[5];
L31: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L32: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 10;
L34: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[6]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 10;
L38: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L46: // GOTO
  goto L57;
L47: // MOVE_CONSTANT_INT
  int_vars[7] = 5;
L48: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L51: // GOTO
  goto L54;
L52: // GOTO
  goto L53;
L53: // ADD_INT
  int_vars[5] = int_vars[5] + int_vars[6];
L54: // MOVE_INT
  int_vars[7] = int_vars[6];
L55: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L56: // ADD_INT
  int_vars[6] = int_vars[7] + int_vars[8];
L57: // MOVE_CONSTANT_INT
  int_vars[7] = 10;
L58: // LT_INT
  int_vars[0] = (int_vars[6] < int_vars[7]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L61: // MOVE_CONSTANT_INT
  int_vars[6] = 40;
L62: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L68: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L69: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L70: // GOTO
  goto L85;
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L72: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::For";
    const char* sub_name = "basic";
    const char* file = "TestCase/For.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L148;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L75: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L78: // GOTO
  goto L89;
L79: // GOTO
  goto L80;
L80: // ADD_INT
  int_vars[6] = int_vars[6] + int_vars[7];
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_INT
  int_vars[8] = int_vars[7];
L83: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L84: // ADD_INT
  int_vars[7] = int_vars[8] + int_vars[9];
L85: // MOVE_CONSTANT_INT
  int_vars[8] = 10;
L86: // LT_INT
  int_vars[0] = (int_vars[7] < int_vars[8]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[7] = 10;
L91: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L92: // BOOL_INT
  int_vars[0] = int_vars[0];
L93: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L94: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L95: // GOTO
  goto L96;
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L98: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L99: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L100: // GOTO
  goto L115;
L101: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L102: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::For";
    const char* sub_name = "basic";
    const char* file = "TestCase/For.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L148;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L105: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[9]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L110; }
L108: // GOTO
  goto L111;
L109: // GOTO
  goto L110;
L110: // ADD_INT
  int_vars[7] = int_vars[7] + int_vars[8];
L111: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L112: // MOVE_INT
  int_vars[9] = int_vars[8];
L113: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L114: // ADD_INT
  int_vars[8] = int_vars[9] + int_vars[10];
L115: // MOVE_CONSTANT_INT
  int_vars[9] = 10;
L116: // LT_INT
  int_vars[0] = (int_vars[8] < int_vars[9]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_NE_ZERO
  if (int_vars[0]) { goto L101; }
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[8] = 40;
L121: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L124: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L125: // GOTO
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // BOOL_INT
  int_vars[0] = int_vars[1];
L128: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L144; }
L129: // BOOL_INT
  int_vars[0] = int_vars[3];
L130: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L143; }
L131: // BOOL_INT
  int_vars[0] = int_vars[4];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L142; }
L133: // BOOL_INT
  int_vars[0] = int_vars[5];
L134: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L141; }
L135: // BOOL_INT
  int_vars[0] = int_vars[6];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L137: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L138: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L148;
L139: // GOTO
  goto L140;
L140: // GOTO
  goto L141;
L141: // GOTO
  goto L142;
L142: // GOTO
  goto L143;
L143: // GOTO
  goto L144;
L144: // MOVE_CONSTANT_INT
  int_vars[9] = 0;
L145: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L148;
L146: // INIT_INT
  int_vars[11] = 0;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[11];
  goto L148;
L148: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L149: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__For__condition_my(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // GOTO
  goto L12;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L4: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L13: // BOOL_INT
  int_vars[0] = int_vars[3];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L3; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__For__nested_last(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L38;
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L9: // BOOL_INT
  int_vars[0] = int_vars[4];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L11: // GOTO
  goto L41;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L14: // GOTO
  goto L41;
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L18: // GOTO
  goto L41;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L22: // GOTO
  goto L32;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[4]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L27: // GOTO
  goto L35;
L28: // GOTO
  goto L29;
L29: // MOVE_INT
  int_vars[6] = int_vars[5];
L30: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L31: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L35: // MOVE_INT
  int_vars[5] = int_vars[3];
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L37: // ADD_INT
  int_vars[3] = int_vars[5] + int_vars[6];
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[4];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L44;
L42: // INIT_INT
  int_vars[5] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__For__nested_last_with_switch(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L24;
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L8: // MOVE_INT
  int_vars[4] = int_vars[1];
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L10: // ADD_INT
  int_vars[1] = int_vars[4] + int_vars[5];
L11: // GOTO
  goto L27;
L12: // GOTO
  goto L13;
L13: // TABLE_SWITCH
  switch(int_vars[3]) {
    case 1: goto L14;
    default: goto L15;
  }
L14: // GOTO
  goto L18;
L15: // MOVE_INT
  int_vars[6] = int_vars[1];
L16: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L17: // ADD_INT
  int_vars[1] = int_vars[6] + int_vars[7];
L18: // MOVE_INT
  int_vars[6] = int_vars[1];
L19: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L20: // ADD_INT
  int_vars[1] = int_vars[6] + int_vars[7];
L21: // MOVE_INT
  int_vars[4] = int_vars[3];
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[4];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L28: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L38;
L33: // GOTO
  goto L34;
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L38;
L36: // INIT_INT
  int_vars[7] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L38;
L38: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__For__nested_next(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L4: // GOTO
  goto L45;
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L6: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L10: // BOOL_INT
  int_vars[0] = int_vars[5];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L12: // GOTO
  goto L42;
L13: // GOTO
  goto L14;
L14: // GOTO
  goto L42;
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L16: // BOOL_INT
  int_vars[0] = int_vars[7];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L18: // GOTO
  goto L42;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L22: // GOTO
  goto L35;
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L27: // GOTO
  goto L32;
L28: // GOTO
  goto L29;
L29: // MOVE_INT
  int_vars[7] = int_vars[3];
L30: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L31: // ADD_INT
  int_vars[3] = int_vars[7] + int_vars[8];
L32: // MOVE_INT
  int_vars[5] = int_vars[6];
L33: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L34: // ADD_INT
  int_vars[6] = int_vars[5] + int_vars[7];
L35: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L36: // LT_INT
  int_vars[0] = (int_vars[6] < int_vars[5]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L39: // MOVE_INT
  int_vars[6] = int_vars[1];
L40: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L41: // ADD_INT
  int_vars[1] = int_vars[6] + int_vars[7];
L42: // MOVE_INT
  int_vars[5] = int_vars[4];
L43: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L44: // ADD_INT
  int_vars[4] = int_vars[5] + int_vars[6];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L46: // LT_INT
  int_vars[0] = (int_vars[4] < int_vars[5]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L5; }
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L50: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[4]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L67;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L57: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L67;
L62: // GOTO
  goto L63;
L63: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L67;
L65: // INIT_INT
  int_vars[8] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L67;
L67: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__For__next_statement(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L20;
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L8: // GOTO
  goto L17;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L11: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L14: // GOTO
  goto L17;
L15: // GOTO
  goto L16;
L16: // ADD_INT
  int_vars[1] = int_vars[1] + int_vars[3];
L17: // MOVE_INT
  int_vars[4] = int_vars[3];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L21: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L25: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L35;
L33: // INIT_INT
  int_vars[7] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L35;
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__For__omit_init_inc(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L8;
L4: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[1];
L5: // MOVE_INT
  int_vars[4] = int_vars[1];
L6: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L7: // ADD_INT
  int_vars[1] = int_vars[4] + int_vars[5];
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 11;
L9: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[4]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 55;
L13: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L21: // INIT_INT
  int_vars[8] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


