#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#include <complex.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE = -1;
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Simple__byte_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = -1;
static int32_t FIELD_ID_TestCase__Simple__double_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__double_value = -1;
static int32_t FIELD_ID_TestCase__Simple__float_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__float_value = -1;
static int32_t FIELD_ID_TestCase__Simple__int_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__int_value = -1;
static int32_t FIELD_ID_TestCase__Simple__long_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__long_value = -1;
static int32_t FIELD_ID_TestCase__Simple__object_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__object_value = -1;
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
static int32_t FIELD_ID_TestCase__Simple__short_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__short_value = -1;
static int32_t FIELD_ID_TestCase__x_byte = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_byte = -1;
static int32_t FIELD_ID_TestCase__x_short = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_short = -1;
static int32_t FIELD_ID_TestCase__x_int = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_int = -1;
static int32_t FIELD_ID_TestCase__x_long = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_long = -1;
static int32_t FIELD_ID_TestCase__x_float = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_float = -1;
static int32_t FIELD_ID_TestCase__x_double = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_double = -1;
static int32_t FIELD_ID_TestCase__minimal = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__minimal = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Extension__call_byte_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_double_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_float_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_int_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_long_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_object_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_short_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Extension__call_void_sub_exception_native = - 1;
static int32_t SUB_ID_TestCase__Simple__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_byte = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_double = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_float = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_int = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_long = - 1;
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_object = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_TestCase__Extension__native_get_get_field_short = - 1;
static int32_t SUB_ID_TestCase__Extension__new = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_byte_test = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_double_test = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_float_test = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_int_test = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_long_test = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_object_test = - 1;
static int32_t SUB_ID_TestCase__Extension__get_package_var_short_test = - 1;
static int32_t SUB_ID_TestCase__Callback__ImplementCallback1__new = - 1;
static int32_t SUB_ID_TestCase__Extension__has_callback_test = - 1;
static int32_t SUB_ID_TestCase__Extension__is_type_test_minimals = - 1;
static int32_t SUB_ID_TestCase__new = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_byte = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_short = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_int = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_long = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_float = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_double = - 1;
static int32_t SUB_ID_TestCase__Extension__native_env_get_field_object = - 1;
static int32_t SUB_ID_TestCase__Extension__native_use_strlen = - 1;
static int32_t SUB_ID_TestCase__Extension__ref_byte_sum = - 1;
static int32_t SUB_ID_TestCase__Extension__ref_double_sum = - 1;
static int32_t SUB_ID_TestCase__Extension__ref_float_sum = - 1;
static int32_t SUB_ID_TestCase__Extension__ref_int_sum = - 1;
static int32_t SUB_ID_TestCase__Extension__ref_long_sum = - 1;
static int32_t SUB_ID_TestCase__Extension__ref_short_sum = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_byte = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_double = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_float = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_int = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_long = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_object = - 1;
static int32_t SUB_ID_TestCase__Extension__native_set_field_short = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_byte_test = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_double_test = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_float_test = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_int_test = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_long_test = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_object_test = - 1;
static int32_t SUB_ID_TestCase__Extension__set_package_var_short_test = - 1;
static int32_t SUB_ID_TestCase__Extension__sum = - 1;
static int32_t SUB_ID_TestCase__Extension__add_iarray = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_TestCase__Callback__ImplementCallback1 = -1;
static int32_t BASIC_TYPE_ID_TestCase__Simple = -1;
static int32_t BASIC_TYPE_ID_TestCase__Extension = -1;
static int32_t BASIC_TYPE_ID_int = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_byte_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_double_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_float_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_int_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_long_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_object_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_short_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__call_void_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_field_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__has_callback(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__is_type(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int)
int32_t SPPRECOMPILE__TestCase__Extension__my_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__native_env_set_field(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__native_use_strlen_test(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Extension()
int32_t SPPRECOMPILE__TestCase__Extension__new(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__ref_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__ref_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__ref_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__ref_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__ref_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__ref_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_field_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__spvm_extension(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Extension__spvm_extension_add_iarray(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Extension__call_byte_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_BYTE
  // TestCase::Extension->call_byte_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_byte_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_byte_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_byte_sub_exception_native", "byte()");
      if (SUB_ID_TestCase__Extension__call_byte_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_byte_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_byte_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_byte_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 611;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_double_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_DOUBLE
  // TestCase::Extension->call_double_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_double_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_double_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_double_sub_exception_native", "double()");
      if (SUB_ID_TestCase__Extension__call_double_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_double_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_double_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_double_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 671;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_float_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_FLOAT
  // TestCase::Extension->call_float_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_float_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_float_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_float_sub_exception_native", "float()");
      if (SUB_ID_TestCase__Extension__call_float_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_float_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_float_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_float_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 659;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_int_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_INT
  // TestCase::Extension->call_int_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_int_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_int_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_int_sub_exception_native", "int()");
      if (SUB_ID_TestCase__Extension__call_int_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_int_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_int_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_int_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 635;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_long_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_LONG
  // TestCase::Extension->call_long_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_long_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_long_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_long_sub_exception_native", "long()");
      if (SUB_ID_TestCase__Extension__call_long_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_long_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_long_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_long_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 647;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_object_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_DOUBLE
  // TestCase::Extension->call_object_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_object_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_object_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_object_sub_exception_native", "double()");
      if (SUB_ID_TestCase__Extension__call_object_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_object_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_object_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_object_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 683;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_short_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_SHORT
  // TestCase::Extension->call_short_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_short_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_short_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_short_sub_exception_native", "short()");
      if (SUB_ID_TestCase__Extension__call_short_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_short_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_short_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_short_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 623;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__call_void_sub_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // CALL_SUB_VOID
  // TestCase::Extension->call_void_sub_exception_native
  {
    if (SUB_ID_TestCase__Extension__call_void_sub_exception_native < 0) {
      SUB_ID_TestCase__Extension__call_void_sub_exception_native = env->get_sub_id(env, "TestCase::Extension", "call_void_sub_exception_native", "void()");
      if (SUB_ID_TestCase__Extension__call_void_sub_exception_native < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension call_void_sub_exception_native");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__call_void_sub_exception_native;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L3: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "call_void_sub_exception";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 599;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L4;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L5: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L6: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 438;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_byte
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_byte < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_byte = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_byte", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_byte < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_byte;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L12: // INIT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[1];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 489;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 489;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_double
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_double < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_double = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_double", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_double < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_double;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 491;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L12: // INIT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[1];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 478;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 479;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 479;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_float
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_float < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_float = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_float", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_float < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_float;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L12: // INIT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 458;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 459;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[2];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 459;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_int
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_int < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_int = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_int", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_int;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L12: // INIT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[1];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 468;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_long
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_long < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_long = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_long", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_long < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_long;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L12: // INIT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (SPVM_VALUE_object*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L12: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(SPVM_VALUE_object*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L18: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_object
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_object < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_object = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_object", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_object < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_object;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L21: // INIT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_field_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->native_get_get_field_short
  {
    if (SUB_ID_TestCase__Extension__native_get_get_field_short < 0) {
      SUB_ID_TestCase__Extension__native_get_get_field_short = env->get_sub_id(env, "TestCase::Extension", "native_get_get_field_short", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_get_get_field_short < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_get_get_field_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_get_get_field_short;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L12: // INIT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L6: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE] = byte_vars[0];
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_BYTE
  // TestCase::Extension->get_package_var_byte_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_byte_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_byte_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_byte_test", "byte(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_byte_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_byte_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_byte_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L11: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 98;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L6: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE] = double_vars[0];
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_DOUBLE
  // TestCase::Extension->get_package_var_double_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_double_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_double_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_double_test", "double(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_double_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_double_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_double_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L10: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L12: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L6: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE] = float_vars[0];
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_FLOAT
  // TestCase::Extension->get_package_var_float_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_float_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_float_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_float_test", "float(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_float_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_float_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_float_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L10: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L12: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 55;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L6: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE] = int_vars[2];
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_INT
  // TestCase::Extension->get_package_var_int_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_int_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_int_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_int_test", "int(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_int_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_int_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_int_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L10: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L22;
L20: // INIT_INT
  int_vars[7] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L6: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE] = long_vars[0];
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_LONG
  // TestCase::Extension->get_package_var_long_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_long_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_long_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_long_test", "long(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_long_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_long_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_long_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L10: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L12: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L7: // SET_PACKAGE_VAR_OBJECT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$MINIMAL_VALUE", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $MINIMAL_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE],
object_vars[1]);  }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // CALL_SUB_OBJECT
  // TestCase::Extension->get_package_var_object_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_object_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_object_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_object_test", "TestCase::Minimal(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_object_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_object_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_object_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L13: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L16: // SET_PACKAGE_VAR_UNDEF
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$MINIMAL_VALUE", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $MINIMAL_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE], NULL);
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__get_package_var_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 40;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L6: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE] = short_vars[0];
  }
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // CALL_SUB_SHORT
  // TestCase::Extension->get_package_var_short_test
  {
    if (SUB_ID_TestCase__Extension__get_package_var_short_test < 0) {
      SUB_ID_TestCase__Extension__get_package_var_short_test = env->get_sub_id(env, "TestCase::Extension", "get_package_var_short_test", "short(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__get_package_var_short_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension get_package_var_short_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__get_package_var_short_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L11: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "get_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__has_callback(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Callback::ImplementCallback1->new
  {
    if (SUB_ID_TestCase__Callback__ImplementCallback1__new < 0) {
      SUB_ID_TestCase__Callback__ImplementCallback1__new = env->get_sub_id(env, "TestCase::Callback::ImplementCallback1", "new", "TestCase::Callback::ImplementCallback1()");
      if (SUB_ID_TestCase__Callback__ImplementCallback1__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Callback::ImplementCallback1 new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Callback__ImplementCallback1__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "has_callback";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Callback__ImplementCallback1 < 0) {
      BASIC_TYPE_ID_TestCase__Callback__ImplementCallback1 = env->get_basic_type_id(env, "TestCase::Callback::ImplementCallback1");
      if (BASIC_TYPE_ID_TestCase__Callback__ImplementCallback1 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Callback::ImplementCallback1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Callback__ImplementCallback1;
    int32_t length = *(SPVM_VALUE_int*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "has_callback";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "has_callback";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // CALL_SUB_INT
  // TestCase::Extension->has_callback_test
  {
    if (SUB_ID_TestCase__Extension__has_callback_test < 0) {
      SUB_ID_TestCase__Extension__has_callback_test = env->get_sub_id(env, "TestCase::Extension", "has_callback_test", "int(object)");
      if (SUB_ID_TestCase__Extension__has_callback_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension has_callback_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__has_callback_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "has_callback";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 226;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L14: // BOOL_INT
  int_vars[0] = int_vars[2];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L18: // GOTO
  goto L19;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L20: // CALL_SUB_INT
  // TestCase::Extension->has_callback_test
  {
    if (SUB_ID_TestCase__Extension__has_callback_test < 0) {
      SUB_ID_TestCase__Extension__has_callback_test = env->get_sub_id(env, "TestCase::Extension", "has_callback_test", "int(object)");
      if (SUB_ID_TestCase__Extension__has_callback_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension has_callback_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__has_callback_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "has_callback";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L33: // GOTO
  goto L34;
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L35: // CALL_SUB_INT
  // TestCase::Extension->has_callback_test
  {
    if (SUB_ID_TestCase__Extension__has_callback_test < 0) {
      SUB_ID_TestCase__Extension__has_callback_test = env->get_sub_id(env, "TestCase::Extension", "has_callback_test", "int(object)");
      if (SUB_ID_TestCase__Extension__has_callback_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension has_callback_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__has_callback_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "has_callback";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 234;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[2];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[3];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L53;
L51: // INIT_INT
  int_vars[6] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__is_type(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(SPVM_VALUE_int*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "is_type";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "is_type";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 244;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L10: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Simple < 0) {
      BASIC_TYPE_ID_TestCase__Simple = env->get_basic_type_id(env, "TestCase::Simple");
      if (BASIC_TYPE_ID_TestCase__Simple < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Simple");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Simple;
    int32_t length = *(SPVM_VALUE_int*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "is_type";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // CALL_SUB_INT
  // TestCase::Extension->is_type_test_minimals
  {
    if (SUB_ID_TestCase__Extension__is_type_test_minimals < 0) {
      SUB_ID_TestCase__Extension__is_type_test_minimals = env->get_sub_id(env, "TestCase::Extension", "is_type_test_minimals", "int(object)");
      if (SUB_ID_TestCase__Extension__is_type_test_minimals < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension is_type_test_minimals");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__is_type_test_minimals;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "is_type";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 247;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[2];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L54;
L19: // GOTO
  goto L20;
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L21: // CALL_SUB_INT
  // TestCase::Extension->is_type_test_minimals
  {
    if (SUB_ID_TestCase__Extension__is_type_test_minimals < 0) {
      SUB_ID_TestCase__Extension__is_type_test_minimals = env->get_sub_id(env, "TestCase::Extension", "is_type_test_minimals", "int(object)");
      if (SUB_ID_TestCase__Extension__is_type_test_minimals < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension is_type_test_minimals");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__is_type_test_minimals;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "is_type";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L23: // BOOL_INT
  int_vars[0] = int_vars[4];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L29: // BOOL_INT
  int_vars[0] = int_vars[3];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L54;
L34: // GOTO
  goto L35;
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L36: // CALL_SUB_INT
  // TestCase::Extension->is_type_test_minimals
  {
    if (SUB_ID_TestCase__Extension__is_type_test_minimals < 0) {
      SUB_ID_TestCase__Extension__is_type_test_minimals = env->get_sub_id(env, "TestCase::Extension", "is_type_test_minimals", "int(object)");
      if (SUB_ID_TestCase__Extension__is_type_test_minimals < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension is_type_test_minimals");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__is_type_test_minimals;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "is_type";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[4];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[2];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // BOOL_INT
  int_vars[0] = int_vars[3];
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L54;
L49: // GOTO
  goto L50;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L54;
L52: // INIT_INT
  int_vars[6] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__my_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L4;
L2: // INIT_INT
  int_vars[3] = 0;
L3: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__native_env_set_field(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  double double_vars[2];
  float float_vars[2];
  int64_t long_vars[2];
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase->new
  {
    if (SUB_ID_TestCase__new < 0) {
      SUB_ID_TestCase__new = env->get_sub_id(env, "TestCase", "new", "TestCase()");
      if (SUB_ID_TestCase__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L6: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_byte < 0, 0)) {
      FIELD_ID_TestCase__x_byte = env->get_field_id(env, "TestCase", "x_byte", "byte");
      if (FIELD_ID_TestCase__x_byte < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_byte = env->get_field_offset(env, FIELD_ID_TestCase__x_byte);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_byte) = byte_vars[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L10: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_short < 0, 0)) {
      FIELD_ID_TestCase__x_short = env->get_field_id(env, "TestCase", "x_short", "short");
      if (FIELD_ID_TestCase__x_short < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_short = env->get_field_offset(env, FIELD_ID_TestCase__x_short);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_short) = short_vars[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L13: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_int < 0, 0)) {
      FIELD_ID_TestCase__x_int = env->get_field_id(env, "TestCase", "x_int", "int");
      if (FIELD_ID_TestCase__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_int = env->get_field_offset(env, FIELD_ID_TestCase__x_int);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_int) = int_vars[2];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 561;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L15: // MOVE_CONSTANT_LONG
  long_vars[0] = 4LL;
L16: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_long < 0, 0)) {
      FIELD_ID_TestCase__x_long = env->get_field_id(env, "TestCase", "x_long", "long");
      if (FIELD_ID_TestCase__x_long < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_long = env->get_field_offset(env, FIELD_ID_TestCase__x_long);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_long) = long_vars[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L18: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L19: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_float < 0, 0)) {
      FIELD_ID_TestCase__x_float = env->get_field_id(env, "TestCase", "x_float", "float");
      if (FIELD_ID_TestCase__x_float < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_float = env->get_field_offset(env, FIELD_ID_TestCase__x_float);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_float) = float_vars[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L21: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.025000000000000001;
L22: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_double < 0, 0)) {
      FIELD_ID_TestCase__x_double = env->get_field_id(env, "TestCase", "x_double", "double");
      if (FIELD_ID_TestCase__x_double < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_double = env->get_field_offset(env, FIELD_ID_TestCase__x_double);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_double) = double_vars[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L27: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__minimal < 0, 0)) {
      FIELD_ID_TestCase__minimal = env->get_field_id(env, "TestCase", "minimal", "TestCase::Minimal");
      if (FIELD_ID_TestCase__minimal < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__minimal = env->get_field_offset(env, FIELD_ID_TestCase__minimal);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (SPVM_VALUE_object*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__minimal);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 566;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L29: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L30: // CALL_SUB_BYTE
  // TestCase::Extension->native_env_get_field_byte
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_byte < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_byte = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_byte", "byte(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_byte < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_byte;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 568;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // CALL_SUB_SHORT
  // TestCase::Extension->native_env_get_field_short
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_short < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_short = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_short", "short(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_short < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_short;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L36: // CALL_SUB_INT
  // TestCase::Extension->native_env_get_field_int
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_int < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_int = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_int", "int(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_int;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 570;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L38: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L39: // CALL_SUB_LONG
  // TestCase::Extension->native_env_get_field_long
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_long < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_long = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_long", "long(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_long < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_long;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 571;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L42: // CALL_SUB_FLOAT
  // TestCase::Extension->native_env_get_field_float
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_float < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_float = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_float", "float(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_float < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_float;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L45: // CALL_SUB_DOUBLE
  // TestCase::Extension->native_env_get_field_double
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_double < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_double = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_double", "double(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_double < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_double;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L49: // CALL_SUB_OBJECT
  // TestCase::Extension->native_env_get_field_object
  {
    if (SUB_ID_TestCase__Extension__native_env_get_field_object < 0) {
      SUB_ID_TestCase__Extension__native_env_get_field_object = env->get_sub_id(env, "TestCase::Extension", "native_env_get_field_object", "TestCase::Minimal(TestCase)");
      if (SUB_ID_TestCase__Extension__native_env_get_field_object < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_env_get_field_object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_env_get_field_object;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_env_set_field";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L51: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L53: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L54: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L55: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L58: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L60: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L61: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L62: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L66: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L69: // MOVE_CONSTANT_LONG
  long_vars[1] = 4LL;
L70: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L90; }
L73: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L74: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L89; }
L77: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.025000000000000001;
L78: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L81: // EQ_OBJECT
  int_vars[0] = (object_vars[1] == object_vars[2]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L95;
L86: // GOTO
  goto L87;
L87: // GOTO
  goto L88;
L88: // GOTO
  goto L89;
L89: // GOTO
  goto L90;
L90: // GOTO
  goto L91;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // INIT_INT
  int_vars[5] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__native_use_strlen_test(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L3: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L4: // CALL_SUB_INT
  // TestCase::Extension->native_use_strlen
  {
    if (SUB_ID_TestCase__Extension__native_use_strlen < 0) {
      SUB_ID_TestCase__Extension__native_use_strlen = env->get_sub_id(env, "TestCase::Extension", "native_use_strlen", "int(string)");
      if (SUB_ID_TestCase__Extension__native_use_strlen < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_use_strlen");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_use_strlen;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "native_use_strlen_test";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L17;
L15: // INIT_INT
  int_vars[7] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__new(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Extension < 0) {
      BASIC_TYPE_ID_TestCase__Extension = env->get_basic_type_id(env, "TestCase::Extension");
      if (BASIC_TYPE_ID_TestCase__Extension < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Extension");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Extension;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__ref_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_BYTE
  byte_vars[0] = 0;
L2: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[2];
L5: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L7: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[1];
L8: // PUSH_ARG_BYTE
  *(int8_t*)&stack[1] = byte_vars[2];
L9: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L10: // CALL_SUB_BYTE
  // TestCase::Extension->ref_byte_sum
  {
    if (SUB_ID_TestCase__Extension__ref_byte_sum < 0) {
      SUB_ID_TestCase__Extension__ref_byte_sum = env->get_sub_id(env, "TestCase::Extension", "ref_byte_sum", "byte(byte,byte,&byte)");
      if (SUB_ID_TestCase__Extension__ref_byte_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension ref_byte_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__ref_byte_sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L12: // GET_DEREF_BYTE
  byte_vars[1] = *(int8_t*)*(void**)&ref_vars[0];
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__ref_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_DOUBLE
  double_vars[0] = 0;
L2: // REF_DOUBLE
  *(void**)&ref_vars[0] = &double_vars[0];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 337;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[1];
L7: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[2];
L8: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L9: // CALL_SUB_DOUBLE
  // TestCase::Extension->ref_double_sum
  {
    if (SUB_ID_TestCase__Extension__ref_double_sum < 0) {
      SUB_ID_TestCase__Extension__ref_double_sum = env->get_sub_id(env, "TestCase::Extension", "ref_double_sum", "double(double,double,&double)");
      if (SUB_ID_TestCase__Extension__ref_double_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension ref_double_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__ref_double_sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 337;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L11: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[0];
L12: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L14: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.25;
L15: // ADD_DOUBLE
  double_vars[4] = double_vars[2] + double_vars[3];
L16: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__ref_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  float float_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_FLOAT
  float_vars[0] = 0;
L2: // REF_FLOAT
  *(void**)&ref_vars[0] = &float_vars[0];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[1];
L7: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[2];
L8: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L9: // CALL_SUB_FLOAT
  // TestCase::Extension->ref_float_sum
  {
    if (SUB_ID_TestCase__Extension__ref_float_sum < 0) {
      SUB_ID_TestCase__Extension__ref_float_sum = env->get_sub_id(env, "TestCase::Extension", "ref_float_sum", "float(float,float,&float)");
      if (SUB_ID_TestCase__Extension__ref_float_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension ref_float_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__ref_float_sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L11: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[0];
L12: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 325;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L14: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.25;
L15: // ADD_FLOAT
  float_vars[4] = float_vars[2] + float_vars[3];
L16: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__ref_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L4: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L8: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L9: // CALL_SUB_INT
  // TestCase::Extension->ref_int_sum
  {
    if (SUB_ID_TestCase__Extension__ref_int_sum < 0) {
      SUB_ID_TestCase__Extension__ref_int_sum = env->get_sub_id(env, "TestCase::Extension", "ref_int_sum", "int(int,int,&int)");
      if (SUB_ID_TestCase__Extension__ref_int_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension ref_int_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__ref_int_sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L11: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[0];
L12: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L16: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__ref_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_LONG
  long_vars[0] = 0;
L2: // REF_LONG
  *(void**)&ref_vars[0] = &long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L7: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[1];
L8: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[2];
L9: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L10: // CALL_SUB_LONG
  // TestCase::Extension->ref_long_sum
  {
    if (SUB_ID_TestCase__Extension__ref_long_sum < 0) {
      SUB_ID_TestCase__Extension__ref_long_sum = env->get_sub_id(env, "TestCase::Extension", "ref_long_sum", "long(long,long,&long)");
      if (SUB_ID_TestCase__Extension__ref_long_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension ref_long_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__ref_long_sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L12: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[0];
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 311;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L17: // ADD_LONG
  long_vars[4] = long_vars[2] + long_vars[3];
L18: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[4]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__ref_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_SHORT
  short_vars[0] = 0;
L2: // REF_SHORT
  *(void**)&ref_vars[0] = &short_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[2];
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L7: // PUSH_ARG_SHORT
  *(int16_t*)&stack[0] = short_vars[1];
L8: // PUSH_ARG_SHORT
  *(int16_t*)&stack[1] = short_vars[2];
L9: // PUSH_ARG_REF
  *(void**)&stack[2] = ref_vars[0];
L10: // CALL_SUB_SHORT
  // TestCase::Extension->ref_short_sum
  {
    if (SUB_ID_TestCase__Extension__ref_short_sum < 0) {
      SUB_ID_TestCase__Extension__ref_short_sum = env->get_sub_id(env, "TestCase::Extension", "ref_short_sum", "short(short,short,&short)");
      if (SUB_ID_TestCase__Extension__ref_short_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension ref_short_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__ref_short_sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L12: // GET_DEREF_SHORT
  short_vars[1] = *(int16_t*)*(void**)&ref_vars[0];
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "ref_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->native_set_field_byte
  {
    if (SUB_ID_TestCase__Extension__native_set_field_byte < 0) {
      SUB_ID_TestCase__Extension__native_set_field_byte = env->get_sub_id(env, "TestCase::Extension", "native_set_field_byte", "void(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_byte < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_byte;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L10: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 412;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->native_set_field_double
  {
    if (SUB_ID_TestCase__Extension__native_set_field_double < 0) {
      SUB_ID_TestCase__Extension__native_set_field_double = env->get_sub_id(env, "TestCase::Extension", "native_set_field_double", "void(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_double < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_double;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->native_set_field_float
  {
    if (SUB_ID_TestCase__Extension__native_set_field_float < 0) {
      SUB_ID_TestCase__Extension__native_set_field_float = env->get_sub_id(env, "TestCase::Extension", "native_set_field_float", "void(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_float < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_float;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->native_set_field_int
  {
    if (SUB_ID_TestCase__Extension__native_set_field_int < 0) {
      SUB_ID_TestCase__Extension__native_set_field_int = env->get_sub_id(env, "TestCase::Extension", "native_set_field_int", "void(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_int < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_int;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 375;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 386;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->native_set_field_long
  {
    if (SUB_ID_TestCase__Extension__native_set_field_long < 0) {
      SUB_ID_TestCase__Extension__native_set_field_long = env->get_sub_id(env, "TestCase::Extension", "native_set_field_long", "void(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_long < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_long;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_INT
  // TestCase::Extension->native_set_field_object
  {
    if (SUB_ID_TestCase__Extension__native_set_field_object < 0) {
      SUB_ID_TestCase__Extension__native_set_field_object = env->get_sub_id(env, "TestCase::Extension", "native_set_field_object", "int(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_object < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_object;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__object_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__object_value = env->get_field_id(env, "TestCase::Simple", "object_value", "TestCase::Minimal");
      if (FIELD_ID_TestCase__Simple__object_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple object_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__object_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__object_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(SPVM_VALUE_object*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__object_value);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 429;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 429;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_field_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->native_set_field_short
  {
    if (SUB_ID_TestCase__Extension__native_set_field_short < 0) {
      SUB_ID_TestCase__Extension__native_set_field_short = env->get_sub_id(env, "TestCase::Extension", "native_set_field_short", "void(TestCase::Simple)");
      if (SUB_ID_TestCase__Extension__native_set_field_short < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension native_set_field_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__native_set_field_short;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 364;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L10: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_field_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 364;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_byte_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_byte_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_byte_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_byte_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_byte_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_byte_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_byte_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L7: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__BYTE_VALUE];
  }
L8: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L9: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_byte";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L11: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_double_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_double_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_double_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_double_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_double_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_double_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_double_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L7: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__DOUBLE_VALUE];
  }
L8: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_double";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L10: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_float_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_float_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_float_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_float_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_float_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_float_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_float_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L7: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__FLOAT_VALUE];
  }
L8: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_float";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L10: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_int_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_int_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_int_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_int_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_int_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_int_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_int_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L7: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__INT_VALUE];
  }
L8: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_int";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L10: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_long_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_long_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_long_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_long_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_long_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_long_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_long_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L7: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__LONG_VALUE];
  }
L8: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_long";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L10: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L20;
L18: // INIT_INT
  int_vars[6] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 207;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_object_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_object_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_object_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_object_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_object_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_object_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_object_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_object";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // GET_PACKAGE_VAR_OBJECT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$MINIMAL_VALUE", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $MINIMAL_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], *(void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE]);
  }
L9: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // SET_PACKAGE_VAR_UNDEF
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$MINIMAL_VALUE", "TestCase::Minimal");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $MINIMAL_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__MINIMAL_VALUE], NULL);
  }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__set_package_var_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Extension->new
  {
    if (SUB_ID_TestCase__Extension__new < 0) {
      SUB_ID_TestCase__Extension__new = env->get_sub_id(env, "TestCase::Extension", "new", "TestCase::Extension()");
      if (SUB_ID_TestCase__Extension__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__new;
    exception_flag = SPPRECOMPILE__TestCase__Extension__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 142;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_VOID
  // TestCase::Extension->set_package_var_short_test
  {
    if (SUB_ID_TestCase__Extension__set_package_var_short_test < 0) {
      SUB_ID_TestCase__Extension__set_package_var_short_test = env->get_sub_id(env, "TestCase::Extension", "set_package_var_short_test", "void(TestCase::Extension)");
      if (SUB_ID_TestCase__Extension__set_package_var_short_test < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension set_package_var_short_test");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__set_package_var_short_test;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L7: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Extension", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Extension $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Extension__SHORT_VALUE];
  }
L8: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L9: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "set_package_var_short";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L11: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__spvm_extension(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L5: // CALL_SUB_INT
  // TestCase::Extension->sum
  {
    if (SUB_ID_TestCase__Extension__sum < 0) {
      SUB_ID_TestCase__Extension__sum = env->get_sub_id(env, "TestCase::Extension", "sum", "int(int,int)");
      if (SUB_ID_TestCase__Extension__sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__sum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L18;
L16: // INIT_INT
  int_vars[7] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Extension__spvm_extension_add_iarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(SPVM_VALUE_int*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L14: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L15: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L22: // NEW_INT_ARRAY
  {
    int32_t length = *(SPVM_VALUE_int*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 6;
L33: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L34: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L37: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L42: // CALL_SUB_OBJECT
  // TestCase::Extension->add_iarray
  {
    if (SUB_ID_TestCase__Extension__add_iarray < 0) {
      SUB_ID_TestCase__Extension__add_iarray = env->get_sub_id(env, "TestCase::Extension", "add_iarray", "int[](int[],int[])");
      if (SUB_ID_TestCase__Extension__add_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Extension add_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Extension__add_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 512;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L48: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L55: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L59: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Extension";
    const char* sub_name = "spvm_extension_add_iarray";
    const char* file = "TestCase/Extension.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 9;
L62: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L67: // GOTO
  goto L68;
L68: // GOTO
  goto L69;
L69: // GOTO
  goto L70;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L74;
L72: // INIT_INT
  int_vars[6] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L74;
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


