#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_byte_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_double_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_double_double_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_float_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_int_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_long_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Add__add_long_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Add__add_long_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_short_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_short_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Add__add_zero_minus(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Add__add(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L4: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L9: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[6];
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L12: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L13: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L14: // ADD_INT
  int_vars[8] = int_vars[3] + int_vars[6];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L17: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L19: // ADD_INT
  int_vars[9] = int_vars[4] + int_vars[6];
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L22: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L23: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L24: // ADD_INT
  int_vars[10] = int_vars[3] + int_vars[6];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L27: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 7;
L29: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L30: // CONVERT_BYTE_TO_INT
  int_vars[11] = (int32_t)byte_vars[1];
L31: // ADD_INT
  int_vars[12] = int_vars[4] + int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L34: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 8;
L36: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L37: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[1];
L38: // ADD_INT
  int_vars[13] = int_vars[4] + int_vars[11];
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L43: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L44: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[0];
L45: // ADD_INT
  int_vars[14] = int_vars[4] + int_vars[11];
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L47: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L51: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[3]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L55: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L59: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[3]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 7;
L63: // EQ_INT
  int_vars[0] = (int_vars[10] == int_vars[3]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L67: // EQ_INT
  int_vars[0] = (int_vars[12] == int_vars[3]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L71: // EQ_INT
  int_vars[0] = (int_vars[13] == int_vars[3]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L75: // EQ_INT
  int_vars[0] = (int_vars[14] == int_vars[3]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L78: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L79: // GOTO
  goto L80;
L80: // GOTO
  goto L81;
L81: // GOTO
  goto L82;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // GOTO
  goto L87;
L87: // BOOL_INT
  int_vars[0] = int_vars[1];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L94;
L91: // GOTO
  goto L92;
L92: // INIT_INT
  int_vars[5] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L94;
L94: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 126;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 253;
L9: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[4];
L17: // MOVE_INT
  int_vars[0] = int_vars[0];
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[7] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_byte_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_double_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L3: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.75;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_double_double_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2147483647.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L3: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2147483647.75;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_float_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L3: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.75;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L4: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L5: // ADD_INT
  int_vars[4] = int_vars[1] + int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L4: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.25;
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L4: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.25;
L6: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2147483646;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 2147483647;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[5];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = INT32_MIN;
L20: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L21: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L22: // MOVE_CONSTANT_INT
  int_vars[2] = -2147483647;
L23: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L33;
L31: // INIT_INT
  int_vars[8] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2147483646;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = INT32_MIN;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_int_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L4: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L5: // ADD_INT
  int_vars[4] = int_vars[1] + int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_long_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 9223372036854775806LL;
L2: // MOVE_CONSTANT_LONG
  long_vars[1] = 1LL;
L3: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = 9223372036854775807LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_LONG
  long_vars[0] = INT64_MIN;
L20: // MOVE_CONSTANT_LONG
  long_vars[1] = 1LL;
L21: // ADD_LONG
  long_vars[3] = long_vars[0] + long_vars[1];
L22: // MOVE_CONSTANT_LONG
  long_vars[0] = -9223372036854775807LL;
L23: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_long_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[5];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 9223372036854775806LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[1];
L5: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  goto L9;
L7: // INIT_LONG
  long_vars[4] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_long_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[5];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = INT64_MIN;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[1];
L5: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  goto L9;
L7: // INIT_LONG
  long_vars[4] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 12;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // SUBTRACT_INT
  int_vars[3] = int_vars[1] - int_vars[2];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L5: // MOVE_CONSTANT_INT
  int_vars[4] = -3;
L6: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L7: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L15: // INIT_INT
  int_vars[8] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_short_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_short_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32766;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 65533;
L9: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[4];
L17: // MOVE_INT
  int_vars[0] = int_vars[0];
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[7] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Add__add_zero_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // SUBTRACT_INT
  int_vars[3] = int_vars[1] - int_vars[2];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L13: // INIT_INT
  int_vars[8] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


