#! perl

use strict;
use warnings;
use Carp;

package Data::iRealPro::URI;

our $VERSION = "0.01";

use Data::iRealPro::Playlist;
use Encode qw(decode_utf8 encode_utf8);

sub new {
    my ( $pkg, %args ) = @_;
    my $self = bless { %args }, $pkg;
    $self->parse( $args{data} ) if $args{data};
    return $self;
}

sub parse {
    my ( $self, $data ) = @_;

    # Un-URI-escape and decode.
    $data =~ s/[\r\n]*//g;
    $data =~ s/%([0-9a-f]{2})/sprintf("%c",hex($1))/gie;
    $data = decode_utf8($data);

    $data =~ s;^.+(irealb(?:ook)?://.*?)(?:$|\").*;$1;s;
    $self->{data} = $data if $self->{debug};

    if ( $data =~ m;^irealb(ook)?://; ) {
	$self->{variant} = $1 ? "irealbook" : "irealpro";
    }
    else {
	Carp::croak("Invalid input: ", substr($data, 0, 40) );
    }

    $self->{playlist} =
      Data::iRealPro::Playlist->new( variant => $self->{variant},
				      data    => $data,
				      debug   => $self->{debug},
				    );

    return $self;
}

sub export {
    my ( $self, %args ) = @_;

    my $v = $args{variant} || $self->{variant};
    $args{uriencode} //= !$args{plain};
    my $r = encode_utf8( $self->{playlist}->export( %args ) );

    if ( $args{html} || $args{uriencode} || !defined( $args{uriencode} ) ) {
	$r =~ s/([^-_."A-Z0-9a-z*\/\'])/sprintf("%%%02X", ord($1))/ge;
    }

    my $uri = $v eq "irealbook" ? "$v://$r" : "irealb://$r";

    if ( $args{html}) {
	my $title = $self->{playlist}->{songs}->[0]->{title};
	return <<EOD;
<!DOCTYPE html>
<html>
  <head>
  <title>$title</title>
</head>
<body>
  <h1>$title</h1>
  <p><a href="$uri">$title</a></p>
  <p><font size="-1">Generated by Data::iRealPro::URI version $Data::iRealPro::URI::VERSION.</font></p>
</body>
</html>
EOD
    }

    return $uri;
}

package main;

unless ( caller ) {
    require Data::Dumper;
    my $d = Data::iRealPro::URI->new( debug => 0 );
    my $data = do { local $/; <> };
    $d->parse($data);
#    warn Data::Dumper::Dumper($d);
    print $d->export( html => 1 );
}

1;
