#!/usr/bin/perl -w

use strict;

require 5.006 ;

use ExtUtils::MakeMaker ;
use ExtUtils::Embed ;

use Config ;
use File::Copy ;

BEGIN
{
    eval { require File::Spec::Functions ; File::Spec::Functions->import() } ;
    if ($@)
    {
        *catfile = sub { return "$_[0]/$_[1]" }
    }
}

########
# NAME #
########

my $NAME = 'PLJava' ;
my $VERSION = '0.01' ;
my $JAVA_PACKAGE = 'perl5' ;

#########
# FILES #
#########

my $C_FILES = "$NAME.c ${NAME}_wrap.c" ;
my $O_FILES = "$NAME.obj ${NAME}_wrap.obj" ;
my $INTERFACE = "$NAME.i" ;
my $CLEAN_FILES = "PLJava.dll" ;

my $CLEAN_SWIG_FILES = "$NAME.java ${NAME}_wrap.c ${NAME}JNI.java" ;

my $JAVA_FILES = '' ;

#opendir (DIRLOG, '.');
#while (my $filename = readdir DIRLOG) { $JAVA_FILES .= " $filename" if $filename =~ /\.java$/ ;}
#closedir (DIRLOG);

########
# VARS #
########

my $debug = 0;

my $dll = ".$Config{so}" ;
my $o = $Config{_o};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld};
my $cc = $Config{cc};

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv );

my $is_MSVC = $cc =~ m/^cl/;
if( $is_MSVC ) {
  $out = '-out:';
  $ccdebug = $debug ? '-Zi ' : '';
  $lddebug = $debug ? '-debug ' : '-release ';
  $warn = '-W3';
} else {
  $out = '-o ';
  $ccdebug = $debug ? '-g ' : '';
  $lddebug = $debug ? '' : '-s ';
  $warn = '-Wall -Wno-comments ';
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

my $rm_dll = "-\$(RM) *$dll" if $dll ;

#################
# WRITEMAKEFILE #
#################

print "Writing Makefile for $NAME\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

PERL=$^X

RM=$rm
MV=$mv

RM_RF = \$(PERL) -MExtUtils::Command -e rm_rf

LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags

INC = -I"$ENV{JAVA_INCLUDE}" -I"$ENV{JAVA_INCLUDE}/win32"

C_FILES = $C_FILES
O_FILES = $O_FILES
INTERFACE = $INTERFACE

OBJECTS=  \$(O_FILES)


DISTNAME = $NAME
VERSION = $VERSION
SUFFIX = .gz

DISTVNAME = \$(DISTNAME)-\$(VERSION)

.c$o:
	\$(CC) -c \$(INC) \$(CFLAGS) \$<

all: $NAME$dll built

clean: cleanbuilt cleanjavaclass
	-\$(RM) *$o *.exp *.lib
	-\$(RM) *.opt *.pdb *.class
	-\$(RM) $CLEAN_FILES
	\$(MV) Makefile Makefile.old

cleanswig:
	-\$(RM) $CLEAN_SWIG_FILES

realclean: clean
	-\$(RM) $NAME$dll
	-\$(RM) Makefile Makefile.old

cleanjavaclass :
	\$(RM_RF) $JAVA_PACKAGE
	-\$(RM) *.class

javaclass:
	javac -d ./ $JAVA_FILES *.java

swig: cleanswig
	swig -java -package $JAVA_PACKAGE \$(INTERFACE)

$NAME$dll: \$(OBJECTS) javaclass
	\$(LD) \$(OBJECTS) \$(LDFLAGS) -dll $out\$@

test:
	java test


dist : \$(DISTVNAME).tar\$(SUFFIX)


\$(DISTVNAME).tar\$(SUFFIX) : distdir
	tar cvf \$(DISTVNAME).tar \$(DISTVNAME)
	\$(RM_RF) \$(DISTVNAME)
	gzip --best \$(DISTVNAME).tar


distdir :
	\$(RM_RF) \$(DISTVNAME)
	\$(PERL) -MExtUtils::Manifest=manicopy,maniread -e "manicopy(maniread(),'\$(DISTVNAME)');"


cleanbuilt :
	\$(RM_RF) built


built : cleanbuilt
	\$(PERL) -MExtUtils::Manifest=manicopy,maniread -e "manicopy( { '\$(DISTNAME)$dll' => '' , \%{ maniread('MANIFEST-BUILT') } } ,'built');"


.SUFFIXES: $o

EOT




