#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Type1',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalanceD100',
    'Image::ExifTool::Nikon::ColorBalanceD2H',
    'Image::ExifTool::Nikon::ColorBalanceD70',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 34 => 0x2a },
    'addoriginaldecisiondata' => { 13 => 0x11 },
    'adjustmentmode' => { 62 => 0x15 },
    'advisory' => { 65 => 'Advisory' },
    'aebbracketvalue' => { 8 => 0x11 },
    'aebsequence' => { 10 => 0x7, 11 => 0x9, 12 => 0x9, 13 => 0x8 },
    'afassist' => { 10 => 0x5, 11 => 0x5 },
    'afassistbeam' => { 13 => 0x4 },
    'afmode' => { 62 => 0x5 },
    'afpoint' => { 0 => 0x13, 52 => 0x88 },
    'afpointactivationarea' => { 12 => 0x11 },
    'afpointillumination' => { 12 => 0xa },
    'afpointregistration' => { 11 => 0x7 },
    'afpointselection' => { 12 => 0xb },
    'afpointselectionmethod' => { 13 => 0xc },
    'afpointspotmetering' => { 12 => 0xd },
    'afpointsused' => { 6 => 0x16 },
    'aiservotrackingsensitivity' => { 12 => 0x14 },
    'aliaslayermetadata' => { 24 => 0xc660 },
    'alphachannelsnames' => { 59 => 0x3ee },
    'analogbalance' => { 24 => 0xc627 },
    'annotations' => { 24 => 0xc44f },
    'antialiasstrength' => { 24 => 0xc632 },
    'aperture' => { 66 => 'Aperture' },
    'aperturevalue' => { 24 => 0x9202, 65 => 'ApertureValue' },
    'applicationnotes' => { 24 => 0x2bc },
    'applicationrecordversion' => { 34 => 0x0 },
    'armidentifier' => { 35 => 0x78 },
    'armversion' => { 35 => 0x7a },
    'artist' => { 24 => 0x13b, 65 => 'Artist' },
    'asshotneutral' => { 24 => 0xc628 },
    'asshotwhitexy' => { 24 => 0xc629 },
    'assistbuttonfunction' => { 11 => 0xd },
    'association' => { 44 => 'asoc' },
    'atob0' => { 31 => 'A2B0' },
    'atob1' => { 31 => 'A2B1' },
    'atob2' => { 31 => 'A2B2' },
    'audio' => { 56 => 0x20 },
    'audioduration' => { 34 => 0x99 },
    'audiooutcue' => { 34 => 0x9a },
    'audiosamplingrate' => { 34 => 0x97 },
    'audiosamplingresolution' => { 34 => 0x98 },
    'audiotype' => { 34 => 0x96 },
    'author' => { 65 => 'Author' },
    'authorsposition' => { 65 => 'AuthorsPosition' },
    'autobracket' => { 62 => 0x19 },
    'autobracketing' => { 25 => 0x1100 },
    'autoexposurebracketing' => { 8 => 0x10 },
    'autorotate' => { 8 => 0x1b },
    'auxiliarylens' => { 52 => 0x82 },
    'avvalue' => { 14 => 0x2 },
    'backgroundcolorindicator' => { 24 => 0x84e8 },
    'backgroundcolorvalue' => { 24 => 0x84ea },
    'badfaxlines' => { 24 => 0x146 },
    'baseiso' => { 18 => 0x101c },
    'baselineexposure' => { 24 => 0xc62a },
    'baselinenoise' => { 24 => 0xc62b },
    'baselinesharpness' => { 24 => 0xc62c },
    'baseurl' => { 65 => 'BaseURL' },
    'batterylevel' => { 24 => 0x828f },
    'bayergreensplit' => { 24 => 0xc62d },
    'bestqualityscale' => { 24 => 0xc65c },
    'bestshotmode' => { 23 => 0x3007 },
    'binaryfilter' => { 44 => 'bfil' },
    'bitspercomponent' => { 37 => 0x87, 43 => 0xa, 44 => 'bpcc' },
    'bitsperextendedrunlength' => { 24 => 0x84e5 },
    'bitsperrunlength' => { 24 => 0x84e4 },
    'bitspersample' => { 24 => 0x102, 65 => 'BitsPerSample' },
    'blacklevel' => { 24 => 0xc61a },
    'blackleveldeltah' => { 24 => 0xc61b },
    'blackleveldeltav' => { 24 => 0xc61c },
    'blacklevelrepeatdim' => { 24 => 0xc619 },
    'bluebalance' => { 49 => 0x1, 50 => 0x1, 51 => 0x1, 55 => 0x1018 },
    'bluebalanceauto' => { 9 => 0x1 },
    'bluebalanceb&w' => { 9 => 0xf },
    'bluebalancecloudy' => { 9 => 0x5 },
    'bluebalancecustom' => { 9 => 0xd },
    'bluebalancedaylight' => { 9 => 0x3 },
    'bluebalanceflash' => { 9 => 0xb },
    'bluebalancefluorescent' => { 9 => 0x9 },
    'bluebalanceshade' => { 9 => 0x11 },
    'bluebalancetungsten' => { 9 => 0x7 },
    'bluehue' => { 65 => 'BlueHue' },
    'bluematrixcolumn' => { 31 => 'bXYZ' },
    'bluesaturation' => { 65 => 'BlueSaturation' },
    'bluetrc' => { 31 => 'bTRC' },
    'blurwarning' => { 25 => 0x1300 },
    'borderid' => { 45 => 0x2 },
    'borderlocation' => { 45 => 0x3 },
    'bordername' => { 45 => 0x1 },
    'bordersversion' => { 45 => 0x0 },
    'bordertype' => { 45 => 0x4 },
    'bracketstep' => { 47 => 0xe },
    'brightness' => { 24 => 0xfe53, 47 => 0x2c, 65 => 'Brightness' },
    'brightnessvalue' => { 24 => 0x9203, 65 => 'BrightnessValue' },
    'btoa0' => { 31 => 'B2A0' },
    'btoa1' => { 31 => 'B2A1' },
    'btoa2' => { 31 => 'B2A2' },
    'bulbduration' => { 8 => 0x18 },
    'bwfilter' => { 47 => 0x2a },
    'by-line' => { 34 => 0x50 },
    'by-linetitle' => { 34 => 0x55 },
    'calibrationdatetime' => { 31 => 'calt' },
    'calibrationilluminant1' => { 24 => 0xc65a },
    'calibrationilluminant2' => { 24 => 0xc65b },
    'cameracalibration1' => { 24 => 0xc623 },
    'cameracalibration2' => { 24 => 0xc624 },
    'cameraid' => { 55 => 0x209, 61 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'cameraobject' => { 18 => 0x2807 },
    'cameraowner' => { 24 => 0xc353 },
    'cameraspecification' => { 18 => 0x3004 },
    'canoncamerasettings' => { 5 => 0x1, 18 => 0x102d },
    'canoncolorinfo' => { 5 => 0xa0 },
    'canoncolorinfo1' => { 18 => 0x32 },
    'canoncolorinfo2' => { 18 => 0x102c },
    'canoncolorinfod30' => { 5 => 0xa },
    'canoncustomfunctions' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions10d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions1d' => { 5 => 0x90 },
    'canoncustomfunctions20d' => { 5 => 0xf, 18 => 0x1033 },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 18 => 0x805 },
    'canonfileinfo' => { 5 => 0x93 },
    'canonfilelength' => { 5 => 0xe },
    'canonfirmwareversion' => { 5 => 0x7, 18 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonfocallength' => { 5 => 0x2, 18 => 0x1029 },
    'canonimageheight' => { 6 => 0x3 },
    'canonimageheightasshot' => { 6 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 5 => 0x6, 18 => 0x815 },
    'canonimagewidth' => { 6 => 0x2 },
    'canonimagewidthasshot' => { 6 => 0x4 },
    'canonpictureinfo' => { 5 => 0x12, 18 => 0x1038 },
    'canonrawmakemodel' => { 18 => 0x80a },
    'canonshotinfo' => { 5 => 0x4, 18 => 0x102a },
    'caption-abstract' => { 34 => 0x78 },
    'captionwriter' => { 65 => 'CaptionWriter' },
    'captureconditionspar' => { 24 => 0xc352 },
    'capturedevicefid' => { 24 => 0xc357 },
    'captureresolution' => { 44 => 'resc' },
    'capturexresolution' => { 41 => 0x4 },
    'capturexresolutionunit' => { 41 => 0x9 },
    'captureyresolution' => { 41 => 0x0 },
    'captureyresolutionunit' => { 41 => 0x8 },
    'casioimagesize' => { 23 => 0x9 },
    'casiopreviewlength' => { 23 => 0x3 },
    'casiopreviewstart' => { 23 => 0x4 },
    'category' => { 34 => 0xf, 65 => 'Category' },
    'ccdisosensitivity' => { 23 => 0x3014 },
    'ccdsensitivity' => { 22 => 0x14 },
    'celllength' => { 24 => 0x109 },
    'cellwidth' => { 24 => 0x108 },
    'certificate' => { 65 => 'Certificate' },
    'cfalayout' => { 24 => 0xc617 },
    'cfapattern' => { 24 => 0xa302, 65 => 'CFAPattern' },
    'cfapattern2' => { 24 => 0x828e },
    'cfapatterncolumns' => { 65 => 'CFAPatternColumns' },
    'cfapatternrows' => { 65 => 'CFAPatternRows' },
    'cfapatternvalues' => { 65 => 'CFAPatternValues' },
    'cfaplanecolor' => { 24 => 0xc616 },
    'cfarepeatpatterndim' => { 24 => 0x828d },
    'chartarget' => { 31 => 'targ' },
    'chromablurradius' => { 24 => 0xc631 },
    'chromaticaberrationb' => { 65 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 65 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 31 => 'chad' },
    'chromaticity' => { 31 => 'chrm' },
    'chromaticitychannel1' => { 28 => 0xc },
    'chromaticitychannel2' => { 28 => 0x14 },
    'chromaticitychannel3' => { 28 => 0x1c },
    'chromaticitychannel4' => { 28 => 0x24 },
    'chromaticitychannels' => { 28 => 0x8 },
    'chromaticitycolorant' => { 28 => 0xa },
    'city' => { 34 => 0x5a, 65 => 'City' },
    'cleanfaxdata' => { 24 => 0x147 },
    'clippath' => { 24 => 0x157 },
    'cmmflags' => { 30 => 0x2c },
    'codedcharacterset' => { 35 => 0x5a },
    'codestreamheader' => { 44 => 'jpch' },
    'codestreamregistration' => { 44 => 'creg' },
    'codingmethods' => { 24 => 0x193 },
    'coloradjustment' => { 62 => 0x14 },
    'coloradjustmentmode' => { 61 => 0x210 },
    'colorant1coordinates' => { 29 => 0x2c },
    'colorant1name' => { 29 => 0xc },
    'colorant2coordinates' => { 29 => 0x52 },
    'colorant2name' => { 29 => 0x32 },
    'colorant3coordinates' => { 29 => 0x78 },
    'colorant3name' => { 29 => 0x58 },
    'colorantcount' => { 29 => 0x8 },
    'colorantorder' => { 31 => 'clro' },
    'coloranttable' => { 31 => 'clrt' },
    'colorbalance1' => { 52 => 0xc },
    'colorbalanceblue' => { 47 => 0x1e },
    'colorbalanced100' => { 52 => 0x97 },
    'colorbalanced2h' => { 52 => 0x97 },
    'colorbalanced70' => { 52 => 0x97 },
    'colorbalancegreen' => { 47 => 0x1d },
    'colorbalancered' => { 47 => 0x1c },
    'colorbalanceunknown' => { 52 => 0x97 },
    'colorbitdepth' => { 17 => 0x5 },
    'colorbw' => { 17 => 0x6 },
    'colorcalibrationmatrix' => { 37 => 0x46 },
    'colorcharacterization' => { 24 => 0x84ed },
    'coloreffect' => { 56 => 0x28 },
    'colorfilter' => { 47 => 0x29 },
    'colorgroup' => { 44 => 'cgrp' },
    'colorhue' => { 52 => 0x8d },
    'colormap' => { 24 => 0x140 },
    'colormatrix' => { 2 => 0xa },
    'colormatrix1' => { 24 => 0xc621 },
    'colormatrix2' => { 24 => 0xc622 },
    'colormode' => { 23 => 0x3015, 47 => 0x28, 48 => 0x101, 52 => 0x3 },
    'colornoisereduction' => { 65 => 'ColorNoiseReduction' },
    'colorpalette' => { 37 => 0x55 },
    'colorrepresentation' => { 37 => 0x3c },
    'colorresponseunit' => { 24 => 0x12c },
    'colorsequence' => { 24 => 0x84e1, 37 => 0x41 },
    'colorspace' => { 18 => 0x10b4, 24 => 0xa001, 62 => 0xb, 65 => 'ColorSpace' },
    'colorspacedata' => { 30 => 0x10 },
    'colorspecification' => { 44 => 'colr' },
    'colortable' => { 24 => 0x84e6 },
    'colortemperature' => { 1 => 0x9, 2 => 0x9, 5 => 0xae, 18 => 0x10ae },
    'colortone' => { 0 => 0x2a },
    'comment' => { 67 => 'Comment' },
    'componentbitdepth' => { 17 => 0x4 },
    'componentdefinition' => { 44 => 'cdef' },
    'componentmapping' => { 44 => 'cmap' },
    'componentsconfiguration' => { 24 => 0x9101, 65 => 'ComponentsConfiguration' },
    'componentversion' => { 18 => 0x80c },
    'compositinglayerheader' => { 44 => 'jplh' },
    'composition' => { 44 => 'comp' },
    'compositionoptions' => { 44 => 'copt' },
    'compressedbitsperpixel' => { 24 => 0x9102, 65 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 48 => 0x40 },
    'compression' => { 24 => 0x103, 43 => 0xb, 54 => 0x103, 65 => 'Compression' },
    'conditionalfec' => { 66 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 39 => 0xa },
    'consecutivebadfaxlines' => { 24 => 0x148 },
    'contact' => { 34 => 0x76 },
    'contentlocationcode' => { 34 => 0x1a },
    'contentlocationname' => { 34 => 0x1b },
    'contiguouscodestream' => { 44 => 'jp2c' },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 22 => 0xc, 23 => 0x20, 24 => [0xa408,0xfe54], 25 => 0x1004, 47 => 0x20, 56 => 0x2c, 57 => 0x20, 62 => 0xd, 65 => 'Contrast' },
    'contributor' => { 65 => 'Contributor' },
    'converter' => { 24 => 0xfe4d },
    'copyright' => { 24 => 0x8298, 31 => 'cprt', 65 => 'Copyright' },
    'copyrightnotice' => { 34 => 0x74 },
    'country' => { 65 => 'Country' },
    'country-primarylocationcode' => { 34 => 0x64 },
    'country-primarylocationname' => { 34 => 0x65 },
    'coverage' => { 65 => 'Coverage' },
    'crdinfo' => { 31 => 'crdi' },
    'createdate' => { 24 => 0x9004, 65 => 'CreateDate' },
    'creationdate' => { 65 => 'CreationDate' },
    'creator' => { 65 => 'Creator' },
    'creatortool' => { 65 => 'CreatorTool' },
    'credit' => { 34 => 0x6e, 65 => 'Credit' },
    'cross-reference' => { 44 => 'cref' },
    'customrendered' => { 24 => 0xa401, 65 => 'CustomRendered' },
    'datacompressionmethod' => { 37 => 0x6e },
    'datadump' => { 52 => 0x10, 55 => 0xf00, 56 => 0x21, 61 => 0xf00 },
    'datareference' => { 44 => 'dtbl' },
    'datatype' => { 24 => 0x80e4 },
    'date' => { 65 => 'Date' },
    'datecreated' => { 34 => 0x37, 65 => 'DateCreated' },
    'datesent' => { 35 => 0x46 },
    'datetime' => { 65 => 'DateTime' },
    'datetimecreated' => { 66 => 'DateTimeCreated' },
    'datetimedigitized' => { 65 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 21 => 0x0, 24 => 0x9003, 65 => 'DateTimeOriginal', 66 => 'DateTimeOriginal' },
    'dealeridnumber' => { 24 => 0xc356 },
    'decode' => { 24 => 0x1b1 },
    'decodertable' => { 18 => 0x1835 },
    'decposition' => { 47 => 0x32 },
    'defaultcroporigin' => { 24 => 0xc61f },
    'defaultcropsize' => { 24 => 0xc620 },
    'defaultimagecolor' => { 24 => 0x1b2 },
    'defaultscale' => { 24 => 0xc61e },
    'derivedfrom' => { 65 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 65 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 65 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 65 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 65 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 65 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 65 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 65 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 65 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 65 => 'DerivedFromVersionID' },
    'description' => { 65 => 'Description' },
    'desiredreproductions' => { 44 => 'drep' },
    'destination' => { 35 => 0x5 },
    'deviceattributes' => { 30 => 0x38 },
    'devicemanufacturer' => { 30 => 0x30 },
    'devicemfgdesc' => { 31 => 'dmnd' },
    'devicemodel' => { 30 => 0x34 },
    'devicemodeldesc' => { 31 => 'dmdd' },
    'devicesettingdescription' => { 24 => 0xa40b, 65 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 65 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 65 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 65 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 31 => 'devs' },
    'digitalcreationdate' => { 34 => 0x3e },
    'digitalcreationtime' => { 34 => 0x3f },
    'digitaleffectsname' => { 46 => 0x1 },
    'digitaleffectstype' => { 46 => 0x2 },
    'digitaleffectsversion' => { 46 => 0x0 },
    'digitalsignature' => { 44 => 'chck' },
    'digitalzoom' => { 0 => 0xc, 22 => 0xa, 47 => 0xc, 52 => 0x86, 55 => 0x204, 57 => 0x1e, 61 => 0x204 },
    'digitalzoomon' => { 61 => 0x21b },
    'digitalzoomratio' => { 24 => 0xa404, 65 => 'DigitalZoomRatio' },
    'displayresolution' => { 44 => 'resd' },
    'displayxresolution' => { 42 => 0x4 },
    'displayxresolutionunit' => { 42 => 0x9 },
    'displayyresolution' => { 42 => 0x0 },
    'displayyresolutionunit' => { 42 => 0x8 },
    'dngbackwardversion' => { 24 => 0xc613 },
    'dngcameraserialnumber' => { 24 => 0xc62f },
    'dnglensinfo' => { 24 => 0xc630 },
    'dngprivatedata' => { 24 => 0xc634 },
    'dngversion' => { 24 => 0xc612 },
    'documentid' => { 65 => 'DocumentID' },
    'documentname' => { 24 => 0x10d },
    'dotrange' => { 24 => 0x150 },
    'drivemode' => { 47 => 0x6, 62 => 0x3, 66 => 'DriveMode' },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 34 => 0x8 },
    'editstatus' => { 34 => 0x7 },
    'edittagarray' => { 24 => 0xc366 },
    'endpoints' => { 37 => 0x7d },
    'enhancement' => { 23 => 0x3016 },
    'envelopenumber' => { 24 => 0xc358, 35 => 0x28 },
    'envelopepriority' => { 35 => 0x3c },
    'enveloperecordversion' => { 35 => 0x0 },
    'epsonimageheight' => { 55 => 0x20c },
    'epsonimagewidth' => { 55 => 0x20b },
    'epsonsoftware' => { 55 => 0x20d },
    'error' => { 67 => 'Error' },
    'ettlii' => { 13 => 0xd },
    'excursiontolerance' => { 37 => 0x82 },
    'exifdata' => { 67 => 'ExifData' },
    'exifimageheight' => { 65 => 'PixelYDimension' },
    'exifimagelength' => { 24 => 0xa003 },
    'exifimagewidth' => { 24 => 0xa002, 65 => 'PixelXDimension' },
    'exifinformation' => { 18 => 0x300b },
    'exifoffset' => { 24 => 0x8769 },
    'exiftoolversion' => { 67 => 'ExifToolVersion' },
    'exifversion' => { 24 => 0x9000, 65 => 'ExifVersion' },
    'expirationdate' => { 34 => 0x25 },
    'expirationtime' => { 34 => 0x26 },
    'exposure' => { 24 => 0xfe51, 65 => 'Exposure' },
    'exposurebracketvalue' => { 52 => 0x19 },
    'exposurecompensation' => { 8 => 0x6, 14 => 0x0, 24 => 0x9204, 47 => 0xd, 62 => 0xc, 65 => 'ExposureBiasValue' },
    'exposureindex' => { 24 => [0x9215,0xa215], 65 => 'ExposureIndex' },
    'exposureinfo' => { 18 => 0x1818 },
    'exposurelevelincrements' => { 10 => 0x4, 11 => 0x6, 12 => 0x6, 13 => 0x5 },
    'exposuremode' => { 24 => 0xa402, 47 => 0x1, 62 => 0x8, 65 => 'ExposureMode' },
    'exposureprogram' => { 24 => 0x8822, 65 => 'ExposureProgram' },
    'exposuretime' => { 8 => 0x16, 24 => 0x829a, 65 => 'ExposureTime' },
    'exposurewarning' => { 25 => 0x1302 },
    'extrasamples' => { 24 => 0x152 },
    'faxprofile' => { 24 => 0x192 },
    'faxrecvparams' => { 24 => 0x885c },
    'faxrecvtime' => { 24 => 0x885e },
    'faxsubaddress' => { 24 => 0x885d },
    'fileformat' => { 16 => 0x0, 35 => 0x14 },
    'filename' => { 67 => 'FileName' },
    'filenumber' => { 3 => 0x1, 5 => 0x8, 18 => 0x1817 },
    'filenumbermemory' => { 47 => 0x1a },
    'filesize' => { 67 => 'FileSize' },
    'filesource' => { 24 => 0xa300, 65 => 'FileSource' },
    'filesystemversion' => { 52 => 0x1 },
    'filetype' => { 44 => 'ftyp', 67 => 'FileType' },
    'fileversion' => { 35 => 0x16 },
    'fillflashautoreduction' => { 10 => 0xa, 11 => 0xe, 12 => 0xe },
    'fillorder' => { 24 => 0x10a },
    'filmcategory' => { 24 => 0xc35a },
    'filmgencode' => { 24 => 0xc35b },
    'filmproductcode' => { 24 => 0xc350 },
    'filmsize' => { 24 => 0xc35d },
    'filter' => { 23 => 0x3017 },
    'finderdisplayduringexposure' => { 12 => 0x1 },
    'firmware' => { 62 => 0x17 },
    'firmwareversion' => { 56 => 0x2 },
    'fixtureidentifier' => { 34 => 0x16 },
    'flash' => { 24 => 0x9209, 65 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 56 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdistance' => { 23 => 0x2034 },
    'flashenergy' => { 24 => [0x920b,0xa20b], 65 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 52 => 0x18 },
    'flashexposurecomp' => { 8 => 0xf, 47 => 0x23, 52 => 0x12 },
    'flashfired' => { 47 => 0x14, 65 => 'FlashFired' },
    'flashfiring' => { 13 => 0x6 },
    'flashfunction' => { 65 => 'FlashFunction' },
    'flashguidenumber' => { 15 => 0x0 },
    'flashinfo' => { 18 => 0x1813 },
    'flashintensity' => { 22 => 0x5 },
    'flashmode' => { 22 => 0x4, 47 => 0x2, 52 => 0x87, 61 => 0x225, 65 => 'FlashMode' },
    'flashon' => { 66 => 'FlashOn' },
    'flashpixversion' => { 24 => 0xa000, 65 => 'FlashpixVersion' },
    'flashredeyemode' => { 65 => 'FlashRedEyeMode' },
    'flashreturn' => { 65 => 'FlashReturn' },
    'flashsetting' => { 52 => 0x8 },
    'flashstrength' => { 25 => 0x1011 },
    'flashsyncspeedav' => { 10 => 0x6, 11 => 0x3, 13 => 0x2 },
    'flashthreshold' => { 15 => 0x1 },
    'flashtype' => { 52 => 0x9, 66 => 'FlashType' },
    'flickerreduce' => { 61 => 0x218 },
    'fnumber' => { 8 => 0x15, 24 => 0x829d, 65 => 'FNumber' },
    'focallength' => { 4 => 0x1, 23 => 0x1d, 24 => 0x920a, 47 => 0x12, 57 => 0x1d, 65 => 'FocalLength' },
    'focallength35efl' => { 66 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 24 => 0xa405, 65 => 'FocalLengthIn35mmFilm' },
    'focalplaneresolutionunit' => { 24 => [0x9210,0xa210], 65 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 24 => [0x920e,0xa20e], 65 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 4 => 0x2 },
    'focalplaneyresolution' => { 24 => [0x920f,0xa20f], 65 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 4 => 0x3 },
    'focalunits' => { 0 => 0x19 },
    'focusarea' => { 47 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 47 => 0x13 },
    'focusdistancelower' => { 8 => 0x14 },
    'focusdistanceupper' => { 8 => 0x13 },
    'focusingscreen' => { 12 => 0x0 },
    'focusmode' => { 0 => 0x7, 22 => 0x3, 23 => [0x3003,0xd], 25 => 0x1021, 47 => 0x30, 52 => 0x7, 56 => 0x7, 57 => 0xd },
    'focussetting' => { 62 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 25 => 0x1301 },
    'foldername' => { 47 => 0x27 },
    'format' => { 65 => 'Format' },
    'fragmentlist' => { 44 => 'flst' },
    'fragmenttable' => { 44 => 'ftbl' },
    'framenumber' => { 24 => 0xc359 },
    'free' => { 44 => 'free' },
    'freebytecounts' => { 24 => 0x121 },
    'freebytes' => { 18 => 0x1 },
    'freeoffsets' => { 24 => 0x120 },
    'fujiflashmode' => { 25 => 0x1010 },
    'gaincontrol' => { 24 => 0xa407, 65 => 'GainControl' },
    'gammacompensatedvalue' => { 37 => 0x91 },
    'gamut' => { 31 => 'gamt' },
    'gdalmetadata' => { 24 => 0xa480 },
    'gdalnodata' => { 24 => 0xa481 },
    'geogangularunits' => { 27 => 0x806 },
    'geogangularunitsize' => { 27 => 0x807 },
    'geogazimuthunits' => { 27 => 0x80c },
    'geogcitation' => { 27 => 0x801 },
    'geogellipsoid' => { 27 => 0x808 },
    'geoggeodeticdatum' => { 27 => 0x802 },
    'geoginvflattening' => { 27 => 0x80b },
    'geoglinearunits' => { 27 => 0x804 },
    'geoglinearunitsize' => { 27 => 0x805 },
    'geogprimemeridian' => { 27 => 0x803 },
    'geogprimemeridianlong' => { 27 => 0x80d },
    'geographictype' => { 27 => 0x800 },
    'geogsemimajoraxis' => { 27 => 0x809 },
    'geogsemiminoraxis' => { 27 => 0x80a },
    'geotiffasciiparams' => { 24 => 0x87b1 },
    'geotiffdirectory' => { 24 => 0x87af },
    'geotiffdoubleparams' => { 24 => 0x87b0 },
    'geotiffversion' => { 27 => 0x1 },
    'globalparametersifd' => { 24 => 0x190 },
    'gpsaltitude' => { 26 => 0x6, 65 => 'GPSAltitude' },
    'gpsaltituderef' => { 26 => 0x5, 65 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 26 => 0x1c, 65 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 26 => 0x1d },
    'gpsdatetime' => { 66 => 'GPSDateTime' },
    'gpsdestbearing' => { 26 => 0x18, 65 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 26 => 0x17, 65 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 26 => 0x1a, 65 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 26 => 0x19, 65 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 26 => 0x14, 65 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 26 => 0x13 },
    'gpsdestlongitude' => { 26 => 0x16, 65 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 26 => 0x15 },
    'gpsdifferential' => { 26 => 0x1e, 65 => 'GPSDifferential' },
    'gpsdop' => { 26 => 0xb },
    'gpsimgdirection' => { 26 => 0x11, 65 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 26 => 0x10, 65 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 24 => 0x8825 },
    'gpslatitude' => { 26 => 0x2, 65 => 'GPSLatitude' },
    'gpslatituderef' => { 26 => 0x1 },
    'gpslongitude' => { 26 => 0x4, 65 => 'GPSLongitude' },
    'gpslongituderef' => { 26 => 0x3 },
    'gpsmapdatum' => { 26 => 0x12, 65 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 26 => 0xa },
    'gpsprocessingmethod' => { 26 => 0x1b, 65 => 'GPSProcessingMethod' },
    'gpssatellites' => { 26 => 0x8, 65 => 'GPSSatellites' },
    'gpsspeed' => { 26 => 0xd, 65 => 'GPSSpeed' },
    'gpsspeedref' => { 26 => 0xc, 65 => 'GPSSpeedRef' },
    'gpsstatus' => { 26 => 0x9, 65 => 'GPSStatus' },
    'gpstimestamp' => { 26 => 0x7, 65 => 'GPSTimeStamp' },
    'gpstrack' => { 26 => 0xf, 65 => 'GPSTrack' },
    'gpstrackref' => { 26 => 0xe, 65 => 'GPSTrackRef' },
    'gpsversionid' => { 26 => 0x0, 65 => 'GPSVersionID' },
    'graphicstechnologystandardoutput' => { 44 => 'gtso' },
    'grayresponsecurve' => { 24 => 0x123 },
    'grayresponseunit' => { 24 => 0x122 },
    'graytrc' => { 31 => 'kTRC' },
    'greenhue' => { 65 => 'GreenHue' },
    'greenmatrixcolumn' => { 31 => 'gXYZ' },
    'greensaturation' => { 65 => 'GreenSaturation' },
    'greentrc' => { 31 => 'gTRC' },
    'gtcitation' => { 27 => 0x402 },
    'gtmodeltype' => { 27 => 0x400 },
    'gtrastertype' => { 27 => 0x401 },
    'halftonehints' => { 24 => 0x141 },
    'hcusage' => { 24 => 0x84ee },
    'headline' => { 34 => 0x69, 65 => 'Headline' },
    'highlight' => { 62 => 0xf },
    'history' => { 65 => 'History' },
    'historyaction' => { 65 => 'HistoryAction' },
    'historyinstanceid' => { 65 => 'HistoryInstanceID' },
    'historyparameters' => { 65 => 'HistoryParameters' },
    'historysoftwareagent' => { 65 => 'HistorySoftwareAgent' },
    'historywhen' => { 65 => 'HistoryWhen' },
    'hostcomputer' => { 24 => 0x13c },
    'hueadjustment' => { 52 => 0x92 },
    'icc_profile' => { 24 => 0x8773 },
    'iccprofile' => { 37 => 0x42 },
    'identifier' => { 65 => 'Identifier' },
    'ifd0_offset' => { 53 => 0x1 },
    'imageadjustment' => { 52 => 0x80 },
    'imageboundry' => { 52 => 0x16 },
    'imagecolorindicator' => { 24 => 0x84e7 },
    'imagecolorvalue' => { 24 => 0x84e9 },
    'imagedepth' => { 24 => 0x80e5 },
    'imagedescription' => { 18 => 0x2804, 24 => 0x10e, 65 => 'ImageDescription' },
    'imageformat' => { 18 => 0x1803 },
    'imageheader' => { 44 => 'ihdr' },
    'imageheight' => { 17 => 0x1, 24 => 0x101, 43 => 0x0, 65 => 'ImageLength', 67 => 'ImageHeight' },
    'imagehistory' => { 24 => [0x9213,0xa213] },
    'imageid' => { 24 => 0x800d },
    'imageinfo' => { 18 => 0x1810 },
    'imagelayer' => { 24 => 0x87ac },
    'imagenumber' => { 24 => [0x9211,0xa211] },
    'imageoptimization' => { 52 => 0xa9 },
    'imageorientation' => { 34 => 0x83 },
    'imageprintstatus' => { 24 => 0xc46e },
    'imageprops' => { 18 => 0x300a },
    'imagequality' => { 56 => 0x1 },
    'imagerotationstatus' => { 24 => 0xc363 },
    'imagesize' => { 66 => 'ImageSize' },
    'imagesourcedata' => { 24 => 0x935c },
    'imagesourceek' => { 24 => 0xc351 },
    'imagestabilization' => { 48 => 0x18 },
    'imagestabilizer' => { 56 => 0x1a },
    'imagetype' => { 34 => 0x82 },
    'imageuniqueid' => { 24 => 0xa420, 65 => 'ImageUniqueID' },
    'imagewidth' => { 17 => 0x0, 24 => 0x100, 43 => 0x4, 65 => 'ImageWidth', 67 => 'ImageWidth' },
    'indexed' => { 24 => 0x15a },
    'inknames' => { 24 => 0x14d },
    'inkset' => { 24 => 0x14c },
    'instructions' => { 65 => 'Instructions' },
    'instructionset' => { 44 => 'inst' },
    'intellectualproperty' => { 44 => 'jp2i' },
    'interchangecolorspace' => { 37 => 0x40 },
    'intergraphflagregisters' => { 24 => 0x847f },
    'intergraphmatrix' => { 24 => 0x8480 },
    'intergraphpacketdata' => { 24 => 0x8474 },
    'interlace' => { 24 => 0x8829 },
    'internalflash' => { 47 => 0x2b },
    'interopindex' => { 24 => 0x1 },
    'interopoffset' => { 24 => 0xa005 },
    'interopversion' => { 24 => 0x2 },
    'intervallength' => { 47 => 0x10 },
    'intervalmode' => { 47 => 0x26 },
    'intervalnumber' => { 47 => 0x11 },
    'iptc-naa' => { 24 => 0x83bb },
    'iptc-naa2' => { 24 => 0x8568 },
    'iptcapplication' => { 36 => 0x2 },
    'iptcbitspersample' => { 37 => 0x56 },
    'iptcdata' => { 59 => 0x404 },
    'iptcenvelope' => { 36 => 0x1 },
    'iptcimageheight' => { 37 => 0x1e },
    'iptcimagerotation' => { 37 => 0x66 },
    'iptcimagewidth' => { 37 => 0x14 },
    'iptcnewsphoto' => { 36 => 0x3 },
    'iptcobjectdata' => { 36 => 0x8 },
    'iptcpicturenumber' => { 37 => 0xa },
    'iptcpixelheight' => { 37 => 0x32 },
    'iptcpixelwidth' => { 37 => 0x28 },
    'iptcpostobjectdata' => { 36 => 0x9 },
    'iptcpreobjectdata' => { 36 => 0x7 },
    'iso' => { 8 => 0x2, 23 => 0x14, 24 => 0x8827, 52 => 0x2, 57 => 0x14, 65 => 'ISOSpeedRatings' },
    'isoexpansion' => { 13 => 0x7 },
    'isoselection' => { 52 => 0xf },
    'isosetting' => { 47 => 0x24, 52 => 0x13 },
    'isospeedexpansion' => { 12 => 0x3 },
    'it8header' => { 24 => 0x84e2 },
    'ixusafpoint' => { 8 => 0xe },
    'jobref' => { 65 => 'JobRef' },
    'jobrefid' => { 65 => 'JobRefId' },
    'jobrefname' => { 65 => 'JobRefName' },
    'jobrefurl' => { 65 => 'JobRefUrl' },
    'jp2header' => { 44 => 'jp2h' },
    'jp2signature' => { 44 => ['jP','jP  '] },
    'jpeg_quality' => { 59 => 0x406 },
    'jpegactables' => { 24 => 0x209 },
    'jpegdctables' => { 24 => 0x208 },
    'jpeglosslesspredictors' => { 24 => 0x205 },
    'jpegpointtransforms' => { 24 => 0x206 },
    'jpegproc' => { 24 => 0x200 },
    'jpegqtables' => { 24 => 0x207 },
    'jpegrestartinterval' => { 24 => 0x203 },
    'jpegtables' => { 24 => 0x15b },
    'jpgfromraw' => { 18 => 0x2007, 66 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 24 => 0x202 },
    'jpgfromrawstart' => { 24 => 0x201 },
    'keywords' => { 34 => 0x19, 65 => 'Keywords' },
    'kodakbordersifd' => { 24 => 0xc36f },
    'kodakeffectsifd' => { 24 => 0xc36e },
    'label' => { 44 => 'lbl ' },
    'language' => { 65 => 'Language' },
    'languageidentifier' => { 34 => 0x87 },
    'lastfilenumber' => { 47 => 0x1b },
    'lasturl' => { 65 => 'LastURL' },
    'lcdpanels' => { 12 => 0x8 },
    'lens' => { 24 => 0xfdea, 52 => 0x84, 62 => 0xa, 65 => 'Lens', 66 => 'Lens' },
    'lens35efl' => { 66 => 'Lens35efl' },
    'lensafstopbutton' => { 10 => 0x9, 11 => 0x11, 12 => 0x13, 13 => 0x10 },
    'lenstype' => { 0 => 0x16, 52 => 0x83, 57 => 0x3f },
    'lightsource' => { 24 => 0x9208, 52 => 0x90, 65 => 'LightSource' },
    'lightsourcespecial' => { 61 => 0x21d },
    'linearizationtable' => { 24 => 0xc618 },
    'linearresponselimit' => { 24 => 0xc62e },
    'localizedcameramodel' => { 24 => 0xc615 },
    'longexposurenoisereduction' => { 10 => 0x1, 13 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'lookuptable' => { 37 => 0x50 },
    'luminance' => { 31 => 'lumi' },
    'luminancesmoothing' => { 65 => 'LuminanceSmoothing' },
    'macro' => { 25 => 0x1020, 55 => 0x202, 61 => 0x202 },
    'macromode' => { 0 => 0x1, 47 => 0xb, 56 => 0x1c },
    'magnification' => { 24 => 0xc367 },
    'make' => { 19 => 0x0, 24 => 0x10f, 65 => 'Make' },
    'makeandmodel' => { 31 => 'mmod' },
    'makernote' => { 65 => 'MakerNote' },
    'makernotecanon' => { 24 => 0x927c },
    'makernotecasio' => { 24 => 0x927c },
    'makernotecasio2' => { 24 => 0x927c },
    'makernotecasioex-z3' => { 24 => 0x927c },
    'makernotefujifilm' => { 24 => 0x927c },
    'makernoteleica' => { 24 => 0x927c },
    'makernoteminolta' => { 24 => 0x927c },
    'makernotenikon' => { 24 => 0x927c },
    'makernoteoffset' => { 61 => 0xff },
    'makernoteolympus' => { 24 => 0x927c },
    'makernotepanasonic' => { 24 => 0x927c },
    'makernotepentax' => { 24 => 0x927c },
    'makernotesafety' => { 24 => 0xc635 },
    'makernotesanyo' => { 24 => 0x927c },
    'makernotesigma' => { 24 => 0x927c },
    'makernotesony' => { 24 => 0x927c },
    'makernoteunknown' => { 24 => 0x927c },
    'makernoteversion' => { 48 => 0x0 },
    'managedfrom' => { 65 => 'ManagedFrom' },
    'managedfromdocumentid' => { 65 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 65 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 65 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 65 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 65 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 65 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 65 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 65 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 65 => 'ManagedFromVersionID' },
    'manager' => { 65 => 'Manager' },
    'managervariant' => { 65 => 'ManagerVariant' },
    'manageto' => { 65 => 'ManageTo' },
    'manageui' => { 65 => 'ManageUI' },
    'manualfocusdistance' => { 52 => 0x85, 61 => 0x223 },
    'manualtv' => { 12 => 0x5 },
    'marked' => { 65 => 'Marked' },
    'matteing' => { 24 => 0x80e3 },
    'maxaperture' => { 47 => 0x17 },
    'maxaperturevalue' => { 24 => 0x9205, 65 => 'MaxApertureValue' },
    'maximumdensityrange' => { 37 => 0x8c },
    'maximumobjectsize' => { 40 => 0x5f },
    'maxsamplevalue' => { 24 => 0x119 },
    'maxsubfilesize' => { 40 => 0x14 },
    'measuredev' => { 18 => 0x1814 },
    'measuredinfo' => { 18 => 0x3003 },
    'measurement' => { 31 => 'meas' },
    'measurementbacking' => { 32 => 0xc },
    'measurementflare' => { 32 => 0x1c },
    'measurementgeometry' => { 32 => 0x18 },
    'measurementilluminant' => { 32 => 0x20 },
    'measurementobserver' => { 32 => 0x8 },
    'mediablackpoint' => { 31 => 'bkpt' },
    'mediadata' => { 44 => 'mdat' },
    'mediawhitepoint' => { 31 => 'wtpt' },
    'menubuttondisplayposition' => { 11 => 0xb, 13 => 0xa },
    'menubuttonreturn' => { 10 => 0xb },
    'metadatadate' => { 65 => 'MetadataDate' },
    'metadatanumber' => { 24 => 0xc365 },
    'meteringmode' => { 0 => 0x11, 24 => 0x9207, 47 => 0x7, 57 => 0x17, 62 => 0x9, 65 => 'MeteringMode' },
    'minoltaaperture' => { 47 => 0xa },
    'minoltacamerasettings' => { 48 => 0x3 },
    'minoltacamerasettings2' => { 48 => 0xf00 },
    'minoltacamerasettingsold' => { 48 => 0x1 },
    'minoltadate' => { 47 => 0x15 },
    'minoltaimagesize' => { 47 => 0x4 },
    'minoltaiso' => { 47 => 0x8 },
    'minoltamodel' => { 47 => 0x25 },
    'minoltaquality' => { 47 => 0x5, 48 => [0x102,0x103] },
    'minoltashutterspeed' => { 47 => 0x9 },
    'minoltatime' => { 47 => 0x16 },
    'minsamplevalue' => { 24 => 0x118 },
    'mirrorlockup' => { 10 => 0x3, 11 => 0xc, 12 => 0xc, 13 => 0xb },
    'moddate' => { 65 => 'ModDate' },
    'model' => { 19 => 0x6, 24 => 0x110, 65 => 'Model' },
    'model2' => { 24 => 0x827d },
    'modelandversion' => { 24 => 0xc35c },
    'modeltiepoint' => { 24 => 0x8482 },
    'modeltransform' => { 24 => 0x85d8 },
    'modenumber' => { 24 => 0x195 },
    'modifydate' => { 24 => 0x132, 65 => 'ModifyDate' },
    'moirefilter' => { 24 => 0xfe58 },
    'mpeg7binary' => { 44 => 'mp7b' },
    'namedcolor' => { 31 => 'ncol' },
    'namedcolor2' => { 31 => 'ncl2' },
    'nativedisplayinfo' => { 31 => 'ndin' },
    'nativeresolutionunit' => { 24 => 0xc37a },
    'nativexresolution' => { 24 => 0xc36c },
    'nativeyresolution' => { 24 => 0xc36d },
    'nefcurve1' => { 52 => 0x8c },
    'nefcurve2' => { 52 => 0x96 },
    'nefthumbnailsize' => { 52 => 0x99 },
    'newsphotoversion' => { 37 => 0x0 },
    'nickname' => { 65 => 'Nickname' },
    'nikoncaptureoffsets' => { 52 => 0xe0e },
    'nikonpreview' => { 52 => 0x11 },
    'noise' => { 24 => [0x920d,0xa20d] },
    'noisereduction' => { 52 => 0x95, 56 => 0x2d },
    'nullrecord' => { 18 => 0x0 },
    'numberlist' => { 44 => 'nlst' },
    'numberofcomponents' => { 43 => 0x8 },
    'numberofinks' => { 24 => 0x14e },
    'numindexentries' => { 37 => 0x54 },
    'objectattributereference' => { 34 => 0x4 },
    'objectcycle' => { 34 => 0x4b },
    'objectdistance' => { 22 => 0x6, 23 => 0x2022 },
    'objectname' => { 34 => 0x5 },
    'objectpreviewdata' => { 34 => 0xca },
    'objectpreviewfileformat' => { 34 => 0xc8 },
    'objectpreviewfileversion' => { 34 => 0xc9 },
    'objectsizeannounced' => { 40 => 0x5a },
    'objecttypereference' => { 34 => 0x3 },
    'oceapplicationselector' => { 24 => 0xc428 },
    'oceidnumber' => { 24 => 0xc429 },
    'oceimagelogic' => { 24 => 0xc42a },
    'ocescanjobdesc' => { 24 => 0xc427 },
    'oecfcolumns' => { 65 => 'OECFColumns' },
    'oecfnames' => { 65 => 'OECFNames' },
    'oecfrows' => { 65 => 'OECFRows' },
    'oecfvalues' => { 65 => 'OECFValues' },
    'oldsubfiletype' => { 24 => 0xff },
    'opacity' => { 44 => 'opct' },
    'opiproxy' => { 24 => 0x15f },
    'opticalzoomon' => { 61 => 0x219 },
    'opto-electricconvfactor' => { 24 => 0x8828, 65 => 'OECF' },
    'orientation' => { 24 => 0x112, 65 => 'Orientation' },
    'originalfilename' => { 18 => 0x816 },
    'originaltransmissionreference' => { 34 => 0x67 },
    'originatingprogram' => { 34 => 0x41 },
    'otherimagelength' => { 24 => 0x202 },
    'otherimagestart' => { 24 => 0x201 },
    'outputresponse' => { 31 => 'resp' },
    'owner' => { 65 => 'Owner' },
    'ownername' => { 5 => 0x9, 18 => 0x810, 24 => 0xfde8 },
    'pagename' => { 24 => 0x11d },
    'pagenumber' => { 24 => 0x129 },
    'palette' => { 44 => 'pclr' },
    'pcscitation' => { 27 => 0xc01 },
    'pdfversion' => { 65 => 'PDFVersion' },
    'pentaximagesize' => { 57 => 0x9 },
    'pentaxmode' => { 57 => 0x1 },
    'photometricinterpretation' => { 24 => 0x106, 65 => 'PhotometricInterpretation' },
    'photoshopformat' => { 58 => 0x1 },
    'photoshopquality' => { 58 => 0x0 },
    'photoshopsettings' => { 24 => 0x8649 },
    'photoshopthumbnail' => { 59 => 0x40c },
    'pictinfo' => { 55 => 0x208, 61 => 0x208 },
    'picturemode' => { 25 => 0x1031, 57 => 0xb },
    'pixelaspectratio' => { 17 => 0x2 },
    'pixelintensityrange' => { 24 => 0x84eb },
    'pixelscale' => { 24 => 0x830e },
    'planarconfiguration' => { 24 => 0x11c, 65 => 'PlanarConfiguration' },
    'postscript2crd0' => { 31 => 'psd0' },
    'postscript2crd1' => { 31 => 'psd1' },
    'postscript2crd2' => { 31 => 'psd2' },
    'postscript2csa' => { 31 => 'ps2s' },
    'predictor' => { 24 => 0x13d },
    'preview0' => { 31 => 'pre0' },
    'preview1' => { 31 => 'pre1' },
    'preview2' => { 31 => 'pre2' },
    'previewfocalplanexresolution' => { 7 => 0x6 },
    'previewfocalplaneyresolution' => { 7 => 0x8 },
    'previewifd_offset' => { 53 => 0x2 },
    'previewimage' => { 23 => 0x2000, 66 => 'PreviewImage', 67 => 'PreviewImage' },
    'previewimagedata' => { 48 => 0x81 },
    'previewimageheight' => { 7 => 0x4 },
    'previewimageinfo' => { 5 => 0xb6 },
    'previewimagelength' => { 7 => 0x2, 24 => [0x117,0x202], 48 => 0x89, 54 => 0x202, 57 => 0x3 },
    'previewimagesize' => { 23 => 0x2, 57 => 0x2, 66 => 'PreviewImageSize' },
    'previewimagestart' => { 7 => 0x5, 24 => [0x111,0x201], 48 => 0x88, 54 => 0x201, 57 => 0x4 },
    'previewimagewidth' => { 7 => 0x3 },
    'primarychromaticities' => { 24 => 0x13f, 65 => 'PrimaryChromaticities' },
    'primaryplatform' => { 30 => 0x28 },
    'printim' => { 23 => 0xe00, 24 => 0xc4a5, 48 => 0xe00, 52 => 0xe00, 56 => 0xe00, 57 => 0xe00, 61 => 0xe00, 63 => 0xe00, 64 => 0xe00 },
    'printquality' => { 24 => 0xc46c },
    'processgeotiff' => { 66 => 'ProcessGeoTiff' },
    'producer' => { 65 => 'Producer' },
    'productid' => { 35 => 0x32 },
    'profile' => { 44 => 'prfl' },
    'profileclass' => { 30 => 0xc },
    'profilecmmtype' => { 30 => 0x4 },
    'profileconnectionspace' => { 30 => [0x14,0x44] },
    'profilecreator' => { 30 => 0x50 },
    'profiledatetime' => { 30 => 0x18 },
    'profiledescription' => { 31 => 'desc' },
    'profiledescriptionml' => { 31 => 'dscm' },
    'profilefilesignature' => { 30 => 0x24 },
    'profileheader' => { 31 => 'Header' },
    'profileid' => { 30 => 0x54 },
    'profilesequencedesc' => { 31 => 'pseq' },
    'profiletype' => { 24 => 0x191 },
    'profileversion' => { 30 => 0x8 },
    'programversion' => { 34 => 0x46 },
    'progressivescans' => { 58 => 0x2 },
    'projazimuthangle' => { 27 => 0xc16 },
    'projcentereasting' => { 27 => 0xc12 },
    'projcenterlat' => { 27 => 0xc11 },
    'projcenterlong' => { 27 => 0xc10 },
    'projcenternorthing' => { 27 => 0xc13 },
    'projcoordtrans' => { 27 => 0xc03 },
    'projectedcstype' => { 27 => 0xc00 },
    'projection' => { 27 => 0xc02 },
    'projfalseeasting' => { 27 => 0xc0a },
    'projfalsenorthing' => { 27 => 0xc0b },
    'projfalseorigineasting' => { 27 => 0xc0e },
    'projfalseoriginlat' => { 27 => 0xc0d },
    'projfalseoriginlong' => { 27 => 0xc0c },
    'projfalseoriginnorthing' => { 27 => 0xc0f },
    'projlinearunits' => { 27 => 0xc04 },
    'projlinearunitsize' => { 27 => 0xc05 },
    'projnatoriginlat' => { 27 => 0xc09 },
    'projnatoriginlong' => { 27 => 0xc08 },
    'projrectifiedgridangle' => { 27 => 0xc18 },
    'projscaleatcenter' => { 27 => 0xc15 },
    'projscaleatnatorigin' => { 27 => 0xc14 },
    'projstdparallel1' => { 27 => 0xc06 },
    'projstdparallel2' => { 27 => 0xc07 },
    'projstraightvertpolelong' => { 27 => 0xc17 },
    'province-state' => { 34 => 0x5f },
    'ps2crdvmsize' => { 31 => 'psvm' },
    'ps2renteringintent' => { 31 => 'ps2i' },
    'publisher' => { 65 => 'Publisher' },
    'quality' => { 0 => 0x3, 22 => 0x2, 23 => 0x3002, 25 => 0x1000, 52 => 0x4, 55 => 0x201, 57 => 0x8, 62 => 0x16 },
    'qualitymode' => { 23 => 0x8 },
    'quantizationmethod' => { 37 => 0x78 },
    'quickshot' => { 61 => 0x213 },
    'rasterizedcaption' => { 34 => 0x7d },
    'rasterpadding' => { 24 => 0x84e3 },
    'rawandjpgrecording' => { 11 => 0x8 },
    'rawdata' => { 18 => 0x2005 },
    'rawfile' => { 24 => 0xfe4c },
    'rawfilename' => { 65 => 'RawFileName' },
    'rawimagesize' => { 57 => 0x39 },
    'readerrequirements' => { 44 => 'rreq' },
    'recordid' => { 18 => 0x1804 },
    'recordingmode' => { 22 => 0x1 },
    'recordmode' => { 23 => 0x3000 },
    'recordshutterrelease' => { 61 => 0x217 },
    'redbalance' => { 49 => 0x0, 50 => 0x0, 51 => 0x0, 55 => 0x1017 },
    'redbalanceauto' => { 9 => 0x0 },
    'redbalanceb&w' => { 9 => 0xe },
    'redbalancecloudy' => { 9 => 0x4 },
    'redbalancecustom' => { 9 => 0xc },
    'redbalancedaylight' => { 9 => 0x2 },
    'redbalanceflash' => { 9 => 0xa },
    'redbalancefluorescent' => { 9 => 0x8 },
    'redbalanceshade' => { 9 => 0x10 },
    'redbalancetungsten' => { 9 => 0x6 },
    'redeyereduction' => { 66 => 'RedEyeReduction' },
    'redhue' => { 65 => 'RedHue' },
    'redmatrixcolumn' => { 31 => 'rXYZ' },
    'redsaturation' => { 65 => 'RedSaturation' },
    'redtrc' => { 31 => 'rTRC' },
    'reductionmatrix1' => { 24 => 0xc625 },
    'reductionmatrix2' => { 24 => 0xc626 },
    'referenceblackwhite' => { 24 => 0x214, 65 => 'ReferenceBlackWhite' },
    'referencedate' => { 34 => 0x2f },
    'referencenumber' => { 34 => 0x32 },
    'referenceservice' => { 34 => 0x2d },
    'relatedimagefileformat' => { 24 => 0x1000 },
    'relatedimagelength' => { 24 => 0x1002 },
    'relatedimagewidth' => { 24 => 0x1001 },
    'relatedsoundfile' => { 24 => 0xa004, 65 => 'RelatedSoundFile' },
    'relation' => { 65 => 'Relation' },
    'releasedate' => { 34 => 0x1e },
    'releasesetting' => { 18 => 0x1016 },
    'releasetime' => { 34 => 0x23 },
    'renderingintent' => { 30 => 0x40 },
    'renditionclass' => { 65 => 'RenditionClass' },
    'renditionof' => { 65 => 'RenditionOf' },
    'renditionofdocumentid' => { 65 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 65 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 65 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 65 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 65 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 65 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 65 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 65 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 65 => 'RenditionOfVersionID' },
    'renditionparams' => { 65 => 'RenditionParams' },
    'resaved' => { 61 => 0x21e },
    'resolution' => { 44 => 'res ' },
    'resolutionmode' => { 62 => 0x4 },
    'resolutionunit' => { 24 => 0x128, 54 => 0x128, 65 => 'ResolutionUnit' },
    'rights' => { 65 => 'Rights' },
    'roidescription' => { 44 => 'roid' },
    'rollguidelements' => { 24 => 0xc364 },
    'romoperationmode' => { 18 => 0x80d },
    'rotation' => { 17 => 0x3 },
    'rowsperstrip' => { 24 => 0x116 },
    'safetyshiftinavortv' => { 11 => 0x10, 12 => 0x10, 13 => 0xf },
    'sampleformat' => { 24 => 0x153 },
    'samplesperpixel' => { 24 => 0x115, 65 => 'SamplesPerPixel' },
    'samplestructure' => { 37 => 0x5a },
    'sanyoquality' => { 61 => 0x201 },
    'sanyothumbnail' => { 61 => 0x100 },
    'saturation' => { 0 => 0xe, 22 => 0xd, 23 => 0x1f, 24 => [0xa409,0xfe55], 25 => 0x1003, 47 => 0x1f, 52 => [0x94,0xaa], 57 => 0x1f, 62 => 0x10, 65 => 'Saturation' },
    'saveid' => { 65 => 'SaveID' },
    'sba_rgbshifts' => { 24 => 0xc35e },
    'sbaexposurerecord' => { 24 => 0xc361 },
    'sbainputimagebitdepth' => { 24 => 0xc360 },
    'sbainputimagecolorspace' => { 24 => 0xc35f },
    'scalefactor35efl' => { 66 => 'ScaleFactor35efl' },
    'scanningdirection' => { 37 => 0x64 },
    'scenecapturetype' => { 24 => 0xa406, 65 => 'SceneCaptureType' },
    'scenemode' => { 52 => 0x8f },
    'sceneselect' => { 61 => 0x21f },
    'scenetype' => { 24 => 0xa301, 65 => 'SceneType' },
    'screening' => { 31 => 'scrn' },
    'screeningdesc' => { 31 => 'scrd' },
    'securityclassification' => { 24 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 8 => 0x1d },
    'selftimer' => { 23 => 0x3001, 61 => 0x214 },
    'selftimermode' => { 24 => 0x882b },
    'selftimertime' => { 18 => 0x1806 },
    'sensingmethod' => { 24 => [0x9217,0xa217], 65 => 'SensingMethod' },
    'sensorbottomborder' => { 20 => 0x8 },
    'sensorcleaning' => { 10 => 0xd },
    'sensorheight' => { 20 => 0x2 },
    'sensorinfo' => { 18 => 0x1031 },
    'sensorleftborder' => { 20 => 0x5 },
    'sensorrightborder' => { 20 => 0x7 },
    'sensortopborder' => { 20 => 0x6 },
    'sensorwidth' => { 20 => 0x1 },
    'sequencenumber' => { 8 => 0x9 },
    'sequenceshotinterval' => { 61 => 0x224 },
    'sequentialshot' => { 61 => 0x20e },
    'serialnumber' => { 5 => 0xc, 18 => 0x180b, 24 => [0xc354,0xfde9], 52 => 0xa0, 56 => 0x25, 62 => 0x2, 65 => 'SerialNumber' },
    'serviceidentifier' => { 35 => 0x1e },
    'setbuttonfunction' => { 10 => 0xc, 11 => 0x1 },
    'setfunctionwhenshooting' => { 13 => 0x0 },
    'shadow' => { 62 => 0xe },
    'shadows' => { 24 => 0xfe52, 65 => 'Shadows' },
    'shadowscale' => { 24 => 0xc633 },
    'shadowtint' => { 65 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 22 => 0xb, 23 => 0x21, 24 => [0xa40a,0xfe56], 25 => 0x1001, 47 => 0x21, 52 => 0x6, 57 => 0x21, 62 => 0x11, 65 => 'Sharpness' },
    'shootingmode' => { 52 => 0x89, 56 => 0x1f, 66 => 'ShootingMode' },
    'shootingrecord' => { 18 => 0x3002 },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 10 => 0x2, 11 => 0x4, 13 => 0x3 },
    'shutteraelbutton' => { 12 => 0x4 },
    'shuttercount' => { 52 => 0xa7 },
    'shuttercurtainhack' => { 66 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 10 => 0x8, 11 => 0xf, 12 => 0xf, 13 => 0xe },
    'shutterreleasemethod' => { 18 => 0x1010 },
    'shutterreleasenocfcard' => { 10 => 0xf, 11 => 0x2, 12 => 0x2 },
    'shutterreleasetiming' => { 18 => 0x1011 },
    'shutterspeed' => { 66 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 24 => 0x9201, 65 => 'ShutterSpeedValue' },
    'site' => { 24 => 0x84e0 },
    'sizemode' => { 40 => 0xa },
    'slowsync' => { 25 => 0x1030 },
    'smaxsamplevalue' => { 24 => 0x155 },
    'sminsamplevalue' => { 24 => 0x154 },
    'smoothness' => { 24 => 0xfe57 },
    'software' => { 24 => 0x131, 62 => 0x18, 65 => 'Software' },
    'softwarerelease' => { 55 => 0x207 },
    'softwareversion' => { 61 => 0x207 },
    'source' => { 34 => 0x73, 65 => 'Source' },
    'sourceimagedirectory' => { 24 => 0xc418 },
    'sourceimagefilename' => { 24 => 0xc419 },
    'sourceimagevolumename' => { 24 => 0xc41a },
    'spatialfrequencyresponse' => { 24 => [0x920c,0xa20c], 65 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 65 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 65 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 65 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 65 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 34 => 0x28 },
    'specialmode' => { 55 => 0x200, 61 => 0x200 },
    'spectralsensitivity' => { 24 => 0x8824, 65 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 47 => 0x2d },
    'spotfocuspointy' => { 47 => 0x2e },
    'spotmode' => { 56 => 0xf },
    'state' => { 65 => 'State' },
    'stonits' => { 24 => 0x923f },
    'stripbytecounts' => { 24 => 0x117 },
    'stripoffsets' => { 24 => 0x111 },
    'striprowcounts' => { 24 => 0x22f },
    'sub-location' => { 34 => 0x5c },
    'subfile' => { 38 => 0xa },
    'subfiletype' => { 24 => 0xfe },
    'subifd' => { 24 => 0x14a },
    'subifd_offset' => { 53 => 0x3 },
    'subject' => { 65 => 'Subject' },
    'subjectarea' => { 65 => 'SubjectArea' },
    'subjectdistance' => { 24 => 0x9206, 65 => 'SubjectDistance' },
    'subjectdistancerange' => { 24 => 0xa40c, 65 => 'SubjectDistanceRange' },
    'subjectlocation' => { 24 => [0x9214,0xa214], 65 => 'SubjectLocation' },
    'subjectprogram' => { 47 => 0x22 },
    'subjectreference' => { 34 => 0xc },
    'subsectime' => { 24 => 0x9290 },
    'subsectimedigitized' => { 24 => 0x9292 },
    'subsectimeoriginal' => { 24 => 0x9291 },
    'superimposeddisplay' => { 10 => 0xe, 11 => 0xa, 13 => 0x9 },
    'supplementalcategories' => { 34 => 0x14, 65 => 'SupplementalCategories' },
    'supplementaltype' => { 37 => 0x37 },
    'switchtoregisteredafpoint' => { 12 => 0x12 },
    't4options' => { 24 => 0x124 },
    't6options' => { 24 => 0x125 },
    'targetcompressionratio' => { 16 => 0x1 },
    'targetdistancesetting' => { 18 => 0x1807 },
    'targetimagetype' => { 18 => 0x100a },
    'targetprinter' => { 24 => 0x151 },
    'technology' => { 31 => 'tech' },
    'thresholding' => { 24 => 0x107 },
    'thumbnailfilename' => { 18 => 0x817 },
    'thumbnailimage' => { 18 => 0x2008, 66 => 'ThumbnailImage' },
    'thumbnaillength' => { 24 => 0x202 },
    'thumbnailoffset' => { 24 => 0x201 },
    'thumbnails' => { 65 => 'Thumbnails' },
    'thumbnailsformat' => { 65 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 65 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 65 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 65 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 24 => [0x9216,0xa216] },
    'tilebytecounts' => { 24 => 0x145 },
    'tiledepth' => { 24 => 0x80e6 },
    'tilelength' => { 24 => 0x143 },
    'tileoffsets' => { 24 => 0x144 },
    'tilewidth' => { 24 => 0x142 },
    'timecreated' => { 34 => 0x3c },
    'timesent' => { 35 => 0x50 },
    'timestamp' => { 18 => 0x180e },
    'timezone' => { 23 => 0x3006 },
    'timezonecode' => { 21 => 0x1 },
    'timezoneinfo' => { 21 => 0x2 },
    'timezoneoffset' => { 24 => 0x882a },
    'title' => { 65 => 'Title' },
    'tonecomp' => { 52 => 0x81 },
    'transferfunction' => { 24 => 0x12d, 65 => 'TransferFunction' },
    'transferrange' => { 24 => 0x156 },
    'transmissionreference' => { 65 => 'TransmissionReference' },
    'transparencyindicator' => { 24 => 0x84ec },
    'tvvalue' => { 14 => 0x1 },
    'type' => { 65 => 'Type' },
    'ucrbg' => { 31 => 'bfd ' },
    'uniquecameramodel' => { 24 => 0xc614 },
    'uniqueobjectname' => { 35 => 0x64 },
    'urgency' => { 34 => 0xa, 65 => 'Urgency' },
    'url' => { 44 => 'url ', 59 => 0x40b },
    'usageterms' => { 65 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 24 => 0xc362 },
    'usercomment' => { 18 => 0x805, 24 => 0x9286, 65 => 'UserComment' },
    'userselectgrouptitle' => { 24 => 0xc355 },
    'usmlenselectronicmf' => { 12 => 0x7 },
    'uuid-geojp2' => { 44 => 'uuid' },
    'uuid-unknown' => { 44 => 'uuid' },
    'uuid-xmp' => { 44 => 'uuid' },
    'uuidinfo' => { 44 => 'uinf' },
    'uuidlist' => { 44 => 'ulst' },
    'variprogram' => { 52 => 0xab },
    'version' => { 25 => 0x0, 65 => 'Version' },
    'versionid' => { 65 => 'VersionID' },
    'versions' => { 65 => 'Versions' },
    'versionscomments' => { 65 => 'VersionsComments' },
    'versionsevent' => { 65 => 'VersionsEvent' },
    'versionseventaction' => { 65 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 65 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 65 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 65 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 65 => 'VersionsEventWhen' },
    'versionsmodifier' => { 65 => 'VersionsModifier' },
    'versionsmodifydate' => { 65 => 'VersionsModifyDate' },
    'versionsversion' => { 65 => 'VersionsVersion' },
    'versionyear' => { 24 => 0x194 },
    'verticalcitation' => { 27 => 0x1001 },
    'verticalcstype' => { 27 => 0x1000 },
    'verticaldatum' => { 27 => 0x1002 },
    'verticalunits' => { 27 => 0x1003 },
    'videocardgamma' => { 31 => 'vcgt' },
    'viewingconddesc' => { 31 => 'vued' },
    'viewingcondilluminant' => { 33 => 0x8 },
    'viewingcondilluminanttype' => { 33 => 0x20 },
    'viewingconditions' => { 31 => 'view' },
    'viewingcondsurround' => { 33 => 0x14 },
    'vignetteamount' => { 65 => 'VignetteAmount' },
    'vignettemidpoint' => { 65 => 'VignetteMidpoint' },
    'voicememo' => { 61 => 0x216 },
    'wangannotation' => { 24 => 0x80a4 },
    'warning' => { 67 => 'Warning' },
    'watermarktype' => { 45 => 0x8 },
    'webstatement' => { 65 => 'WebStatement' },
    'whitebalance' => { 8 => 0x7, 22 => 0x7, 23 => [0x19,0x2012], 24 => [0xa403,0xfe4e], 25 => 0x1002, 47 => 0x3, 52 => 0x5, 56 => 0x3, 57 => 0x19, 62 => 0x7, 65 => 'WhiteBalance' },
    'whitebalancebias' => { 23 => 0x2011, 56 => 0x23 },
    'whitebalancefinetune' => { 52 => 0xb },
    'whitebalancetable' => { 5 => 0xa9, 18 => 0x10a9 },
    'whitelevel' => { 24 => 0xc61d },
    'whitepoint' => { 24 => 0x13e, 65 => 'WhitePoint' },
    'widefocuszone' => { 47 => 0x2f },
    'widerange' => { 61 => 0x20f },
    'writer-editor' => { 34 => 0x7a },
    'x3filllight' => { 62 => 0x12 },
    'xclippathunits' => { 24 => 0x158 },
    'xml' => { 44 => 'xml ' },
    'xpauthor' => { 24 => 0x9c9d },
    'xpcomment' => { 24 => 0x9c9c },
    'xpkeywords' => { 24 => 0x9c9e },
    'xposition' => { 24 => 0x11e },
    'xpsubject' => { 24 => 0x9c9f },
    'xptitle' => { 24 => 0x9c9b },
    'xresolution' => { 24 => 0x11a, 54 => 0x11a, 65 => 'XResolution' },
    'ycbcrcoefficients' => { 24 => 0x211, 65 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 24 => 0x213, 54 => 0x213 },
    'ycbcrsubsampling' => { 24 => 0x212, 65 => 'YCbCrSubSampling' },
    'yclippathunits' => { 24 => 0x159 },
    'yposition' => { 24 => 0x11f },
    'yresolution' => { 24 => 0x11b, 54 => 0x11b, 65 => 'YResolution' },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool|Image::ExifTool>
L<Image::ExifTool::BuildTagLookup|Image::ExifTool::BuildTagLookup>

=cut
