#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.01';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::Canon1DSettings',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::MakerNote1',
    'Image::ExifTool::Casio::MakerNote2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalanceD100',
    'Image::ExifTool::Nikon::ColorBalanceD2H',
    'Image::ExifTool::Nikon::ColorBalanceD70',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 33 => 0x2a },
    'addoriginaldecisiondata' => { 12 => 0x11 },
    'adjustmentmode' => { 55 => 0x15 },
    'advisory' => { 58 => 'Advisory' },
    'aebbracketvalue' => { 7 => 0x11 },
    'aebsequence' => { 9 => 0x7, 10 => 0x9, 11 => 0x9, 12 => 0x8 },
    'afassist' => { 9 => 0x5, 10 => 0x5 },
    'afassistbeam' => { 12 => 0x4 },
    'afmode' => { 55 => 0x5 },
    'afpoint' => { 0 => 0x13, 45 => 0x88 },
    'afpointactivationarea' => { 11 => 0x11 },
    'afpointillumination' => { 11 => 0xa },
    'afpointregistration' => { 10 => 0x7 },
    'afpointselection' => { 11 => 0xb },
    'afpointselectionmethod' => { 12 => 0xc },
    'afpointspotmetering' => { 11 => 0xd },
    'afpointsused' => { 5 => 0x16 },
    'aiservotrackingsensitivity' => { 11 => 0x14 },
    'aliaslayermetadata' => { 23 => 0xc660 },
    'alphachannelsnames' => { 52 => 0x3ee },
    'analogbalance' => { 23 => 0xc627 },
    'annotations' => { 23 => 0xc44f },
    'antialiasstrength' => { 23 => 0xc632 },
    'aperture' => { 59 => 'Aperture' },
    'aperturevalue' => { 23 => 0x9202, 58 => 'ApertureValue' },
    'applicationnotes' => { 23 => 0x2bc },
    'applicationrecordversion' => { 33 => 0x0 },
    'armidentifier' => { 34 => 0x78 },
    'armversion' => { 34 => 0x7a },
    'artist' => { 23 => 0x13b, 58 => 'Artist' },
    'asshotneutral' => { 23 => 0xc628 },
    'asshotwhitexy' => { 23 => 0xc629 },
    'assistbuttonfunction' => { 10 => 0xd },
    'atob0' => { 30 => 'A2B0' },
    'atob1' => { 30 => 'A2B1' },
    'atob2' => { 30 => 'A2B2' },
    'audio' => { 49 => 0x20 },
    'audioduration' => { 33 => 0x99 },
    'audiooutcue' => { 33 => 0x9a },
    'audiosamplingrate' => { 33 => 0x97 },
    'audiosamplingresolution' => { 33 => 0x98 },
    'audiotype' => { 33 => 0x96 },
    'author' => { 58 => 'Author' },
    'authorsposition' => { 58 => 'AuthorsPosition' },
    'autobracket' => { 55 => 0x19 },
    'autobracketing' => { 24 => 0x1100 },
    'autoexposurebracketing' => { 7 => 0x10 },
    'auxiliarylens' => { 45 => 0x82 },
    'avvalue' => { 13 => 0x2 },
    'badfaxlines' => { 23 => 0x146 },
    'baseiso' => { 17 => 0x101c },
    'baselineexposure' => { 23 => 0xc62a },
    'baselinenoise' => { 23 => 0xc62b },
    'baselinesharpness' => { 23 => 0xc62c },
    'baseurl' => { 58 => 'BaseURL' },
    'batterylevel' => { 23 => 0x828f },
    'bayergreensplit' => { 23 => 0xc62d },
    'bestqualityscale' => { 23 => 0xc65c },
    'bestshotmode' => { 22 => 0x3007 },
    'bitspercomponent' => { 36 => 0x87 },
    'bitspersample' => { 23 => 0x102, 58 => 'BitsPerSample' },
    'blacklevel' => { 23 => 0xc61a },
    'blackleveldeltah' => { 23 => 0xc61b },
    'blackleveldeltav' => { 23 => 0xc61c },
    'blacklevelrepeatdim' => { 23 => 0xc619 },
    'bluebalance' => { 42 => 0x1, 43 => 0x1, 44 => 0x1, 48 => 0x1018 },
    'bluebalanceauto' => { 8 => 0x1 },
    'bluebalanceb&w' => { 8 => 0xf },
    'bluebalancecloudy' => { 8 => 0x5 },
    'bluebalancecustom' => { 8 => 0xd },
    'bluebalancedaylight' => { 8 => 0x3 },
    'bluebalanceflash' => { 8 => 0xb },
    'bluebalancefluorescent' => { 8 => 0x9 },
    'bluebalanceshade' => { 8 => 0x11 },
    'bluebalancetungsten' => { 8 => 0x7 },
    'bluehue' => { 58 => 'BlueHue' },
    'bluematrixcolumn' => { 30 => 'bXYZ' },
    'bluesaturation' => { 58 => 'BlueSaturation' },
    'bluetrc' => { 30 => 'bTRC' },
    'blurwarning' => { 24 => 0x1300 },
    'bracketstep' => { 40 => 0xe },
    'brightness' => { 40 => 0x2c, 58 => 'Brightness' },
    'brightnessvalue' => { 23 => 0x9203, 58 => 'BrightnessValue' },
    'btoa0' => { 30 => 'B2A0' },
    'btoa1' => { 30 => 'B2A1' },
    'btoa2' => { 30 => 'B2A2' },
    'bulbduration' => { 7 => 0x18 },
    'bwfilter' => { 40 => 0x2a },
    'by-line' => { 33 => 0x50 },
    'by-linetitle' => { 33 => 0x55 },
    'calibrationdatetime' => { 30 => 'calt' },
    'calibrationilluminant1' => { 23 => 0xc65a },
    'calibrationilluminant2' => { 23 => 0xc65b },
    'cameracalibration1' => { 23 => 0xc623 },
    'cameracalibration2' => { 23 => 0xc624 },
    'cameraid' => { 48 => 0x209, 54 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'cameraobject' => { 17 => 0x2807 },
    'cameraspecification' => { 17 => 0x3004 },
    'canon1dsettings' => { 4 => 0xa },
    'canoncamerasettings' => { 4 => 0x1, 17 => 0x102d },
    'canoncolorinfo1' => { 17 => 0x32 },
    'canoncolorinfo2' => { 17 => 0x102c },
    'canoncustomfunctions' => { 4 => 0xf, 17 => 0x1033 },
    'canoncustomfunctions10d' => { 4 => 0xf, 17 => 0x1033 },
    'canoncustomfunctions1d' => { 4 => 0x90 },
    'canoncustomfunctions20d' => { 4 => 0xf, 17 => 0x1033 },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 17 => 0x805 },
    'canonfileinfo' => { 4 => 0x93 },
    'canonfilelength' => { 4 => 0xe },
    'canonfirmwareversion' => { 4 => 0x7, 17 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonfocallength' => { 4 => 0x2, 17 => 0x1029 },
    'canonimageheight' => { 5 => 0x3 },
    'canonimageheightasshot' => { 5 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 4 => 0x6, 17 => 0x815 },
    'canonimagewidth' => { 5 => 0x2 },
    'canonimagewidthasshot' => { 5 => 0x4 },
    'canonpictureinfo' => { 4 => 0x12, 17 => 0x1038 },
    'canonrawmakemodel' => { 17 => 0x80a },
    'canonshotinfo' => { 4 => 0x4, 17 => 0x102a },
    'caption-abstract' => { 33 => 0x78 },
    'captionwriter' => { 58 => 'CaptionWriter' },
    'casioimagesize' => { 22 => 0x9 },
    'casiopreviewlength' => { 22 => 0x3 },
    'casiopreviewstart' => { 22 => 0x4 },
    'category' => { 33 => 0xf, 58 => 'Category' },
    'ccdisosensitivity' => { 22 => 0x3014 },
    'ccdsensitivity' => { 21 => 0x14 },
    'celllength' => { 23 => 0x109 },
    'cellwidth' => { 23 => 0x108 },
    'certificate' => { 58 => 'Certificate' },
    'cfalayout' => { 23 => 0xc617 },
    'cfapattern' => { 23 => 0xa302, 58 => 'CFAPattern' },
    'cfapattern2' => { 23 => 0x828e },
    'cfapatterncolumns' => { 58 => 'CFAPatternColumns' },
    'cfapatternrows' => { 58 => 'CFAPatternRows' },
    'cfapatternvalues' => { 58 => 'CFAPatternValues' },
    'cfaplanecolor' => { 23 => 0xc616 },
    'cfarepeatpatterndim' => { 23 => 0x828d },
    'chartarget' => { 30 => 'targ' },
    'chromablurradius' => { 23 => 0xc631 },
    'chromaticaberrationb' => { 58 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 58 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 30 => 'chad' },
    'chromaticity' => { 30 => 'chrm' },
    'chromaticitychannel1' => { 27 => 0xc },
    'chromaticitychannel2' => { 27 => 0x14 },
    'chromaticitychannel3' => { 27 => 0x1c },
    'chromaticitychannel4' => { 27 => 0x24 },
    'chromaticitychannels' => { 27 => 0x8 },
    'chromaticitycolorant' => { 27 => 0xa },
    'city' => { 33 => 0x5a, 58 => 'City' },
    'cleanfaxdata' => { 23 => 0x147 },
    'clippath' => { 23 => 0x157 },
    'cmmflags' => { 29 => 0x2c },
    'codedcharacterset' => { 34 => 0x5a },
    'codingmethods' => { 23 => 0x193 },
    'coloradjustment' => { 55 => 0x14 },
    'coloradjustmentmode' => { 54 => 0x210 },
    'colorant1coordinates' => { 28 => 0x2c },
    'colorant1name' => { 28 => 0xc },
    'colorant2coordinates' => { 28 => 0x52 },
    'colorant2name' => { 28 => 0x32 },
    'colorant3coordinates' => { 28 => 0x78 },
    'colorant3name' => { 28 => 0x58 },
    'colorantcount' => { 28 => 0x8 },
    'colorantorder' => { 30 => 'clro' },
    'coloranttable' => { 30 => 'clrt' },
    'colorbalance1' => { 45 => 0xc },
    'colorbalance2dh' => { 45 => 0x97 },
    'colorbalanceblue' => { 40 => 0x1e },
    'colorbalanced100' => { 45 => 0x97 },
    'colorbalanced70' => { 45 => 0x97 },
    'colorbalancegreen' => { 40 => 0x1d },
    'colorbalancered' => { 40 => 0x1c },
    'colorbalanceunknown' => { 45 => 0x97 },
    'colorbitdepth' => { 16 => 0x5 },
    'colorbw' => { 16 => 0x6 },
    'coloreffect' => { 49 => 0x28 },
    'colorfilter' => { 40 => 0x29 },
    'colorhue' => { 45 => 0x8d },
    'colormap' => { 23 => 0x140 },
    'colormatrix' => { 1 => 0xa },
    'colormatrix1' => { 23 => 0xc621 },
    'colormatrix2' => { 23 => 0xc622 },
    'colormode' => { 22 => 0x3015, 40 => 0x28, 41 => 0x101, 45 => 0x3 },
    'colornoisereduction' => { 58 => 'ColorNoiseReduction' },
    'colorrepresentation' => { 36 => 0x3c },
    'colorsequence' => { 36 => 0x41 },
    'colorspace' => { 17 => 0x10b4, 23 => 0xa001, 55 => 0xb, 58 => 'ColorSpace' },
    'colorspacedata' => { 29 => 0x10 },
    'colortemperature' => { 1 => 0x9 },
    'colortone' => { 0 => 0x2a },
    'comment' => { 60 => 'Comment' },
    'componentbitdepth' => { 16 => 0x4 },
    'componentsconfiguration' => { 23 => 0x9101, 58 => 'ComponentsConfiguration' },
    'componentversion' => { 17 => 0x80c },
    'compressedbitsperpixel' => { 23 => 0x9102, 58 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 41 => 0x40 },
    'compression' => { 23 => 0x103, 47 => 0x103, 58 => 'Compression' },
    'conditionalfec' => { 59 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 38 => 0xa },
    'consecutivebadfaxlines' => { 23 => 0x148 },
    'contact' => { 33 => 0x76 },
    'contentlocationcode' => { 33 => 0x1a },
    'contentlocationname' => { 33 => 0x1b },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 21 => 0xc, 22 => 0x20, 23 => 0xa408, 24 => 0x1004, 40 => 0x20, 49 => 0x2c, 50 => 0x20, 55 => 0xd, 58 => 'Contrast' },
    'contributor' => { 58 => 'Contributor' },
    'copyright' => { 23 => 0x8298, 30 => 'cprt', 58 => 'Copyright' },
    'copyrightnotice' => { 33 => 0x74 },
    'country' => { 58 => 'Country' },
    'country-primarylocationcode' => { 33 => 0x64 },
    'country-primarylocationname' => { 33 => 0x65 },
    'coverage' => { 58 => 'Coverage' },
    'crdinfo' => { 30 => 'crdi' },
    'createdate' => { 23 => 0x9004, 58 => 'CreateDate' },
    'creationdate' => { 58 => 'CreationDate' },
    'creator' => { 58 => 'Creator' },
    'creatortool' => { 58 => 'CreatorTool' },
    'credit' => { 33 => 0x6e, 58 => 'Credit' },
    'customrendered' => { 23 => 0xa401, 58 => 'CustomRendered' },
    'datacompressionmethod' => { 36 => 0x6e },
    'datadump' => { 45 => 0x10, 48 => 0xf00, 49 => 0x21, 54 => 0xf00 },
    'date' => { 58 => 'Date' },
    'datecreated' => { 33 => 0x37, 58 => 'DateCreated' },
    'datesent' => { 34 => 0x46 },
    'datetime' => { 58 => 'DateTime' },
    'datetimecreated' => { 59 => 'DateTimeCreated' },
    'datetimedigitized' => { 58 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 20 => 0x0, 23 => 0x9003, 58 => 'DateTimeOriginal', 59 => 'DateTimeOriginal' },
    'decode' => { 23 => 0x1b1 },
    'decodertable' => { 17 => 0x1835 },
    'decposition' => { 40 => 0x32 },
    'defaultcroporigin' => { 23 => 0xc61f },
    'defaultcropsize' => { 23 => 0xc620 },
    'defaultimagecolor' => { 23 => 0x1b2 },
    'defaultscale' => { 23 => 0xc61e },
    'derivedfrom' => { 58 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 58 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 58 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 58 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 58 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 58 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 58 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 58 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 58 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 58 => 'DerivedFromVersionID' },
    'description' => { 58 => 'Description' },
    'destination' => { 34 => 0x5 },
    'deviceattributes' => { 29 => 0x38 },
    'devicemanufacturer' => { 29 => 0x30 },
    'devicemfgdesc' => { 30 => 'dmnd' },
    'devicemodel' => { 29 => 0x34 },
    'devicemodeldesc' => { 30 => 'dmdd' },
    'devicesettingdescription' => { 23 => 0xa40b, 58 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 58 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 58 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 58 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 30 => 'devs' },
    'digitalcreationdate' => { 33 => 0x3e },
    'digitalcreationtime' => { 33 => 0x3f },
    'digitalzoom' => { 0 => 0xc, 21 => 0xa, 40 => 0xc, 45 => 0x86, 48 => 0x204, 50 => 0x1e, 54 => 0x204 },
    'digitalzoomon' => { 54 => 0x21b },
    'digitalzoomratio' => { 23 => 0xa404, 58 => 'DigitalZoomRatio' },
    'dngbackwardversion' => { 23 => 0xc613 },
    'dngcameraserialnumber' => { 23 => 0xc62f },
    'dnglensinfo' => { 23 => 0xc630 },
    'dngprivatedata' => { 23 => 0xc634 },
    'dngversion' => { 23 => 0xc612 },
    'documentid' => { 58 => 'DocumentID' },
    'documentname' => { 23 => 0x10d },
    'dotrange' => { 23 => 0x150 },
    'drivemode' => { 40 => 0x6, 55 => 0x3, 59 => 'DriveMode' },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 33 => 0x8 },
    'editstatus' => { 33 => 0x7 },
    'endpoints' => { 36 => 0x7d },
    'enhancement' => { 22 => 0x3016 },
    'envelopenumber' => { 34 => 0x28 },
    'envelopepriority' => { 34 => 0x3c },
    'enveloperecordversion' => { 34 => 0x0 },
    'epsonimageheight' => { 48 => 0x20c },
    'epsonimagewidth' => { 48 => 0x20b },
    'epsonsoftware' => { 48 => 0x20d },
    'error' => { 60 => 'Error' },
    'ettlii' => { 12 => 0xd },
    'excursiontolerance' => { 36 => 0x82 },
    'exifdata' => { 60 => 'ExifData' },
    'exifimageheight' => { 58 => 'PixelYDimension' },
    'exifimagelength' => { 23 => 0xa003 },
    'exifimagewidth' => { 23 => 0xa002, 58 => 'PixelXDimension' },
    'exifinformation' => { 17 => 0x300b },
    'exifoffset' => { 23 => 0x8769 },
    'exiftoolversion' => { 60 => 'ExifToolVersion' },
    'exifversion' => { 23 => 0x9000, 58 => 'ExifVersion' },
    'expirationdate' => { 33 => 0x25 },
    'expirationtime' => { 33 => 0x26 },
    'exposure' => { 58 => 'Exposure' },
    'exposurebracketvalue' => { 45 => 0x19 },
    'exposurecompensation' => { 7 => 0x6, 13 => 0x0, 23 => 0x9204, 40 => 0xd, 55 => 0xc, 58 => 'ExposureBiasValue' },
    'exposureindex' => { 23 => [0x9215,0xa215], 58 => 'ExposureIndex' },
    'exposureinfo' => { 17 => 0x1818 },
    'exposurelevelincrements' => { 9 => 0x4, 10 => 0x6, 11 => 0x6, 12 => 0x5 },
    'exposuremode' => { 23 => 0xa402, 40 => 0x1, 55 => 0x8, 58 => 'ExposureMode' },
    'exposureprogram' => { 23 => 0x8822, 58 => 'ExposureProgram' },
    'exposuretime' => { 7 => 0x16, 23 => 0x829a, 58 => 'ExposureTime' },
    'exposurewarning' => { 24 => 0x1302 },
    'extrasamples' => { 23 => 0x152 },
    'faxprofile' => { 23 => 0x192 },
    'fileformat' => { 15 => 0x0, 34 => 0x14 },
    'filename' => { 60 => 'FileName' },
    'filenumber' => { 2 => 0x1, 4 => 0x8, 17 => 0x1817 },
    'filenumbermemory' => { 40 => 0x1a },
    'filesize' => { 60 => 'FileSize' },
    'filesource' => { 23 => 0xa300, 58 => 'FileSource' },
    'filesystemversion' => { 45 => 0x1 },
    'filetype' => { 60 => 'FileType' },
    'fileversion' => { 34 => 0x16 },
    'fillflashautoreduction' => { 9 => 0xa, 10 => 0xe, 11 => 0xe },
    'fillorder' => { 23 => 0x10a },
    'filter' => { 22 => 0x3017 },
    'finderdisplayduringexposure' => { 11 => 0x1 },
    'firmware' => { 55 => 0x17 },
    'firmwareversion' => { 49 => 0x2 },
    'fixtureidentifier' => { 33 => 0x16 },
    'flash' => { 23 => 0x9209, 58 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 49 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdistance' => { 22 => 0x2034 },
    'flashenergy' => { 23 => [0x920b,0xa20b], 58 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 45 => 0x18 },
    'flashexposurecomp' => { 7 => 0xf, 40 => 0x23, 45 => 0x12 },
    'flashfired' => { 40 => 0x14, 58 => 'FlashFired' },
    'flashfiring' => { 12 => 0x6 },
    'flashfunction' => { 58 => 'FlashFunction' },
    'flashguidenumber' => { 14 => 0x0 },
    'flashinfo' => { 17 => 0x1813 },
    'flashintensity' => { 21 => 0x5 },
    'flashmode' => { 21 => 0x4, 40 => 0x2, 45 => 0x87, 54 => 0x225, 58 => 'FlashMode' },
    'flashon' => { 59 => 'FlashOn' },
    'flashpixversion' => { 23 => 0xa000, 58 => 'FlashpixVersion' },
    'flashredeyemode' => { 58 => 'FlashRedEyeMode' },
    'flashreturn' => { 58 => 'FlashReturn' },
    'flashsetting' => { 45 => 0x8 },
    'flashstrength' => { 24 => 0x1011 },
    'flashsyncspeedav' => { 9 => 0x6, 10 => 0x3, 12 => 0x2 },
    'flashthreshold' => { 14 => 0x1 },
    'flashtype' => { 45 => 0x9, 59 => 'FlashType' },
    'flickerreduce' => { 54 => 0x218 },
    'fnumber' => { 7 => 0x15, 23 => 0x829d, 58 => 'FNumber' },
    'focallength' => { 3 => 0x1, 22 => 0x1d, 23 => 0x920a, 40 => 0x12, 50 => 0x1d, 58 => 'FocalLength' },
    'focallength35efl' => { 59 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 23 => 0xa405, 58 => 'FocalLengthIn35mmFilm' },
    'focalplaneresolutionunit' => { 23 => [0x9210,0xa210], 58 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 23 => [0x920e,0xa20e], 58 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 3 => 0x2 },
    'focalplaneyresolution' => { 23 => [0x920f,0xa20f], 58 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 3 => 0x3 },
    'focalunits' => { 0 => 0x19 },
    'focusarea' => { 40 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 40 => 0x13 },
    'focusdistancelower' => { 7 => 0x14 },
    'focusdistanceupper' => { 7 => 0x13 },
    'focusingscreen' => { 11 => 0x0 },
    'focusmode' => { 0 => 0x7, 21 => 0x3, 22 => [0x3003,0xd], 24 => 0x1021, 40 => 0x30, 45 => 0x7, 49 => 0x7, 50 => 0xd },
    'focussetting' => { 55 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 24 => 0x1301 },
    'foldername' => { 40 => 0x27 },
    'format' => { 58 => 'Format' },
    'freebytecounts' => { 23 => 0x121 },
    'freebytes' => { 17 => 0x1 },
    'freeoffsets' => { 23 => 0x120 },
    'fujiflashmode' => { 24 => 0x1010 },
    'gaincontrol' => { 23 => 0xa407, 58 => 'GainControl' },
    'gamut' => { 30 => 'gamt' },
    'gdalmetadata' => { 23 => 0xa480 },
    'gdalnodata' => { 23 => 0xa481 },
    'geogangularunits' => { 26 => 0x806 },
    'geogangularunitsize' => { 26 => 0x807 },
    'geogazimuthunits' => { 26 => 0x80c },
    'geogcitation' => { 26 => 0x801 },
    'geogellipsoid' => { 26 => 0x808 },
    'geoggeodeticdatum' => { 26 => 0x802 },
    'geoginvflattening' => { 26 => 0x80b },
    'geoglinearunits' => { 26 => 0x804 },
    'geoglinearunitsize' => { 26 => 0x805 },
    'geogprimemeridian' => { 26 => 0x803 },
    'geogprimemeridianlong' => { 26 => 0x80d },
    'geographictype' => { 26 => 0x800 },
    'geogsemimajoraxis' => { 26 => 0x809 },
    'geogsemiminoraxis' => { 26 => 0x80a },
    'geotiffasciiparams' => { 23 => 0x87b1 },
    'geotiffdirectory' => { 23 => 0x87af },
    'geotiffdoubleparams' => { 23 => 0x87b0 },
    'geotiffversion' => { 26 => 0x1 },
    'globalparametersifd' => { 23 => 0x190 },
    'gpsaltitude' => { 25 => 0x6, 58 => 'GPSAltitude' },
    'gpsaltituderef' => { 25 => 0x5, 58 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 25 => 0x1c, 58 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 25 => 0x1d },
    'gpsdatetime' => { 59 => 'GPSDateTime' },
    'gpsdestbearing' => { 25 => 0x18, 58 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 25 => 0x17, 58 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 25 => 0x1a, 58 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 25 => 0x19, 58 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 25 => 0x14, 58 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 25 => 0x13 },
    'gpsdestlongitude' => { 25 => 0x16, 58 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 25 => 0x15 },
    'gpsdifferential' => { 25 => 0x1e, 58 => 'GPSDifferential' },
    'gpsdop' => { 25 => 0xb },
    'gpsimgdirection' => { 25 => 0x11, 58 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 25 => 0x10, 58 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 23 => 0x8825 },
    'gpslatitude' => { 25 => 0x2, 58 => 'GPSLatitude' },
    'gpslatituderef' => { 25 => 0x1 },
    'gpslongitude' => { 25 => 0x4, 58 => 'GPSLongitude' },
    'gpslongituderef' => { 25 => 0x3 },
    'gpsmapdatum' => { 25 => 0x12, 58 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 25 => 0xa },
    'gpsprocessingmethod' => { 25 => 0x1b, 58 => 'GPSProcessingMethod' },
    'gpssatellites' => { 25 => 0x8, 58 => 'GPSSatellites' },
    'gpsspeed' => { 25 => 0xd, 58 => 'GPSSpeed' },
    'gpsspeedref' => { 25 => 0xc, 58 => 'GPSSpeedRef' },
    'gpsstatus' => { 25 => 0x9, 58 => 'GPSStatus' },
    'gpstimestamp' => { 25 => 0x7, 58 => 'GPSTimeStamp' },
    'gpstrack' => { 25 => 0xf, 58 => 'GPSTrack' },
    'gpstrackref' => { 25 => 0xe, 58 => 'GPSTrackRef' },
    'gpsversionid' => { 25 => 0x0, 58 => 'GPSVersionID' },
    'grayresponsecurve' => { 23 => 0x123 },
    'grayresponseunit' => { 23 => 0x122 },
    'graytrc' => { 30 => 'kTRC' },
    'greenhue' => { 58 => 'GreenHue' },
    'greenmatrixcolumn' => { 30 => 'gXYZ' },
    'greensaturation' => { 58 => 'GreenSaturation' },
    'greentrc' => { 30 => 'gTRC' },
    'gtcitation' => { 26 => 0x402 },
    'gtmodeltype' => { 26 => 0x400 },
    'gtrastertype' => { 26 => 0x401 },
    'halftonehints' => { 23 => 0x141 },
    'headline' => { 33 => 0x69, 58 => 'Headline' },
    'highlight' => { 55 => 0xf },
    'history' => { 58 => 'History' },
    'historyaction' => { 58 => 'HistoryAction' },
    'historyinstanceid' => { 58 => 'HistoryInstanceID' },
    'historyparameters' => { 58 => 'HistoryParameters' },
    'historysoftwareagent' => { 58 => 'HistorySoftwareAgent' },
    'historywhen' => { 58 => 'HistoryWhen' },
    'hostcomputer' => { 23 => 0x13c },
    'hueadjustment' => { 45 => 0x92 },
    'icc_profile' => { 23 => 0x8773 },
    'identifier' => { 58 => 'Identifier' },
    'ifd0_offset' => { 46 => 0x1 },
    'imageadjustment' => { 45 => 0x80 },
    'imageboundry' => { 45 => 0x16 },
    'imagedescription' => { 17 => 0x2804, 23 => 0x10e, 58 => 'ImageDescription' },
    'imageformat' => { 17 => 0x1803 },
    'imageheight' => { 16 => 0x1, 23 => 0x101, 58 => 'ImageLength', 60 => 'ImageHeight' },
    'imagehistory' => { 23 => [0x9213,0xa213] },
    'imageid' => { 23 => 0x800d },
    'imageinfo' => { 17 => 0x1810 },
    'imagelayer' => { 23 => 0x87ac },
    'imagenumber' => { 23 => [0x9211,0xa211] },
    'imageoptimization' => { 45 => 0xa9 },
    'imageorientation' => { 33 => 0x83 },
    'imageprops' => { 17 => 0x300a },
    'imagequality' => { 49 => 0x1 },
    'imagesize' => { 59 => 'ImageSize' },
    'imagesourcedata' => { 23 => 0x935c },
    'imagestabilization' => { 41 => 0x18 },
    'imagestabilizer' => { 49 => 0x1a },
    'imagetype' => { 33 => 0x82 },
    'imageuniqueid' => { 23 => 0xa420, 58 => 'ImageUniqueID' },
    'imagewidth' => { 16 => 0x0, 23 => 0x100, 58 => 'ImageWidth', 60 => 'ImageWidth' },
    'indexed' => { 23 => 0x15a },
    'inknames' => { 23 => 0x14d },
    'inkset' => { 23 => 0x14c },
    'instructions' => { 58 => 'Instructions' },
    'interchangecolorspace' => { 36 => 0x40 },
    'intergraphflagregisters' => { 23 => 0x847f },
    'intergraphmatrix' => { 23 => 0x8480 },
    'intergraphpacketdata' => { 23 => 0x8474 },
    'interlace' => { 23 => 0x8829 },
    'internalflash' => { 40 => 0x2b },
    'interopindex' => { 23 => 0x1 },
    'interopoffset' => { 23 => 0xa005 },
    'interopversion' => { 23 => 0x2 },
    'intervallength' => { 40 => 0x10 },
    'intervalmode' => { 40 => 0x26 },
    'intervalnumber' => { 40 => 0x11 },
    'iptc-naa' => { 23 => 0x83bb },
    'iptc-naa2' => { 23 => 0x8568 },
    'iptcapplication' => { 35 => 0x2 },
    'iptcbitspersample' => { 36 => 0x56 },
    'iptcdata' => { 52 => 0x404 },
    'iptcenvelope' => { 35 => 0x1 },
    'iptcimageheight' => { 36 => 0x1e },
    'iptcimagerotation' => { 36 => 0x66 },
    'iptcimagewidth' => { 36 => 0x14 },
    'iptcnewsphoto' => { 35 => 0x3 },
    'iptcobjectdata' => { 35 => 0x8 },
    'iptcpicturenumber' => { 36 => 0xa },
    'iptcpixelheight' => { 36 => 0x32 },
    'iptcpixelwidth' => { 36 => 0x28 },
    'iptcpostobjectdata' => { 35 => 0x9 },
    'iptcpreobjectdata' => { 35 => 0x7 },
    'iso' => { 7 => 0x2, 23 => 0x8827, 45 => 0x2, 58 => 'ISOSpeedRatings' },
    'isoexpansion' => { 12 => 0x7 },
    'isoselection' => { 45 => 0xf },
    'isosetting' => { 22 => 0x14, 40 => 0x24, 45 => 0x13 },
    'isospeedexpansion' => { 11 => 0x3 },
    'ixusafpoint' => { 7 => 0xe },
    'jobref' => { 58 => 'JobRef' },
    'jobrefid' => { 58 => 'JobRefId' },
    'jobrefname' => { 58 => 'JobRefName' },
    'jobrefurl' => { 58 => 'JobRefUrl' },
    'jpeg_quality' => { 52 => 0x406 },
    'jpegactables' => { 23 => 0x209 },
    'jpegdctables' => { 23 => 0x208 },
    'jpeglosslesspredictors' => { 23 => 0x205 },
    'jpegpointtransforms' => { 23 => 0x206 },
    'jpegproc' => { 23 => 0x200 },
    'jpegqtables' => { 23 => 0x207 },
    'jpegrestartinterval' => { 23 => 0x203 },
    'jpegtables' => { 23 => 0x15b },
    'jpgfromraw' => { 17 => 0x2007, 59 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 23 => 0x202 },
    'jpgfromrawstart' => { 23 => 0x201 },
    'keywords' => { 33 => 0x19, 58 => 'Keywords' },
    'language' => { 58 => 'Language' },
    'languageidentifier' => { 33 => 0x87 },
    'lastfilenumber' => { 40 => 0x1b },
    'lasturl' => { 58 => 'LastURL' },
    'lcdpanels' => { 11 => 0x8 },
    'lens' => { 45 => 0x84, 55 => 0xa, 58 => 'Lens', 59 => 'Lens' },
    'lens35efl' => { 59 => 'Lens35efl' },
    'lensafstopbutton' => { 9 => 0x9, 10 => 0x11, 11 => 0x13, 12 => 0x10 },
    'lenstype' => { 0 => 0x16, 45 => 0x83, 50 => 0x3f },
    'lightsource' => { 23 => 0x9208, 45 => 0x90, 58 => 'LightSource' },
    'lightsourcespecial' => { 54 => 0x21d },
    'linearizationtable' => { 23 => 0xc618 },
    'linearresponselimit' => { 23 => 0xc62e },
    'localizedcameramodel' => { 23 => 0xc615 },
    'longexposurenoisereduction' => { 9 => 0x1, 12 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'luminance' => { 30 => 'lumi' },
    'luminancesmoothing' => { 58 => 'LuminanceSmoothing' },
    'macro' => { 24 => 0x1020, 48 => 0x202, 54 => 0x202 },
    'macromode' => { 0 => 0x1, 40 => 0xb, 49 => 0x1c },
    'make' => { 18 => 0x0, 23 => 0x10f, 58 => 'Make' },
    'makeandmodel' => { 30 => 'mmod' },
    'makernote' => { 58 => 'MakerNote' },
    'makernotecanon' => { 23 => 0x927c },
    'makernotecasio' => { 23 => 0x927c },
    'makernotecasio2' => { 23 => 0x927c },
    'makernotefujifilm' => { 23 => 0x927c },
    'makernoteleica' => { 23 => 0x927c },
    'makernoteminolta' => { 23 => 0x927c },
    'makernotenikon' => { 23 => 0x927c },
    'makernoteoffset' => { 54 => 0xff },
    'makernoteolympus' => { 23 => 0x927c },
    'makernotepanasonic' => { 23 => 0x927c },
    'makernotepentax' => { 23 => 0x927c },
    'makernotesafety' => { 23 => 0xc635 },
    'makernotesanyo' => { 23 => 0x927c },
    'makernotesigma' => { 23 => 0x927c },
    'makernotesony' => { 23 => 0x927c },
    'makernoteunknown' => { 23 => 0x927c },
    'makernoteversion' => { 41 => 0x0 },
    'managedfrom' => { 58 => 'ManagedFrom' },
    'managedfromdocumentid' => { 58 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 58 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 58 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 58 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 58 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 58 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 58 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 58 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 58 => 'ManagedFromVersionID' },
    'manager' => { 58 => 'Manager' },
    'managervariant' => { 58 => 'ManagerVariant' },
    'manageto' => { 58 => 'ManageTo' },
    'manageui' => { 58 => 'ManageUI' },
    'manualfocusdistance' => { 45 => 0x85, 54 => 0x223 },
    'manualtv' => { 11 => 0x5 },
    'marked' => { 58 => 'Marked' },
    'maxaperture' => { 40 => 0x17 },
    'maxaperturevalue' => { 23 => 0x9205, 58 => 'MaxApertureValue' },
    'maximumobjectsize' => { 39 => 0x5f },
    'maxsamplevalue' => { 23 => 0x119 },
    'maxsubfilesize' => { 39 => 0x14 },
    'measuredev' => { 17 => 0x1814 },
    'measuredinfo' => { 17 => 0x3003 },
    'measurement' => { 30 => 'meas' },
    'measurementbacking' => { 31 => 0xc },
    'measurementflare' => { 31 => 0x1c },
    'measurementgeometry' => { 31 => 0x18 },
    'measurementilluminant' => { 31 => 0x20 },
    'measurementobserver' => { 31 => 0x8 },
    'mediablackpoint' => { 30 => 'bkpt' },
    'mediawhitepoint' => { 30 => 'wtpt' },
    'menubuttondisplayposition' => { 10 => 0xb, 12 => 0xa },
    'menubuttonreturn' => { 9 => 0xb },
    'metadatadate' => { 58 => 'MetadataDate' },
    'meteringmode' => { 0 => 0x11, 23 => 0x9207, 40 => 0x7, 50 => 0x17, 55 => 0x9, 58 => 'MeteringMode' },
    'minoltaaperture' => { 40 => 0xa },
    'minoltacamerasettings' => { 41 => 0x3 },
    'minoltacamerasettings2' => { 41 => 0xf00 },
    'minoltacamerasettingsold' => { 41 => 0x1 },
    'minoltadate' => { 40 => 0x15 },
    'minoltaimagesize' => { 40 => 0x4 },
    'minoltaiso' => { 40 => 0x8 },
    'minoltamodel' => { 40 => 0x25 },
    'minoltaquality' => { 40 => 0x5, 41 => [0x102,0x103] },
    'minoltashutterspeed' => { 40 => 0x9 },
    'minoltatime' => { 40 => 0x16 },
    'minsamplevalue' => { 23 => 0x118 },
    'mirrorlockup' => { 9 => 0x3, 10 => 0xc, 11 => 0xc, 12 => 0xb },
    'moddate' => { 58 => 'ModDate' },
    'model' => { 18 => 0x6, 23 => 0x110, 58 => 'Model' },
    'model2' => { 23 => 0x827d },
    'modeltiepoint' => { 23 => 0x8482 },
    'modeltransform' => { 23 => 0x85d8 },
    'modenumber' => { 23 => 0x195 },
    'modifydate' => { 23 => 0x132, 58 => 'ModifyDate' },
    'namedcolor' => { 30 => 'ncol' },
    'namedcolor2' => { 30 => 'ncl2' },
    'nativedisplayinfo' => { 30 => 'ndin' },
    'nefcurve1' => { 45 => 0x8c },
    'nefcurve2' => { 45 => 0x96 },
    'nefthumbnailsize' => { 45 => 0x99 },
    'newsphotoversion' => { 36 => 0x0 },
    'nickname' => { 58 => 'Nickname' },
    'nikoncaptureoffsets' => { 45 => 0xe0e },
    'nikonpreview' => { 45 => 0x11 },
    'noise' => { 23 => [0x920d,0xa20d] },
    'noisereduction' => { 45 => 0x95, 49 => 0x2d },
    'nullrecord' => { 17 => 0x0 },
    'numberofinks' => { 23 => 0x14e },
    'numindexentries' => { 36 => 0x54 },
    'objectattributereference' => { 33 => 0x4 },
    'objectcycle' => { 33 => 0x4b },
    'objectdistance' => { 21 => 0x6, 22 => 0x2022 },
    'objectname' => { 33 => 0x5 },
    'objectpreviewdata' => { 33 => 0xca },
    'objectpreviewfileformat' => { 33 => 0xc8 },
    'objectpreviewfileversion' => { 33 => 0xc9 },
    'objectsizeannounced' => { 39 => 0x5a },
    'objecttypereference' => { 33 => 0x3 },
    'oceapplicationselector' => { 23 => 0xc428 },
    'oceidnumber' => { 23 => 0xc429 },
    'oceimagelogic' => { 23 => 0xc42a },
    'ocescanjobdesc' => { 23 => 0xc427 },
    'oecfcolumns' => { 58 => 'OECFColumns' },
    'oecfnames' => { 58 => 'OECFNames' },
    'oecfrows' => { 58 => 'OECFRows' },
    'oecfvalues' => { 58 => 'OECFValues' },
    'oldsubfiletype' => { 23 => 0xff },
    'opiproxy' => { 23 => 0x15f },
    'opticalzoomon' => { 54 => 0x219 },
    'opto-electricconvfactor' => { 23 => 0x8828, 58 => 'OECF' },
    'orientation' => { 23 => 0x112, 58 => 'Orientation' },
    'originalfilename' => { 17 => 0x816 },
    'originaltransmissionreference' => { 33 => 0x67 },
    'originatingprogram' => { 33 => 0x41 },
    'outputresponse' => { 30 => 'resp' },
    'owner' => { 58 => 'Owner' },
    'ownername' => { 4 => 0x9, 17 => 0x810 },
    'pagename' => { 23 => 0x11d },
    'pagenumber' => { 23 => 0x129 },
    'pcscitation' => { 26 => 0xc01 },
    'pdfversion' => { 58 => 'PDFVersion' },
    'pentaximagesize' => { 50 => 0x9 },
    'pentaxiso' => { 50 => 0x14 },
    'pentaxmode' => { 50 => 0x1 },
    'photometricinterpretation' => { 23 => 0x106, 58 => 'PhotometricInterpretation' },
    'photoshopformat' => { 51 => 0x1 },
    'photoshopquality' => { 51 => 0x0 },
    'photoshopsettings' => { 23 => 0x8649 },
    'photoshopthumbnail' => { 52 => 0x40c },
    'pictinfo' => { 48 => 0x208, 54 => 0x208 },
    'picturemode' => { 24 => 0x1031, 50 => 0xb },
    'pixelaspectratio' => { 16 => 0x2 },
    'pixelscale' => { 23 => 0x830e },
    'planarconfiguration' => { 23 => 0x11c, 58 => 'PlanarConfiguration' },
    'postscript2crd0' => { 30 => 'psd0' },
    'postscript2crd1' => { 30 => 'psd1' },
    'postscript2crd2' => { 30 => 'psd2' },
    'postscript2csa' => { 30 => 'ps2s' },
    'predictor' => { 23 => 0x13d },
    'preview0' => { 30 => 'pre0' },
    'preview1' => { 30 => 'pre1' },
    'preview2' => { 30 => 'pre2' },
    'previewfocalplanexresolution' => { 6 => 0x6 },
    'previewfocalplaneyresolution' => { 6 => 0x8 },
    'previewifd_offset' => { 46 => 0x2 },
    'previewimage' => { 22 => 0x2000, 59 => 'PreviewImage', 60 => 'PreviewImage' },
    'previewimagedata' => { 41 => 0x81 },
    'previewimageheight' => { 6 => 0x4 },
    'previewimageinfo' => { 4 => 0xb6 },
    'previewimagelength' => { 6 => 0x2, 23 => 0x202, 41 => 0x89, 47 => 0x202, 50 => 0x3 },
    'previewimagesize' => { 22 => 0x2, 50 => 0x2, 59 => 'PreviewImageSize' },
    'previewimagestart' => { 6 => 0x5, 23 => 0x201, 41 => 0x88, 47 => 0x201, 50 => 0x4 },
    'previewimagewidth' => { 6 => 0x3 },
    'primarychromaticities' => { 23 => 0x13f, 58 => 'PrimaryChromaticities' },
    'primaryplatform' => { 29 => 0x28 },
    'printim' => { 22 => 0xe00, 23 => 0xc4a5, 41 => 0xe00, 45 => 0xe00, 49 => 0xe00, 50 => 0xe00, 54 => 0xe00, 56 => 0xe00, 57 => 0xe00 },
    'processgeotiffdirectory' => { 59 => 'ProcessGeoTiffDirectory' },
    'producer' => { 58 => 'Producer' },
    'productid' => { 34 => 0x32 },
    'profileclass' => { 29 => 0xc },
    'profilecmmtype' => { 29 => 0x4 },
    'profileconnectionspace' => { 29 => [0x14,0x44] },
    'profilecreator' => { 29 => 0x50 },
    'profiledatetime' => { 29 => 0x18 },
    'profiledescription' => { 30 => 'desc' },
    'profiledescriptionml' => { 30 => 'dscm' },
    'profilefilesignature' => { 29 => 0x24 },
    'profileheader' => { 30 => 'Header' },
    'profileid' => { 29 => 0x54 },
    'profilesequencedesc' => { 30 => 'pseq' },
    'profiletype' => { 23 => 0x191 },
    'profileversion' => { 29 => 0x8 },
    'programversion' => { 33 => 0x46 },
    'progressivescans' => { 51 => 0x2 },
    'projazimuthangle' => { 26 => 0xc16 },
    'projcentereasting' => { 26 => 0xc12 },
    'projcenterlat' => { 26 => 0xc11 },
    'projcenterlong' => { 26 => 0xc10 },
    'projcenternorthing' => { 26 => 0xc13 },
    'projcoordtrans' => { 26 => 0xc03 },
    'projectedcstype' => { 26 => 0xc00 },
    'projection' => { 26 => 0xc02 },
    'projfalseeasting' => { 26 => 0xc0a },
    'projfalsenorthing' => { 26 => 0xc0b },
    'projfalseorigineasting' => { 26 => 0xc0e },
    'projfalseoriginlat' => { 26 => 0xc0d },
    'projfalseoriginlong' => { 26 => 0xc0c },
    'projfalseoriginnorthing' => { 26 => 0xc0f },
    'projlinearunits' => { 26 => 0xc04 },
    'projlinearunitsize' => { 26 => 0xc05 },
    'projnatoriginlat' => { 26 => 0xc09 },
    'projnatoriginlong' => { 26 => 0xc08 },
    'projrectifiedgridangle' => { 26 => 0xc18 },
    'projscaleatcenter' => { 26 => 0xc15 },
    'projscaleatnatorigin' => { 26 => 0xc14 },
    'projstdparallel1' => { 26 => 0xc06 },
    'projstdparallel2' => { 26 => 0xc07 },
    'projstraightvertpolelong' => { 26 => 0xc17 },
    'province-state' => { 33 => 0x5f },
    'ps2crdvmsize' => { 30 => 'psvm' },
    'ps2renteringintent' => { 30 => 'ps2i' },
    'publisher' => { 58 => 'Publisher' },
    'quality' => { 0 => 0x3, 21 => 0x2, 22 => 0x3002, 24 => 0x1000, 45 => 0x4, 48 => 0x201, 50 => 0x8, 55 => 0x16 },
    'qualitymode' => { 22 => 0x8 },
    'quantizationmethod' => { 36 => 0x78 },
    'quickshot' => { 54 => 0x213 },
    'rasterizedcaption' => { 33 => 0x7d },
    'rawandjpgrecording' => { 10 => 0x8 },
    'rawdata' => { 17 => 0x2005 },
    'rawfilename' => { 58 => 'RawFileName' },
    'rawimagesize' => { 50 => 0x39 },
    'recordid' => { 17 => 0x1804 },
    'recordingmode' => { 21 => 0x1 },
    'recordmode' => { 22 => 0x3000 },
    'recordshutterrelease' => { 54 => 0x217 },
    'redbalance' => { 42 => 0x0, 43 => 0x0, 44 => 0x0, 48 => 0x1017 },
    'redbalanceauto' => { 8 => 0x0 },
    'redbalanceb&w' => { 8 => 0xe },
    'redbalancecloudy' => { 8 => 0x4 },
    'redbalancecustom' => { 8 => 0xc },
    'redbalancedaylight' => { 8 => 0x2 },
    'redbalanceflash' => { 8 => 0xa },
    'redbalancefluorescent' => { 8 => 0x8 },
    'redbalanceshade' => { 8 => 0x10 },
    'redbalancetungsten' => { 8 => 0x6 },
    'redeyereduction' => { 59 => 'RedEyeReduction' },
    'redhue' => { 58 => 'RedHue' },
    'redmatrixcolumn' => { 30 => 'rXYZ' },
    'redsaturation' => { 58 => 'RedSaturation' },
    'redtrc' => { 30 => 'rTRC' },
    'reductionmatrix1' => { 23 => 0xc625 },
    'reductionmatrix2' => { 23 => 0xc626 },
    'referenceblackwhite' => { 23 => 0x214, 58 => 'ReferenceBlackWhite' },
    'referencedate' => { 33 => 0x2f },
    'referencenumber' => { 33 => 0x32 },
    'referenceservice' => { 33 => 0x2d },
    'relatedimagefileformat' => { 23 => 0x1000 },
    'relatedimagelength' => { 23 => 0x1002 },
    'relatedimagewidth' => { 23 => 0x1001 },
    'relatedsoundfile' => { 23 => 0xa004, 58 => 'RelatedSoundFile' },
    'relation' => { 58 => 'Relation' },
    'releasedate' => { 33 => 0x1e },
    'releasesetting' => { 17 => 0x1016 },
    'releasetime' => { 33 => 0x23 },
    'renderingintent' => { 29 => 0x40 },
    'renditionclass' => { 58 => 'RenditionClass' },
    'renditionof' => { 58 => 'RenditionOf' },
    'renditionofdocumentid' => { 58 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 58 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 58 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 58 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 58 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 58 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 58 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 58 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 58 => 'RenditionOfVersionID' },
    'renditionparams' => { 58 => 'RenditionParams' },
    'resaved' => { 54 => 0x21e },
    'resolutionmode' => { 55 => 0x4 },
    'resolutionunit' => { 23 => 0x128, 47 => 0x128, 58 => 'ResolutionUnit' },
    'rights' => { 58 => 'Rights' },
    'romoperationmode' => { 17 => 0x80d },
    'rotation' => { 16 => 0x3 },
    'rowsperstrip' => { 23 => 0x116 },
    'safetyshiftinavortv' => { 10 => 0x10, 11 => 0x10, 12 => 0xf },
    'sampleformat' => { 23 => 0x153 },
    'samplesperpixel' => { 23 => 0x115, 58 => 'SamplesPerPixel' },
    'samplestructure' => { 36 => 0x5a },
    'sanyoquality' => { 54 => 0x201 },
    'sanyothumbnail' => { 54 => 0x100 },
    'saturation' => { 0 => 0xe, 21 => 0xd, 22 => 0x1f, 23 => 0xa409, 24 => 0x1003, 40 => 0x1f, 45 => [0x94,0xaa], 50 => 0x1f, 55 => 0x10, 58 => 'Saturation' },
    'saveid' => { 58 => 'SaveID' },
    'scalefactor35efl' => { 59 => 'ScaleFactor35efl' },
    'scanningdirection' => { 36 => 0x64 },
    'scenecapturetype' => { 23 => 0xa406, 58 => 'SceneCaptureType' },
    'scenemode' => { 45 => 0x8f },
    'sceneselect' => { 54 => 0x21f },
    'scenetype' => { 23 => 0xa301, 58 => 'SceneType' },
    'screening' => { 30 => 'scrn' },
    'screeningdesc' => { 30 => 'scrd' },
    'securityclassification' => { 23 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 7 => 0x1d },
    'selftimer' => { 22 => 0x3001, 54 => 0x214 },
    'selftimermode' => { 23 => 0x882b },
    'selftimertime' => { 17 => 0x1806 },
    'sensingmethod' => { 23 => [0x9217,0xa217], 58 => 'SensingMethod' },
    'sensorbottomborder' => { 19 => 0x8 },
    'sensorcleaning' => { 9 => 0xd },
    'sensorheight' => { 19 => 0x2 },
    'sensorinfo' => { 17 => 0x1031 },
    'sensorleftborder' => { 19 => 0x5 },
    'sensorrightborder' => { 19 => 0x7 },
    'sensortopborder' => { 19 => 0x6 },
    'sensorwidth' => { 19 => 0x1 },
    'sequencenumber' => { 7 => 0x9 },
    'sequenceshotinterval' => { 54 => 0x224 },
    'sequentialshot' => { 54 => 0x20e },
    'serialnumber' => { 4 => 0xc, 17 => 0x180b, 45 => 0xa0, 49 => 0x25, 55 => 0x2, 58 => 'SerialNumber' },
    'serviceidentifier' => { 34 => 0x1e },
    'setbuttonfunction' => { 9 => 0xc, 10 => 0x1 },
    'setfunctionwhenshooting' => { 12 => 0x0 },
    'shadow' => { 55 => 0xe },
    'shadows' => { 58 => 'Shadows' },
    'shadowscale' => { 23 => 0xc633 },
    'shadowtint' => { 58 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 21 => 0xb, 22 => 0x21, 23 => 0xa40a, 24 => 0x1001, 40 => 0x21, 45 => 0x6, 50 => 0x21, 55 => 0x11, 58 => 'Sharpness' },
    'shootingmode' => { 45 => 0x89, 49 => 0x1f, 59 => 'ShootingMode' },
    'shootingrecord' => { 17 => 0x3002 },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 9 => 0x2, 10 => 0x4, 12 => 0x3 },
    'shutteraelbutton' => { 11 => 0x4 },
    'shuttercount' => { 45 => 0xa7 },
    'shuttercurtainhack' => { 59 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 9 => 0x8, 10 => 0xf, 11 => 0xf, 12 => 0xe },
    'shutterreleasemethod' => { 17 => 0x1010 },
    'shutterreleasenocfcard' => { 9 => 0xf, 10 => 0x2, 11 => 0x2 },
    'shutterreleasetiming' => { 17 => 0x1011 },
    'shutterspeed' => { 59 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 23 => 0x9201, 58 => 'ShutterSpeedValue' },
    'sizemode' => { 39 => 0xa },
    'slowsync' => { 24 => 0x1030 },
    'smaxsamplevalue' => { 23 => 0x155 },
    'sminsamplevalue' => { 23 => 0x154 },
    'software' => { 23 => 0x131, 55 => 0x18, 58 => 'Software' },
    'softwarerelease' => { 48 => 0x207 },
    'softwareversion' => { 54 => 0x207 },
    'source' => { 33 => 0x73, 58 => 'Source' },
    'spatialfrequencyresponse' => { 23 => [0x920c,0xa20c], 58 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 58 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 58 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 58 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 58 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 33 => 0x28 },
    'specialmode' => { 48 => 0x200, 54 => 0x200 },
    'spectralsensitivity' => { 23 => 0x8824, 58 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 40 => 0x2d },
    'spotfocuspointy' => { 40 => 0x2e },
    'spotmode' => { 49 => 0xf },
    'state' => { 58 => 'State' },
    'stripbytecounts' => { 23 => 0x117 },
    'stripoffsets' => { 23 => 0x111 },
    'striprowcounts' => { 23 => 0x22f },
    'sub-location' => { 33 => 0x5c },
    'subfile' => { 37 => 0xa },
    'subfiletype' => { 23 => 0xfe },
    'subifd' => { 23 => 0x14a },
    'subifd_offset' => { 46 => 0x3 },
    'subject' => { 58 => 'Subject' },
    'subjectarea' => { 58 => 'SubjectArea' },
    'subjectdistance' => { 23 => 0x9206, 58 => 'SubjectDistance' },
    'subjectdistancerange' => { 23 => 0xa40c, 58 => 'SubjectDistanceRange' },
    'subjectlocation' => { 23 => [0x9214,0xa214], 58 => 'SubjectLocation' },
    'subjectprogram' => { 40 => 0x22 },
    'subjectreference' => { 33 => 0xc },
    'subsectime' => { 23 => 0x9290 },
    'subsectimedigitized' => { 23 => 0x9292 },
    'subsectimeoriginal' => { 23 => 0x9291 },
    'superimposeddisplay' => { 9 => 0xe, 10 => 0xa, 12 => 0x9 },
    'supplementalcategories' => { 33 => 0x14, 58 => 'SupplementalCategories' },
    'supplementaltype' => { 36 => 0x37 },
    'switchtoregisteredafpoint' => { 11 => 0x12 },
    't4options' => { 23 => 0x124 },
    't6options' => { 23 => 0x125 },
    'targetcompressionratio' => { 15 => 0x1 },
    'targetdistancesetting' => { 17 => 0x1807 },
    'targetimagetype' => { 17 => 0x100a },
    'targetprinter' => { 23 => 0x151 },
    'technology' => { 30 => 'tech' },
    'thresholding' => { 23 => 0x107 },
    'thumbnailfilename' => { 17 => 0x817 },
    'thumbnailimage' => { 59 => 'ThumbnailImage' },
    'thumbnaillength' => { 23 => 0x202 },
    'thumbnailoffset' => { 23 => 0x201 },
    'thumbnails' => { 58 => 'Thumbnails' },
    'thumbnailsformat' => { 58 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 58 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 58 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 58 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 23 => [0x9216,0xa216] },
    'tilebytecounts' => { 23 => 0x145 },
    'tilelength' => { 23 => 0x143 },
    'tileoffsets' => { 23 => 0x144 },
    'tilewidth' => { 23 => 0x142 },
    'timecreated' => { 33 => 0x3c },
    'timesent' => { 34 => 0x50 },
    'timestamp' => { 17 => 0x180e },
    'timezone' => { 22 => 0x3006 },
    'timezonecode' => { 20 => 0x1 },
    'timezoneinfo' => { 20 => 0x2 },
    'timezoneoffset' => { 23 => 0x882a },
    'title' => { 58 => 'Title' },
    'tonecomp' => { 45 => 0x81 },
    'transferfunction' => { 23 => 0x12d, 58 => 'TransferFunction' },
    'transferrange' => { 23 => 0x156 },
    'transmissionreference' => { 58 => 'TransmissionReference' },
    'tvvalue' => { 13 => 0x1 },
    'type' => { 58 => 'Type' },
    'ucrbg' => { 30 => 'bfd ' },
    'uniquecameramodel' => { 23 => 0xc614 },
    'uniqueobjectname' => { 34 => 0x64 },
    'urgency' => { 33 => 0xa, 58 => 'Urgency' },
    'url' => { 52 => 0x40b },
    'usageterms' => { 58 => 'UsageTerms' },
    'usercomment' => { 17 => 0x805, 23 => 0x9286, 58 => 'UserComment' },
    'usmlenselectronicmf' => { 11 => 0x7 },
    'variprogram' => { 45 => 0xab },
    'version' => { 24 => 0x0, 58 => 'Version' },
    'versionid' => { 58 => 'VersionID' },
    'versions' => { 58 => 'Versions' },
    'versionscomments' => { 58 => 'VersionsComments' },
    'versionsevent' => { 58 => 'VersionsEvent' },
    'versionseventaction' => { 58 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 58 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 58 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 58 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 58 => 'VersionsEventWhen' },
    'versionsmodifier' => { 58 => 'VersionsModifier' },
    'versionsmodifydate' => { 58 => 'VersionsModifyDate' },
    'versionsversion' => { 58 => 'VersionsVersion' },
    'versionyear' => { 23 => 0x194 },
    'verticalcitation' => { 26 => 0x1001 },
    'verticalcstype' => { 26 => 0x1000 },
    'verticaldatum' => { 26 => 0x1002 },
    'verticalunits' => { 26 => 0x1003 },
    'videocardgamma' => { 30 => 'vcgt' },
    'viewingconddesc' => { 30 => 'vued' },
    'viewingcondilluminant' => { 32 => 0x8 },
    'viewingcondilluminanttype' => { 32 => 0x20 },
    'viewingconditions' => { 30 => 'view' },
    'viewingcondsurround' => { 32 => 0x14 },
    'vignetteamount' => { 58 => 'VignetteAmount' },
    'vignettemidpoint' => { 58 => 'VignetteMidpoint' },
    'voicememo' => { 54 => 0x216 },
    'wangannotation' => { 23 => 0x80a4 },
    'warning' => { 60 => 'Warning' },
    'webstatement' => { 58 => 'WebStatement' },
    'whitebalance' => { 7 => 0x7, 21 => 0x7, 22 => [0x19,0x2012], 23 => 0xa403, 24 => 0x1002, 40 => 0x3, 45 => 0x5, 49 => 0x3, 50 => 0x19, 55 => 0x7, 58 => 'WhiteBalance' },
    'whitebalancebias' => { 22 => 0x2011, 49 => 0x23 },
    'whitebalancefinetune' => { 45 => 0xb },
    'whitebalancetable' => { 4 => 0xa9, 17 => 0x10a9 },
    'whitelevel' => { 23 => 0xc61d },
    'whitepoint' => { 23 => 0x13e, 58 => 'WhitePoint' },
    'widefocuszone' => { 40 => 0x2f },
    'widerange' => { 54 => 0x20f },
    'writer-editor' => { 33 => 0x7a },
    'x3filllight' => { 55 => 0x12 },
    'xclippathunits' => { 23 => 0x158 },
    'xpauthor' => { 23 => 0x9c9d },
    'xpcomment' => { 23 => 0x9c9c },
    'xpkeywords' => { 23 => 0x9c9e },
    'xposition' => { 23 => 0x11e },
    'xpsubject' => { 23 => 0x9c9f },
    'xptitle' => { 23 => 0x9c9b },
    'xresolution' => { 23 => 0x11a, 47 => 0x11a, 58 => 'XResolution' },
    'ycbcrcoefficients' => { 23 => 0x211, 58 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 23 => 0x213, 47 => 0x213 },
    'ycbcrsubsampling' => { 23 => 0x212, 58 => 'YCbCrSubSampling' },
    'yclippathunits' => { 23 => 0x159 },
    'yposition' => { 23 => 0x11f },
    'yresolution' => { 23 => 0x11b, 47 => 0x11b, 58 => 'YResolution' },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool|Image::ExifTool>

=cut
