#!/usr/local/bin/perl -w
#
# pisql.pl - an implementation of ISQL in Perl
# Not quite finished, but functioning.
#
# Copyright 1998-1999 Bill Karwin
#

use strict;
use IBPerl;
use Getopt::Long;

select STDERR; $|++;
select STDOUT; $|++;

my ($user, $password, $role, $terminator, $inputfile, $outputfile,
    $echo, $noauto, $extract, $database, $pagelength,
    $autocommitddl, $merge);
my (@history);
my ($st, $tr, $db);

$tr = 0;
$db = 0;

Getopt::Long::config(
    'auto_abbrev',
    'ignore_case_always',
    'bundling_override'
    );

GetOptions(
    "database=s"   => \$database,
    "user=s"       => \$user,
    "password=s"   => \$password,
    "role=s"       => \$role,
    "input=s"      => \$inputfile,
    "output=s"     => \$outputfile,
    "extract|x|a!" => \$extract,
    "terminator=s" => \$terminator,
    "page=i"       => \$pagelength,
    "echo!"        => \$echo,
    "noauto!"      => \$noauto,
    "merge!"       => \$merge
    );

$terminator |= ';';
$pagelength |= 20;
$autocommitddl = $noauto ? 0 : 1;

$user = defined($user)? $user:
	defined($ENV{ISC_USER})? $ENV{ISC_USER}:
	getlogin || getpwuid($<);

$password = defined($password)? $password:
	defined($ENV{ISC_PASSWORD})? $ENV{ISC_PASSWORD}: '';

$database = defined($database)? $database:
	@ARGV? shift:
	defined($ENV{ISC_DATABASE})? $ENV{ISC_DATABASE}: '';

*INPUT = *STDIN;
if ($inputfile)
{
    open(INPUT, ">$inputfile") or die "Cannot open input file $inputfile";
}

*OUTPUT = *STDOUT;
if ($outputfile)
{
    open(OUTPUT, "<$outputfile") or die "Cannot open output file $outputfile";
}

*STDERR = *OUTPUT if ($merge);

if ($extract)
{
    # Silently exit if no database chosen
    exit 1 if (!$database);

    # Do extract metadata
    print OUTPUT "...EXTRACT is not implemented...\n";
    exit 0;
}

if ($database)
{
    my %props;

    $props{Path}     = $database;
    $props{User}     = $user     if ($user);
    $props{Password} = $password if ($password);
    $props{Role}     = $role     if ($role);

    $db = new IBPerl::Connection(%props);
    if ($db->{Handle} < 0)
    { print STDERR "$db->{Error}\n"; die "Aborting."; }

    print "Database: $database\n";
}

for (print OUTPUT "SQL> "; <INPUT>; print OUTPUT "SQL> ")
{
    s/#.*//o; # get rid of comments

    while (!m/$terminator/)
    {
	print OUTPUT "CON> ";
	$_ .= <INPUT>;
    }
    s/$terminator\s*$//;

    # Blank line?
    next if (m/^\s*$/o);

    push(@history, $_);

    print OUTPUT "$_" if ($echo);

    # QUIT/EXIT
    if (m/^\s*(QUIT|EXIT)\b/io)
    {
	$1 =~ m/EXIT/io? $tr->commit(): $tr->rollback()
	    if ($tr && $tr->{Handle} >= 0);
	$db->disconnect()
	    if ($db && $db->{Handle} >= 0);
	last;
    }

    # SET statements
    if (m/^\s*SET\s+(AUTODDL|BLOBDISPLAY|COUNT|ECHO|LIST|NAMES|PLAN|STATS|TERM|TIME)\b/io)
    {
	if ($1 =~ /TERM/io)
	{
	    $terminator = $_;
	}

	elsif ($1 =~ /ECHO/io)
	{
	    $echo = ! $echo;
	}

	else
	{
	    print "...SET $1 is not implemented...\n";
	}
	next;
    }

    # SHOW statements
    if (m/^\s*SHOW\s+(CHECK|DATABASE|DOMAIN|EXCEPTION|FILTER|FUNCTION|GENERATOR|GRANT|INDEX|INDICES|PROCEDURE|ROLE|SYSTEM|TABLE|TRIGGER|VERSION|VIEW)S?\b/io)
    {
	print "...SHOW $1 is not implemented...\n";
	next;
    }

    # INPUT
    if (m/^\s*INPUT\b/io)
    {
	print "...INPUT is not implemented...\n";
	next;
    }

    # OUTPUT
    if (m/^\s*OUTPUT\b/io)
    {
	print "...OUTPUT is not implemented...\n";
	next;
    }

    # EDIT
    if (m/^\s*EDIT\b/io)
    {
	print "...EDIT is not implemented...\n";
	# redo;
    }

    # COMMIT or ROLLBACK the transaction
    if (m/^\s*(COMMIT|ROLLBACK)\b/io)
    {
	$1 =~ m/COMMIT/io? $tr->commit(): $tr->rollback()
	    if ($tr && $tr->{Handle} >= 0);
	$tr = 0;
	next;
    }

    # CONNECT to a database
    if (m/^\s*CONNECT\b/io)
    {
	print "...CONNECT is not implemented...\n";
	# $db->disconnect() if ($db && $db->{Handle} >= 0);
	# $db = new IBPerl::Connection(...);
	# if ($db->{Handle} < 0)
	# { print STDERR "$db->{Error}\n"; die; }
	next;
    }

    # CREATE DATABASE
    if (m/^\s*CREATE\s+DATABASE\b/io)
    {
	print "...CREATE is not implemented...\n";
	# $db->disconnect() if ($db && $db->{Handle} >= 0);
	# $db = create IBPerl::Connection(...);
	# if ($db->{Handle} < 0)
	# { print STDERR "$db->{Error}\n"; die; }
	next;
    }

    # Any other DDL
    if ($autocommitddl &&
	m/^\s*(CREATE|ALTER|DROP|GRANT|REVOKE|SET\s+GENERATOR)\b/io)
    {
	my $ddl_tr = new IBPerl::Transaction(Database=>$db);
	if ($tr->{Handle} < 0)
	{ print STDERR "$tr->{Error}\n"; next; }

	my $ddl_st = new IBPerl::Statement(Stmt=>$_, Transaction=>$ddl_tr);
	if ($ddl_st->{Handle} < 0)
	{ print STDERR "$ddl_st->{Error}\n"; next; }

	if ($ddl_st->execute() < 0)
	{ print STDERR "$ddl_st->{Error}\n"; }

	if ($ddl_tr->commit() < 0)
	{ print STDERR "$tr->{Error}\n"; }

	next;
    }

    # Any other statement is treated as DSQL
    if (!defined($db) || !$db || $db->{Handle} < 0)
    {
	print "Use CONNECT or CREATE DATABASE to specify a database\n";
	next;
    }

    $tr = new IBPerl::Transaction(Database=>$db) if (!$tr);
    if ($tr->{Handle} < 0)
    { print STDERR "$tr->{Error}\n"; next; }

    $st = new IBPerl::Statement(Stmt=>$_, Transaction=>$tr);
    if ($st->{Handle} < 0)
    { print STDERR "$st->{Error}\n"; next; }

    if ($st->{Type} eq "SELECT" || $st->{Type} eq "SELECT_FOR_UPD")
    {
	my ($row, $ret, @record);

	if ($st->open() < 0)
	{ print STDERR "$st->{Error}\n"; };

	for ($row = 0; ($ret = $st->fetch(\@record)) == 0; ++$row)
	{
	    if ($row % $pagelength == 0)
	    {
		print "\n";
		for (my $i = 0; $i <= $#{ $st->{Columns} }; ++$i)
		{
		    printf("%s\t", ${ $st->{Columns} }[$i]);
		}
		print "\n";
		for (my $i = 0; $i <= $#{ $st->{Columns} }; ++$i)
		{
		    printf("%s\t", "=" x length(${ $st->{Columns} }[$i]));
		}
		print "\n\n";
	    }
	    for (my $i = 0; $i <= $#{ $st->{Columns} }; ++$i)
	    {
		printf("%s\t", 
		    ${ $st->{Nulls} }[$i] ?
		     "<null>" :
		     $record[$i]);
	    }
	    print "\n";
	}
	print "\n";
	print STDERR "$st->{Error}\n" if ($ret < 0);

	if ($st->close() < 0)
	{ print STDERR "$st->{Error}\n"; };
    }

    else
    {
	if ($st->execute() < 0)
	{ print STDERR "$st->{Error}\n"; };
    }

    next;
}

exit 0;
