#!/usr/local/bin/perl -w
#
# test_misc.pl - Run this after you compile IBPerl
# to test if it is working.  Also use this as an
# example of programming with IBPerl.
#
# Copyright 1996-1998 Bill Karwin

use strict;
use IBPerl;

select STDERR; $|++;
select STDOUT; $|++;

my ($db, $tr, $st, @row, %col, $line);

$db = new IBPerl::Connection(
	Path     => 'employee.gdb',
	User     => 'sysdba',
	Password => 'masterkey' );
if ($db->{Handle} < 0) { die "$0: connect failed:\n$db->{Error}"; }
print " $0: connected to database\n";

$tr = new IBPerl::Transaction( Database => $db);
if ($tr->{Handle} < 0) { die "$0: transaction failed:\n$tr->{Error}"; }
print " $0: created transaction\n";

# ----------------------------------------

print "\n\n *** Test SELECT into an array\n";

$st = new IBPerl::Statement( Transaction => $tr,
    Stmt => "SELECT DEPARTMENT, LOCATION FROM DEPARTMENT WHERE LOCATION STARTING WITH 'C'" );
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$st->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'};\n";

if ($st->open < 0) { die "$0: statement open failed:\n$st->{Error}"; }
while ($st->fetch(\@row) == 0) {
    print("  \$row[0] = length ", length($row[0]), " ", substr($row[0],0,20), "\n");
    print("  \$row[1] = length ", length($row[1]), " ", substr($row[1],0,20), "\n");
}
if ($st->close < 0) { die "$0: statement close failed:\n$st->{Error}"; }

# ----------------------------------------

print "\n\n *** Test INSERT\n";

$st = new IBPerl::Statement( Transaction => $tr, Stmt => "INSERT INTO DEPARTMENT (DEPT_NO, HEAD_DEPT, DEPARTMENT, LOCATION) VALUES (998, 900, 'Pewter Solutions', 'Capitola')");
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$tr->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'};\n";

if ($st->execute < 0) { die " $0: $st->{'Error'}\n"; }

# ----------------------------------------

print "\n\n*** Test SELECT into a hashed array\n";


$st = new IBPerl::Statement( Transaction => $tr, Stmt => "SELECT DEPARTMENT, LOCATION FROM DEPARTMENT WHERE LOCATION STARTING WITH 'C'");
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$st->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'};\n";

if ($st->open < 0) { die "$0: statement open failed:\n$st->{Error}"; }
while (!$st->fetch(\%col)) {
    print("  \$col{'DEPARTMENT'} = length ", length($col{DEPARTMENT}), " ", substr($col{'DEPARTMENT'},0,20), "\n");
    print("  \$col{'LOCATION'}   = length ", length($col{LOCATION}), " ", substr($col{'LOCATION'},0,20), "\n");
}
if ($st->close < 0) { die "$0: statement close failed:\n$st->{Error}"; }

# ----------------------------------------

print "\n\n*** Test UPDATE\n";

$st = new IBPerl::Statement( Transaction => $tr, Stmt => "UPDATE DEPARTMENT SET LOCATION = 'California' WHERE DEPARTMENT STARTING WITH 'Pewter'");
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$st->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'};\n";

if ($st->execute < 0) { die " $0: $st->{'Error'}\n"; }

# ----------------------------------------

print "\n\n*** Test SELECT into a scalar\n";

$st = new IBPerl::Statement( Transaction => $tr, Stmt => "SELECT DEPARTMENT, LOCATION FROM DEPARTMENT WHERE LOCATION STARTING WITH 'C'");
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$st->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'}\n";

if ($st->open < 0) { die "$0: statement open failed:\n$st->{Error}"; }
while (!$st->fetch(\$line)) {
    print("  \$line = $line\n");
}
if ($st->close < 0) { die "$0: statement close failed:\n$st->{Error}"; }

# ----------------------------------------

print "\n\n*** Test DELETE\n";

$st = new IBPerl::Statement( Transaction => $tr, Stmt => "DELETE FROM DEPARTMENT WHERE DEPARTMENT STARTING WITH 'Pewter'");
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$st->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'};\n";

if ($st->execute < 0) { die " $0: $st->{'Error'}\n"; }

# ----------------------------------------

print "\n\n*** Test SELECT into a scalar, altering Separator\n";

$st = new IBPerl::Statement( Transaction => $tr, Stmt => "SELECT DEPARTMENT, LOCATION FROM DEPARTMENT WHERE LOCATION STARTING WITH 'C'");
if ($st->{Handle} < 0) { die "$0: statement prepare failed:\n$st->{Error}"; }
print " $0: created $st->{'Type'} statement:\n $st->{'Stmt'}\n";

if ($st->open < 0) { die "$0: statement open failed:\n$st->{Error}"; }
$st->{'Sep'} = "\t\t";
while (!$st->fetch(\$line)) {
    print("  \$line = length ", length($line), " ", substr($line,0,20), "\n");
}
if ($st->close < 0) { die "$0: statement close failed:\n$st->{Error}"; }

print "Committing... ";
if ($tr->commit() < 0)
{
    print "Commit Error:\n$tr->{Error}\n";
    exit 1;
}
print "ok\n";

print "Disconnecting... ";
if ($db->disconnect() < 0)
{
    print "Disconnection Error:\n$db->{Error}\n";
    exit 1;
}
print "ok\n";

exit 0;
