package Oak::Web::HTML::Base;

use strict;
use Error qw(:try);
use base qw(Oak::Web::Visual);

=head1 NAME

Oak::Web::HTML::Base - Base HTML tag

=head1 DESCRIPTION

Create a base tag

=head1 HIERARCHY

  Oak::Object
  Oak::Persistent
  Oak::Component
  Oak::Web::Visual
  Oak::Web::HTML::Base

=head1 PROPERTIES

The Oak::Web::HTML::Base object has the properties defined by W3C

=cut

sub valid_html_attributes {
	(
	 "href"
  	);
}

sub show {
	my $self = shift;
	$self->SUPER::show;
	print "<LINK";
	print $self->print_html_attributes;
	print ">\n";
}

1;

__END__

=head1 COPYRIGHT

Copyright (c) 2001
Daniel Ruoso <daniel@ruoso.com>
All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.
