#
# This file is part of Config-Model-Systemd
#
# This software is Copyright (c) 2015-2016 by Dominique Dumont.
#
# This is free software, licensed under:
#
#   The GNU Lesser General Public License, Version 2.1, February 1999
#
package Config::Model::Backend::Systemd::Layers;
$Config::Model::Backend::Systemd::Layers::VERSION = '0.001';
use Mouse::Role;


sub default_directories {
    my $self = shift ;
    my $app = $self->node->instance->application;

    my @layers ;
    if ($app eq 'systemd-user') {
        @layers = (
            # paths documented by systemd-system.conf man page
            '/etc/systemd/user.conf.d/',
            '/run/systemd/user.conf.d/',
            '/usr/lib/systemd/user.conf.d/',
            # path found on Debian
            '/usr/lib/systemd/user/'
        );
    }
    elsif ($app eq 'systemd') {
        @layers = (
            # paths documented by systemd-system.conf man page
            '/etc/systemd/system.conf.d/',
            '/run/systemd/system.conf.d/',
            '/lib/systemd/system.conf.d/',
            # path found on Debian
            '/lib/systemd/system/',
        );
    }

    return @layers;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Config::Model::Backend::Systemd::Layers

=head1 VERSION

version 0.001

=head1 AUTHOR

Dominique Dumont

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015-2016 by Dominique Dumont.

This is free software, licensed under:

  The GNU Lesser General Public License, Version 2.1, February 1999

=cut
