#!/usr/bin/env perl
#This scrip retrieves kenv values from FreeBSD using XS.
#By default the script will look for all elements  containing "system", change this
#to the string you are looking for.
use ExtUtils::testlib;
use kenvperl;
use strict;
use warnings;


# for what string are we looking for? By default is 'system'
my $search = "system";
my $kenvironment = kenvperl::kdumpenv();


# split the return value into lines, on the pipe ('|') that we
# added in the kdumpenv() function.
my (@kernelenvarray) = split(/\|/, $kenvironment);
for (@kernelenvarray) {
	s/=/ /; #remove =
	s/^\s+|\s+$//; #remove white space
	}


# Debugging, seeing entire environmental variables set
#print "KERNELARRAY:\n" . join("\n", @kernelenvarray) . "\nKERNELARRAY\n\n\n\n\n";

# Get all lines that contain the string "serial"
my (@serials) = grep(/$search/i, @kernelenvarray);


# Now print it out, with a newline between each variable
print join("\n", @serials) . "\n";
