#!/usr/bin/perl
use Test;
BEGIN { plan tests => 69 };
use PostScript::Graph::Paper;
ok(1); # module found

my $gp = new PostScript::Graph::Paper();
ok($gp); # object created
ok($gp->paper_left_edge(), 37);
ok($gp->paper_bottom_edge(), 37);
ok($gp->paper_right_edge(), 558.27559);
ok($gp->paper_top_edge(), 804.88976);
ok($gp->paper_right_margin(), 15);
ok($gp->paper_top_margin(), 5);
ok($gp->paper_spacing(), 0);
ok($gp->paper_dots_per_inch(), 300);
ok($gp->paper_heading(), '');
ok($gp->paper_heading_height(), 27);
ok($gp->paper_key_width(), 0);
ok($gp->paper_background(), 1);
ok($gp->paper_color(), 0.5);
ok($gp->paper_heavy_color(), 0.5);
ok($gp->paper_mid_color(), 0.5);
ok($gp->paper_light_color(), 0.5);
ok($gp->paper_heavy_width(), 0.75);
ok($gp->paper_mid_width(), 0.5);
ok($gp->paper_light_width(), 0.25);
ok($gp->paper_font(), 'Helvetica');
ok($gp->paper_font_size(), 10);
ok($gp->paper_font_color(), 0);
ok($gp->paper_heading_font(), 'Helvetica-Bold');
ok($gp->paper_heading_font_size(), 12);
ok($gp->paper_heading_font_color(), 0);
ok($gp->x_axis_low(), 0);
ok($gp->x_axis_high(), 100);
ok($gp->x_axis_width(), 475.27559);
ok($gp->x_axis_height(), 33);
ok($gp->x_axis_label_gap(), 30);
ok($gp->x_axis_smallest(), 0.72);
ok($gp->x_axis_title(), '');
ok($gp->x_axis_font(), 'Helvetica');
ok($gp->x_axis_font_color(), 0);
ok($gp->x_axis_font_size(), 10);
ok($gp->x_axis_mark_min(), 0.5);
ok($gp->x_axis_mark_max(), 8);
ok($gp->x_axis_labels_req(), 15);
ok($gp->x_axis_labels(), '[ 0 10 20 30 40 50 60 70 80 90 100 ]');
ok($gp->x_axis_rotate(), 0);
ok($gp->x_axis_center(), 0);
ok($gp->y_axis_low(), 0);
ok($gp->y_axis_high(), 100);
ok($gp->y_axis_width(), 30);
ok($gp->y_axis_height(), 767.88976);
ok($gp->y_axis_label_gap(), 30);
ok($gp->y_axis_smallest(), 0.72);
ok($gp->y_axis_title(), '');
ok($gp->y_axis_font(), 'Helvetica');
ok($gp->y_axis_font_color(), 0);
ok($gp->y_axis_font_size(), 10);
ok($gp->y_axis_mark_min(), 0.5);
ok($gp->y_axis_mark_max(), 8);
ok($gp->y_axis_labels_req(), 23);
ok($gp->y_axis_labels(), '[ 0 10 20 30 40 50 60 70 80 90 100 ]');
ok($gp->y_axis_rotate(), 0);
ok($gp->y_axis_center(), 0);
ok($gp->graph_area(), (67, 70, 542.27559, 772.88976));
ok($gp->key_area(), (557.27559, 37, 557.27559, 804.88976));
ok($gp->vertical_bar_area(1), (68.42582677, 70, 69.37637795, 772.88976));
ok($gp->horizontal_bar_area(1), (67, 71.40577952, 542.27559, 72.81155904));
ok($gp->physical_point(20, 50), (162.055118, 421.44488));
ok($gp->logical_point(100, 200), (6.94333996829082, 18.495076667499));
ok($gp->px(24), 181.0661416);
ok($gp->py(67), 540.9361392);
ok($gp->lx(345), 58.4923791268136);
ok($gp->ly(678), 86.5000508756878);
