#!perl
use strict;
use warnings;

use Test::More;

BEGIN {
    use_ok('Time::Moment');
}

my @tests = (
    [ '0001-01-01T00:00:00Z',          -62135596800,        0,    0 ],
    [ '00010101T000000Z',              -62135596800,        0,    0 ],
    [ '0001-W01-1T00:00:00Z',          -62135596800,        0,    0 ],
    [ '0001W011T000000Z',              -62135596800,        0,    0 ],
    [ '0001-001T00:00:00Z',            -62135596800,        0,    0 ],
    [ '0001001T000000Z',               -62135596800,        0,    0 ],
    [ '1970-01-01T00:00:00Z',                     0,        0,    0 ],
    [ '1970-01-01T02:00:00+02:00',                0,        0,  120 ],
    [ '1970-01-01T01:30:00+01:30',                0,        0,   90 ],
    [ '1970-01-01T01:00:00+01:00',                0,        0,   60 ],
    [ '1970-01-01T00:01:00+00:01',                0,        0,    1 ],
    [ '1970-01-01T00:00:00+00:00',                0,        0,    0 ],
    [ '1969-12-31T23:59:00-00:01',                0,        0,   -1 ],
    [ '1969-12-31T23:00:00-01:00',                0,        0,  -60 ],
    [ '1969-12-31T22:30:00-01:30',                0,        0,  -90 ],
    [ '1969-12-31T22:00:00-02:00',                0,        0, -120 ],
    [ '1970-01-01T00:00:00.123456Z',              0,   123456,    0 ],
    [ '1970-01-01T00:00:00.12345Z',               0,   123450,    0 ],
    [ '1970-01-01T00:00:00.1234Z',                0,   123400,    0 ],
    [ '1970-01-01T00:00:00.123Z',                 0,   123000,    0 ],
    [ '1970-01-01T00:00:00.12Z',                  0,   120000,    0 ],
    [ '1970-01-01T00:00:00.1Z',                   0,   100000,    0 ],
    [ '1970-01-01T00:00:00.01Z',                  0,    10000,    0 ],
    [ '1970-01-01T00:00:00.001Z',                 0,     1000,    0 ],
    [ '1970-01-01T00:00:00.0001Z',                0,      100,    0 ],
    [ '1970-01-01T00:00:00.00001Z',               0,       10,    0 ],
    [ '1970-01-01T00:00:00.000001Z',              0,        1,    0 ],
    [ '1970-01-01T00:00:00.0Z',                   0,        0,    0 ],
    [ '1970-01-01T00:00:00.00Z',                  0,        0,    0 ],
    [ '1970-01-01T00:00:00.000Z',                 0,        0,    0 ],
    [ '1970-01-01T00:00:00.0000Z',                0,        0,    0 ],
    [ '1970-01-01T00:00:00.00000Z',               0,        0,    0 ],
    [ '1970-01-01T00:00:00.000000Z',              0,        0,    0 ],
    [ '1973-11-29T21:33:09Z',             123456789,        0,    0 ],
    [ '2013-10-28T17:51:56Z',            1382982716,        0,    0 ],
    [ '9999-12-31T23:59:59Z',          253402300799,        0,    0 ],
);

foreach my $test (@tests) {
    my ($string, $epoch, $microsecond, $offset) = @$test;

    my $tm = Time::Moment->from_string($string);
    is($tm->epoch,       $epoch,       "${string} epoch");
    is($tm->microsecond, $microsecond, "${string} microsecond");
    is($tm->offset,      $offset,      "${string} offset");
}

done_testing();

