use Test::More tests => 6;

BEGIN {	use_ok( 'POE::Component::Server::NRPE' ) };

use Socket;
use POE qw(Wheel::SocketFactory Filter::Stream Component::Client::NRPE);

my $nrped = POE::Component::Server::NRPE->spawn(
	address => '127.0.0.1',
	port => 0,
	version => 1,
	verstring => 'NRPE v1.9',
	options => { trace => 0 },
);

isa_ok( $nrped, 'POE::Component::Server::NRPE' );

POE::Session->create(
  package_states => [
	'main' => [qw(_start _response)],
  ],
);

$poe_kernel->run();
exit 0;

sub _start {
  my ($kernel,$heap) = @_[KERNEL,HEAP];
  my $port = ( unpack_sockaddr_in $nrped->getsockname() )[0];

  my $check = POE::Component::Client::NRPE->check_nrpe( 
	host  => '127.0.0.1',
	port  => $port,
	event => '_response',
	version => 1,
	context => { thing => 'moo' },
  );

  return;
}

sub _response {
  my ($kernel,$heap,$res) = @_[KERNEL,HEAP,ARG0];
  ok( $res->{context}->{thing} eq 'moo', 'Context data was okay' );
  ok( $res->{version} eq '1', 'Response version' );
  ok( $res->{result} eq '0', 'The result code was okay' );
  ok( $res->{data} eq 'NRPE v1.9', 'And the data was cool' ) or diag("Got '$res->{data}', expected 'NRPE v1.9'\n");
  $nrped->shutdown();
  return;
}
