use strict;
use inc::Module::Install;
use Module::Install::ReadmeFromPod;
use Module::Install::AutoLicense;
use Module::Install::GithubMeta;
name 'POE-Component-Metabase-Relay-Server';
author 'Chris Williams <chris@bingosnet.co.uk>';
version_from 'lib/POE/Component/Metabase/Relay/Server.pm';
abstract_from 'lib/POE/Component/Metabase/Relay/Server.pm';
readme_from 'lib/POE/Component/Metabase/Relay/Server.pm';
perl_version '5.006';
license 'perl';
auto_license holder => 'Chris Williams',
build_requires 'Test::More' => 0.47;
requires 'CPAN::Testers::Report' => '1.999';
requires 'Data::UUID' => '1.203';
requires 'DBD::SQLite' => '1.29';
requires 'DBI' => '1.609';
requires 'JSON' => '2.17';
requires 'JSON::XS' => '2.29';
requires 'Params::Util' => '1.01';
requires 'POE' => '1.287';
requires 'POE::Component::Client::HTTP' => '0.895';
requires 'POE::Component::EasyDBI' => '1.23';
requires 'POE::Component::Metabase::Client::Submit' => '0.02';
requires 'Metabase::Fact' => '0.011';
requires 'Metabase::User::Profile' => '0.003';
requires 'Metabase::User::Secret' => '0.003';
requires 'Moose' => '1.01';
requires 'Moose::Util::TypeConstraints' => '1.01';
requires 'MooseX::AttributeHelpers' => '0.23';
requires 'MooseX::POE' => '0.205';
requires 'MooseX::Types::Path::Class' => '0.05';
requires 'MooseX::Types::URI' => '0.02';
requires 'Test::POE::Server::TCP' => '1.08';
requires 'Time::HiRes' => 0;
requires 'Storable' => 0;
requires 'URI' => '1.52';
makemaker_args(dist => { PREOP => "$^X ./tools/git-log.pl > ./Changes" });
githubmeta;
auto_provides;
WriteAll();
