/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript.optimizer;

import net.sourceforge.htmlunit.corejs.javascript.Kit;
import net.sourceforge.htmlunit.corejs.javascript.Node;
import net.sourceforge.htmlunit.corejs.javascript.ast.FunctionNode;
import net.sourceforge.htmlunit.corejs.javascript.ast.ScriptNode;

final class OptFunctionNode {
    FunctionNode fnode;
    private boolean[] numberVarFlags;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode fnode) {
        this.fnode = fnode;
        fnode.setCompilerData(this);
    }

    static OptFunctionNode get(ScriptNode scriptOrFn, int i) {
        FunctionNode fnode = scriptOrFn.getFunctionNode(i);
        return (OptFunctionNode)fnode.getCompilerData();
    }

    static OptFunctionNode get(ScriptNode scriptOrFn) {
        return (OptFunctionNode)scriptOrFn.getCompilerData();
    }

    boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int directTargetIndex) {
        if (directTargetIndex < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = directTargetIndex;
    }

    void setParameterNumberContext(boolean b) {
        this.itsParameterNumberContext = b;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    int getVarCount() {
        return this.fnode.getParamAndVarCount();
    }

    boolean isParameter(int varIndex) {
        return varIndex < this.fnode.getParamCount();
    }

    boolean isNumberVar(int varIndex) {
        if ((varIndex -= this.fnode.getParamCount()) >= 0 && this.numberVarFlags != null) {
            return this.numberVarFlags[varIndex];
        }
        return false;
    }

    void setIsNumberVar(int varIndex) {
        if ((varIndex -= this.fnode.getParamCount()) < 0) {
            Kit.codeBug();
        }
        if (this.numberVarFlags == null) {
            int size = this.fnode.getParamAndVarCount() - this.fnode.getParamCount();
            this.numberVarFlags = new boolean[size];
        }
        this.numberVarFlags[varIndex] = true;
    }

    int getVarIndex(Node n) {
        int index = n.getIntProp(7, -1);
        if (index == -1) {
            Node node;
            int type = n.getType();
            if (type == 55) {
                node = n;
            } else if (type == 56 || type == 156) {
                node = n.getFirstChild();
            } else {
                throw Kit.codeBug();
            }
            index = this.fnode.getIndexForNameNode(node);
            if (index < 0) {
                throw Kit.codeBug();
            }
            n.putIntProp(7, index);
        }
        return index;
    }
}

