/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCheckBoxInput
extends HtmlInput {
    private boolean defaultCheckedState_ = this.hasAttribute("checked");
    private boolean valueAtFocus_;

    HtmlCheckBoxInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getAttribute("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttribute("value", "on");
        }
    }

    @Override
    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    @Override
    public Page setChecked(boolean isChecked) {
        if (isChecked) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS)) {
            return this.getPage();
        }
        return HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    public String asText() {
        return super.asText();
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        boolean isChecked;
        boolean bl = isChecked = !this.isChecked();
        if (isChecked) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        super.doClickStateUpdate();
        return true;
    }

    @Override
    protected void doClickFireChangeEvent() throws IOException {
        if (!this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS)) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void preventDefault() {
        this.setChecked(!this.isChecked());
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_DEFAULT_IS_CHECKED)) {
            this.setChecked(defaultChecked);
        }
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    public void focus() {
        super.focus();
        this.valueAtFocus_ = this.isChecked();
    }

    @Override
    void removeFocus() {
        super.removeFocus();
        boolean fireOnChange = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS);
        if (fireOnChange && this.valueAtFocus_ != this.isChecked()) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
        this.valueAtFocus_ = this.isChecked();
    }
}

