/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.dom.CSSCharsetRuleImpl;
import com.steadystate.css.dom.CSSFontFaceRuleImpl;
import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSOMObject;
import com.steadystate.css.dom.CSSPageRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.CSSUnknownRuleImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.AbstractSACParser;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.SACParserCSS21;
import com.steadystate.css.sac.DocumentHandlerExt;
import com.steadystate.css.userdata.UserDataConstants;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.helpers.ParserFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSOMParser {
    private static final String DEFAULT_PARSER = "com.steadystate.css.parser.SACParserCSS21";
    private static String LastFailed_;
    private Parser parser_;
    private CSSStyleSheetImpl parentStyleSheet_;

    public CSSOMParser() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSOMParser(Parser parser) {
        String string = DEFAULT_PARSER;
        synchronized (DEFAULT_PARSER) {
            if (null != parser) {
                System.setProperty("org.w3c.css.sac.parser", parser.getClass().getCanonicalName());
                this.parser_ = parser;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            String currentParser = System.getProperty("org.w3c.css.sac.parser");
            try {
                if (null != LastFailed_ && LastFailed_.equals(currentParser)) {
                    this.parser_ = new SACParserCSS21();
                } else {
                    if (null == currentParser) {
                        System.setProperty("org.w3c.css.sac.parser", DEFAULT_PARSER);
                        currentParser = DEFAULT_PARSER;
                    }
                    ParserFactory factory = new ParserFactory();
                    this.parser_ = factory.makeParser();
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                System.err.println("using the default parser instead");
                LastFailed_ = currentParser;
                this.parser_ = new SACParserCSS21();
            }
            return;
        }
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.parser_.setErrorHandler(eh);
    }

    public CSSStyleSheet parseStyleSheet(InputSource source, Node ownerNode, String href) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        handler.setOwnerNode(ownerNode);
        handler.setHref(href);
        this.parser_.setDocumentHandler((DocumentHandler)handler);
        this.parser_.parseStyleSheet(source);
        Object o = handler.getRoot();
        if (o instanceof CSSStyleSheet) {
            return (CSSStyleSheet)o;
        }
        return null;
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        CSSStyleDeclarationImpl sd = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(sd, source);
        return sd;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration sd, InputSource source) throws IOException {
        Stack<Object> nodeStack = new Stack<Object>();
        nodeStack.push(sd);
        CSSOMHandler handler = new CSSOMHandler(nodeStack);
        this.parser_.setDocumentHandler((DocumentHandler)handler);
        this.parser_.parseStyleDeclaration(source);
    }

    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.parser_.setDocumentHandler((DocumentHandler)handler);
        LexicalUnit lu = this.parser_.parsePropertyValue(source);
        if (null == lu) {
            return null;
        }
        return new CSSValueImpl(lu);
    }

    public CSSRule parseRule(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.parser_.setDocumentHandler((DocumentHandler)handler);
        this.parser_.parseRule(source);
        return (CSSRule)handler.getRoot();
    }

    public SelectorList parseSelectors(InputSource source) throws IOException {
        HandlerBase handler = new HandlerBase();
        this.parser_.setDocumentHandler((DocumentHandler)handler);
        return this.parser_.parseSelectors(source);
    }

    public SACMediaList parseMedia(InputSource source) throws IOException {
        HandlerBase handler = new HandlerBase();
        this.parser_.setDocumentHandler((DocumentHandler)handler);
        if (this.parser_ instanceof AbstractSACParser) {
            return ((AbstractSACParser)this.parser_).parseMedia(source);
        }
        return null;
    }

    public void setParentStyleSheet(CSSStyleSheetImpl parentStyleSheet) {
        this.parentStyleSheet_ = parentStyleSheet;
    }

    protected CSSStyleSheetImpl getParentStyleSheet() {
        return this.parentStyleSheet_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CSSOMHandler
    implements DocumentHandlerExt {
        private Stack<Object> nodeStack_;
        private Object root_;
        private Node ownerNode_;
        private String href_;

        private Node getOwnerNode() {
            return this.ownerNode_;
        }

        private void setOwnerNode(Node ownerNode) {
            this.ownerNode_ = ownerNode;
        }

        private String getHref() {
            return this.href_;
        }

        private void setHref(String href) {
            this.href_ = href;
        }

        public CSSOMHandler(Stack<Object> nodeStack) {
            this.nodeStack_ = nodeStack;
        }

        public CSSOMHandler() {
            this.nodeStack_ = new Stack();
        }

        public Object getRoot() {
            return this.root_;
        }

        public void startDocument(InputSource source) throws CSSException {
            if (this.nodeStack_.empty()) {
                CSSStyleSheetImpl ss = new CSSStyleSheetImpl();
                CSSOMParser.this.setParentStyleSheet(ss);
                ss.setOwnerNode(this.getOwnerNode());
                ss.setBaseUri(source.getURI());
                ss.setHref(this.getHref());
                ss.setMediaText(source.getMedia());
                ss.setTitle(source.getTitle());
                CSSRuleListImpl rules = new CSSRuleListImpl();
                ss.setCssRules(rules);
                this.nodeStack_.push(ss);
                this.nodeStack_.push(rules);
            }
        }

        public void endDocument(InputSource source) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            this.ignorableAtRule(atRule, null);
        }

        @Override
        public void ignorableAtRule(String atRule, Locator locator) throws CSSException {
            CSSUnknownRuleImpl ir = new CSSUnknownRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), atRule);
            this.addLocator(locator, ir);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ir);
            } else {
                this.root_ = ir;
            }
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        @Override
        public void charset(String characterEncoding, Locator locator) throws CSSException {
            CSSCharsetRuleImpl cr = new CSSCharsetRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), characterEncoding);
            this.addLocator(locator, cr);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cr);
            } else {
                this.root_ = cr;
            }
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            this.importStyle(uri, media, defaultNamespaceURI, null);
        }

        @Override
        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI, Locator locator) throws CSSException {
            CSSImportRuleImpl ir = new CSSImportRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), uri, new MediaListImpl(media));
            this.addLocator(locator, ir);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ir);
            } else {
                this.root_ = ir;
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.startMedia(media, null);
        }

        @Override
        public void startMedia(SACMediaList media, Locator locator) throws CSSException {
            MediaListImpl ml = new MediaListImpl(media);
            CSSMediaRuleImpl mr = new CSSMediaRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), ml);
            this.addLocator(locator, mr);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(mr);
            }
            CSSRuleListImpl rules = new CSSRuleListImpl();
            mr.setRuleList(rules);
            this.nodeStack_.push(mr);
            this.nodeStack_.push(rules);
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        public void startPage(String name, String pseudoPage) throws CSSException {
            this.startPage(name, pseudoPage, null);
        }

        @Override
        public void startPage(String name, String pseudoPage, Locator locator) throws CSSException {
            CSSPageRuleImpl pr = new CSSPageRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), name, pseudoPage);
            this.addLocator(locator, pr);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(pr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(pr);
            pr.setStyle(decl);
            this.nodeStack_.push(pr);
            this.nodeStack_.push(decl);
        }

        public void endPage(String name, String pseudoPage) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        public void startFontFace() throws CSSException {
            this.startFontFace(null);
        }

        @Override
        public void startFontFace(Locator locator) throws CSSException {
            CSSFontFaceRuleImpl ffr = new CSSFontFaceRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule());
            this.addLocator(locator, ffr);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ffr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(ffr);
            ffr.setStyle(decl);
            this.nodeStack_.push(ffr);
            this.nodeStack_.push(decl);
        }

        public void endFontFace() throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.startSelector(selectors, null);
        }

        @Override
        public void startSelector(SelectorList selectors, Locator locator) throws CSSException {
            CSSStyleRuleImpl sr = new CSSStyleRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), selectors);
            this.addLocator(locator, sr);
            if (!this.nodeStack_.empty()) {
                Object o = this.nodeStack_.peek();
                ((CSSRuleListImpl)o).add(sr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(sr);
            sr.setStyle(decl);
            this.nodeStack_.push(sr);
            this.nodeStack_.push(decl);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            this.property(name, value, important, null);
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important, Locator locator) {
            CSSStyleDeclarationImpl decl = (CSSStyleDeclarationImpl)this.nodeStack_.peek();
            try {
                Property property = new Property(name, new CSSValueImpl(value), important);
                this.addLocator(locator, property);
                decl.addProperty(property);
            }
            catch (DOMException e) {
                // empty catch block
            }
        }

        private CSSRule getParentRule() {
            Object node;
            if (!this.nodeStack_.empty() && this.nodeStack_.size() > 1 && (node = this.nodeStack_.get(this.nodeStack_.size() - 2)) instanceof CSSRule) {
                return (CSSRule)node;
            }
            return null;
        }

        private void addLocator(Locator locator, CSSOMObject cssomObject) {
            if (locator == null) {
                Parser parser = CSSOMParser.this.parser_;
                try {
                    Method getLocatorMethod = parser.getClass().getMethod("getLocator", null);
                    locator = (Locator)getLocatorMethod.invoke((Object)parser, (Object[])null);
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            if (locator != null) {
                cssomObject.setUserData(UserDataConstants.KEY_LOCATOR, locator);
            }
        }
    }
}

