/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.regexp;

public class RegExpJsToJavaConverter {
    private static final String DIGITS = "0123456789";
    private Tape tape_;
    private boolean insideCharClass_;
    private boolean insideRepetition_;
    private int noOfSubexpressions_;

    public String convert(String input) {
        this.tape_ = new Tape(input);
        this.insideCharClass_ = false;
        this.insideRepetition_ = false;
        this.noOfSubexpressions_ = 0;
        int current = this.tape_.read();
        while (current > -1) {
            if (92 == current) {
                this.processEscapeSequence();
            } else if (91 == current) {
                this.processCharClassStart();
            } else if (93 == current) {
                this.processCharClassEnd();
            } else if (123 == current) {
                this.processRepetitionStart();
            } else if (125 == current) {
                this.processRepetitionEnd();
            } else if (40 == current) {
                this.processSubExpressionStart();
            }
            current = this.tape_.read();
        }
        return this.tape_.toString();
    }

    private void processCharClassStart() {
        if (this.insideCharClass_) {
            this.tape_.insert("\\", -1);
        } else {
            this.insideCharClass_ = true;
            int next = this.tape_.read();
            if (next < 0) {
                this.tape_.insert("\\", -1);
                return;
            }
            if (94 == next) {
                next = this.tape_.read();
                if (next < 0) {
                    this.tape_.insert("\\", -2);
                    return;
                }
                if (92 == next) {
                    next = this.tape_.read();
                    if (DIGITS.indexOf(next) < 0) {
                        this.tape_.move(-2);
                        return;
                    }
                    if (this.handleBackReferenceOrOctal(next) && 93 == (next = this.tape_.read())) {
                        this.tape_.move(-3);
                        this.tape_.replace("");
                        this.tape_.replace("");
                        this.tape_.replace(".");
                        this.insideCharClass_ = false;
                    }
                } else {
                    this.tape_.move(-1);
                }
            } else {
                this.tape_.move(-1);
            }
        }
    }

    private void processCharClassEnd() {
        this.insideCharClass_ = false;
    }

    private void processRepetitionStart() {
        int next = this.tape_.read();
        if (next < 0) {
            this.tape_.insert("\\", -1);
            return;
        }
        if (DIGITS.indexOf(next) > -1) {
            this.insideRepetition_ = true;
        } else if (125 == next) {
            this.tape_.insert("\\", -2);
            this.tape_.insert("\\", -1);
        } else {
            this.tape_.insert("\\", -2);
        }
    }

    private void processRepetitionEnd() {
        if (this.insideRepetition_) {
            this.insideRepetition_ = false;
            return;
        }
        this.tape_.insert("\\", -1);
    }

    private void processSubExpressionStart() {
        int next = this.tape_.read();
        if (next < 0) {
            return;
        }
        if (63 != next) {
            ++this.noOfSubexpressions_;
            this.tape_.move(-1);
            return;
        }
        next = this.tape_.read();
        if (next < 0) {
            return;
        }
        if (58 != next) {
            ++this.noOfSubexpressions_;
            this.tape_.move(-1);
            return;
        }
    }

    private void processEscapeSequence() {
        int escapeSequence = this.tape_.read();
        if (escapeSequence < 0) {
            return;
        }
        if (120 == escapeSequence) {
            this.tape_.move(2);
            return;
        }
        if (117 == escapeSequence) {
            this.tape_.move(4);
            return;
        }
        if ("ACEFGHIJKLMNOPQRTUVXYZaeghijklmpqyz".indexOf(escapeSequence) > -1) {
            this.tape_.move(-2);
            this.tape_.replace("");
            this.tape_.move(1);
            return;
        }
        if (this.insideCharClass_ && 98 == escapeSequence) {
            this.tape_.move(-1);
            this.tape_.replace("cH");
            this.tape_.move(2);
            return;
        }
        if (DIGITS.indexOf(escapeSequence) > -1) {
            this.handleBackReferenceOrOctal(escapeSequence);
        }
    }

    private boolean handleBackReferenceOrOctal(int aFirstChar) {
        int value;
        StringBuilder tmpNo = new StringBuilder(Character.toString((char)aFirstChar));
        int tmpInsertPos = -1;
        int next = this.tape_.read();
        if (next > -1) {
            if (DIGITS.indexOf(next) > -1) {
                tmpNo.append(next);
                --tmpInsertPos;
                next = this.tape_.read();
                if (next > -1) {
                    if (DIGITS.indexOf(next) > -1) {
                        tmpNo.append(next);
                        --tmpInsertPos;
                    } else {
                        this.tape_.move(-1);
                    }
                }
            } else {
                this.tape_.move(-1);
            }
        }
        if ((value = Integer.parseInt(tmpNo.toString())) > this.noOfSubexpressions_) {
            this.tape_.insert("0", tmpInsertPos);
            return false;
        }
        if (this.insideCharClass_) {
            for (int i = tmpInsertPos; i <= 0; ++i) {
                this.tape_.move(-1);
                this.tape_.replace("");
            }
        }
        return true;
    }

    private static class Tape {
        private StringBuilder tape_;
        private int currentPos_ = 0;

        public Tape(String input) {
            this.tape_ = new StringBuilder(input);
        }

        public void move(int offset) {
            this.currentPos_ += offset;
        }

        public int read() {
            if (this.currentPos_ < 0) {
                return -1;
            }
            if (this.currentPos_ >= this.tape_.length()) {
                return -1;
            }
            return this.tape_.charAt(this.currentPos_++);
        }

        public void insert(String token, int offset) {
            this.tape_.insert(this.currentPos_ + offset, token);
            this.currentPos_ += token.length();
        }

        public void replace(String token) {
            this.tape_.replace(this.currentPos_, this.currentPos_ + 1, token);
        }

        public String toString() {
            return this.tape_.toString();
        }
    }
}

