/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Storage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StorageImpl
implements Serializable {
    private static final Log LOG = LogFactory.getLog(Storage.class);
    private static StorageImpl SINGLETON_ = new StorageImpl();
    private Map<String, Map<String, String>> globalStorage_ = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> localStorage_ = new HashMap<String, Map<String, String>>();
    private transient Map<String, Map<String, String>> sessionStorage_ = new HashMap<String, Map<String, String>>();

    private StorageImpl() {
    }

    static StorageImpl getInstance() {
        return SINGLETON_;
    }

    void set(Storage.Type type, HtmlPage page, String key, String data) {
        StorageImpl.set(this.getStorage(type), this.getKey(type, page), key, data);
    }

    Map<String, String> getMap(Storage.Type type, HtmlPage page) {
        String key;
        Map<String, Map<String, String>> storage = this.getStorage(type);
        Map<String, String> map = storage.get(key = this.getKey(type, page));
        if (map == null) {
            map = new LinkedHashMap<String, String>();
            storage.put(key, map);
        }
        return map;
    }

    void clear(Storage.Type type, HtmlPage page) {
        this.getStorage(type).remove(this.getKey(type, page));
    }

    private String getKey(Storage.Type type, HtmlPage page) {
        switch (type) {
            case GLOBAL_STORAGE: {
                return page.getUrl().getHost();
            }
            case LOCAL_STORAGE: {
                URL url = page.getUrl();
                return url.getProtocol() + "://" + url.getHost() + ':' + url.getProtocol();
            }
            case SESSION_STORAGE: {
                WebWindow topWindow = page.getEnclosingWindow().getTopWindow();
                return Integer.toHexString(topWindow.hashCode());
            }
        }
        return null;
    }

    Map<String, Map<String, String>> getStorage(Storage.Type type) {
        switch (type) {
            case GLOBAL_STORAGE: {
                return this.globalStorage_;
            }
            case LOCAL_STORAGE: {
                return this.localStorage_;
            }
            case SESSION_STORAGE: {
                return this.sessionStorage_;
            }
        }
        return null;
    }

    private static void set(Map<String, Map<String, String>> storage, String url, String key, String data) {
        Map<String, String> map = storage.get(url);
        if (map == null) {
            map = new LinkedHashMap<String, String>();
            storage.put(url, map);
        }
        map.put(key, data);
        StorageImpl.save();
    }

    String get(Storage.Type type, HtmlPage page, String key) {
        return StorageImpl.get(this.getStorage(type), this.getKey(type, page), key);
    }

    private static String get(Map<String, Map<String, String>> storage, String url, String key) {
        Map<String, String> map = storage.get(url);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    private static void save() {
        try {
            File file = new File(System.getProperty("user.home"), "htmlunit.storage");
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(SINGLETON_);
            out.close();
        }
        catch (IOException e) {
            LOG.info((Object)"Could not save storage", (Throwable)e);
        }
    }

    private static void load() {
        try {
            File file = new File(System.getProperty("user.home"), "htmlunit.storage");
            if (file.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                SINGLETON_ = (StorageImpl)in.readObject();
                StorageImpl.SINGLETON_.sessionStorage_ = new HashMap<String, Map<String, String>>();
                in.close();
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Could not load storage", (Throwable)e);
        }
    }

    static {
        StorageImpl.load();
    }
}

