# UPPA OpenVPN Manager HTTP API

L'accès a l'API nécessite une clé transmise via l'entête HTTP Authorization pour les chemins commançant par /api

## GET /api/iptables/profiles[?hidden]

Retourne la liste des profiles disponibles dont les profiles cachés (ou automatiques) si le paramètre **hidden** est présent dans la querystring :

### code HTTP 200

```json
{ "profiles": [] }
```

## GET /api/iptables/profile/[profilename]

Retourne le contenu du profile **[profilename]** :

### code HTTP 200

```json
{
  "name": "profilename",
  "content": {"entries": []}
}

```

### code HTTP 404


```json
{ "error": "..." }
```

## GET /api/totp/token/[uid]

Créer un nouveau token TOTP si **[uid]** n'en possède pas ou ne l'a pas encore validé. Retourne une URL directement transformable en QRCode :

```json
{ "uri": "otpauth://totp/..." }
```

Retourne une erreur si un token existe et est déjà validé pour **[uid]** :

```json
{ "error": "..." }
```

## GET /api/totp/hastoken/[uid]

Indique si **[uid]** possède déjà un token TOTP :

### code HTTP 200

```json
{ "hastoken": true|false }
```

## GET /api/totp/testtoken/[uid]/[totpcode]

Verifie que le code TOTP **[totpcode]** est correct pour l'utilisateur **[uid]**. 

### code HTTP 200

```json
{ "validated": true|false }
```

## DELETE /api/totp/token/[uid]

Efface le token TOTP de l'utilisateur **[uid]** si celui-ci existe :

### code HTTP 200

```json
{ "status": true }
```

### code HTTP 404

```json
{ "error": "..." }
```

## GET /api/profile/config/[uid]

Retourne la configuration openvpn pour l'utilisateur **[uid]**

### code HTTP 200

```json
{ "config": "..." }
```

### code HTTP 500

```json
{ "error": "..." }
```

## GET /api/profile/token/[uid]

Créer un token JWT pour l'utilisateur **[uid]** permettant ensuite au client OpenVPN Connect de récuperer sa configuration :

### code HTTP 200

```json
{ "token": "..." }
```

Le token est utilisé pour forger une URL qui sera prise en charge par le client OpenVPN Connect pour télécharger la configuration :

```
openvpn://import-profile/https://vpn.server/profile/config/[token]
```

Cette URL peut être utiliser pour remplacer la "location" du navigateur :

```javascript
window.location.href = url
```

## GET /profile/config/[jwt]

Retourne la configuration associée au token **[jwt]**. Ce endpoint n'est logiquement utilisé que
par le client OpenVPN Connect lorsqu'il reçoit une URL avec le scheme openvpn://.

### code HTTP 200

Retourne la configuration avec le Content-Type "application/x-openvpn-profile"

### code HTTP 404

Si le token JWT est invalide ou expiré

## exemples

```bash
curl -H "Authorization: Bearer ***" https://vpn.server/api/totp/hastoken/foo
```

