#  Makefile.PL for WebMod::Chain
#
package WebDyne::Chain;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',
    PM					   =>  {
	'Chain.pm'			   =>  '$(INST_LIBDIR)/Chain.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/Chain/VERSION.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/Chain/LICENSE'
    },

    'dist'				   =>  {
	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz'
    },

    'depend'				   =>  { 
	Makefile			   =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },

    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Chain.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

);

