#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebMod::Log.
#
#  WebMod::Log is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Log_Print.pm,v 1.4 2005/09/28 15:14:16 aspeer Exp $

#
#  Log messages to nowhere
#
package WebMod::Log::Print;


#  Compiler pragma
#
use strict 	qw(vars);
use vars 	qw($VERSION $REVISION $PACKAGE @ISA);


#  External modules
#
use WebMod::Log::Null;


#  Inheritance
#
@ISA=qw(WebMod::Log::Null);


#  Version Info, must be all one line for MakeMaker, CPAN.
#
$VERSION = eval { require WebMod::Log::VERSION; do $INC{'WebMod/Log/VERSION.pm'}};


#  Release info
#
$REVISION = (qw $Revision: 1.4 $)[1];


#  Package
#
$PACKAGE=__PACKAGE__;


#  All done, return OK
#
return 1;


#============================================================================


sub write {


    #  Get message, print
    #
    my ($self, $param_hr)=@_;
    my $message=$param_hr->{'message'};
    print STDOUT $message, "\n";


    #  Done
    #
    return 1;

}


sub DESTROY {

    1;
    
    
}
