#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebMod::Log.
#
#  WebMod::Log is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Constant.pm,v 1.6 2003/11/03 02:45:34 aspeer Exp $

#
#  Webmod::Log Constants file
#
package WebMod::Log::Constant;


#  Version Info, must be all one line for MakeMaker, CPAN.
#
$VERSION = eval { require WebMod::Log::VERSION; do $INC{'WebMod/Log/VERSION.pm'}};


#  Compiler Pragma
#
use strict qw(vars);
local $^W=0;


#  Exteral Modules. Use file spec for Win32 platforms
#
use File::Spec;


#  Config hash
#
my %Config=(

	    'linux'	=>	{

				 LOG_SOCKET		=>	'unix',

				 DIR_DEFAULT		=>	'/tmp',

				 BIN_LOGGER		=>	'/usr/bin/logger',

				 MODE_DEFAULT	=>	undef,

				 LOG_FACILITY	=>	'LOG_USER',

				 LOG_PRIORITY	=>	'LOG_INFO',

				 SYSLOG			=>	TRUE,

				 DEBUG			=>	1

				},


	    'MSWin32'	=>	{

				 LOG_SOCKET		=>	undef,

				 DIR_DEFAULT		=>	$ENV{'windir'},

				 BIN_LOGGER		=>	undef,

				 MODE_DEFAULT	=>	undef,

				 LOG_FACILITY	=>	undef,

				 LOG_PRIORITY	=>	undef,

				 SYSLOG			=>	undef,

				 DEBUG			=>	undef

				}

	   );


#  Return set appropriate for OS or linux by
#  default
#
return $Config{$^O} ||= $Config{'linux'}
