#  Makefile.PL
#
package WebDyne::Install;


#  Compiler Pragma
#
use strict  qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',

    PM					   =>  {

	'WebDyne_Install.pm'		   =>  '$(INST_LIBDIR)/Install.pm',
	'Constant.pm'			   =>  '$(INST_LIBDIR)/Install/Constant.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/Install/VERSION.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/Install/LICENSE',
	'support/webdyne.conf.inc'	   =>  '$(INST_LIBDIR)/Install/webdyne.conf.inc',
	'support/apache.conf.inc'	   =>  '$(INST_LIBDIR)/Install/apache.conf.inc',
    },

    EXE_FILES				   =>  [

    	'support/wdapacheinit',
    	'support/perl5lib.pm',

       ],

    'dist'				   =>  {

	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz'

    },

    'depend'				   =>  {
	Makefile			   =>  '$(VERSION_FROM)',
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },

    ($] >= 5.005 ?
       (AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );


sub MY::install_ {

    package MY;
    my $install=shift()->SUPER::install();
    $install=~s/install\s*(\:+)\s* all (.*)$/install $1 all $2 module_install/m;
    $install.=
	"module_install ::\n\t".
	    '$(PERL) -I$(INST_ARCHLIB) -I$(INST_LIB) -I$(INSTALLPRIVLIB) -I$(INSTALLSITELIB) '.
		'-I$(DESTINSTALLSCRIPT) -Mperl5lib '.
		    '-MWebMod::Err=errdump -M$(NAME) '.
			q[-e "$(NAME)->install('$(PREFIX)', '$(INSTALLBIN)') || die errdump()"].$/;

    $install=~s/uninstall\s*(\:+).*/uninstall $1 module_uninstall/m;
    $install.=
	"module_uninstall ::\n\t".
	    '$(PERL) -I$(INST_ARCHLIB) -I$(INST_LIB) -I$(INSTALLPRIVLIB) -I$(INSTALLSITELIB) '.
	    '-MWebMod::Err=errdump -M$(NAME) '.
		q[-e "$(NAME)->uninstall('$(PREFIX)', '$(INSTALLBIN)') || die errdump()"].$/;

}


