#  Makefile.PL
#
package Bundle::WebDyne::Dist;


#  Compiler Pragma
#
use strict  qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;


#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(


    NAME				 =>  __PACKAGE__,

    PM					 =>  {

    	($_{'version_from_fn'}='lib/Bundle/WebDyne/Dist.pm') => '$(INST_LIBDIR)/Dist.pm',
    	'Dumper.pm'                                	=> '$(INST_LIBDIR)/Dumper.pm',
    	'LICENSE'                                  	=> '$(INST_LIBDIR)/Dist/LICENSE',

    },

    VERSION_FROM			 =>  $_{'version_from_fn'},

    'dist'				 =>  {

	COMPRESS			 =>  'gzip -9f',
	SUFFIX				 =>  '.gz'

    },

    'depend'				 =>  {
	Makefile			 =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	PACKAGER			 =>  $_{'author'}='Andrew Speer <andrew.speer@isolutions.com.au>',
    	VENDOR				 =>  $_{'author'},
        TEMPLATE_RPM                     =>  '$(DISTNAME).spec',

    },
    
    ($] >= 5.005 ?
      (ABSTRACT_FROM 			 => $_{'version_from_fn'},
       AUTHOR     			 => $_{'author'}) : ()
    ),

   );


# Internal development use only
#
sub BEGIN {  eval('use ExtUtils::Bundle') }
