package main;
use Evo -modern;
use Promises6 ':all';
use Test::More;

my ($p1, $p2, $res, $F, $R);

# resolve first
$res = undef;
$p1  = promise {};
$p2  = promise {};
race($p1, $p2)->then(sub { $res = shift });
$p1->deferred->resolve(1);
is $res, 1, 'right result';
$p1->deferred->resolve('bad');
is $res, 1, 'right result remained';

# reject second, should reject promise
$res = undef;
$p1  = promise {};
$p2  = promise {};
race($p1, $p2)->then(sub {fail}, sub { $res = shift });
$p1->deferred->reject('r');
is $res, 'r', 'right reason';
$p1->deferred->resolve('bad');
$p1->deferred->reject('bad');
is $res, 'r', 'right reason remained';

# not promises
$res = undef;
race(3, 1)->then(sub { $res = shift });
is $res, 3, 'right race';

# thenable should work too
($F, $R) = ();
$res = undef;
$p1 = promise {};
race($p1, Thenable->new)->then(sub { $res = shift });
$F->('th1');
$p1->deferred->resolve('bad');
is $res, 'th1', 'thenable won a race';

# thenable resolve
($F, $R) = ();
$res = undef;
$p1 = promise {};
race(Thenable->new, $p1)->then(sub {fail}, sub { $res = shift });
$R->('thE');
$p1->deferred->resolve('bad');
is $res, 'thE', 'thenable won a race';

done_testing;

{

  package Thenable;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $F = $f; $R = $r }
}

