use Evo;
use Test::More;

BEGIN {
  plan skip_all => 'set TEST_EV env to enable this test' unless $ENV{TEST_EV};
}

use Promises6::EV::Builder;
use EV;
plan tests => 3;

my $bldr = Promises6::EV::Builder->new;

# from blocking
my $safe;
$safe = EV::timer 1, 0, sub { fail; EV::break };
my $d = $bldr->deferred;

my $ok_w;
$d->promise->then(sub { is EV::depth, 1, 'depth 1'; })->then(
  sub {
    is EV::depth, 1, 'depth 1';
    $ok_w = EV::timer 0, 0, sub { shift->data('ok'); EV::break };
  }
);

my $w = EV::timer 0, 0, sub { $d->resolve(1) };

EV::run;
is $ok_w->data, 'ok';

done_testing;
