package Task::BeLike::ALEXBIO;

use warnings;
use strict;

=head1 NAME

Task::BeLike::ALEXBIO - Useful modules list

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

This module installs many useful dependencies

=head1 TASK CONTENTS

=head2 AnyEvent Framework

=over 4

=item * L<AnyEvent>

=item * L<AnyEvent::HTTPD>

=back

=head2 Apps

=over 4

=item * L<App::Ack>

=item * L<App::TwitShell>

=back

=head2 CPAN

=over 4

=item * L<CPAN::Mini>

=item * L<CPAN::SQLite>

=item * L<YAML>

=back

=head2 Encryption

=over 4

=item * L<Crypt::Blowfish>

=item * L<Crypt::CBC>

=item * L<Crypt::RandPasswd>

=back

=head2 Development

=over 4

=item * L<Devel::NYTProf>

=item * L<Devel::Trace>

=item * L<Perl::Critic>

=item * L<Regexp::Common>

=back

=head2 Gnome2

=over 4

=item * L<Gnome2::GConf>

=back

=head2 JSON

=over 4

=item * L<JSON>

=item * L<JSON:PP>

=item * L<JSON::XS>

=back

=head2 Module

=over 4

=item * L<Module::CheckDeps>

=item * L<Module::Starter>

=item * L<Module::Starter::Smart>

=back

=head2 Testing

=over 4

=item * L<Test::Pod>

=item * L<Test::Pod::Coverage>

=item * L<Test::More>

=back

=head2 Web

=over 4

=item * L<LWP>

=item * L<WWW::GitHub::Gist>

=back

=head2 XML

=over 4

=item * L<XML::Simple>

=back

=head1 AUTHOR

Alessandro Ghedini, C<< <alexbio at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-task-belike-alexbio at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-BeLike-ALEXBIO>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::BeLike::ALEXBIO

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-BeLike-ALEXBIO>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-BeLike-ALEXBIO>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-BeLike-ALEXBIO>

=item * Search CPAN

L<http://search.cpan.org/dist/Task-BeLike-ALEXBIO/>

=back

=head1 LICENSE AND COPYRIGHT

Copyright 2010 Alessandro Ghedini.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut

1; # End of Task::BeLike::ALEXBIO
