package WWW::Streamripper::WebUI;

use strict;


require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(install);


use IO::All;
use Archive::Tar;

sub tarball { '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' }

sub install {
    (my $cont = tarball) =~ s/(..)/chr hex($1)/eg;
    io("./webui.tar.gz")->print($cont);
    Archive::Tar->extract_archive("./webui.tar.gz");
    unlink "./webui.tar.gz";
    chmod 0777, qw(config mp3 mp3/incomplete run);
    chmod 0755, qw(bin/get_streams.pl);
    chmod 0666, qw(config/stream_schedule config/stream_source);
    print "WWW::Streamripper::WebUI is Installed.\n";
}




1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

WWW::Streamripper::WebUI - WWW interface for streamripper

=head1 INSTALLATION

 mkdir ~/htdocs/streamripper
 cd ~/htdocs/streamripper
 perl -MWWW::Streamripper::WebUI -e 'install'


=head1 SEE ALSO

L<http://streamripper.sourceforge.net/>. Please have it installed first.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004 by Yung-chung Lin (a.k.a. xern) <xern@cpan.org> This package is free software; you can redistribute it and/or modify it under the same terms as Perl itself

=cut
