/*
 *  Copyright 1999-2001 Vizdom Software, Inc. All Rights Reserved.
 * 
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the same terms as the Perl Kit, namely, under 
 *  the terms of either:
 *
 *      a) the GNU General Public License as published by the Free
 *      Software Foundation; either version 1 of the License, or 
 *      (at your option) any later version, or
 *
 *      b) the "Artistic License" that comes with the Perl Kit.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either
 *  the GNU General Public License or the Artistic License for more 
 *  details.
 */

package com.vizdom.ber;

import java.io.*;

/**
 * Unit testing for the package.
 * 
 * @author John Lacey
 * @version $Revision: 1.13 $
 */
public class TestBer
{
    private static void printHex(byte[] aByteArray)
    {
        for (int i = 0; i < aByteArray.length; i++)
        {
            System.out.print(Integer.toHexString(aByteArray[i] & 0xFF));
            System.out.print(' ');
        }
    }

    private static void printlnHex(byte[] aByteArray)
    {
        printHex(aByteArray);
        System.out.println();
    }

    public static void originalMain(String[] args) throws Exception
    {
        /*
        System.out.println("hello, world");
        printlnHex("ciao, bella".getBytes());

        //BerIdentifier bi = new BerIdentifier(BerTypes.OCTET_STRING);
        {
        System.out.println();
        java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();
        BerOctetString berString = new BerOctetString("hello, world", "ASCII");
        berString.write(bout);
        byte[] bytes = bout.toByteArray();
        System.out.println(new String(bytes));
        printlnHex(bytes);

        System.out.println();
        java.io.ByteArrayInputStream bin = new java.io.ByteArrayInputStream(bytes);
        System.out.println("Identifier = " + new BerIdentifier(bin));
        int length = BerObject.gReadLength(bin);
        System.out.println("Length = " + length);
        BerOctetString inputString = new BerOctetString(bin, length, "ASCII");
        System.out.println("Contents = " + inputString.toString());
        }

        {
        System.out.println();
        java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();
        byte[] octets = new byte[260];
        for (int i = 0; i < octets.length; i++)
            octets[i] = (byte) i;

        BerOctetString berString = new BerOctetString(octets, "ASCII");
        berString.write(bout);
        byte[] bytes = bout.toByteArray();
        System.out.println(new String(bytes));
        printlnHex(bytes);
        }

        {
        System.out.println();
        java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();
        TestString berString = new TestString("hello, world", "ASCII");
        berString.write(bout);
        byte[] bytes = bout.toByteArray();
        System.out.println(new String(bytes));
        printlnHex(bytes);

        System.out.println();
        java.io.ByteArrayInputStream bin = new java.io.ByteArrayInputStream(bytes);
        System.out.println("Identifier = " + new BerIdentifier(bin));
        int length = BerObject.gReadLength(bin);
        System.out.println("Length = " + length);
        BerOctetString inputString = new BerOctetString(bin, length, "ASCII");
        System.out.println("Contents = " + inputString.toString());
        }

        // Integer promotion
        {
        System.out.println();
        int n = 0xFF;
        byte b = (byte) n;
        int n2 = b;
        System.out.println("-1, " + n + ", " + n2);
        }

        // BerInteger
        {
        int[] ints = { 1729, 0, -1, 128, 256, -32768, 32767, 0xFFFFFFFF,
            0x80000000, 0x80000001, 0x80808080, 129, 254, 255, 32768 };
        for (int i = 0; i < ints.length; i++)
        {
        System.out.println();
        java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();
        BerInteger berInt = new BerInteger(ints[i]);
        berInt.write(bout);
        byte[] bytes = bout.toByteArray();
        //System.out.println(new String(bytes));
        System.out.print(berInt + " = ");
        printlnHex(bytes);

        System.out.println();
        java.io.ByteArrayInputStream bin = new java.io.ByteArrayInputStream(bytes);
        System.out.println("Identifier = " + new BerIdentifier(bin));
        int length = BerObject.gReadLength(bin);
        System.out.println("Length = " + length);
        BerInteger inputInt = new BerInteger(bin, length);
        System.out.println("Contents = " + inputInt);
        }
        }
        */
    }


    private static long testBer(int loops) throws Exception
    {
        long before, after;
        
        BerModule module = new BerModule();
        module.setCharacterEncoding("ASCII");
        module.registerFactory(new TestStringFactory());
        //module.registerFactory(new TestStringFactory(), TestString.gIDENTIFIER);

        before = System.currentTimeMillis();
        for (int test = 0; test < loops; test++)
        {
        // BerOctetString
        {
        java.io.ByteArrayOutputStream bout = 
            new java.io.ByteArrayOutputStream();
        BerOctetString berString = new BerOctetString("hello, world", "ASCII");
        berString.writeTo(bout);
        byte[] bytes = bout.toByteArray();
        java.io.ByteArrayInputStream bin = 
            new java.io.ByteArrayInputStream(bytes);
        BerOctetString inputString = (BerOctetString) module.readFrom(bin);
        System.out.println("hello, world = " + inputString.toString());
        }

        // Long BerOctetString
        {
        java.io.ByteArrayOutputStream bout = new java.io.ByteArrayOutputStream();
        byte[] octets = new byte[260];
        for (int i = 0; i < octets.length; i++)
            octets[i] = (byte) i;
        BerOctetString berString = new BerOctetString(octets, "ASCII");
        berString.writeTo(bout);
        byte[] bytes = bout.toByteArray();
        java.io.ByteArrayInputStream bin = 
            new java.io.ByteArrayInputStream(bytes);
        BerOctetString inputString = (BerOctetString) module.readFrom(bin);
        byte[] inputOctets = inputString.toByteArray();
        boolean match = (inputOctets.length == octets.length);
        if (match)
        {
            for (int i = 0; i < inputOctets.length; i++)
            {
                if (inputOctets[i] != octets[i])
                {
                    match = false;
                    break;
                }
            }
        }
        System.out.println("Long octets match: " + match);
        }

        // TestString
        {
        java.io.ByteArrayOutputStream bout = 
            new java.io.ByteArrayOutputStream();
        TestString berString = new TestString("ciao, bella", "ASCII");
        berString.writeTo(bout);
        byte[] bytes = bout.toByteArray();
        java.io.ByteArrayInputStream bin = 
            new java.io.ByteArrayInputStream(bytes);
        TestString inputString = (TestString) module.readFrom(bin);
        System.out.println("ciao, bella = " + inputString.toString());
        }

        // BerInteger
        {
        int[] ints = { 1729, 0, -1, 128, 256, -32768, 32767, 0xFFFFFFFF,
            0x80000000, 0x80000001, 0x80808080, 129, 254, 255, 32768 };
        for (int i = 0; i < ints.length; i++)
        {
        java.io.ByteArrayOutputStream bout = 
            new java.io.ByteArrayOutputStream();
        BerInteger berInt = new BerInteger(ints[i]);
        berInt.writeTo(bout);
        byte[] bytes = bout.toByteArray();
        java.io.ByteArrayInputStream bin = 
            new java.io.ByteArrayInputStream(bytes);
        BerInteger inputInt = (BerInteger) module.readFrom(bin);
        System.out.println(ints[i] + " = " + inputInt);
        }
        }
        }
        after = System.currentTimeMillis();
        System.err.println("New ber time: " + (after - before));
        return after - before;
    }


    private static void testStream() throws Exception
    {
        String s = "All good dogs go to heaven.";
        byte[] bytes = new byte[24];
        int count;

        ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());
        BerContentsInputStream bers = new BerContentsInputStream(bin, 13);
        int b;
        while ((b = bers.read()) != -1)
            System.out.write(b);
        System.out.println("|");

        count = bin.read(bytes);
        System.out.write(bytes, 0, count);
        System.out.println("|");

        bin = new ByteArrayInputStream(s.getBytes());
        bers = new BerContentsInputStream(bin, 13);
        count = bers.read(bytes);
        System.out.write(bytes, 0, count);
        System.out.println("|");

        count = bin.read(bytes);
        System.out.write(bytes, 0, count);
        System.out.println("|");
    }


    private static void testSequence() throws Exception
    {
        BerOctetString berString = new BerOctetString("hello, world", "ASCII");
        BerInteger berInt = new BerInteger(42);
        BerNull berNull = new BerNull();

        BerModule module = new BerModule();
        module.setCharacterEncoding("ASCII");

        java.io.ByteArrayOutputStream bout = 
            new java.io.ByteArrayOutputStream();
        BerSequence berSeq = 
            new BerSequence(new BerObject[] { berString, berInt, berNull });
        berSeq.writeTo(bout);
        byte[] bytes = bout.toByteArray();
        printlnHex(bytes);

        java.io.ByteArrayInputStream bin = 
            new java.io.ByteArrayInputStream(bytes);
        BerSequence inputSeq = (BerSequence) module.readFrom(bin);
        System.out.println("[hello, world, 42, NULL] = " + inputSeq.toString());
    }


    public static void main(String[] args) throws Exception
    {
        if (args.length != 1)
        {
            System.out.println("usage: java TestBer test-number");
            return;
        }

        int which = Integer.parseInt(args[0]);
        switch (which)
        {
        case 0:
            testBer(1);
            break;

        case 1:
            for (int i = 0; i < 4; i++)
                testBer(100);
            break;

        case 2:
            testStream();
            break;

        case 3:
            testSequence();
            break;

            /*
        case 42:
            {
                int length = 68;
                for (int i = 0; i < 4; i++)
                {
                    java.io.ByteArrayOutputStream bout = 
                        new java.io.ByteArrayOutputStream();
                    BerObject.gWriteLength(length, bout);
                    printlnHex(bout.toByteArray());
                    length *= 31;
                }
            }
            break;
            */

        default:
            System.out.println("Unknown test: " + which);
        }
    }
}

class TestString extends BerOctetString
{
    //private static final int TAG_NUMBER = 0x80;
    //private static final int TAG_NUMBER = 4107;
    private static final int TAG_NUMBER = 75;


    static final BerIdentifier gIDENTIFIER = 
        new BerIdentifier(BerTypes.APPLICATION, BerTypes.CONSTRUCTED, TAG_NUMBER);


    TestString(String s, String enc) throws java.io.UnsupportedEncodingException
    {
        super(s, enc);
    }

    TestString()
    {
        super();
    }

    public BerIdentifier getIdentifier()
    {
        return gIDENTIFIER;
    }
}

class TestStringFactory implements BerObjectFactory
{
    public boolean acceptsIdentifier(BerIdentifier anIdentifier)
    {
        return anIdentifier.equals(TestString.gIDENTIFIER);
    }


    public BerObject createBerObject()
    {
        return new TestString();
    }
}

