#!./perl

BEGIN {
    our $hasne;
    try { my @n = @( getnetbyname "loopback" ) };
    $hasne = 1 unless $@ && $@->{description} =~ m/unimplemented|unsupported/i;
    unless ($hasne) { print "1..0 # Skip: no getnetbyname\n"; exit 0 }
    use Config;
    $hasne = 0 unless %Config{'i_netdb'} eq 'define';
    unless ($hasne) { print "1..0 # Skip: no netdb.h\n"; exit 0 }
}

our @netent;

BEGIN {
    @netent = @( getnetbyname "loopback" ); # This is the function getnetbyname.
    unless (nelems @netent) { print "1..0 # Skip: no loopback net\n"; exit 0 }
}

print "1..2\n";

use Net::netent;

print "ok 1\n";

my $netent = getnetbyname "loopback"; # This is the OO getnetbyname.

print "not " unless $netent->name   eq @netent[0];
print "ok 2\n";

# Testing pretty much anything else is unportable;
# e.g. the canonical name of the "loopback" net may be "loop".

