/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.AxisTick;
import gma.MapPoint;
import gma.simr.MappingChain;
import gma.simr.MatchingPredicate;
import gma.simr.PointDisplacementComparator;
import gma.util.ByteParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SearchRectangle {
    public static final String MATCHING_PREDICATE = "matchingPredicate";
    public static final String CHAIN_POINT_AMBIGUITY = "chainPointAmbiguity";
    public static final String SIMR = "simr";
    public boolean debug = false;
    private double defaultSlope;
    private int defaultChainSize;
    private int defaultChainPointAmbiguity;
    private List xAxisTicks = new ArrayList();
    private List yAxisTicks = new ArrayList();
    private PointDisplacementComparator pointDisplacementComparator = new PointDisplacementComparator();
    private SortedSet mapPoints = new TreeSet(this.pointDisplacementComparator);
    private SortedSet noiselessMapPoints = new TreeSet(this.pointDisplacementComparator);
    private List mappingChains = null;
    private MappingChain bestChain = null;
    private boolean hasNewPoint = false;
    private Map xAxisAmbiguityCounter = new HashMap();
    private Map yAxisAmbiguityCounter = new HashMap();
    private Properties properties = null;
    private MatchingPredicate matching = null;

    public SearchRectangle(Properties properties) {
        this.properties = properties;
        String matchingPredicate = properties.getProperty(MATCHING_PREDICATE);
        try {
            Class<?> matchClass = Class.forName(matchingPredicate);
            Object matchingObject = matchClass.newInstance();
            this.matching = (MatchingPredicate)matchingObject;
            this.matching.setProperties(properties);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.defaultSlope = Double.parseDouble(properties.getProperty("slope"));
        this.defaultChainSize = Integer.parseInt(properties.getProperty("chainSize"));
        this.defaultChainPointAmbiguity = Integer.parseInt(properties.getProperty(CHAIN_POINT_AMBIGUITY));
    }

    public void expandSearchRectangle(AxisTick axisTick, boolean isXAxis) {
        if (isXAxis) {
            this.hasNewPoint = false;
        }
        if (isXAxis) {
            this.xAxisTicks.add(axisTick);
            this.matchPoints(this.yAxisTicks, axisTick, false);
        } else {
            this.yAxisTicks.add(axisTick);
            this.matchPoints(this.xAxisTicks, axisTick, true);
        }
    }

    public SearchRectangle reduceSearchRectangle() {
        this.reduceAxisTicks(true);
        this.reduceAxisTicks(false);
        this.reduceMapPoints();
        this.hasNewPoint = false;
        this.bestChain = null;
        this.mappingChains = null;
        this.noiselessMapPoints.clear();
        return this;
    }

    private void reduceAxisTicks(boolean isXAxis) {
        if (isXAxis) {
            AxisTick minAxisTick = this.bestChain.getEndMapPoint(true, true).getXAxisTick();
            this.doReduceAxisTicks(this.xAxisTicks, minAxisTick);
        } else {
            AxisTick minAxisTick = this.bestChain.getEndMapPoint(false, true).getYAxisTick();
            this.doReduceAxisTicks(this.yAxisTicks, minAxisTick);
        }
    }

    private void doReduceAxisTicks(List axisTicks, AxisTick minAxisTick) {
        AxisTick axisTick;
        Iterator iterator = axisTicks.iterator();
        while (iterator.hasNext() && (axisTick = (AxisTick)iterator.next()).isMaxAxisTick(minAxisTick) != 1) {
            iterator.remove();
        }
    }

    private void reduceMapPoints() {
        AxisTick minXAxisTick = this.bestChain.getEndMapPoint(true, true).getXAxisTick();
        AxisTick minYAxisTick = this.bestChain.getEndMapPoint(false, true).getYAxisTick();
        Iterator iterator = this.mapPoints.iterator();
        while (iterator.hasNext()) {
            MapPoint mapPoint = (MapPoint)iterator.next();
            if (mapPoint.getXAxisTick().isMaxAxisTick(minXAxisTick) == 1 && mapPoint.getYAxisTick().isMaxAxisTick(minYAxisTick) == 1) continue;
            iterator.remove();
            this.updateAmbiguityCounters(mapPoint, false);
        }
    }

    public int getNumInstances(boolean isXAxis, AxisTick axisTick) {
        int count = 0;
        if (isXAxis) {
            Iterator xTicks = this.xAxisTicks.iterator();
            while (xTicks.hasNext()) {
                if (!((AxisTick)xTicks.next()).equals(axisTick)) continue;
                ++count;
            }
        } else {
            Iterator yTicks = this.yAxisTicks.iterator();
            while (yTicks.hasNext()) {
                if (!((AxisTick)yTicks.next()).equals(axisTick)) continue;
                ++count;
            }
        }
        return count;
    }

    public AxisTick getBoundaryAxisTick(boolean isXAxis, boolean isMinimum) {
        if (isXAxis) {
            if (isMinimum) {
                return (AxisTick)this.xAxisTicks.get(0);
            }
            return (AxisTick)this.xAxisTicks.get(this.xAxisTicks.size() - 1);
        }
        if (isMinimum) {
            return (AxisTick)this.yAxisTicks.get(0);
        }
        return (AxisTick)this.yAxisTicks.get(this.yAxisTicks.size() - 1);
    }

    public boolean canExpandYAxis() {
        double currentSlope = ((double)((AxisTick)this.yAxisTicks.get(this.yAxisTicks.size() - 1)).getPosition() - (double)((AxisTick)this.yAxisTicks.get(0)).getPosition()) / ((double)((AxisTick)this.xAxisTicks.get(this.xAxisTicks.size() - 1)).getPosition() - (double)((AxisTick)this.xAxisTicks.get(0)).getPosition());
        return currentSlope < this.defaultSlope;
    }

    private void matchPoints(List axisTicks, AxisTick axisTick, boolean listIsXAxis) {
        Iterator iterator = axisTicks.iterator();
        while (iterator.hasNext()) {
            AxisTick tick = (AxisTick)iterator.next();
            if (!this.matching.isMatch(axisTick.getWord(), tick.getWord(), listIsXAxis)) continue;
            ByteParser bp1 = new ByteParser(axisTick.getWord());
            ByteParser bp2 = new ByteParser(tick.getWord());
            MapPoint mapPoint = listIsXAxis ? new MapPoint(tick, axisTick) : new MapPoint(axisTick, tick);
            mapPoint.computeDisplacement(this.defaultSlope);
            boolean dup = false;
            Iterator iteratorTmp = this.mapPoints.iterator();
            while (iteratorTmp.hasNext()) {
                MapPoint mapPointTmp = (MapPoint)iteratorTmp.next();
                if (!mapPoint.getXAxisTick().equals(mapPointTmp.getXAxisTick()) || !mapPoint.getYAxisTick().equals(mapPointTmp.getYAxisTick())) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            this.mapPoints.add(mapPoint);
            int ambiguityCounter = this.getAmbiguityCounters(mapPoint);
            this.updateAmbiguityCounters(mapPoint, true);
            if (ambiguityCounter > this.defaultChainPointAmbiguity) continue;
            this.hasNewPoint = true;
        }
    }

    private int getAmbiguityCounters(MapPoint mapPoint) {
        int counter = this.getAmbiguityCounter(this.xAxisAmbiguityCounter, mapPoint.getXAxisTick());
        return (counter += this.getAmbiguityCounter(this.yAxisAmbiguityCounter, mapPoint.getYAxisTick())) - 2;
    }

    private int getAmbiguityCounter(Map ambiguityCounter, AxisTick axisTick) {
        if (ambiguityCounter.containsKey(axisTick)) {
            return (Integer)ambiguityCounter.get(axisTick);
        }
        return 0;
    }

    private void updateAmbiguityCounters(MapPoint mapPoint, boolean isIncrement) {
        this.updateAmbiguityCounter(this.xAxisAmbiguityCounter, mapPoint.getXAxisTick(), isIncrement);
        this.updateAmbiguityCounter(this.yAxisAmbiguityCounter, mapPoint.getYAxisTick(), isIncrement);
    }

    private void updateAmbiguityCounter(Map ambiguityCounter, AxisTick axisTick, boolean isIncrement) {
        int counter = this.getAmbiguityCounter(ambiguityCounter, axisTick);
        if (isIncrement) {
            ambiguityCounter.put(axisTick, new Integer(++counter));
        } else if (counter > 0) {
            ambiguityCounter.put(axisTick, new Integer(--counter));
        }
    }

    public boolean hasNewPoint() {
        return this.hasNewPoint;
    }

    public boolean hasMappingChain() {
        if (this.xAxisAmbiguityCounter.size() < this.defaultChainSize || this.yAxisAmbiguityCounter.size() < this.defaultChainSize) {
            return false;
        }
        this.noiselessMapPoints = this.removeNoise(this.mapPoints);
        this.mappingChains = this.generateMappingChains(this.noiselessMapPoints);
        this.bestChain = this.findBestChain(this.mappingChains, this.noiselessMapPoints);
        if (this.bestChain != null) {
            if (this.debug) {
                System.err.println("bestChain was not null = hasMappingChain");
                System.err.println(this.noiselessMapPoints);
                System.err.println(this.bestChain);
            }
            return true;
        }
        return false;
    }

    private SortedSet removeNoise(Set noiseMapPoints) {
        TreeSet<MapPoint> noiselessMapPoints = new TreeSet<MapPoint>(this.pointDisplacementComparator);
        Iterator iterator = noiseMapPoints.iterator();
        while (iterator.hasNext()) {
            MapPoint mapPoint = (MapPoint)iterator.next();
            if (this.getAmbiguityCounters(mapPoint) > this.defaultChainPointAmbiguity) continue;
            boolean match = false;
            Iterator silentIterator = noiselessMapPoints.iterator();
            while (silentIterator.hasNext()) {
                MapPoint silentMapPoint = (MapPoint)silentIterator.next();
                if (!silentMapPoint.equals(mapPoint)) continue;
                match = true;
            }
            if (match) continue;
            noiselessMapPoints.add(mapPoint);
        }
        return noiselessMapPoints;
    }

    private List generateMappingChains(Set noiselessMapPoints) {
        ArrayList<MappingChain> mappingChains = new ArrayList<MappingChain>();
        block0: for (int outerIndex = 1; outerIndex <= noiselessMapPoints.size() - this.defaultChainSize + 1; ++outerIndex) {
            Iterator iterator = noiselessMapPoints.iterator();
            int innerIndex = 0;
            MappingChain mappingChain = new MappingChain(this.properties);
            while (iterator.hasNext()) {
                if (++innerIndex < outerIndex) {
                    iterator.next();
                } else {
                    mappingChain.addMapPoint((MapPoint)iterator.next(), true);
                }
                if (innerIndex < outerIndex + this.defaultChainSize - 1) continue;
                mappingChains.add(mappingChain);
                continue block0;
            }
        }
        return mappingChains;
    }

    public MappingChain findBestChain(List mappingChains, SortedSet noiselessMapPoints) {
        while (mappingChains.size() > 0) {
            Iterator iterator = mappingChains.iterator();
            MappingChain leastDisplacedChain = null;
            while (iterator.hasNext()) {
                MappingChain mappingChain = (MappingChain)iterator.next();
                if (!mappingChain.isQualifiedMappingChain()) {
                    iterator.remove();
                    continue;
                }
                if (leastDisplacedChain == null) {
                    leastDisplacedChain = mappingChain;
                    continue;
                }
                if (leastDisplacedChain.isLessDisplaced(mappingChain)) continue;
                leastDisplacedChain = mappingChain;
            }
            if (leastDisplacedChain == null) break;
            boolean result = mappingChains.remove(leastDisplacedChain);
            if (!leastDisplacedChain.isAmbiguous() && leastDisplacedChain.isLegalMappingChain()) {
                return leastDisplacedChain;
            }
            List newMappingChains = this.disambiguateChain(leastDisplacedChain, noiselessMapPoints);
            if (newMappingChains.size() == 0) continue;
            mappingChains.addAll(newMappingChains);
        }
        return null;
    }

    private List disambiguateChain(MappingChain ambiguousChain, SortedSet noiselessMapPoints) {
        Object[] tailPoints;
        ArrayList noiselessArray = new ArrayList();
        Iterator pts = noiselessMapPoints.iterator();
        while (pts.hasNext()) {
            noiselessArray.add(pts.next());
        }
        MapPoint toMapPoint = ambiguousChain.getMapPoint(0);
        int indexTo = noiselessArray.indexOf(toMapPoint);
        List headList = noiselessArray.subList(0, indexTo + 1);
        Object[] headPoints = headList.toArray();
        MapPoint fromMapPoint = ambiguousChain.getMapPoint(ambiguousChain.getChainSize() - 1);
        int indexFrom = noiselessArray.indexOf(fromMapPoint);
        List tailList = new ArrayList();
        if (indexFrom < noiselessArray.size() - 1) {
            tailList = noiselessArray.subList(indexFrom + 1, noiselessArray.size() - 1);
            tailList.add(noiselessArray.get(noiselessArray.size() - 1));
            tailPoints = tailList.toArray();
        }
        tailPoints = tailList.toArray();
        ArrayList<MappingChain> mappingChains = new ArrayList<MappingChain>();
        List disambiguatedChains = ambiguousChain.disambiguateChain();
        Iterator iterator = disambiguatedChains.iterator();
        while (iterator.hasNext()) {
            int loopIndex;
            MappingChain disambiguatedChain = (MappingChain)iterator.next();
            int pointsNeeded = this.defaultChainSize - disambiguatedChain.getChainSize();
            if (headPoints.length - 1 + tailPoints.length < pointsNeeded) continue;
            int headMaxIndex = headPoints.length - 2;
            int n = loopIndex = pointsNeeded < headMaxIndex + 1 ? pointsNeeded : headMaxIndex + 1;
            while (loopIndex >= 0 && pointsNeeded - loopIndex - 1 <= tailPoints.length) {
                int needed = pointsNeeded;
                int lowNeeded = loopIndex;
                MappingChain chain = (MappingChain)disambiguatedChain.clone();
                for (int headIndex = headMaxIndex; headIndex >= 0 && lowNeeded != 0; --headIndex) {
                    if (!chain.addMapPoint((MapPoint)headPoints[headIndex], false)) continue;
                    --needed;
                    --lowNeeded;
                }
                for (int tailIndex = 0; tailIndex < tailPoints.length && needed != 0; ++tailIndex) {
                    if (!chain.addMapPoint((MapPoint)tailPoints[tailIndex], false)) continue;
                    --needed;
                }
                if (chain.getChainSize() == this.defaultChainSize && chain.isQualifiedMappingChain() && chain.isLegalMappingChain()) {
                    mappingChains.add(chain);
                }
                --loopIndex;
            }
        }
        return mappingChains;
    }

    public MappingChain getBestChain() {
        return this.bestChain;
    }
}

