/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.reader;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.io.dataformat.ColumnDescription;
import org.maltparser.core.io.dataformat.DataFormatException;
import org.maltparser.core.io.dataformat.DataFormatInstance;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.TokenStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.core.syntaxgraph.reader.SyntaxGraphReader;

public class TabReader
implements SyntaxGraphReader {
    private BufferedReader reader;
    private int sentenceCount;
    private final StringBuilder input = new StringBuilder();
    private DataFormatInstance dataFormatInstance;
    private static final String IGNORE_COLUMN_SIGN = "_";
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private String fileName = null;
    private URL url = null;
    private String charsetName;
    private int nIterations = 1;
    private int cIterations = 1;
    private boolean closeStream = true;

    private void reopen() throws MaltChainedException {
        this.close();
        if (this.fileName != null) {
            this.open(this.fileName, this.charsetName);
        } else if (this.url != null) {
            this.open(this.url, this.charsetName);
        } else {
            throw new DataFormatException("The input stream cannot be reopen. ");
        }
    }

    public void open(String fileName, String charsetName) throws MaltChainedException {
        this.setFileName(fileName);
        this.setCharsetName(charsetName);
        try {
            this.open(new FileInputStream(fileName), charsetName);
        }
        catch (FileNotFoundException e) {
            throw new DataFormatException("The input file '" + fileName + "' cannot be found. ", e);
        }
    }

    public void open(URL url, String charsetName) throws MaltChainedException {
        this.setUrl(url);
        this.setCharsetName(charsetName);
        if (url == null) {
            throw new DataFormatException("The input file cannot be found. ");
        }
        try {
            this.open(url.openStream(), charsetName);
        }
        catch (IOException e) {
            throw new DataFormatException("The URL '" + url.toString() + "' cannot be opened. ", e);
        }
    }

    public void open(InputStream is, String charsetName) throws MaltChainedException {
        try {
            if (is == System.in) {
                this.closeStream = false;
            }
            this.open(new InputStreamReader(is, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("The character encoding set '" + charsetName + "' isn't supported. ", e);
        }
    }

    private void open(InputStreamReader isr) throws MaltChainedException {
        this.setReader(new BufferedReader(isr));
        this.setSentenceCount(0);
    }

    public void readProlog() throws MaltChainedException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readSentence(TokenStructure syntaxGraph) throws MaltChainedException {
        int c;
        if (syntaxGraph == null || this.dataFormatInstance == null) {
            return false;
        }
        TokenNode node = null;
        Edge edge = null;
        this.input.setLength(0);
        int i = 0;
        int terminalCounter = 0;
        int nNewLines = 0;
        syntaxGraph.clear();
        Iterator<ColumnDescription> columns = this.dataFormatInstance.iterator();
        do {
            try {
                c = this.reader.read();
            }
            catch (IOException e) {
                this.close();
                throw new DataFormatException("Error when reading from the input file. ", e);
            }
            if (c == 9 || c == 10 || c == 13 || c == -1) {
                if (this.input.length() != 0) {
                    if (i == 0) {
                        node = syntaxGraph.addTokenNode(++terminalCounter);
                    }
                    ColumnDescription column = null;
                    if (columns.hasNext()) {
                        column = columns.next();
                        if (column.getCategory() == 1 && node != null) {
                            syntaxGraph.addLabel(node, column.getName(), this.input.toString());
                        } else if (column.getCategory() == 2) {
                            if (!(syntaxGraph instanceof DependencyStructure)) {
                                this.close();
                                throw new DataFormatException("The input graph is not a dependency graph and therefore it is not possible to add dependncy edges. ");
                            }
                            if (column.getType() != 5 && !this.input.toString().equals(IGNORE_COLUMN_SIGN)) {
                                edge = ((DependencyStructure)syntaxGraph).addDependencyEdge(Integer.parseInt(this.input.toString()), terminalCounter);
                            }
                        } else if (column.getCategory() == 3 && edge != null) {
                            syntaxGraph.addLabel(edge, column.getName(), this.input.toString());
                        }
                    }
                    this.input.setLength(0);
                    nNewLines = 0;
                    ++i;
                } else if (c == 9) {
                    throw new MaltChainedException("The input file '" + this.fileName + "' contains a column where the value is an empty string. Please check your input file. ");
                }
                if (c == 10) {
                    ++nNewLines;
                    i = 0;
                    columns = this.dataFormatInstance.iterator();
                }
            } else {
                this.input.append((char)c);
            }
            if (nNewLines != 2 || c != 10) continue;
            if (syntaxGraph.hasTokens()) {
                ++this.sentenceCount;
            }
            return true;
        } while (c != -1);
        if (syntaxGraph.hasTokens()) {
            ++this.sentenceCount;
        }
        if (this.cIterations < this.nIterations) {
            ++this.cIterations;
            this.reopen();
            return true;
        }
        return false;
    }

    public void readEpilog() throws MaltChainedException {
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public void setReader(BufferedReader reader) throws MaltChainedException {
        this.close();
        this.reader = reader;
    }

    public DataFormatInstance getDataFormatInstance() {
        return this.dataFormatInstance;
    }

    public void setDataFormatInstance(DataFormatInstance dataFormatInstance) {
        this.dataFormatInstance = dataFormatInstance;
    }

    public int getSentenceCount() throws MaltChainedException {
        return this.sentenceCount;
    }

    public void setSentenceCount(int sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public String getOptions() {
        return null;
    }

    public void setOptions(String optionString) throws MaltChainedException {
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public int getNIterations() {
        return this.nIterations;
    }

    public void setNIterations(int iterations) {
        this.nIterations = iterations;
    }

    public int getIterationCounter() {
        return this.cIterations;
    }

    public void close() throws MaltChainedException {
        try {
            if (this.reader != null) {
                if (this.closeStream) {
                    this.reader.close();
                }
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new DataFormatException("Error when closing the input file. ", e);
        }
    }

    public void clear() throws MaltChainedException {
        this.close();
        this.input.setLength(0);
        this.dataFormatInstance = null;
        this.sentenceCount = 0;
    }
}

