/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.symbol.nullvalue.NullValues;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;
import org.maltparser.core.syntaxgraph.node.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcDirFeature
implements FeatureFunction {
    protected AddressFunction addressFunction;
    protected SymbolTableHandler tableHandler;
    protected SymbolTable table;
    protected SingleFeatureValue featureValue = new SingleFeatureValue(this);

    public ArcDirFeature(SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setTableHandler(tableHandler);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1) {
            throw new SyntaxGraphException("Could not initialize ArcDirFeature: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize ArcDirFeature: the first argument is not an address function. ");
        }
        this.setAddressFunction((AddressFunction)arguments[0]);
        this.setSymbolTable(this.tableHandler.addSymbolTable("ARCDIR", 1, "one"));
        this.table.addSymbol("LEFT");
        this.table.addSymbol("RIGHT");
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{AddressFunction.class};
        return paramTypes;
    }

    @Override
    public String getSymbol(int code) throws MaltChainedException {
        return this.table.getSymbolCodeToString(code);
    }

    @Override
    public int getCode(String symbol) throws MaltChainedException {
        return this.table.getSymbolStringToCode(symbol);
    }

    @Override
    public void updateCardinality() {
        this.featureValue.setCardinality(this.table.getValueCounter());
    }

    @Override
    public void update() throws MaltChainedException {
        if (this.addressFunction.getAddressValue().getAddress() != null) {
            DependencyNode node = (DependencyNode)this.addressFunction.getAddressValue().getAddress();
            if (!node.isRoot()) {
                if (node.getHead().getIndex() < node.getIndex()) {
                    this.featureValue.setCode(this.table.getSymbolStringToCode("LEFT"));
                    this.featureValue.setSymbol("LEFT");
                    this.featureValue.setKnown(true);
                    this.featureValue.setNullValue(false);
                } else {
                    this.featureValue.setCode(this.table.getSymbolStringToCode("RIGHT"));
                    this.featureValue.setSymbol("RIGHT");
                    this.featureValue.setKnown(true);
                    this.featureValue.setNullValue(false);
                }
            } else {
                this.featureValue.setCode(this.table.getNullValueCode(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setSymbol(this.table.getNullValueSymbol(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setKnown(true);
                this.featureValue.setNullValue(true);
            }
        } else {
            this.featureValue.setCode(this.table.getNullValueCode(NullValues.NullValueId.NO_NODE));
            this.featureValue.setSymbol(this.table.getNullValueSymbol(NullValues.NullValueId.NO_NODE));
            this.featureValue.setKnown(true);
            this.featureValue.setNullValue(true);
        }
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public AddressFunction getAddressFunction() {
        return this.addressFunction;
    }

    public void setAddressFunction(AddressFunction addressFunction) {
        this.addressFunction = addressFunction;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return 217 + (null == this.toString() ? 0 : this.toString().hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArcDir(");
        sb.append(this.addressFunction.toString());
        sb.append(')');
        return sb.toString();
    }
}

