/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nowrad;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.nowrad.NOWRadheader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class NOWRadiosp
extends AbstractIOServiceProvider {
    static final int DEF_WBITS = 15;
    static final int Z_DEFLATED = 8;
    protected int fileUsed = 0;
    protected int recStart = 0;
    protected boolean debug = false;
    protected boolean debugSize = false;
    protected boolean debugSPIO = false;
    protected boolean showHeaderBytes = false;
    protected HashMap dimHash = new HashMap(50);
    protected boolean fill;
    protected NOWRadheader headerParser;
    private RandomAccessFile myRaf;
    private NetcdfFile ncfile;
    private int pcode;
    protected boolean readonly;

    public boolean isValidFile(RandomAccessFile raf) {
        NOWRadheader localHeader = new NOWRadheader();
        return localHeader.isValidFile(raf);
    }

    public String getFileTypeId() {
        return "NOWRAD";
    }

    public String getFileTypeDescription() {
        return "NOWRAD Products";
    }

    public void open(RandomAccessFile raf, NetcdfFile file, CancelTask cancelTask) throws IOException {
        this.ncfile = file;
        this.myRaf = raf;
        this.headerParser = new NOWRadheader();
        try {
            this.headerParser.read(this.myRaf, this.ncfile);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pcode = 0;
        this.ncfile.finish();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        byte[] vdata = null;
        List<Range> ranges = section.getRanges();
        NOWRadheader.Vinfo vinfo = (NOWRadheader.Vinfo)v2.getSPobject();
        try {
            vdata = this.headerParser.getData((int)vinfo.hoff);
        }
        catch (Exception e) {
            // empty catch block
        }
        ByteBuffer bos = ByteBuffer.wrap(vdata);
        Object data = this.readOneScanData(bos, vinfo, v2.getName());
        Array outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), data);
        outputData = outputData.flip(1);
        return outputData.sectionNoReduce(ranges).copy();
    }

    public Object readOneScanData(ByteBuffer bos, NOWRadheader.Vinfo vinfo, String vName) throws IOException, InvalidRangeException {
        int doff = (int)vinfo.hoff;
        int npixel = vinfo.yt * vinfo.xt;
        byte[] rdata = null;
        byte[] ldata = new byte[vinfo.xt];
        byte[] pdata = new byte[npixel];
        byte[] b2 = new byte[2];
        bos.position(doff);
        if (this.convertunsignedByte2Short(bos.get()) != 240 || bos.get() != 12) {
            return null;
        }
        int offset = 0;
        int roffset = 0;
        boolean newline = true;
        int linenum = 0;
        while (true) {
            int datarun;
            if (newline) {
                bos.get(b2);
                linenum = (this.convertunsignedByte2Short(b2[1]) << 8) + this.convertunsignedByte2Short(b2[0]);
            }
            short b = this.convertunsignedByte2Short(bos.get());
            int color = b & 0xF;
            int ecode = b >> 4;
            int datapos = bos.position();
            if (ecode == 15) {
                byte bb1 = bos.get(datapos - 2);
                byte bb2 = bos.get(datapos);
                if (color == 0 && bb1 == 0 && bb2 == 0) {
                    ++datapos;
                }
                bos.position(datapos);
                datarun = 0;
            } else if (ecode == 14) {
                byte b0 = bos.get(datapos);
                datarun = this.convertunsignedByte2Short(b0) + 1;
                bos.position(++datapos);
            } else if (ecode == 13) {
                b2[0] = bos.get(datapos);
                b2[1] = bos.get(datapos + 1);
                datarun = (this.convertunsignedByte2Short(b2[1]) << 8) + this.convertunsignedByte2Short(b2[0]) + 1;
                bos.position(datapos += 2);
            } else {
                datarun = ecode + 1;
            }
            rdata = new byte[datarun];
            for (int i = 0; i < datarun; ++i) {
                rdata[i] = (byte)color;
            }
            System.arraycopy(rdata, 0, ldata, roffset, datarun);
            roffset += datarun;
            short c0 = this.convertunsignedByte2Short(bos.get());
            if (c0 == 0) {
                short c1 = this.convertunsignedByte2Short(bos.get());
                short c2 = this.convertunsignedByte2Short(bos.get());
                if (c0 == 0 && c1 == 240 && c2 == 12) {
                    System.arraycopy(ldata, 0, pdata, offset, roffset);
                    offset += vinfo.xt;
                    roffset = 0;
                    newline = true;
                    ldata = new byte[vinfo.xt];
                    continue;
                }
                if (c1 == 240 && c2 == 2) break;
                datapos = bos.position() - 3;
                bos.position(datapos);
                newline = false;
                continue;
            }
            newline = false;
            datapos = bos.position();
            bos.position(datapos - 1);
        }
        return pdata;
    }

    int getUInt(byte[] b, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[i]);
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    public static int bytesToInt(short a, short b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public static int bytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public byte[] readOneRowData(byte[] ddata, int rLen, int xt) throws IOException, InvalidRangeException {
        int run;
        byte[] bdata = new byte[xt];
        int nbin = 0;
        int total = 0;
        for (run = 0; run < rLen; ++run) {
            int drun = this.convertunsignedByte2Short(ddata[run]) >> 4;
            byte dcode1 = (byte)(this.convertunsignedByte2Short(ddata[run]) & 0xF);
            for (int i = 0; i < drun; ++i) {
                bdata[nbin++] = dcode1;
                ++total;
            }
        }
        if (total < xt) {
            for (run = total; run < xt; ++run) {
                bdata[run] = 0;
            }
        }
        return bdata;
    }

    int getUInt(byte[] b, int offset, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[offset + i]);
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    int getInt(byte[] b, int offset, int num) {
        int i;
        int base = 1;
        int word = 0;
        int[] bv = new int[num];
        for (i = 0; i < num; ++i) {
            bv[i] = this.convertunsignedByte2Short(b[offset + i]);
        }
        if (bv[0] > 127) {
            bv[0] = bv[0] - 128;
            base = -1;
        }
        for (i = num - 1; i >= 0; --i) {
            word += base * bv[i];
            base *= 256;
        }
        return word;
    }

    public short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public void flush() throws IOException {
        this.myRaf.flush();
    }

    public void close() throws IOException {
        this.myRaf.close();
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "z:/nowrad/BREF_951207_2230";
        NetcdfFile.registerIOProvider(NOWRadiosp.class);
        NetcdfFile ncf = NetcdfFile.open(fileIn);
        Variable v = ncf.findVariable("BaseReflectivity");
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{300, 36};
        ArrayByte data = (ArrayByte)v.read(origin, shape);
        ncf.close();
    }
}

