/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;
import ucar.nc2.ft.point.standard.plug.UnidataPointDatasetHelper;

public class UnidataPointFeature
extends TableConfigurerImpl {
    private static final String STN_NAME = "name";
    private static final String STN_LAT = "Latitude";
    private static final String STN_LON = "Longitude";
    private static final String STN_ELEV = "Height_of_station";

    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        FeatureType featureType = FeatureDatasetFactoryManager.findFeatureType(ds);
        if (featureType != FeatureType.STATION_PROFILE) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Point Feature v1.0")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        TableConfig nt = new TableConfig(Table.Type.ArrayStructure, "station");
        nt.featureType = FeatureType.STATION_PROFILE;
        nt.structName = "station";
        nt.stnId = STN_NAME;
        nt.lat = STN_LAT;
        nt.lon = STN_LON;
        nt.elev = STN_ELEV;
        TableConfig obs = new TableConfig(Table.Type.Structure, "obsRecord");
        obs.structName = "record";
        obs.dimName = Evaluator.getDimensionName(ds, "record", errlog);
        obs.lat = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lat);
        obs.lon = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Lon);
        obs.elev = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height);
        obs.time = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Time);
        obs.stnId = Evaluator.getVariableName(ds, STN_NAME, errlog);
        nt.addChild(obs);
        TableConfig levels = new TableConfig(Table.Type.Structure, "seq1");
        levels.structName = "seq1";
        levels.elev = UnidataPointDatasetHelper.getCoordinateName(ds, AxisType.Height);
        obs.addChild(levels);
        return nt;
    }
}

