# Copyright (c) 2005 - 2006 Hans Jeuken. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

# This file was generated from the 'nasm.xml' file of the syntax highlight
# engine of the kate text editor (http://www.kate-editor.org

#kate xml version 1.20
#kate version 2.3
#kate author Nicola Gigante (nicola.gigante@gmail.com)
#generated: Sun Feb  3 22:02:05 2008, localtime

package Syntax::Highlight::Engine::Kate::Intel_x86_NASM;

our $VERSION = '0.06';

use strict;
use warnings;
use base('Syntax::Highlight::Engine::Kate::Template');

sub new {
   my $proto = shift;
   my $class = ref($proto) || $proto;
   my $self = $class->SUPER::new(@_);
   $self->attributes({
      'BaseN' => 'BaseN',
      'Char' => 'Char',
      'Comment' => 'Comment',
      'Data' => 'DataType',
      'Float' => 'Float',
      'Instructions' => 'Keyword',
      'Label' => 'Function',
      'NASM Keywords' => 'Keyword',
      'Normal Text' => 'Normal',
      'Number' => 'DecVal',
      'Preprocessor' => 'Others',
      'Registers' => 'Keyword',
      'String' => 'String',
   });
   $self->listAdd('Data',
      'byte',
      'db',
      'dd',
      'dq',
      'dt',
      'dw',
      'dword',
      'equ',
      'incbin',
      'ptr',
      'qword',
      'resb',
      'resd',
      'resq',
      'rest',
      'resw',
      'short',
      'times',
      'word',
   );
   $self->listAdd('NASM Keywords',
      '__FILE__',
      '__LINE__',
      '__NASM_MAJOR__',
      '__NASM_MINOR__',
      '__NASM_SUBMINOR__',
      '__NASM_VERSION_ID__',
      '__NASM_VER__',
      '___NASM_PATCHLEVEL__',
      '__sect__',
      'absolute',
      'align',
      'alignb',
      'at',
      'bits',
      'common',
      'endstruc',
      'extern',
      'global',
      'iend',
      'istruc',
      'org',
      'section',
      'seg',
      'segment',
      'strict',
      'struc',
      'use16',
      'use32',
      'wrt',
   );
   $self->listAdd('instructions',
      'aaa',
      'aaa',
      'aad',
      'aad',
      'aam',
      'aam',
      'aas',
      'aas',
      'adc',
      'adc',
      'add',
      'add',
      'addpd',
      'addpd',
      'addps',
      'addps',
      'addsd',
      'addsd',
      'addss',
      'addss',
      'and',
      'and',
      'andnpd',
      'andnpd',
      'andnps',
      'andnps',
      'andpd',
      'andpd',
      'andps',
      'andps',
      'arpl',
      'arpl',
      'bound',
      'bound',
      'bsf',
      'bsf',
      'bsr',
      'bsr',
      'bswap',
      'bswap',
      'bt',
      'bt',
      'btc',
      'btc',
      'btr',
      'btr',
      'bts',
      'bts',
      'call',
      'call',
      'cbw',
      'cbw',
      'cdq',
      'cdq',
      'clc',
      'clc',
      'cld',
      'cld',
      'clflush',
      'clflush',
      'cli',
      'cli',
      'clts',
      'clts',
      'cmc',
      'cmc',
      'cmovcc',
      'cmovcc',
      'cmp',
      'cmp',
      'cmpeqpd',
      'cmpeqpd',
      'cmpeqps',
      'cmpeqps',
      'cmpeqsd',
      'cmpeqsd',
      'cmpeqss',
      'cmpeqss',
      'cmplepd',
      'cmplepd',
      'cmpleps',
      'cmpleps',
      'cmplesd',
      'cmplesd',
      'cmpless',
      'cmpless',
      'cmpltpd',
      'cmpltpd',
      'cmpltps',
      'cmpltps',
      'cmpltsd',
      'cmpltsd',
      'cmpltss',
      'cmpltss',
      'cmpneqpd',
      'cmpneqpd',
      'cmpneqps',
      'cmpneqps',
      'cmpneqsd',
      'cmpneqsd',
      'cmpneqss',
      'cmpneqss',
      'cmpnlepd',
      'cmpnlepd',
      'cmpnleps',
      'cmpnleps',
      'cmpnlesd',
      'cmpnlesd',
      'cmpnless',
      'cmpnless',
      'cmpnltpd',
      'cmpnltpd',
      'cmpnltps',
      'cmpnltps',
      'cmpnltsd',
      'cmpnltsd',
      'cmpnltss',
      'cmpnltss',
      'cmpordpd',
      'cmpordpd',
      'cmpordps',
      'cmpordps',
      'cmpordsd',
      'cmpordsd',
      'cmpordss',
      'cmpordss',
      'cmppd',
      'cmppd',
      'cmpps',
      'cmpps',
      'cmpsb',
      'cmpsb',
      'cmpsd',
      'cmpsd',
      'cmpss',
      'cmpss',
      'cmpsw',
      'cmpsw',
      'cmpunordpd',
      'cmpunordpd',
      'cmpunordps',
      'cmpunordps',
      'cmpunordsd',
      'cmpunordsd',
      'cmpunordss',
      'cmpunordss',
      'cmpxchg',
      'cmpxchg',
      'cmpxchg486',
      'cmpxchg486',
      'cmpxchg8b',
      'cmpxchg8b',
      'comisd',
      'comisd',
      'comiss',
      'comiss',
      'cpuid',
      'cpuid',
      'cvtdq2pd',
      'cvtdq2pd',
      'cvtdq2ps',
      'cvtdq2ps',
      'cvtpd2dq',
      'cvtpd2dq',
      'cvtpd2pi',
      'cvtpd2pi',
      'cvtpd2ps',
      'cvtpd2ps',
      'cvtpi2pd',
      'cvtpi2pd',
      'cvtpi2ps',
      'cvtpi2ps',
      'cvtps2dq',
      'cvtps2dq',
      'cvtps2pd',
      'cvtps2pd',
      'cvtps2pi',
      'cvtps2pi',
      'cvtsd2si',
      'cvtsd2si',
      'cvtsd2ss',
      'cvtsd2ss',
      'cvtsi2sd',
      'cvtsi2sd',
      'cvtsi2ss',
      'cvtsi2ss',
      'cvtss2sd',
      'cvtss2sd',
      'cvtss2si',
      'cvtss2si',
      'cvttpd2dq',
      'cvttpd2dq',
      'cvttpd2pi',
      'cvttpd2pi',
      'cvttps2dq',
      'cvttps2dq',
      'cvttps2pi',
      'cvttps2pi',
      'cvttsd2si',
      'cvttsd2si',
      'cwd',
      'cwd',
      'cwde',
      'cwde',
      'daa',
      'daa',
      'das',
      'das',
      'dec',
      'dec',
      'div',
      'div',
      'divpd',
      'divpd',
      'divps',
      'divps',
      'divsd',
      'divsd',
      'divss',
      'divss',
      'emms',
      'emms',
      'enter',
      'enter',
      'f2xm1',
      'f2xm1',
      'fabs',
      'fabs',
      'fadd',
      'fadd',
      'faddp',
      'faddp',
      'fbld',
      'fbld',
      'fbstp',
      'fbstp',
      'fchs',
      'fchs',
      'fclex',
      'fclex',
      'fcmovb',
      'fcmovb',
      'fcmovbe',
      'fcmovbe',
      'fcmove',
      'fcmove',
      'fcmovnb',
      'fcmovnb',
      'fcmovnbe',
      'fcmovnbe',
      'fcmovne',
      'fcmovne',
      'fcmovnu',
      'fcmovnu',
      'fcmovu',
      'fcmovu',
      'fcom',
      'fcom',
      'fcomi',
      'fcomi',
      'fcomip',
      'fcomip',
      'fcomp',
      'fcomp',
      'fcompp',
      'fcompp',
      'fcos',
      'fcos',
      'fdecstp',
      'fdecstp',
      'fdisi',
      'fdisi',
      'fdiv',
      'fdiv',
      'fdivp',
      'fdivp',
      'fdivr',
      'fdivr',
      'fdivrp',
      'fdivrp',
      'femms',
      'femms',
      'feni',
      'feni',
      'ffree',
      'ffree',
      'ffreep',
      'ffreep',
      'fiadd',
      'fiadd',
      'ficom',
      'ficom',
      'ficomp',
      'ficomp',
      'fidiv',
      'fidiv',
      'fidivr',
      'fidivr',
      'fild',
      'fild',
      'fimul',
      'fimul',
      'fincstp',
      'fincstp',
      'finit',
      'finit',
      'fist',
      'fist',
      'fistp',
      'fistp',
      'fisub',
      'fisub',
      'fisubr',
      'fisubr',
      'fld',
      'fld',
      'fld1',
      'fld1',
      'fldcw',
      'fldcw',
      'fldenv',
      'fldenv',
      'fldl2e',
      'fldl2e',
      'fldl2t',
      'fldl2t',
      'fldlg2',
      'fldlg2',
      'fldln2',
      'fldln2',
      'fldpi',
      'fldpi',
      'fldz',
      'fldz',
      'fmul',
      'fmul',
      'fmulp',
      'fmulp',
      'fnclex',
      'fnclex',
      'fndisi',
      'fndisi',
      'fneni',
      'fneni',
      'fninit',
      'fninit',
      'fnop',
      'fnop',
      'fnsave',
      'fnsave',
      'fnstcw',
      'fnstcw',
      'fnstenv',
      'fnstenv',
      'fnstsw',
      'fnstsw',
      'fpatan',
      'fpatan',
      'fprem',
      'fprem',
      'fprem1',
      'fprem1',
      'fptan',
      'fptan',
      'frndint',
      'frndint',
      'frstor',
      'frstor',
      'fsave',
      'fsave',
      'fscale',
      'fscale',
      'fsetpm',
      'fsetpm',
      'fsin',
      'fsin',
      'fsincos',
      'fsincos',
      'fsqrt',
      'fsqrt',
      'fst',
      'fst',
      'fstcw',
      'fstcw',
      'fstenv',
      'fstenv',
      'fstp',
      'fstp',
      'fstsw',
      'fstsw',
      'fsub',
      'fsub',
      'fsubp',
      'fsubp',
      'fsubr',
      'fsubr',
      'fsubrp',
      'fsubrp',
      'ftst',
      'ftst',
      'fucom',
      'fucom',
      'fucomi',
      'fucomi',
      'fucomip',
      'fucomip',
      'fucomp',
      'fucomp',
      'fucompp',
      'fucompp',
      'fwait',
      'fwait',
      'fxam',
      'fxam',
      'fxch',
      'fxch',
      'fxrstor',
      'fxrstor',
      'fxsave',
      'fxsave',
      'fxtract',
      'fxtract',
      'fyl2x',
      'fyl2x',
      'fyl2xp1',
      'fyl2xp1',
      'hlt',
      'hlt',
      'ibts',
      'ibts',
      'icebp',
      'icebp',
      'idiv',
      'idiv',
      'imul',
      'imul',
      'in',
      'in',
      'inc',
      'inc',
      'insb',
      'insb',
      'insd',
      'insd',
      'insw',
      'insw',
      'int',
      'int',
      'int01',
      'int01',
      'int03',
      'int03',
      'int1',
      'int1',
      'int3',
      'int3',
      'into',
      'into',
      'invd',
      'invd',
      'invlpg',
      'invlpg',
      'iret',
      'iret',
      'iretd',
      'iretd',
      'iretw',
      'iretw',
      'jcc',
      'jcc',
      'jcxz',
      'jcxz',
      'jecxz',
      'jecxz',
      'jmp',
      'jmp',
      'lahf',
      'lahf',
      'lar',
      'lar',
      'ldmxcsr',
      'ldmxcsr',
      'lds',
      'lds',
      'lea',
      'lea',
      'leave',
      'leave',
      'les',
      'les',
      'lfence',
      'lfence',
      'lfs',
      'lfs',
      'lgdt',
      'lgdt',
      'lgs',
      'lgs',
      'lidt',
      'lidt',
      'lldt',
      'lldt',
      'lmsw',
      'lmsw',
      'loadall',
      'loadall',
      'loadall286',
      'loadall286',
      'lodsb',
      'lodsb',
      'lodsd',
      'lodsd',
      'lodsw',
      'lodsw',
      'loop',
      'loop',
      'loope',
      'loope',
      'loopne',
      'loopne',
      'loopnz',
      'loopnz',
      'loopz',
      'loopz',
      'lsl',
      'lsl',
      'lss',
      'lss',
      'ltr',
      'ltr',
      'maskmovdqu',
      'maskmovdqu',
      'maskmovq',
      'maskmovq',
      'maxpd',
      'maxpd',
      'maxps',
      'maxps',
      'maxsd',
      'maxsd',
      'maxss',
      'maxss',
      'mfence',
      'mfence',
      'minpd',
      'minpd',
      'minps',
      'minps',
      'minsd',
      'minsd',
      'minss',
      'minss',
      'mov',
      'mov',
      'movapd',
      'movapd',
      'movaps',
      'movaps',
      'movd',
      'movd',
      'movdq2q',
      'movdq2q',
      'movdqa',
      'movdqa',
      'movdqu',
      'movdqu',
      'movhlps',
      'movhlps',
      'movhpd',
      'movhpd',
      'movhps',
      'movhps',
      'movlhps',
      'movlhps',
      'movlpd',
      'movlpd',
      'movlps',
      'movlps',
      'movmskpd',
      'movmskpd',
      'movmskps',
      'movmskps',
      'movntdq',
      'movntdq',
      'movnti',
      'movnti',
      'movntpd',
      'movntpd',
      'movntps',
      'movntps',
      'movntq',
      'movntq',
      'movq',
      'movq',
      'movq2dq',
      'movq2dq',
      'movsb',
      'movsb',
      'movsd',
      'movsd',
      'movss',
      'movss',
      'movsw',
      'movsw',
      'movsx',
      'movsx',
      'movupd',
      'movupd',
      'movups',
      'movups',
      'movzx',
      'movzx',
      'mul',
      'mul',
      'mulpd',
      'mulpd',
      'mulps',
      'mulps',
      'mulsd',
      'mulsd',
      'mulss',
      'mulss',
      'neg',
      'neg',
      'nop',
      'nop',
      'not',
      'not',
      'or',
      'or',
      'orpd',
      'orpd',
      'orps',
      'orps',
      'out',
      'out',
      'outsb',
      'outsb',
      'outsd',
      'outsd',
      'outsw',
      'outsw',
      'packssdw',
      'packssdw',
      'packssdw',
      'packsswb',
      'packsswb',
      'packsswb',
      'packuswb',
      'packuswb',
      'packuswb',
      'paddb',
      'paddb',
      'paddb',
      'paddd',
      'paddd',
      'paddd',
      'paddq',
      'paddq',
      'paddsb',
      'paddsb',
      'paddsb',
      'paddsiw',
      'paddsiw',
      'paddsw',
      'paddsw',
      'paddsw',
      'paddusb',
      'paddusb',
      'paddusb',
      'paddusw',
      'paddusw',
      'paddusw',
      'paddw',
      'paddw',
      'paddw',
      'pand',
      'pand',
      'pand',
      'pandn',
      'pandn',
      'pandn',
      'pause',
      'pause',
      'paveb',
      'paveb',
      'pavgb',
      'pavgb',
      'pavgb',
      'pavgusb',
      'pavgusb',
      'pavgw',
      'pavgw',
      'pavgw',
      'pcmpeqb',
      'pcmpeqb',
      'pcmpeqb',
      'pcmpeqd',
      'pcmpeqd',
      'pcmpeqd',
      'pcmpeqw',
      'pcmpeqw',
      'pcmpeqw',
      'pcmpgtb',
      'pcmpgtb',
      'pcmpgtb',
      'pcmpgtd',
      'pcmpgtd',
      'pcmpgtd',
      'pcmpgtw',
      'pcmpgtw',
      'pcmpgtw',
      'pdistib',
      'pdistib',
      'pextrw',
      'pextrw',
      'pf2id',
      'pf2id',
      'pf2iw',
      'pf2iw',
      'pfacc',
      'pfacc',
      'pfadd',
      'pfadd',
      'pfcmpeq',
      'pfcmpeq',
      'pfcmpge',
      'pfcmpge',
      'pfcmpgt',
      'pfcmpgt',
      'pfmax',
      'pfmax',
      'pfmin',
      'pfmin',
      'pfmul',
      'pfmul',
      'pfnacc',
      'pfnacc',
      'pfpnacc',
      'pfpnacc',
      'pfrcp',
      'pfrcp',
      'pfrcpit1',
      'pfrcpit1',
      'pfrcpit2',
      'pfrcpit2',
      'pfrsqit1',
      'pfrsqit1',
      'pfrsqrt',
      'pfrsqrt',
      'pfsub',
      'pfsub',
      'pfsubr',
      'pfsubr',
      'pi2fd',
      'pi2fd',
      'pi2fw',
      'pi2fw',
      'pinsrw',
      'pinsrw',
      'pmachriw',
      'pmachriw',
      'pmaddwd',
      'pmaddwd',
      'pmagw',
      'pmagw',
      'pmaxsw',
      'pmaxsw',
      'pmaxub',
      'pmaxub',
      'pminsw',
      'pminsw',
      'pminub',
      'pminub',
      'pmovmskb',
      'pmovmskb',
      'pmulhriw',
      'pmulhriw',
      'pmulhrwa',
      'pmulhrwa',
      'pmulhrwc',
      'pmulhrwc',
      'pmulhuw',
      'pmulhuw',
      'pmulhw',
      'pmulhw',
      'pmulhw',
      'pmullw',
      'pmullw',
      'pmullw',
      'pmuludq',
      'pmuludq',
      'pmvgezb',
      'pmvgezb',
      'pmvlzb',
      'pmvlzb',
      'pmvnzb',
      'pmvnzb',
      'pmvzb',
      'pmvzb',
      'pop',
      'pop',
      'popa',
      'popa',
      'popad',
      'popad',
      'popaw',
      'popaw',
      'popf',
      'popf',
      'popfd',
      'popfd',
      'popfw',
      'popfw',
      'por',
      'por',
      'prefetch',
      'prefetch',
      'prefetchnta',
      'prefetchnta',
      'prefetcht0',
      'prefetcht0',
      'prefetcht1',
      'prefetcht1',
      'prefetcht2',
      'prefetcht2',
      'prefetchw',
      'prefetchw',
      'psadbw',
      'psadbw',
      'pshufd',
      'pshufd',
      'pshufhw',
      'pshufhw',
      'pshuflw',
      'pshuflw',
      'pshufw',
      'pshufw',
      'pslld',
      'pslld',
      'pslldq',
      'pslldq',
      'psllq',
      'psllq',
      'psllw',
      'psllw',
      'psrad',
      'psrad',
      'psraw',
      'psraw',
      'psrld',
      'psrld',
      'psrldq',
      'psrldq',
      'psrlq',
      'psrlq',
      'psrlw',
      'psrlw',
      'psubb',
      'psubb',
      'psubb',
      'psubd',
      'psubd',
      'psubd',
      'psubq',
      'psubq',
      'psubq',
      'psubsb',
      'psubsb',
      'psubsb',
      'psubsiw',
      'psubsiw',
      'psubsw',
      'psubsw',
      'psubsw',
      'psubusb',
      'psubusb',
      'psubusb',
      'psubusw',
      'psubusw',
      'psubusw',
      'psubw',
      'psubw',
      'psubw',
      'pswapd',
      'pswapd',
      'punpckhbw',
      'punpckhbw',
      'punpckhbw',
      'punpckhdq',
      'punpckhdq',
      'punpckhdq',
      'punpckhqdq',
      'punpckhqdq',
      'punpckhwd',
      'punpckhwd',
      'punpckhwd',
      'punpcklbw',
      'punpcklbw',
      'punpcklbw',
      'punpckldq',
      'punpckldq',
      'punpckldq',
      'punpcklqdq',
      'punpcklqdq',
      'punpcklwd',
      'punpcklwd',
      'punpcklwd',
      'push',
      'push',
      'pusha',
      'pusha',
      'pushad',
      'pushad',
      'pushaw',
      'pushaw',
      'pushf',
      'pushf',
      'pushfd',
      'pushfd',
      'pushfw',
      'pushfw',
      'pxor',
      'pxor',
      'rcl',
      'rcl',
      'rcpps',
      'rcpps',
      'rcpss',
      'rcpss',
      'rcr',
      'rcr',
      'rdmsr',
      'rdmsr',
      'rdpmc',
      'rdpmc',
      'rdshr',
      'rdshr',
      'rdtsc',
      'rdtsc',
      'ret',
      'ret',
      'retf',
      'retf',
      'retn',
      'retn',
      'rol',
      'rol',
      'ror',
      'ror',
      'rsdc',
      'rsdc',
      'rsldt',
      'rsldt',
      'rsm',
      'rsm',
      'rsqrtps',
      'rsqrtps',
      'rsqrtss',
      'rsqrtss',
      'rsts',
      'rsts',
      'sahf',
      'sahf',
      'sal',
      'sal',
      'salc',
      'salc',
      'sar',
      'sar',
      'sbb',
      'sbb',
      'scasb',
      'scasb',
      'scasd',
      'scasd',
      'scasw',
      'scasw',
      'setcc',
      'setcc',
      'sfence',
      'sfence',
      'sgdt',
      'sgdt',
      'shl',
      'shl',
      'shld',
      'shld',
      'shr',
      'shr',
      'shrd',
      'shrd',
      'shufpd',
      'shufpd',
      'shufps',
      'shufps',
      'sidt',
      'sidt',
      'sldt',
      'sldt',
      'smi',
      'smi',
      'smint',
      'smint',
      'smintold',
      'smintold',
      'smsw',
      'smsw',
      'sqrtpd',
      'sqrtpd',
      'sqrtps',
      'sqrtps',
      'sqrtsd',
      'sqrtsd',
      'sqrtss',
      'sqrtss',
      'stc',
      'stc',
      'std',
      'std',
      'sti',
      'sti',
      'stmxcsr',
      'stmxcsr',
      'stosb',
      'stosb',
      'stosd',
      'stosd',
      'stosw',
      'stosw',
      'str',
      'str',
      'sub',
      'sub',
      'subpd',
      'subpd',
      'subps',
      'subps',
      'subsd',
      'subsd',
      'subss',
      'subss',
      'svdc',
      'svdc',
      'svldt',
      'svldt',
      'svts',
      'svts',
      'syscall',
      'syscall',
      'sysenter',
      'sysenter',
      'sysexit',
      'sysexit',
      'sysret',
      'sysret',
      'test',
      'test',
      'ucomisd',
      'ucomisd',
      'ucomiss',
      'ucomiss',
      'ud0',
      'ud0',
      'ud1',
      'ud1',
      'ud2',
      'ud2',
      'umov',
      'umov',
      'unpckhpd',
      'unpckhpd',
      'unpckhps',
      'unpckhps',
      'unpcklpd',
      'unpcklpd',
      'unpcklps',
      'unpcklps',
      'verr',
      'verr',
      'verw',
      'verw',
      'wait',
      'wait',
      'wbinvd',
      'wbinvd',
      'wrmsr',
      'wrmsr',
      'wrshr',
      'wrshr',
      'xadd',
      'xadd',
      'xbts',
      'xbts',
      'xchg',
      'xchg',
      'xlat',
      'xlat',
      'xlatb',
      'xlatb',
      'xor',
      'xor',
      'xorpd',
      'xorpd',
      'xorps',
      'xorps',
   );
   $self->listAdd('registers',
      'ah',
      'al',
      'ax',
      'bh',
      'bl',
      'bp',
      'bx',
      'ch',
      'cl',
      'cr0',
      'cr1',
      'cr2',
      'cr3',
      'cr4',
      'cs',
      'cx',
      'dh',
      'di',
      'dl',
      'ds',
      'dx',
      'eax',
      'ebp',
      'ebx',
      'ecx',
      'edi',
      'edx',
      'eip',
      'es',
      'esi',
      'esp',
      'fs',
      'gs',
      'ip',
      'mm0',
      'mm1',
      'mm2',
      'mm3',
      'mm4',
      'mm5',
      'mm6',
      'mm7',
      'si',
      'sp',
      'ss',
      'st',
      'xmm0',
      'xmm1',
      'xmm2',
      'xmm3',
      'xmm4',
      'xmm5',
      'xmm6',
      'xmm7',
   );
   $self->contextdata({
      'Comment' => {
         callback => \&parseComment,
         attribute => 'Comment',
         lineending => '#pop',
      },
      'Normal' => {
         callback => \&parseNormal,
         attribute => 'Normal Text',
      },
      'Preprocessor' => {
         callback => \&parsePreprocessor,
         attribute => 'Preprocessor',
         lineending => '#pop',
      },
      'String' => {
         callback => \&parseString,
         attribute => 'String',
         lineending => '#pop',
      },
   });
   $self->deliminators('\\s||\\.|\\(|\\)|:|\\!|\\+|,|-|<|=|>|\\%|\\&|\\*|\\/|;|\\?|\\[|\\]|\\^|\\{|\\||\\}|\\~|\\\\');
   $self->basecontext('Normal');
   $self->keywordscase(0);
   $self->initialize;
   bless ($self, $class);
   return $self;
}

sub language {
   return 'Intel x86 (NASM)';
}

sub parseComment {
   my ($self, $text) = @_;
   return 0;
};

sub parseNormal {
   my ($self, $text) = @_;
   # String => 'registers'
   # attribute => 'Registers'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'registers', 0, undef, 0, '#stay', 'Registers')) {
      return 1
   }
   # String => 'Data'
   # attribute => 'Data'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Data', 0, undef, 0, '#stay', 'Data')) {
      return 1
   }
   # String => 'instructions'
   # attribute => 'Instructions'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'instructions', 0, undef, 0, '#stay', 'Instructions')) {
      return 1
   }
   # String => 'NASM Keywords'
   # attribute => 'NASM Keywords'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'NASM Keywords', 0, undef, 0, '#stay', 'NASM Keywords')) {
      return 1
   }
   # attribute => 'Comment'
   # char => ';'
   # context => 'Comment'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ';', 0, 0, 0, undef, 0, 'Comment', 'Comment')) {
      return 1
   }
   # attribute => 'Preprocessor'
   # char => '%'
   # context => 'Preprocessor'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '%', 0, 0, 0, undef, 0, 'Preprocessor', 'Preprocessor')) {
      return 1
   }
   # String => '"''
   # attribute => 'String'
   # context => 'String'
   # type => 'AnyChar'
   if ($self->testAnyChar($text, '"\'', 0, 0, undef, 0, 'String', 'String')) {
      return 1
   }
   # String => '^\s*[A-Za-z0-9_.$]+:'
   # attribute => 'Label'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '^\\s*[A-Za-z0-9_.$]+:', 0, 0, 0, undef, 0, '#stay', 'Label')) {
      return 1
   }
   # String => '(cmov|fcmov|j|loop|set)(a|ae|b|be|c|e|g|ge|l|le|na|nae|nb|nbe|nc|ne|ng|nge|nl|nle|no|np|ns|nz|o|p|pe|po|s|z)'
   # attribute => 'Instructions'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '(cmov|fcmov|j|loop|set)(a|ae|b|be|c|e|g|ge|l|le|na|nae|nb|nbe|nc|ne|ng|nge|nl|nle|no|np|ns|nz|o|p|pe|po|s|z)', 0, 0, 0, undef, 0, '#stay', 'Instructions')) {
      return 1
   }
   # String => 'cpu (pentium|ppro|p2|p3|katmai|p4|willamette|prescott|ia64)*'
   # attribute => 'NASM Keywords'
   # context => '#stay'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, 'cpu (pentium|ppro|p2|p3|katmai|p4|willamette|prescott|ia64)*', 0, 0, 0, undef, 0, '#stay', 'NASM Keywords')) {
      return 1
   }
   # String => '(\$[0-9]+[a-f0-9]*|[a-f0-9]+h)'
   # attribute => 'BaseN'
   # context => '#stay'
   # insensitive => 'TRUE'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '(\\$[0-9]+[a-f0-9]*|[a-f0-9]+h)', 1, 0, 0, undef, 0, '#stay', 'BaseN')) {
      return 1
   }
   # String => '([0-7]+(q|o)|[01]+b)'
   # attribute => 'BaseN'
   # context => '#stay'
   # insensitive => 'TRUE'
   # type => 'RegExpr'
   if ($self->testRegExpr($text, '([0-7]+(q|o)|[01]+b)', 1, 0, 0, undef, 0, '#stay', 'BaseN')) {
      return 1
   }
   # attribute => 'Number'
   # char => '$'
   # context => '#stay'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '$', 0, 0, 0, undef, 0, '#stay', 'Number')) {
      return 1
   }
   # attribute => 'BaseN'
   # context => '#stay'
   # type => 'HlCOct'
   if ($self->testHlCOct($text, 0, undef, 0, '#stay', 'BaseN')) {
      return 1
   }
   # attribute => 'BaseN'
   # context => '#stay'
   # type => 'HlCHex'
   if ($self->testHlCHex($text, 0, undef, 0, '#stay', 'BaseN')) {
      return 1
   }
   # attribute => 'Float'
   # context => '#stay'
   # type => 'Float'
   if ($self->testFloat($text, 0, undef, 0, '#stay', 'Float')) {
      return 1
   }
   # attribute => 'Number'
   # context => '#stay'
   # type => 'Int'
   if ($self->testInt($text, 0, undef, 0, '#stay', 'Number')) {
      return 1
   }
   # attribute => 'Char'
   # context => '#stay'
   # type => 'HlCChar'
   if ($self->testHlCChar($text, 0, undef, 0, '#stay', 'Char')) {
      return 1
   }
   return 0;
};

sub parsePreprocessor {
   my ($self, $text) = @_;
   return 0;
};

sub parseString {
   my ($self, $text) = @_;
   # String => '"''
   # attribute => 'String'
   # context => '#pop'
   # type => 'AnyChar'
   if ($self->testAnyChar($text, '"\'', 0, 0, undef, 0, '#pop', 'String')) {
      return 1
   }
   return 0;
};


1;

__END__

=head1 NAME

Syntax::Highlight::Engine::Kate::Intel_x86_NASM - a Plugin for Intel x86 (NASM) syntax highlighting

=head1 SYNOPSIS

 require Syntax::Highlight::Engine::Kate::Intel_x86_NASM;
 my $sh = new Syntax::Highlight::Engine::Kate::Intel_x86_NASM([
 ]);

=head1 DESCRIPTION

Syntax::Highlight::Engine::Kate::Intel_x86_NASM is a  plugin module that provides syntax highlighting
for Intel x86 (NASM) to the Syntax::Haghlight::Engine::Kate highlighting engine.

This code is generated from the syntax definition files used
by the Kate project.
It works quite fine, but can use refinement and optimization.

It inherits Syntax::Higlight::Engine::Kate::Template. See also there.

=cut

=head1 AUTHOR

Hans Jeuken (haje <at> toneel <dot> demon <dot> nl)

=cut

=head1 BUGS

Unknown. If you find any, please contact the author

=cut

